/*
 * Decompiled with CFR 0.152.
 */
package flm.b4a.accelerview;

import android.graphics.Bitmap;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.keywords.constants.TypefaceWrapper;
import anywheresoftware.b4a.objects.drawable.CanvasWrapper;
import flm.b4a.accelerview.ComplexObject;
import flm.b4a.accelerview.ComplexPath;
import flm.b4a.accelerview.ComplexText;

@BA.ShortName(value="AS_Canvas")
public class AcceleratedCanvas {
    protected Canvas cvs = null;
    private Paint paint = null;
    private RectF rectF = null;
    private Camera cam = null;
    private Matrix matrix = null;
    private int width = 0;
    private int height = 0;
    public static final Paint.Align ALIGN_LEFT = Paint.Align.LEFT;
    public static final Paint.Align ALIGN_CENTER = Paint.Align.CENTER;
    public static final Paint.Align ALIGN_RIGHT = Paint.Align.RIGHT;
    private int SL = -1;

    /*
     * WARNING - void declaration
     */
    protected final void Initialize(Canvas c, int w, int h, Camera cmr, Paint p, Matrix m, RectF r) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.cvs = var1_1;
        this.paint = p;
        this.rectF = r;
        this.cam = cmr;
        this.matrix = m;
        this.width = var2_2;
        this.height = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public void ImportMatrix(Matrix m) {
        void var1_1;
        this.matrix = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void MatrixPostRotate(float degrees) {
        void var1_1;
        this.matrix.postRotate((float)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void MatrixPostRotate2(float degrees, float px, float py) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.matrix.postRotate((float)var1_1, (float)var2_2, (float)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public AcceleratedCanvas MatrixSetRotate(float degrees) {
        void var1_1;
        this.matrix.setRotate((float)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public AcceleratedCanvas MatrixSetRotate2(float degrees, float px, float py) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.matrix.setRotate((float)var1_1, (float)var2_2, (float)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public void MatrixPostScale(float sx, float sy) {
        void var2_2;
        void var1_1;
        this.matrix.postScale((float)var1_1, (float)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public AcceleratedCanvas MatrixSetScale(float sx, float sy) {
        void var2_2;
        void var1_1;
        this.matrix.setScale((float)var1_1, (float)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public AcceleratedCanvas MatrixSetSinCos(float sinValue, float cosValue, float px, float py) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.matrix.setSinCos((float)var1_1, (float)var2_2, (float)var3_3, py);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public void MatrixPostSkew(float sx, float sy) {
        void var2_2;
        void var1_1;
        this.matrix.postSkew((float)var1_1, (float)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public AcceleratedCanvas MatrixSetSkew(float sx, float sy) {
        void var2_2;
        void var1_1;
        this.matrix.setSkew((float)var1_1, (float)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public AcceleratedCanvas MatrixSetSkew2(float sx, float sy, float px, float py) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.matrix.setSkew((float)var1_1, (float)var2_2, (float)var3_3, py);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public void MatrixPostTranslate(float dx, float dy) {
        void var2_2;
        void var1_1;
        this.matrix.postTranslate((float)var1_1, (float)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public AcceleratedCanvas MatrixSetTranslate(float dx, float dy) {
        void var2_2;
        void var1_1;
        this.matrix.setTranslate((float)var1_1, (float)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public void DrawBitmapWithMatrixAt(CanvasWrapper.BitmapWrapper Bmp, int Left, int Top, boolean Filter) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.matrix.postTranslate((float)var2_2, (float)var3_3);
        if (Filter) {
            this.paint.reset();
            this.setPaintFilter();
            this.cvs.drawBitmap((Bitmap)Bmp.getObject(), this.matrix, this.paint);
            return;
        }
        this.cvs.drawBitmap((Bitmap)var1_1.getObject(), this.matrix, null);
    }

    /*
     * WARNING - void declaration
     */
    public void DrawBitmapObjectWithMatrixAt(ComplexObject objBmp, int Left, int Top) throws Exception {
        if (objBmp.objType == 1 || objBmp.objType == 2) {
            void var1_1;
            void var3_3;
            void var2_2;
            this.matrix.postTranslate((float)var2_2, (float)var3_3);
            this.cvs.drawBitmap(objBmp.bmpParam, this.matrix, var1_1.paint);
            return;
        }
        throw new Exception("DrawBitmapObjectWithMatrixAt: wrong object type");
    }

    /*
     * WARNING - void declaration
     */
    private void ResetWithColor(int color) {
        void var1_1;
        this.paint.reset();
        this.paint.setColor((int)var1_1);
    }

    private void setPaintFilter() {
        this.paint.setAntiAlias(true);
        this.paint.setFilterBitmap(true);
    }

    /*
     * WARNING - void declaration
     */
    public void DrawBitmap(CanvasWrapper.BitmapWrapper Bmp, Rect SrcRect, Rect DestRect) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.cvs.drawBitmap((Bitmap)var1_1.getObject(), (Rect)var2_2, (Rect)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public void DrawBitmapAt(CanvasWrapper.BitmapWrapper Bmp, int Left, int Top) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.cvs.drawBitmap((Bitmap)var1_1.getObject(), (float)var2_2, (float)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public void DrawBitmapMesh(CanvasWrapper.BitmapWrapper Bmp, int MeshWidth, int MeshHeight, float[] Verts, int VertOffset) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        if (Bmp == null || !Bmp.IsInitialized()) {
            throw new Exception("DrawBitmapMesh: bitmap not initialized");
        }
        this.cvs.drawBitmapMesh((Bitmap)var1_1.getObject(), (int)var2_2, (int)var3_3, Verts, VertOffset, null, 0, null);
    }

    /*
     * WARNING - void declaration
     */
    public void DrawArc(CanvasWrapper.RectWrapper OvalRect, float StartAngle, float SweepAngle, boolean Wedge, int Color, boolean Filled, float StrokeWidth, boolean Filter) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.ResetWithColor(Color);
        if (Filter) {
            this.setPaintFilter();
        }
        this.paint.setStyle(Filled ? Paint.Style.FILL : Paint.Style.STROKE);
        this.paint.setStrokeWidth(StrokeWidth);
        this.rectF.set((Rect)var1_1.getObject());
        this.cvs.drawArc(this.rectF, (float)var2_2, (float)var3_3, Wedge, this.paint);
    }

    /*
     * WARNING - void declaration
     */
    public void DrawCircle(float x, float y, float Radius, int Color, boolean Filled, float StrokeWidth, boolean Filter) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.ResetWithColor(Color);
        if (Filter) {
            this.setPaintFilter();
        }
        this.paint.setStyle(Filled ? Paint.Style.FILL : Paint.Style.STROKE);
        this.paint.setStrokeWidth(StrokeWidth);
        this.cvs.drawCircle((float)var1_1, (float)var2_2, (float)var3_3, this.paint);
    }

    /*
     * WARNING - void declaration
     */
    public void DrawColor(int Color) {
        void var1_1;
        if (Color == 0) {
            this.cvs.drawColor(Color, PorterDuff.Mode.CLEAR);
            return;
        }
        this.cvs.drawColor((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void DrawDrawable(Drawable drawable, CanvasWrapper.RectWrapper DestRect) {
        void var1_1;
        void var2_2;
        drawable.setBounds((Rect)var2_2.getObject());
        var1_1.draw(this.cvs);
    }

    /*
     * WARNING - void declaration
     */
    public void DrawLine(float x1, float y1, float x2, float y2, int Color, float StrokeWidth, boolean Filter) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.ResetWithColor(Color);
        if (Filter) {
            this.setPaintFilter();
        }
        this.paint.setStrokeWidth(StrokeWidth);
        this.cvs.drawLine((float)var1_1, (float)var2_2, (float)var3_3, y2, this.paint);
    }

    /*
     * WARNING - void declaration
     */
    public void DrawObjectAt(ComplexObject Obj, float X, float Y) throws Exception {
        if (Obj == null || !Obj.getIsInitialized()) {
            throw new Exception("DrawObjectAt: object not initialized");
        }
        switch (Obj.objType) {
            case 0: {
                this.rectF.set(X, Y, X + (float)Obj.iWidth, Y + (float)Obj.iHeight);
                this.cvs.drawArc(this.rectF, Obj.fParam1, Obj.fParam2, Obj.boolParam, Obj.paint);
                return;
            }
            case 1: {
                this.cvs.drawBitmap(Obj.bmpParam, X, Y, Obj.paint);
                return;
            }
            case 2: {
                this.rectF.set(X, Y, X + (float)Obj.iWidth, Y + (float)Obj.iHeight);
                this.cvs.drawBitmap(Obj.bmpParam, Obj.rctParam, this.rectF, Obj.paint);
                return;
            }
            case 3: {
                this.cvs.drawCircle(X, Y, Obj.fParam1, Obj.paint);
                return;
            }
            case 4: {
                this.cvs.drawLine(X, Y, X + Obj.fParam1, Y + Obj.fParam2, Obj.paint);
                return;
            }
            case 5: {
                this.rectF.set(X, Y, X + (float)Obj.iWidth, Y + (float)Obj.iHeight);
                this.cvs.drawOval(this.rectF, Obj.paint);
                return;
            }
            case 6: {
                if (X != 0.0f || Y != 0.0f) {
                    this.cvs.save();
                    this.cvs.translate(X, Y);
                    this.cvs.drawPath(Obj.pathParam, Obj.paint);
                    this.cvs.restore();
                    return;
                }
                this.cvs.drawPath(Obj.pathParam, Obj.paint);
                return;
            }
            case 7: {
                this.cvs.drawPoint(X, Y, Obj.paint);
                return;
            }
            case 8: {
                this.rectF.set(X, Y, X + (float)Obj.iWidth, Y + (float)Obj.iHeight);
                this.cvs.drawRect(this.rectF, Obj.paint);
                return;
            }
            case 9: {
                void var1_1;
                void var3_3;
                void var2_2;
                this.rectF.set(X, Y, (float)(var2_2 + (float)Obj.iWidth), (float)(var3_3 + (float)Obj.iHeight));
                this.cvs.drawRoundRect(this.rectF, Obj.fParam1, Obj.fParam2, var1_1.paint);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void DrawOval(CanvasWrapper.RectWrapper Rect2, int Color, boolean Filled, float StrokeWidth, boolean Filter) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.ResetWithColor((int)var2_2);
        if (Filter) {
            this.setPaintFilter();
        }
        this.paint.setStyle(var3_3 != false ? Paint.Style.FILL : Paint.Style.STROKE);
        this.paint.setStrokeWidth(StrokeWidth);
        this.rectF.set((Rect)var1_1.getObject());
        this.cvs.drawOval(this.rectF, this.paint);
    }

    /*
     * WARNING - void declaration
     */
    public void DrawPath(Object Path2, int Color, boolean Filled, float StrokeWidth, boolean Filter) throws Exception {
        void var3_3;
        void var2_2;
        this.ResetWithColor((int)var2_2);
        if (Filter) {
            this.setPaintFilter();
        }
        this.paint.setStyle(var3_3 != false ? Paint.Style.FILL : Paint.Style.STROKE);
        this.paint.setStrokeWidth(StrokeWidth);
        if (Path2.getClass().getName().equals("android.graphics.Path")) {
            this.cvs.drawPath((Path)Path2, this.paint);
            return;
        }
        if (Path2 instanceof ComplexPath) {
            void var1_1;
            this.cvs.drawPath(((ComplexPath)var1_1).path, this.paint);
            return;
        }
        throw new Exception("DrawPath: invalid path");
    }

    /*
     * WARNING - void declaration
     */
    public void DrawPoint(float x, float y, int Color) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.ResetWithColor((int)var3_3);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(0.0f);
        this.cvs.drawPoint((float)var1_1, (float)var2_2, this.paint);
    }

    /*
     * WARNING - void declaration
     */
    public void DrawRect(CanvasWrapper.RectWrapper Rect2, int Color, boolean Filled, float StrokeWidth, boolean Filter) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.ResetWithColor((int)var2_2);
        if (Filter) {
            this.setPaintFilter();
        }
        this.paint.setStyle(var3_3 != false ? Paint.Style.FILL : Paint.Style.STROKE);
        this.paint.setStrokeWidth(StrokeWidth);
        this.cvs.drawRect((Rect)var1_1.getObject(), this.paint);
    }

    /*
     * WARNING - void declaration
     */
    public void DrawRoundRect(CanvasWrapper.RectWrapper Rect2, int Color, float CornerRadius, boolean Filled, float StrokeWidth, boolean Filter) {
        void var3_3;
        void var1_1;
        void var2_2;
        this.ResetWithColor((int)var2_2);
        if (Filter) {
            this.setPaintFilter();
        }
        this.paint.setStyle(Filled ? Paint.Style.FILL : Paint.Style.STROKE);
        this.paint.setStrokeWidth(StrokeWidth);
        this.rectF.set((Rect)var1_1.getObject());
        this.cvs.drawRoundRect(this.rectF, CornerRadius, (float)var3_3, this.paint);
    }

    /*
     * WARNING - void declaration
     */
    public void DrawText(String Text, float x, float y, TypefaceWrapper Typeface2, float TextSize, int Color, Paint.Align Align2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.ResetWithColor(Color);
        this.setPaintFilter();
        this.paint.setStrokeWidth(0.0f);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setTextAlign(Align2);
        this.paint.setTextSize(TextSize * BA.applicationContext.getResources().getDisplayMetrics().scaledDensity);
        this.paint.setTypeface((Typeface)Typeface2.getObject());
        this.cvs.drawText((String)var1_1, (float)var2_2, (float)var3_3, this.paint);
    }

    /*
     * WARNING - void declaration
     */
    public void DrawTextObject(ComplexText objText, String Text, float X, float Y, Paint.Align Align2) throws Exception {
        void var1_1;
        void var3_3;
        void var2_2;
        if (objText == null || !objText.getIsInitialized()) {
            throw new Exception("DrawTextObject: object not initialized");
        }
        objText.getCO().paint.setTextAlign(Align2);
        if (objText.getCO().pathParam == null) {
            this.cvs.drawText(Text, X, Y, objText.getCO().paint);
            return;
        }
        this.cvs.drawTextOnPath((String)var2_2, objText.getCO().pathParam, (float)var3_3, Y, var1_1.getCO().paint);
    }

    /*
     * WARNING - void declaration
     */
    public void DrawTextOnPath(String Text, float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, TypefaceWrapper Typeface2, float TextSize, int Color, Paint.Align Align2) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.ResetWithColor(Color);
        this.setPaintFilter();
        this.paint.setStrokeWidth(0.0f);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setTextAlign(Align2);
        this.paint.setTextSize(TextSize * BA.applicationContext.getResources().getDisplayMetrics().scaledDensity);
        this.paint.setTypeface((Typeface)Typeface2.getObject());
        Path path = new Path();
        path.moveTo((float)var2_2, (float)var3_3);
        path.cubicTo(x2, y2, x3, y3, x4, y4);
        this.cvs.drawTextOnPath((String)var1_1, path, 0.0f, 0.0f, this.paint);
    }

    /*
     * WARNING - void declaration
     */
    public float MeasureStringWidth(String Text, TypefaceWrapper Typeface2, float TextSize) {
        void var1_1;
        void var2_2;
        void var3_3;
        this.paint.reset();
        this.setPaintFilter();
        this.paint.setStrokeWidth(0.0f);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setTextAlign(ALIGN_LEFT);
        this.paint.setTextSize((float)(var3_3 * BA.applicationContext.getResources().getDisplayMetrics().scaledDensity));
        this.paint.setTypeface((Typeface)var2_2.getObject());
        return this.paint.measureText((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public int MeasureStringHeight(String Text, TypefaceWrapper Typeface2, float TextSize) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.paint.reset();
        this.setPaintFilter();
        this.paint.setStrokeWidth(0.0f);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setTextAlign(ALIGN_LEFT);
        this.paint.setTextSize((float)(var3_3 * BA.applicationContext.getResources().getDisplayMetrics().scaledDensity));
        this.paint.setTypeface((Typeface)Typeface2.getObject());
        Rect r = new Rect();
        this.paint.getTextBounds(Text, 0, var1_1.length(), r);
        return var2_2.height();
    }

    public void SaveState() {
        this.cvs.save();
    }

    public void RestoreState() {
        this.cvs.restore();
    }

    /*
     * WARNING - void declaration
     */
    public int CreateLayer(CanvasWrapper.RectWrapper LayerRect) {
        void var1_1;
        this.rectF.set((Rect)var1_1.getObject());
        this.SL = this.SL == -1 ? this.cvs.saveLayer(this.rectF, null, 31) : (this.SL += this.cvs.saveLayer(this.rectF, null, 31));
        return this.SL;
    }

    public void TransferLayer() {
        if (this.SL >= 0) {
            this.cvs.restoreToCount(this.SL);
        }
        this.SL = -1;
    }

    /*
     * WARNING - void declaration
     */
    public void RotateCanvas(float Degrees) {
        void var1_1;
        this.cvs.rotate((float)var1_1, (float)(this.width >> 1), (float)(this.height >> 1));
    }

    /*
     * WARNING - void declaration
     */
    public void RotateCanvasAround(float Degrees, float PivotX, float PivotY) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.cvs.rotate((float)var1_1, (float)var2_2, (float)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void ScaleCanvas(float ScaleX, float ScaleY) {
        void var2_2;
        void var1_1;
        this.cvs.scale((float)var1_1, (float)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void SkewCanvas(float SkewX, float SkewY) {
        void var2_2;
        void var1_1;
        this.cvs.skew((float)var1_1, (float)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void TranslateCanvas(float dX, float dY) {
        void var2_2;
        void var1_1;
        this.cvs.translate((float)var1_1, (float)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void ClipPath(Object Path2) {
        if (Path2.getClass().getName().equals("android.graphics.Path")) {
            this.cvs.clipPath((Path)Path2);
            return;
        }
        if (Path2 instanceof ComplexPath) {
            void var1_1;
            this.cvs.clipPath(((ComplexPath)var1_1).path);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void ClipRect(CanvasWrapper.RectWrapper Rect2) {
        void var1_1;
        this.cvs.clipRect((Rect)var1_1.getObject());
    }

    /*
     * WARNING - void declaration
     */
    public void RemoveClip() {
        void var1_1;
        Rect r = new Rect(0, 0, this.width, this.height);
        this.cvs.clipRect((Rect)var1_1, Region.Op.UNION);
    }

    /*
     * WARNING - void declaration
     */
    public void ImportCamera(Camera c) {
        void var1_1;
        this.cam = var1_1;
    }

    public void CameraSave() {
        this.cam.save();
    }

    public void CameraRestore() {
        this.cam.restore();
    }

    /*
     * WARNING - void declaration
     */
    public void CameraRotateX(float deg) {
        void var1_1;
        this.cam.rotateX((float)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void CameraRotateY(float deg) {
        void var1_1;
        this.cam.rotateY((float)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void CameraRotateZ(float deg) {
        void var1_1;
        this.cam.rotateZ((float)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void CameraSetLocation(float x, float y, float z) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.cam.setLocation((float)var1_1, (float)var2_2, (float)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void CameraTranslate(float x, float y, float z) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.cam.translate((float)var1_1, (float)var2_2, (float)var3_3);
    }

    public void CameraComputeMatrix() {
        this.cam.getMatrix(this.matrix);
    }
}

