/*
 * Decompiled with CFR 0.152.
 */
package flm.b4a.accelerview;

import android.graphics.Bitmap;
import android.graphics.ColorFilter;
import android.graphics.ComposePathEffect;
import android.graphics.CornerPathEffect;
import android.graphics.DashPathEffect;
import android.graphics.DiscretePathEffect;
import android.graphics.LightingColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathDashPathEffect;
import android.graphics.PathEffect;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.SumPathEffect;
import android.graphics.Xfermode;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.objects.drawable.CanvasWrapper;
import flm.b4a.accelerview.ComplexPath;
import flm.b4a.accelerview.Texture;

@BA.ShortName(value="AS_Object")
public class ComplexObject {
    private boolean isInitialized = false;
    protected byte objType = (byte)-1;
    protected Bitmap bmpParam;
    protected boolean boolParam;
    protected float fParam1;
    protected float fParam2;
    protected int iWidth;
    protected int iHeight;
    protected Path pathParam;
    protected Rect rctParam;
    protected Paint paint;
    @BA.Hide
    public static final byte TYPE_ARC = 0;
    @BA.Hide
    public static final byte TYPE_BITMAP = 1;
    @BA.Hide
    public static final byte TYPE_BITMAP2 = 2;
    @BA.Hide
    public static final byte TYPE_CIRCLE = 3;
    @BA.Hide
    public static final byte TYPE_LINE = 4;
    @BA.Hide
    public static final byte TYPE_OVAL = 5;
    @BA.Hide
    public static final byte TYPE_PATH = 6;
    @BA.Hide
    public static final byte TYPE_POINT = 7;
    @BA.Hide
    public static final byte TYPE_RECT = 8;
    @BA.Hide
    public static final byte TYPE_ROUNDRECT = 9;
    @BA.Hide
    public static final byte TYPE_TEXT = 10;
    public static final Paint.Style STYLE_FILL = Paint.Style.FILL;
    public static final Paint.Style STYLE_FILL_AND_STROKE = Paint.Style.FILL_AND_STROKE;
    public static final Paint.Style STYLE_STROKE = Paint.Style.STROKE;
    public static final int PATHEFFECT_CLEAR = 0;
    public static final int PATHEFFECT_DASH_ALTERNATE = 1;
    public static final int PATHEFFECT_DASH_REGULAR = 2;
    public static final int PATHEFFECT_DASH_SEGMENTED = 3;
    public static final int PATHEFFECT_DISTORTED = 4;
    public static final int PATHEFFECT_ROUNDED = 5;
    public static final PathDashPathEffect.Style PATHEFFECT_STYLE_MORPH = PathDashPathEffect.Style.MORPH;
    public static final PathDashPathEffect.Style PATHEFFECT_STYLE_ROTATE = PathDashPathEffect.Style.ROTATE;
    public static final PathDashPathEffect.Style PATHEFFECT_STYLE_TRANSLATE = PathDashPathEffect.Style.TRANSLATE;
    public static final PorterDuff.Mode MODE_CLEAR = PorterDuff.Mode.CLEAR;
    public static final PorterDuff.Mode MODE_DARKEN = PorterDuff.Mode.DARKEN;
    public static final PorterDuff.Mode MODE_LIGHTEN = PorterDuff.Mode.LIGHTEN;
    public static final PorterDuff.Mode MODE_MULTIPLY = PorterDuff.Mode.MULTIPLY;
    public static final PorterDuff.Mode MODE_SCREEN = PorterDuff.Mode.SCREEN;
    public static final PorterDuff.Mode MODE_SRC_ATOP = PorterDuff.Mode.SRC_ATOP;
    public static final PorterDuff.Mode MODE_SRC_IN = PorterDuff.Mode.SRC_IN;
    public static final PorterDuff.Mode MODE_SRC_OUT = PorterDuff.Mode.SRC_OUT;
    public static final PorterDuff.Mode MODE_SRC_OVER = PorterDuff.Mode.SRC_OVER;
    public static final PorterDuff.Mode MODE_DST_ATOP = PorterDuff.Mode.DST_ATOP;
    public static final PorterDuff.Mode MODE_DST_IN = PorterDuff.Mode.DST_IN;
    public static final PorterDuff.Mode MODE_DST_OUT = PorterDuff.Mode.DST_OUT;
    public static final PorterDuff.Mode MODE_DST_OVER = PorterDuff.Mode.DST_OVER;
    public static final PorterDuff.Mode MODE_XOR = PorterDuff.Mode.XOR;

    @BA.Hide
    public byte getType() {
        return this.objType;
    }

    /*
     * WARNING - void declaration
     */
    private void Initialize(boolean Filter) {
        void var1_1;
        this.isInitialized = false;
        this.bmpParam = null;
        this.boolParam = false;
        this.fParam1 = 0.0f;
        this.fParam2 = 0.0f;
        this.iWidth = 0;
        this.iHeight = 0;
        this.pathParam = null;
        this.rctParam = null;
        this.paint = new Paint();
        this.paint.setAntiAlias(Filter);
        this.paint.setFilterBitmap((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void CheckInitialization(String funcName) throws Exception {
        if (!this.isInitialized) {
            void var1_1;
            throw new Exception(String.valueOf(var1_1) + ": object not initialized");
        }
    }

    /*
     * WARNING - void declaration
     */
    public final ComplexObject Clone(ComplexObject ObjToCopy) {
        void var1_1;
        this.isInitialized = false;
        if (!ObjToCopy.isInitialized) {
            return null;
        }
        this.objType = ObjToCopy.objType;
        this.bmpParam = ObjToCopy.bmpParam;
        this.boolParam = ObjToCopy.boolParam;
        this.fParam1 = ObjToCopy.fParam1;
        this.fParam2 = ObjToCopy.fParam2;
        this.iWidth = ObjToCopy.iWidth;
        this.iHeight = ObjToCopy.iHeight;
        this.pathParam = ObjToCopy.pathParam == null ? null : new Path(ObjToCopy.pathParam);
        this.rctParam = ObjToCopy.rctParam == null ? null : new Rect(ObjToCopy.rctParam);
        this.paint = ObjToCopy.paint == null ? null : new Paint(var1_1.paint);
        this.isInitialized = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ComplexObject CreateArc(int Width, int Height, float StartAngle, float SweepAngle, boolean Wedge, boolean Filter) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.Initialize(Filter);
        this.objType = 0;
        this.iWidth = var1_1;
        this.iHeight = var2_2;
        this.fParam1 = var3_3;
        this.fParam2 = SweepAngle;
        this.boolParam = Wedge;
        this.isInitialized = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public void ChangeArcAngles(float StartAngle, float SweepAngle) throws Exception {
        void var2_2;
        void var1_1;
        this.CheckInitialization("ChangeArcAngles");
        if (this.objType != 0) {
            throw new Exception("ChangeArcAngles: wrong object type");
        }
        this.fParam1 = var1_1;
        this.fParam2 = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final ComplexObject CreateBitmap(CanvasWrapper.BitmapWrapper SrcBmp, boolean Filter) {
        void var1_1;
        void var2_2;
        this.Initialize((boolean)var2_2);
        this.objType = 1;
        this.bmpParam = (Bitmap)var1_1.getObject();
        this.isInitialized = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ComplexObject CreateBitmap2(CanvasWrapper.BitmapWrapper SrcBmp, Rect SrcRect, int Width, int Height, boolean Filter) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.Initialize(Filter);
        this.objType = (byte)2;
        this.bmpParam = (Bitmap)var1_1.getObject();
        this.rctParam = var2_2;
        this.iWidth = var3_3;
        this.iHeight = Height;
        this.isInitialized = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public void ChangeBitmap(CanvasWrapper.BitmapWrapper SrcBmp) throws Exception {
        void var1_1;
        this.CheckInitialization("ChangeBitmap");
        if (this.objType != 1 && this.objType != 2) {
            throw new Exception("ChangeBitmap: wrong object type");
        }
        this.bmpParam = (Bitmap)var1_1.getObject();
    }

    /*
     * WARNING - void declaration
     */
    public final ComplexObject CreateCircle(float Radius, boolean Filter) {
        void var1_1;
        void var2_2;
        this.Initialize((boolean)var2_2);
        this.objType = (byte)3;
        this.fParam1 = var1_1;
        this.isInitialized = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public void ChangeCircleRadius(float Radius) throws Exception {
        void var1_1;
        this.CheckInitialization("ChangeCircleRadius");
        if (this.objType != 3) {
            throw new Exception("ChangeCircleRadius: wrong object type");
        }
        this.fParam1 = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final ComplexObject CreateLine(float DeltaX, float DeltaY, boolean Filter) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.Initialize((boolean)var3_3);
        this.objType = (byte)4;
        this.fParam1 = var1_1;
        this.fParam2 = var2_2;
        this.isInitialized = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ComplexObject CreateOval(int Width, int Height, boolean Filter) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.Initialize((boolean)var3_3);
        this.objType = (byte)5;
        this.iWidth = var1_1;
        this.iHeight = var2_2;
        this.isInitialized = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ComplexObject CreatePath(Object Path2, boolean Filter) throws Exception {
        void var2_2;
        this.Initialize((boolean)var2_2);
        this.objType = (byte)6;
        if (Path2 == null) {
            throw new Exception("CreatePath: Path is null");
        }
        if (Path2.getClass().getName().equals("android.graphics.Path")) {
            this.pathParam = (Path)Path2;
        } else if (Path2 instanceof ComplexPath) {
            void var1_1;
            this.pathParam = ((ComplexPath)var1_1).path;
        } else {
            throw new Exception("CreatePath: invalid Path");
        }
        this.isInitialized = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public void ChangePath(Object Path2) throws Exception {
        this.CheckInitialization("ChangePath");
        if (this.objType != 6) {
            throw new Exception("ChangePath: wrong object type");
        }
        if (Path2 == null) {
            this.pathParam = null;
            return;
        }
        if (Path2.getClass().getName().equals("android.graphics.Path")) {
            this.pathParam = (Path)Path2;
            return;
        }
        if (Path2 instanceof ComplexPath) {
            void var1_1;
            this.pathParam = ((ComplexPath)var1_1).path;
        }
    }

    public final ComplexObject CreatePoint() {
        this.Initialize(false);
        this.objType = (byte)7;
        this.isInitialized = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ComplexObject CreateRect(int Width, int Height, boolean Filter) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.Initialize((boolean)var3_3);
        this.objType = (byte)8;
        this.iWidth = var1_1;
        this.iHeight = var2_2;
        this.isInitialized = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ComplexObject CreateRoundRect(int Width, int Height, float CornerRadiusX, float CornerRadiusY, boolean Filter) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.Initialize(Filter);
        this.objType = (byte)9;
        this.iWidth = var1_1;
        this.iHeight = var2_2;
        this.fParam1 = var3_3;
        this.fParam2 = CornerRadiusY;
        this.isInitialized = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public void ChangeWidthHeight(int Width, int Height) throws Exception {
        void var2_2;
        void var1_1;
        this.CheckInitialization("ChangeWidthHeight");
        this.iWidth = var1_1;
        this.iHeight = var2_2;
    }

    public int GetWidth() throws Exception {
        this.CheckInitialization("GetWidth");
        return this.iWidth;
    }

    public int GetHeight() throws Exception {
        this.CheckInitialization("GetHeight");
        return this.iHeight;
    }

    /*
     * WARNING - void declaration
     */
    protected final ComplexObject CreateText(boolean Filter) {
        void var1_1;
        this.Initialize((boolean)var1_1);
        this.objType = (byte)10;
        this.isInitialized = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public void SetAlpha(int Alpha) throws Exception {
        void var1_1;
        this.CheckInitialization("SetAlpha");
        this.paint.setAlpha((int)var1_1);
    }

    public int GetAlpha() throws Exception {
        this.CheckInitialization("GetAlpha");
        return this.paint.getAlpha();
    }

    /*
     * WARNING - void declaration
     */
    public final ComplexObject SetColor(int Color) throws Exception {
        void var1_1;
        this.CheckInitialization("SetColor");
        if (this.paint.getShader() != null) {
            this.paint.setShader(null);
        }
        this.paint.setColor((int)var1_1);
        return this;
    }

    public int GetColor() throws Exception {
        this.CheckInitialization("GetColor");
        return this.paint.getColor();
    }

    /*
     * WARNING - void declaration
     */
    public final ComplexObject SetStyle(Paint.Style style, int StrokeWidth) throws Exception {
        void var2_2;
        void var1_1;
        this.CheckInitialization("SetStyle");
        this.paint.setStyle((Paint.Style)var1_1);
        this.paint.setStrokeWidth((float)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ComplexObject SetPathEffect(int Effect, float Value) throws Exception {
        void var1_1;
        this.CheckInitialization("SetPathEffect");
        switch (var1_1) {
            case 1: {
                this.paint.setPathEffect((PathEffect)new DashPathEffect(new float[]{Value * 2.5f, Value, Value, Value}, 0.0f));
                break;
            }
            case 2: {
                this.paint.setPathEffect((PathEffect)new DashPathEffect(new float[]{Value, Value}, 0.0f));
                break;
            }
            case 3: {
                this.paint.setPathEffect((PathEffect)new DashPathEffect(new float[]{Value * 3.0f, Value}, 0.0f));
                break;
            }
            case 4: {
                this.paint.setPathEffect((PathEffect)new DiscretePathEffect(Value * 3.0f, Value));
                break;
            }
            case 5: {
                void var2_2;
                this.paint.setPathEffect((PathEffect)new CornerPathEffect((float)var2_2));
                break;
            }
            default: {
                this.paint.setPathEffect(null);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ComplexObject SetPathEffect2(Object Shape, float Spacing, PathDashPathEffect.Style Style2) throws Exception {
        this.CheckInitialization("SetPathEffect2");
        if (Shape == null) {
            this.paint.setPathEffect(null);
        } else if (Shape.getClass().getName().equals("android.graphics.Path")) {
            this.paint.setPathEffect((PathEffect)new PathDashPathEffect((Path)Shape, Spacing, 0.0f, Style2));
        } else if (Shape instanceof ComplexPath) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.paint.setPathEffect((PathEffect)new PathDashPathEffect(((ComplexPath)var1_1).path, (float)var2_2, 0.0f, (PathDashPathEffect.Style)var3_3));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void SumPathEffect(boolean Combine, PathEffect PE) {
        void var2_2;
        if (Combine) {
            this.paint.setPathEffect((PathEffect)new ComposePathEffect(this.paint.getPathEffect(), PE));
            return;
        }
        this.paint.setPathEffect((PathEffect)new SumPathEffect(this.paint.getPathEffect(), (PathEffect)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final ComplexObject AddToPathEffect(int Effect, float Value, boolean Combine) throws Exception {
        void var1_1;
        this.CheckInitialization("AddToPathEffect");
        if (this.paint.getPathEffect() == null) {
            return this.SetPathEffect(Effect, Value);
        }
        switch (var1_1) {
            case 1: {
                this.SumPathEffect(Combine, (PathEffect)new DashPathEffect(new float[]{Value * 2.5f, Value, Value, Value}, 0.0f));
                break;
            }
            case 2: {
                this.SumPathEffect(Combine, (PathEffect)new DashPathEffect(new float[]{Value, Value}, 0.0f));
                break;
            }
            case 3: {
                this.SumPathEffect(Combine, (PathEffect)new DashPathEffect(new float[]{Value * 3.0f, Value}, 0.0f));
                break;
            }
            case 4: {
                this.SumPathEffect(Combine, (PathEffect)new DiscretePathEffect(Value * 3.0f, Value));
                break;
            }
            case 5: {
                void var2_2;
                void var3_3;
                this.SumPathEffect((boolean)var3_3, (PathEffect)new CornerPathEffect((float)var2_2));
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ComplexObject SetLightingColorFilter(int Multiply, int Add) throws Exception {
        void var2_2;
        void var1_1;
        this.CheckInitialization("SetLightingColorFilter");
        this.paint.setColorFilter((ColorFilter)new LightingColorFilter((int)var1_1, (int)var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ComplexObject SetPorterDuffColorFilter(int SrcColor, PorterDuff.Mode PDMode) throws Exception {
        this.CheckInitialization("SetPorterDuffColorFilter");
        if (PDMode == null) {
            this.paint.setColorFilter(null);
        } else {
            void var2_2;
            void var1_1;
            this.paint.setColorFilter((ColorFilter)new PorterDuffColorFilter((int)var1_1, (PorterDuff.Mode)var2_2));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ComplexObject SetXferMode(PorterDuff.Mode PDMode) throws Exception {
        this.CheckInitialization("SetXferMode");
        if (PDMode == null) {
            this.paint.setXfermode(null);
        } else {
            void var1_1;
            this.paint.setXfermode((Xfermode)new PorterDuffXfermode((PorterDuff.Mode)var1_1));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ComplexObject SetTexture(Texture texture) throws Exception {
        this.CheckInitialization("SetTexture");
        if (texture == null || !texture.getIsInitialized()) {
            this.paint.setShader(null);
        } else {
            void var1_1;
            this.paint.setShader(var1_1.getShader());
        }
        return this;
    }

    public Paint getPaint() throws Exception {
        this.CheckInitialization("getPaint");
        return this.paint;
    }

    /*
     * WARNING - void declaration
     */
    public void setPaint(Paint paint) throws Exception {
        void var1_1;
        this.CheckInitialization("setPaint");
        this.paint = var1_1;
    }

    public boolean getIsInitialized() {
        return this.isInitialized;
    }
}

