/*
 * Decompiled with CFR 0.152.
 */
package flm.b4a.accelerview;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.objects.collections.Map;
import anywheresoftware.b4a.objects.drawable.CanvasWrapper;
import anywheresoftware.b4a.objects.streams.File;
import java.io.IOException;
import java.io.InputStream;

@BA.ShortName(value="AS_ImageUtils")
public class ImageUtils {
    /*
     * WARNING - void declaration
     */
    public static Map GetImageDimensions(String Dir, String FileName) {
        void var2_2;
        void var1_1;
        String string;
        Map m = new Map();
        m.Initialize();
        BitmapFactory.Options options = new BitmapFactory.Options();
        new BitmapFactory.Options().inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)File.Combine((String)string, (String)var1_1), (BitmapFactory.Options)options);
        if (options.outHeight > 0 || options.outWidth > 0) {
            void var3_3;
            m.Put((Object)"Height", (Object)options.outHeight);
            m.Put((Object)"Width", (Object)var3_3.outWidth);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap LoadScaledBitmap(String Dir, String FileName, int dstWidth, int dstHeight, boolean Filter) throws IOException {
        void var3_3;
        void var2_2;
        String string;
        String bmp;
        void var1_1;
        File.InputStreamWrapper in = File.OpenInput((String)Dir, (String)FileName);
        BitmapFactory.Options opt = new BitmapFactory.Options();
        new BitmapFactory.Options().inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)((InputStream)in.getObject()), null, (BitmapFactory.Options)opt);
        in.Close();
        int ratio = Math.max(opt.outWidth / dstWidth, opt.outHeight / dstHeight);
        BitmapFactory.Options opt2 = null;
        if (ratio > 1) {
            opt2 = new BitmapFactory.Options();
            new BitmapFactory.Options().inSampleSize = ratio;
        }
        File.InputStreamWrapper inputStreamWrapper = File.OpenInput((String)Dir, (String)var1_1);
        try {
            bmp = BitmapFactory.decodeStream((InputStream)((InputStream)inputStreamWrapper.getObject()), null, (BitmapFactory.Options)opt2);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new RuntimeException("LoadScaledBitmap: Out of memory.");
        }
        inputStreamWrapper.Close();
        if (bmp == null) {
            throw new RuntimeException("LoadScaledBitmap: Error loading bitmap.");
        }
        if (dstWidth == -1 && dstHeight == -1) {
            return bmp;
        }
        if (dstWidth == -1) {
            dstWidth = bmp.getWidth();
        }
        if (dstHeight == -1) {
            dstHeight = bmp.getHeight();
        }
        return Bitmap.createScaledBitmap((Bitmap)string, (int)var2_2, (int)var3_3, (boolean)Filter);
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap CreateScaledBitmap(CanvasWrapper.BitmapWrapper srcBmp, int dstWidth, int dstHeight, boolean filter) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Bitmap.createScaledBitmap((Bitmap)((Bitmap)srcBmp.getObject()), (int)var1_1, (int)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap Crop(CanvasWrapper.BitmapWrapper srcBmp, int x, int y, int width, int height) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Bitmap.createBitmap((Bitmap)((Bitmap)srcBmp.getObject()), (int)var1_1, (int)var2_2, (int)var3_3, (int)height);
    }

    public static Bitmap ReduceColors(CanvasWrapper.BitmapWrapper srcBmp) {
        return ((Bitmap)srcBmp.getObject()).copy(Bitmap.Config.RGB_565, true);
    }

    public static Bitmap MakeMutable(CanvasWrapper.BitmapWrapper srcBmp) {
        CanvasWrapper.BitmapWrapper bitmapWrapper;
        return ((Bitmap)srcBmp.getObject()).copy(((Bitmap)bitmapWrapper.getObject()).getConfig(), true);
    }

    /*
     * WARNING - void declaration
     */
    public static void GetPixels(CanvasWrapper.BitmapWrapper src, int[] Pixels, int offset, int stride, int x, int y, int width, int height) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        void var3_3;
        void var2_2;
        void var1_1;
        ((Bitmap)src.getObject()).getPixels((int[])var1_1, (int)var2_2, (int)var3_3, x, y, width, height);
    }

    /*
     * WARNING - void declaration
     */
    public static Drawable LoadSystemDrawable(BA ba, String Name) {
        void var1_2;
        BA bA;
        int ID_drawable = Resources.getSystem().getIdentifier(Name, "drawable", "android");
        return bA.context.getResources().getDrawable((int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Drawable LoadNinePatchDrawable(BA ba, String Name) {
        void var1_2;
        BA bA;
        int ID_drawable = ba.context.getResources().getIdentifier(Name, "drawable", ba.context.getPackageName());
        return bA.context.getResources().getDrawable((int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap AlterColors(CanvasWrapper.BitmapWrapper srcBmp, int Alpha, int Hue, float Saturation) {
        void var2_2;
        void var3_3;
        ColorMatrix cm = new ColorMatrix();
        if (Saturation != 1.0f) {
            cm.setSaturation(Saturation);
        }
        if (Hue != 0) {
            float NewHue = (float)Hue / 180.0f * (float)Math.PI;
            float cosVal = (float)Math.cos(NewHue);
            float sinVal = (float)Math.sin(NewHue);
            float[] mat = new float[]{0.213f + cosVal * 0.787f + sinVal * -0.213f, 0.715f + cosVal * -0.715f + sinVal * -0.715f, 0.072f + cosVal * -0.072f + sinVal * 0.928f, 0.0f, 0.0f, 0.213f + cosVal * -0.213f + sinVal * 0.143f, 0.715f + cosVal * 0.28500003f + sinVal * 0.14f, 0.072f + cosVal * -0.072f + sinVal * -0.283f, 0.0f, 0.0f, 0.213f + cosVal * -0.213f + sinVal * -0.787f, 0.715f + cosVal * -0.715f + sinVal * 0.715f, 0.072f + cosVal * 0.928f + sinVal * 0.072f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
            cm.postConcat(new ColorMatrix(mat));
        }
        Bitmap bmp = Bitmap.createBitmap((Bitmap)((Bitmap)srcBmp.getObject()));
        Canvas canvas = new Canvas(bmp);
        if (var3_3 != 1.0f || var2_2 != false) {
            CanvasWrapper.BitmapWrapper bitmapWrapper;
            Paint p = new Paint();
            CanvasWrapper.BitmapWrapper cmFilter = new ColorMatrixColorFilter(cm);
            p.setColorFilter((ColorFilter)bitmapWrapper);
            canvas.drawBitmap(bmp, 0.0f, 0.0f, p);
        }
        if (Alpha >= 0) {
            void var1_1;
            int Color = (var1_1 & 0xFF) << 24;
            canvas.drawColor(Color, PorterDuff.Mode.DST_IN);
        }
        return bmp;
    }

    public static int GetDensity(CanvasWrapper.BitmapWrapper srcBmp) {
        return ((Bitmap)srcBmp.getObject()).getDensity();
    }

    /*
     * WARNING - void declaration
     */
    public static void SetDensity(CanvasWrapper.BitmapWrapper srcBmp, int Density) {
        void var1_1;
        ((Bitmap)srcBmp.getObject()).setDensity((int)var1_1);
    }
}

