/*
 * Decompiled with CFR 0.152.
 */
package flm.b4a.accelerview;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.ComposeShader;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.PorterDuff;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.objects.drawable.CanvasWrapper;

@BA.ShortName(value="AS_Texture")
public class Texture {
    public static final Shader.TileMode TILEMODE_CLAMP = Shader.TileMode.CLAMP;
    public static final Shader.TileMode TILEMODE_REPEAT = Shader.TileMode.REPEAT;
    public static final Shader.TileMode TILEMODE_MIRROR = Shader.TileMode.MIRROR;
    public static final PorterDuff.Mode MERGEMODE_DARKEN = PorterDuff.Mode.DARKEN;
    public static final PorterDuff.Mode MERGEMODE_LIGHTEN = PorterDuff.Mode.LIGHTEN;
    public static final PorterDuff.Mode MERGEMODE_MULTIPLY = PorterDuff.Mode.MULTIPLY;
    public static final PorterDuff.Mode MERGEMODE_SCREEN = PorterDuff.Mode.SCREEN;
    public static final PorterDuff.Mode MERGEMODE_TEX1_ATOP = PorterDuff.Mode.SRC_ATOP;
    public static final PorterDuff.Mode MERGEMODE_TEX1_IN = PorterDuff.Mode.SRC_IN;
    public static final PorterDuff.Mode MERGEMODE_TEX1_OUT = PorterDuff.Mode.SRC_OUT;
    public static final PorterDuff.Mode MERGEMODE_TEX1_OVER = PorterDuff.Mode.SRC_OVER;
    public static final PorterDuff.Mode MERGEMODE_TEX2_ATOP = PorterDuff.Mode.DST_ATOP;
    public static final PorterDuff.Mode MERGEMODE_TEX2_IN = PorterDuff.Mode.DST_IN;
    public static final PorterDuff.Mode MERGEMODE_TEX2_OUT = PorterDuff.Mode.DST_OUT;
    public static final PorterDuff.Mode MERGEMODE_TEX2_OVER = PorterDuff.Mode.DST_OVER;
    public static final PorterDuff.Mode MERGEMODE_XOR = PorterDuff.Mode.XOR;
    private Shader shader = null;
    private Matrix m;
    private boolean isInitialized = false;

    /*
     * WARNING - void declaration
     */
    public final Texture CreateWithBitmap(CanvasWrapper.BitmapWrapper Image, Shader.TileMode ModeX, Shader.TileMode ModeY) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        if (Image == null || !Image.IsInitialized()) {
            throw new Exception("CreateWithBitmap: Image not initialized");
        }
        this.shader = new BitmapShader((Bitmap)var1_1.getObject(), (Shader.TileMode)var2_2, (Shader.TileMode)var3_3);
        this.m = new Matrix();
        this.isInitialized = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final Texture CreateLinearGradient(float X0, float Y0, float X1, float Y1, int[] Colors, Shader.TileMode TileMode2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.shader = new LinearGradient((float)var1_1, (float)var2_2, (float)var3_3, Y1, Colors, null, TileMode2);
        this.m = new Matrix();
        this.isInitialized = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final Texture CreateRadialGradient(float X, float Y, float Radius, int[] Colors, Shader.TileMode TileMode2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.shader = new RadialGradient((float)var1_1, (float)var2_2, (float)var3_3, Colors, null, TileMode2);
        this.m = new Matrix();
        this.isInitialized = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final Texture CreateSweepGradient(float X, float Y, int[] Colors) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.shader = new SweepGradient((float)var1_1, (float)var2_2, (int[])var3_3, null);
        this.m = new Matrix();
        this.isInitialized = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public void Translate(int OffsetX, int OffsetY) throws Exception {
        if (!this.isInitialized) {
            throw new Exception("Translate: texture not initialized");
        }
        if (this.shader != null) {
            void var2_2;
            void var1_1;
            this.m.setTranslate((float)var1_1, (float)var2_2);
            this.shader.setLocalMatrix(this.m);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Texture Merge(Texture Tex1, Texture Tex2, PorterDuff.Mode MergeMode) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (Tex1 == null) {
            return Tex2;
        }
        if (Tex2 == null) {
            return Tex1;
        }
        this.shader = new ComposeShader(var1_1.getShader(), var2_2.getShader(), (PorterDuff.Mode)var3_3);
        this.m = new Matrix();
        this.isInitialized = true;
        return this;
    }

    @BA.Hide
    public Shader getShader() {
        return this.shader;
    }

    public boolean getIsInitialized() {
        return this.isInitialized;
    }
}

