﻿
Imports System.IO
Imports System.Runtime.InteropServices
Imports Microsoft.Win32
Imports System.Text
Imports System.Text.RegularExpressions



Module Routines

    'Public Variables
    Public B4AActiveProjectFile As String 'The Basic4Android project name
    Public MyDir As String
    Public ProjFiles As New List(Of String)
    Public SubRoutines As New List(Of String)
    Public Settings As New List(Of Integer)
    Public MyTempFile As String = Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData)

    'Private Variables
    Private Indent As Integer = 0 'The current indentation
    Private Blanklines As Integer
    Private Codestart As Boolean = False
    Private blank As Boolean = False
    Private LineNo As Integer = 0 'The current line number of the Basic4Android project
    Private Processed As Integer
    Private HoldSpace As Boolean = False
    Private SelStart As Boolean
    Private mystring As String = ""
    Private VarList As New System.Data.DataTable
    Private Varcol As System.Data.DataColumn
    Private Varrow As System.Data.DataRow
    Private Faults As New System.Data.DataTable
    Private column As System.Data.DataColumn
    Private row As System.Data.DataRow
    Dim WithEvents PrintDocument1 As New System.Drawing.Printing.PrintDocument
    Private SubName As String = ""
    Private FixString As String = ""
    Private ErrInt As Integer = 0

    Public Sub BackupCodeToFile()
        'Create a backupfile with date and time identification 

        For Each filename As String In ProjFiles

            Dim MyDate As String = Date.Now.ToString

            Do While MyDate.Contains("/")
                MyDate = MyDate.Replace("/", "-")
            Loop

            Do While MyDate.Contains(":")
                MyDate = MyDate.Replace(":", ".")
            Loop

            Dim pos As Integer = 0
            Dim SafeName As String = ""
            pos = filename.LastIndexOf("\") + 1
            SafeName = filename.Substring(pos)
            My.Computer.FileSystem.CopyFile(filename, MyDir & "b4acoderbackups\" & SafeName & MyDate)
        Next

    End Sub

    Private Sub AddTab()
        'Add a tab

        Indent = Indent + 1
        Writer(mystring)

    End Sub

    Private Sub DelTab()
        'Remove a tab

        Indent = Indent - 1

        If mystring.ToString.Substring(0, 1) = vbTab Then
            mystring = mystring.Substring(1, mystring.ToString.Length - 1)
        End If

        Writer(mystring)

    End Sub

    Private Sub SendBlank(ByVal L As Integer)
        'Send a linespace

        L = L - Blanklines
        For A As Integer = 0 To L - 1
            blank = True
            Writer(" ")
        Next

    End Sub

    Private Function CommentStrip(ByVal Tempstring As String) As String

        Dim SingQuote As Integer
        Dim Quote As Integer

        If Tempstring.Contains("'") Then

            Do
                SingQuote = Tempstring.LastIndexOf("'")
                Quote = Tempstring.LastIndexOf(ControlChars.Quote)

                If SingQuote > Quote Then
                    Tempstring = Tempstring.Substring(0, Tempstring.LastIndexOf("'"))
                    Tempstring = Tempstring.TrimEnd
                Else
                    Exit Do
                End If

            Loop While SingQuote > 0

            Return Tempstring

        Else
            Return Tempstring
        End If

    End Function

    Private Sub Writer(ByVal PrintString As String)

        If Codestart Then 'Only handle editable lines


            If PrintString.Trim.Length > 0 Then
                Call InLineFormat()
                PrintString = mystring
            End If

            'Get rid of duplicate spaces
            Do While PrintString.Contains("  ")
                PrintString = PrintString.Replace("  ", " ")
            Loop

            If blank = False And PrintString.TrimEnd = "" Then Exit Sub

            blank = False

            If PrintString.TrimEnd = "" Then
                Blanklines = Blanklines + 1
            Else
                Blanklines = 0
            End If

        End If

        If PrintString.Trim.Length > 5 Then
            FixString = PrintString
            If PrintString.Trim.Substring(0, 4) = "Dim " Then Call fixAs()
            PrintString = FixString
        End If

        If LineNo = 1 Then
            Try
                My.Computer.FileSystem.WriteAllText(MyTempFile & "\b4aRebuildFile", PrintString, True)
            Catch ex As Exception
                MessageBox.Show(ex.Message)
            End Try

        Else
            Try
                My.Computer.FileSystem.WriteAllText(MyTempFile & "\b4aRebuildFile", vbNewLine & PrintString, True)
            Catch ex As Exception
                MessageBox.Show(ex.Message)
            End Try
        End If

    End Sub

    Private Sub fixAs()

        Dim s As Integer = 0
        Dim t As Integer = 0
        Dim tb As Integer = 0
        Dim tempstring As String = ""
        Dim endpos As Integer = 0
        Dim myCol As Integer = CInt(GetRegKey("DimAsColumn"))

        Do While FixString.Substring(t, 1) = Space(1)
            t = t + 1
        Loop

        Do While FixString.Substring(tb, 1) = vbTab
            tb = tb + 1
        Loop


        FixString = FixString.TrimStart
        Dim x As Integer = FixString.IndexOf(" As ")
        Dim l As Integer = FixString.Length

        If x > 0 And x < myCol Then
            endpos = x + ((tb - 2) * 4)
            tempstring = FixString.Substring(0, x) & Space(myCol - endpos) & " As "
            FixString = Space(t) & tempstring & FixString.Substring(x + 4, l - (x + 4))
            If tb > 0 Then FixString = Space(tb * 4) & FixString
        End If

    End Sub
    Private Sub InLineFormat()

        Dim TempStr As String = ""

        If Not (mystring.TrimStart.Substring(0, 1) = "'") Then 'Do not reformat comments

            If mystring.Contains(Chr(34)) Then
                Dim c1, c2 As Integer
                c1 = mystring.IndexOf(Chr(34))
                c2 = mystring.LastIndexOf(Chr(34))
                If c2 - c1 > 2 Then
                    TempStr = mystring.Substring(c1, c2 - c1)
                End If
            End If

            'Dim Check (remove used variables from list)
            If Not mystring.TrimStart.Substring(0, 3) = "Dim" Then

                For x As Integer = VarList.Rows.Count - 1 To 0 Step -1

                    If VarList.Rows(x)("VarName").ToString.Trim.Length > 0 Then
                        If mystring.Contains(VarList.Rows(x)("VarName").ToString) Then
                            VarList.Rows(x)("VarHits") = CInt(VarList.Rows(x)("VarHits")) + 1
                        End If
                    End If

                Next

                VarList.AcceptChanges()

            End If
           

            If MainScreen.CheckBox2.Checked Then mystring = mystring.Replace(",", ", ")

            If MainScreen.CheckBox1.CheckState = CheckState.Checked Then
                mystring = mystring.Replace("+", " + ")

                If Not mystring.Contains("Format") Then
                    mystring = mystring.Replace("-", " - ")
                End If

                mystring = mystring.Replace("=", " = ")
                mystring = mystring.Replace("&", " & ")
                mystring = mystring.Replace("<", " < ")
                mystring = mystring.Replace(">", " > ")
                mystring = mystring.Replace("<   >", " <> ")
                mystring = mystring.Replace("<  >", " <> ")
                mystring = mystring.Replace("< >", " <> ")
                mystring = mystring.Replace("<   =", " <= ")
                mystring = mystring.Replace("<  =", " <= ")
                mystring = mystring.Replace("< =", " <= ")
                mystring = mystring.Replace(">   =", " >= ")
                mystring = mystring.Replace(">  =", " >= ")
                mystring = mystring.Replace("> =", " >= ")
                mystring = mystring.Replace("*", " * ")
            End If

            If MainScreen.CheckBox1.CheckState = CheckState.Indeterminate Then
                mystring = mystring.Replace(" + ", "+")
                mystring = mystring.Replace(" - ", "-")
                mystring = mystring.Replace(" = ", "=")
                mystring = mystring.Replace("& ", "&")
                mystring = mystring.Replace("< ", "<")
                mystring = mystring.Replace("> ", ">")
            End If

            If TempStr.Length > 0 Then
                Dim c1, c2 As Integer
                c1 = mystring.IndexOf(Chr(34))
                c2 = mystring.LastIndexOf(Chr(34))
                mystring = mystring.Substring(0, c1) & TempStr & mystring.Substring(c2)
                TempStr = ""
            End If

        End If

    End Sub
    Private Sub Translator()
        'Identify a specific command name

        If Not Codestart Then
            Call Writer(mystring)
            Exit Sub
        End If
        'Clear any spaces from the start of the current line and add the correct number of tab characters ******
        mystring = mystring.ToString.TrimStart

        For Y As Integer = 0 To Indent - 1
            mystring = vbTab & mystring
        Next
        '*******************************************************************************************************
        '
        '
        '
        'Create a temporary copy of the current line in lower case and strip any comments **********************
        Dim Tempstring As String = mystring.ToString.Trim.ToLower
        Tempstring = CommentStrip(Tempstring)

        If Tempstring.Length < 2 Then
            Writer(mystring)
            Exit Sub
        End If
        '******************************************************************************************************
        '
        '
        '
        'Identify specific commands ***************************************************************************
        Select Case Tempstring.Substring(0, 2)

            Case Is = "if" 'Identify the start of a conditional statement

                If ConfirmIf(Tempstring) Then
                    SendBlank(Settings(2))
                    Call AddTab()
                    SendBlank(Settings(3))
                Else
                    Writer(mystring)
                End If

            Case Is = "en"

                If ConfirmEnd(Tempstring) Then

                    If Tempstring.Contains("end sub") Then
                        Call ClearSubLevelVars()
                        SendBlank(Settings(8))
                        Call DelTab()
                        SendBlank(Settings(7))
                        Exit Select
                    End If

                    If Tempstring.Contains("end select") Then
                        SendBlank(Settings(6))
                        Indent = Indent - 1

                        If mystring.ToString.Substring(0, 1) = vbTab Then
                            mystring = mystring.Substring(1, mystring.ToString.Length - 1)
                        End If

                        Call DelTab()
                        SendBlank(Settings(7))
                        Exit Select
                    End If

                    SendBlank(Settings(6))
                    Call DelTab()
                    SendBlank(Settings(7))

                Else
                    Writer(mystring)
                End If


            Case Is = "su"

                If ConfirmSub(Tempstring) Then

                    If Tempstring.Contains("(") Then
                        Dim p As Integer = Tempstring.IndexOf("(") - 4
                        SubName = Tempstring.Substring(4, p).Trim
                    Else
                        SubName = Tempstring.Substring(4).Trim
                    End If
                    If Not SubName.Contains("_") Then SubRoutines.Add(SubName)
                    If SubName.Contains("globals") Then SubRoutines.Remove(SubName)

                    SendBlank(Settings(0))
                    Indent = 0
                    Call AddTab()

                    If Not (Tempstring.Substring(Tempstring.Length - 2) = " _") Then
                        SendBlank(Settings(1))
                    Else
                        HoldSpace = True 'Indicates that we are handling a split line
                    End If

                Else
                    Writer(mystring)
                End If

            Case Is = "pr"

                If ConfirmPrivateSub(Tempstring) Then

                    If Tempstring.Contains("(") Then
                        Dim p As Integer = Tempstring.IndexOf("(") - 12
                        SubName = Tempstring.Substring(12, p).Trim
                    Else
                        SubName = Tempstring.Substring(12).Trim
                    End If
                    If Not SubName.Contains("_") Then SubRoutines.Add(SubName)
                    If SubName.Contains("globals") Then SubRoutines.Remove(SubName)

                    SendBlank(Settings(0))
                    Indent = 0
                    Call AddTab()

                    If Not (Tempstring.Substring(Tempstring.Length - 2) = " _") Then
                        SendBlank(Settings(1))
                    Else
                        HoldSpace = True 'Indicates that we are handling a split line
                    End If

                Else
                    Writer(mystring)
                End If

            Case Is = "pu"

                If ConfirmPublicSub(Tempstring) Then

                    If Tempstring.Contains("(") Then
                        Dim p As Integer = Tempstring.IndexOf("(") - 11
                        SubName = Tempstring.Substring(11, p).Trim
                    Else
                        SubName = Tempstring.Substring(11).Trim
                    End If
                    If Not SubName.Contains("_") Then SubRoutines.Add(SubName)
                    If SubName.Contains("globals") Then SubRoutines.Remove(SubName)

                    SendBlank(Settings(0))
                    Indent = 0
                    Call AddTab()

                    If Not (Tempstring.Substring(Tempstring.Length - 2) = " _") Then
                        SendBlank(Settings(1))
                    Else
                        HoldSpace = True 'Indicates that we are handling a split line
                    End If

                Else
                    Writer(mystring)
                End If

            Case Is = "fo"

                If ConfirmFor(Tempstring) Then
                    SendBlank(Settings(2))
                    Call AddTab()
                    SendBlank(Settings(3))
                Else
                    Writer(mystring)
                End If


            Case Is = "do"

                If ConfirmDo(Tempstring) Then
                    SendBlank(Settings(2))
                    Call AddTab()
                    SendBlank(Settings(3))
                Else
                    Writer(mystring)
                End If

            Case Is = "di"

                ConfirmDim()
                Writer(mystring)

            Case Is = "lo"

                If ConfirmLoop(Tempstring) Then
                    SendBlank(Settings(6))
                    Call DelTab()
                    SendBlank(Settings(7))
                Else
                    Writer(mystring)
                End If


            Case Is = "ne"

                If ConfirmNext(Tempstring) Then
                    SendBlank(Settings(6))
                    Call DelTab()
                    SendBlank(Settings(7))
                Else
                    Writer(mystring)
                End If

            Case Is = "el"

                If ConfirmElse(Tempstring) Then
                    SendBlank(Settings(4))
                    Call DelTab()
                    Indent = Indent + 1
                    SendBlank(Settings(5))
                Else
                    Writer(mystring)
                End If

            Case Is = "se"

                If ConfirmSelect(Tempstring) Then
                    SelStart = True
                    SendBlank(Settings(2))
                    Call AddTab()
                Else
                    Writer(mystring)
                End If

            Case Is = "ca"

                If ConfirmCase(Tempstring) Then
                    SendBlank(Settings(2)) 'print blank line

                    If SelStart Then
                        Call AddTab() 'add indent and write to file
                        SelStart = False
                    Else
                        Call DelTab()
                        Indent = Indent + 1
                    End If

                    Exit Select
                End If

                If ConfirmCatch(Tempstring) Then
                    SendBlank(Settings(4))
                    Call DelTab()
                    Indent = Indent + 1
                    SendBlank(Settings(5))
                    Exit Select
                End If

                Writer(mystring)

                Exit Select

            Case Is = "tr"

                If ConfirmTry(Tempstring) Then
                    SendBlank(Settings(2))
                    Call AddTab()
                    SendBlank(Settings(3))
                Else
                    Writer(mystring)
                End If

            Case Else
                Writer(mystring)

        End Select

    End Sub

    Private Function ConfirmIf(ByVal Tempstring As String) As Boolean
        'Confirm that we are handling the 'If' conditional operator

        If Tempstring.Substring(0, 3) = "if " Then
            If Tempstring.TrimEnd.Substring(Tempstring.Length - 4, 4) = "then" Then Return True
        End If

        Return False

    End Function

    Private Function ConfirmEnd(ByVal Tempstring As String) As Boolean
        'Confirm that we are handling a routine 'End' operator

        If Tempstring.Trim.Substring(0, 6) = "end if" Then Return True
        If Tempstring.Trim.Substring(0, 7) = "end sub" Then Return True
        If Tempstring.Trim.Substring(0, 7) = "end try" Then Return True
        If Tempstring.Trim.Substring(0, 10) = "end select" Then Return True

        Return False

    End Function

    Private Function ConfirmDo(ByVal Tempstring As String) As Boolean
        'Confirm that we are handling the start of a 'Do' loop operation

        Select Case Tempstring.Trim.Length

            Case Is = 2
                If Tempstring.Trim = "do" Then Return True

            Case Is > 2
                If Tempstring.TrimStart.Substring(0, 3) = "do " Then Return True

        End Select

        Return False

    End Function

    Private Function ConfirmLoop(ByVal Tempstring As String) As Boolean
        'Confirm that we are handling the end of a do 'Loop' operation

        Select Case Tempstring.Trim.Length

            Case Is < 4
                Return False

            Case Is = 4
                If Tempstring.Trim.Substring(0, 4) = "loop" Then Return True

            Case Is > 4
                If Tempstring.Trim.Substring(0, 5) = "loop " Then Return True

        End Select

        Return False

    End Function

    Private Function ConfirmCatch(ByVal Tempstring As String) As Boolean
        'Confirm that we are handling a 'Catch' point in a Try / End Try operation

        Select Case Tempstring.Trim.Length

            Case Is < 5
                Return False

            Case Is = 5
                If Tempstring.Trim.Substring(0, 5) = "catch" Then Return True

            Case Is > 6
                If Tempstring.Trim.Substring(0, 6) = "catch " Then Return True

        End Select

        Return False

    End Function

    Private Function ConfirmNext(ByVal Tempstring As String) As Boolean
        'Confirm that we are handling 'Next' at the end of a conditional operation

        Select Case Tempstring.Trim.Length
            Case Is < 4
                Return False

            Case Is = 4
                If Tempstring.Trim.Substring(0, 4) = "next" Then Return True

            Case Is > 4
                If Tempstring.Trim.Substring(0, 5) = "next " Then Return True
        End Select

        Return False

    End Function

    Private Function ConfirmCase(ByVal Tempstring As String) As Boolean
        'Confirm that we are handling a 'Case statement in a conditional select statement

        Select Case Tempstring.Trim.Length
            Case Is < 4
                Return False

            Case Is = 4
                If Tempstring.Trim.Substring(0, 4) = "case" Then Return True

            Case Is > 4
                If Tempstring.Trim.Substring(0, 5) = "case " Then Return True
        End Select

        Return False

    End Function

    Private Function ConfirmElse(ByVal Tempstring As String) As Boolean
        'Confirm that we are handling the 'Else' part of an If End if conditional operation

        Select Case Tempstring.Trim.Length
            Case Is < 4
                Return False

            Case Is = 4
                If Tempstring.Trim.Substring(0, 4) = "else" Then Return True

            Case Is > 4
                If Tempstring.Trim.Substring(0, 5) = "else " Then Return True
        End Select

        Return False

    End Function

    Private Function ConfirmSelect(ByVal Tempstring As String) As Boolean

        Select Case Tempstring.Trim.Length
            Case Is < 7
                Return False

            Case Is >= 7
                If Tempstring.Trim.Substring(0, 7) = "select " Then Return True

        End Select

        Return False

    End Function

    Private Function ConfirmTry(ByVal Tempstring As String) As Boolean

        Select Case Tempstring.Trim.Length

            Case Is < 3
                Return False

            Case Is = 3
                If Tempstring.Trim.Substring(0, 3) = "try" Then Return True

            Case Is > 3
                If Tempstring.Trim.Substring(0, 4) = "try " Then Return True

        End Select

        Return False

    End Function

    Private Function ConfirmFor(ByVal Tempstring As String) As Boolean

        Select Case Tempstring.Trim.Length

            Case Is < 3
                Return False

            Case Is = 3
                If Tempstring.Trim.Substring(0, 3) = "for" Then Return True

            Case Is > 3
                If Tempstring.Trim.Substring(0, 4) = "for " Then Return True

        End Select

        Return False

    End Function

    Private Function ConfirmSub(ByVal Tempstring As String) As Boolean

        Select Case Tempstring.Trim.Length

            Case Is < 3
                Return False

            Case Is = 3
                If Tempstring.Trim.Substring(0, 3) = "sub" Then Return True

            Case Is > 3
                If Tempstring.Trim.Substring(0, 4) = "sub " Then Return True

        End Select

        Return False

    End Function

    Private Function ConfirmPrivateSub(ByVal Tempstring As String) As Boolean

        Select Case Tempstring.Trim.Length

            Case Is < 10
                Return False

            Case Is = 10
                If Tempstring.Trim.Substring(0, 11) = "private sub" Then Return True

            Case Is > 10
                If Tempstring.Trim.Substring(0, 12) = "private sub " Then Return True

        End Select

        Return False

    End Function

    Private Function ConfirmPublicSub(ByVal Tempstring As String) As Boolean

        Select Case Tempstring.Trim.Length

            Case Is < 10
                Return False

            Case Is = 10
                If Tempstring.Trim.Substring(0, 10) = "public sub" Then Return True

            Case Is > 10
                If Tempstring.Trim.Substring(0, 11) = "public sub " Then Return True

        End Select

        Return False

    End Function

    Private Sub ConfirmDim()

        Dim Temp As String = mystring.Trim

        If Temp.Length > 4 Then

            If Temp.TrimStart.Substring(0, 4) = "Dim " Then
                Dim E As Integer

                'if single dim
                Try
                    E = Temp.IndexOf("As ") - 4

                    If Temp.Contains(",") Then
                        Dim A, B, C As Integer
                        A = Temp.IndexOf("(")
                        B = Temp.IndexOf(",")
                        C = Temp.IndexOf(")")
                        If B > A And B < C Then Temp = Temp.Replace(",", "")
                    End If

                    Dim Temprow As System.Data.DataRow

                    If Not Temp.Contains(",") Then

                        If Temp.Substring(4, E).Contains("(") Then
                            Dim B As Integer = Temp.IndexOf("(")
                            E = B - 4
                        End If

                        Temprow = VarList.NewRow
                        Temprow("Module") = B4AActiveProjectFile.Substring(B4AActiveProjectFile.LastIndexOf("\") + 1)
                        Temprow("Subname") = SubName
                        Temprow("Varname") = Temp.Substring(4, E).TrimEnd

                        Select Case SubName.ToLower

                            Case Is = "process_globals"
                                Temprow("VarScope") = 0

                            Case Is = "globals"
                                Temprow("VarScope") = 1

                            Case Else
                                Temprow("VarScope") = 2

                        End Select
                        Temprow("VarHits") = 0
                        Temprow("ModCount") = 0
                        Temprow.EndEdit()
                        VarList.Rows.Add(Temprow)


                    Else 'multiple dim 
                        Dim arr As String() = SplitWords(Temp.Substring(4, E))

                        ' Display each word. Note that punctuation is handled correctly.
                        For Each s As String In arr

                            If s.Length > 0 Then
                                Temprow = VarList.NewRow
                                Temprow("Module") = B4AActiveProjectFile.Substring(B4AActiveProjectFile.LastIndexOf("\") + 1)
                                Temprow("Subname") = SubName
                                Temprow("Varname") = s

                                Select Case SubName.ToLower

                                    Case Is = "process_globals"
                                        Temprow("VarScope") = 0

                                    Case Is = "globals"
                                        Temprow("VarScope") = 1

                                    Case Else
                                        Temprow("VarScope") = 2

                                End Select
                                Temprow("VarHits") = 0
                                Temprow("ModCount") = 0
                                Temprow.EndEdit()
                                VarList.Rows.Add(Temprow)

                            End If

                        Next

                    End If
                Catch ex As System.ArgumentOutOfRangeException

                    row = Faults.NewRow()
                    row("Module") = B4AActiveProjectFile.Substring(B4AActiveProjectFile.LastIndexOf("\") + 1)
                    row("Sub") = SubName
                    row("Variable_Name") = Temp.Substring(4)
                    row("Fault Description") = " not declared as type" & vbNewLine
                    Faults.Rows.Add(row)
                    Dim Temprow As System.Data.DataRow
                    Temprow = VarList.NewRow
                    Temprow("Module") = B4AActiveProjectFile.Substring(B4AActiveProjectFile.LastIndexOf("\"))
                    Temprow("Subname") = SubName
                    Temprow("Varname") = Temp.Substring(4).TrimEnd
                    Select Case SubName.ToLower

                        Case Is = "process_globals"
                            Temprow("VarScope") = 0

                        Case Is = "globals"
                            Temprow("VarScope") = 1

                        Case Else
                            Temprow("VarScope") = 2

                    End Select
                    Temprow("VarHits") = 0
                    Temprow("ModCount") = 0
                    Temprow.EndEdit()
                    VarList.ImportRow(Temprow)
                End Try

            End If

        End If

    End Sub



    Public Function GetRegKey(ByVal name As String) As String
        'Get a value from the registry

        Dim reg As RegistryKey = Nothing

        'regkey is built from CompanyName\ProductName\MajorVersion.MinorVersion
        Dim version As String = "1.1" 'Convert.ToString(My.Application.Info.Version.Major) & "." & _
        'Convert.ToString(My.Application.Info.Version.Minor)
        Try
            Try
                reg = Registry.CurrentUser.OpenSubKey("Software\" & _
                 My.Application.Info.CompanyName & "\" & My.Application.Info.ProductName & "\" & version)

                If reg IsNot Nothing Then
                    Return Convert.ToString(reg.GetValue(name))
                End If
            Finally
                If reg IsNot Nothing Then reg.Close()
            End Try
        Catch ex As Exception
            MessageBox.Show("Error reading from registry (GetRegKey)", "", MessageBoxButtons.OK, MessageBoxIcon.Exclamation) '29/04/2010
        End Try

        Return ""
    End Function

    Public Function SetRegKey(ByVal name As String, ByVal value As String) As Boolean

        Try
            'Put a value into the registry
            Dim reg As RegistryKey = Nothing

            'regkey is built from CompanyName\ProductName\MajorVersion.MinorVersion
            Dim version As String = "1.1" 'Convert.ToString(My.Application.Info.Version.Major) & "." & _
            'Convert.ToString(My.Application.Info.Version.Minor)

            Try
                reg = Registry.CurrentUser.CreateSubKey("Software\" & _
                 My.Application.Info.CompanyName & "\" & My.Application.Info.ProductName & "\" & version)
                reg.SetValue(name, value)
                Return True
            Catch ex As Exception
                MessageBox.Show("Error accessing registry (SetRegKey2)", "", MessageBoxButtons.OK, MessageBoxIcon.Exclamation) '29/04/2010
                Return False
            Finally
                If reg IsNot Nothing Then reg.Close()
            End Try
        Catch
            MessageBox.Show("Error writing to registry (SetRegKey1)", "", MessageBoxButtons.OK, MessageBoxIcon.Exclamation) '29/04/2010
        End Try


    End Function

    Public Sub Reader()
        'Read through the project file line by line

        Dim fileReader As System.IO.StreamReader = My.Computer.FileSystem.OpenTextFileReader(B4AActiveProjectFile)
        LineNo = 0

        'Start the main file loop to read lines *******************************************************************
        If fileReader.BaseStream.Length > 0 Then
            MainScreen.ToolStripStatusLabel4.Text = B4AActiveProjectFile
            Dim sr As New StreamReader(B4AActiveProjectFile)
            Dim lines As String() = System.Text.RegularExpressions.Regex.Split(sr.ReadToEnd(), Environment.NewLine)
            MainScreen.ToolStripProgressBar1.Maximum = lines.Length
            sr.Close()
        End If
        '**********************************************************************************************************


        Do While Not fileReader.EndOfStream 'Read through a file line by line

            LineNo = LineNo + 1 'Generate the next line number
            MainScreen.ToolStripStatusLabel2.Text = LineNo.ToString 'Display the current line number 
            MainScreen.ToolStripProgressBar1.Value = LineNo
            My.Application.DoEvents()
            mystring = fileReader.ReadLine 'Get a line of text from the b4a project

            If mystring = "@EndOfDesignText@" Then
                Codestart = True 'Set the flag to show that we are in editable code
            End If


            If mystring.ToLower.Contains("'#coderoff") Then
                Codestart = False
            End If

            If mystring.ToLower.Contains("'#coderon") Then
                Codestart = True
            End If

            If mystring.Trim.Length >= 2 Then 'If the line is longer than two characters then pass it to the translator
                Translator()
            End If

            If HoldSpace = True Then 'Indicates the potential of a split line

                'Check whether we are handling a split line
                If Not (mystring.Trim.Substring(mystring.Trim.Length - 2) = " _") Then
                    SendBlank(CInt(MainScreen.TextBox3.Text))
                    HoldSpace = False
                End If

            End If

        Loop
        'EOF

        Call ClearModLevelVars()

        MainScreen.ToolStripProgressBar1.Value = MainScreen.ToolStripProgressBar1.Maximum 'Maximise progress bar if necessary
        fileReader.Close() 'Close the filereader
        fileReader = Nothing
        Processed = Processed + 1 'Advance the processed file counter
        My.Computer.FileSystem.DeleteFile(B4AActiveProjectFile) 'Delete the read file
        My.Computer.FileSystem.CopyFile(MyTempFile & "\b4aRebuildFile", B4AActiveProjectFile) 'Copy processed file to replace original

        If ProjFiles.Count > Processed Then 'If all files have NOT YET been processed

            Try 'Delete the temporary rebuild file
                If My.Computer.FileSystem.FileExists(MyTempFile & "\b4aRebuildFile") Then Kill(MyTempFile & "\b4aRebuildFile")
            Catch ex As Exception
                MessageBox.Show(ex.Message)
            End Try

            B4AActiveProjectFile = ProjFiles(Processed) 'Set the current file name to the next file name
            Codestart = False 'Set flag to indicate that we are not in editable code
            Call Reader() 'Start the file reading process again
        Else

            'If all files have been formatted build a list of filenames processed ***********************************************
            Dim Message As String = "Files formatted:" & vbNewLine & vbNewLine
            For Each PFile As String In ProjFiles
                Message = Message & PFile & vbNewLine
            Next
            '*******************************************************************************************************************

            'Transfer sub data to faultlist
            For Each filename As String In ProjFiles
                Call SubScan(filename)
            Next

            If SubRoutines.Count > 0 Then
                For Each s As String In SubRoutines
                    row = Faults.NewRow()
                    row("Module") = ""
                    row("Sub") = s
                    row("Variable_Name") = "Possibly dead code"
                    row("Fault Description") = " is an unused subroutine" & vbNewLine
                    Faults.Rows.Add(row)
                Next
            End If

            'Transfer variable data to fault table
            If VarList.Rows.Count > 0 Then 'if there are variables

                For Each Varrow In VarList.Rows

                    Select Case CInt(Varrow("VarScope"))

                        Case Is = 0 'Project Global

                            If CInt(Varrow("ModCount")) = 0 Then

                                row = Faults.NewRow()
                                row("Module") = Varrow("Module").ToString
                                row("Sub") = Varrow("Subname").ToString
                                row("Variable_Name") = Varrow("varname").ToString
                                row("Fault Description") = " is an unused variable" & vbNewLine
                                Faults.Rows.Add(row)

                            End If

                            If CInt(Varrow("ModCount")) = 1 Then
                                row = Faults.NewRow()
                                row("Module") = Varrow("Module").ToString
                                row("Sub") = Varrow("Subname").ToString
                                row("Variable_Name") = Varrow("varname").ToString
                                row("Fault Description") = " 'may' be a wrongly scoped variable" & vbNewLine
                                Faults.Rows.Add(row)
                            End If

                        Case Is > 0 'Module or sub level variable

                            row = Faults.NewRow()
                            row("Module") = Varrow("Module").ToString
                            row("Sub") = Varrow("Subname").ToString
                            row("Variable_Name") = Varrow("varname").ToString
                            row("Fault Description") = " is an unused variable" & vbNewLine
                            Faults.Rows.Add(row)

                    End Select

                Next

            End If

            If Faults.Rows.Count = 0 Then
                row = Faults.NewRow()
                row("Variable_Name") = "OK"
                row("Fault Description") = " No faults found" & vbNewLine
                Faults.Rows.Add(row)
            End If

            MainScreen.DataGridView1.Visible = True

            Faults.AcceptChanges()

            MainScreen.DataGridView1.DataSource = Faults
            MainScreen.DataGridView1.Columns(2).FillWeight = 100
            MainScreen.DataGridView1.Columns(1).FillWeight = 50
            MainScreen.DataGridView1.Columns(0).FillWeight = 50
            MainScreen.Button1.Visible = False
            MainScreen.Label4.Visible = False
            MainScreen.Button2.Visible = True
            MainScreen.ToolStripProgressBar1.Width = 0
            MainScreen.ToolStripStatusLabel4.Text = ""
            MainScreen.ToolStripStatusLabel2.Text = ""


            'Tell user that the B4aCoder is finished
            If ProjFiles.Count < 15 Then
                MessageBox.Show(Message, "Job Completed", MessageBoxButtons.OK, MessageBoxIcon.Information)
            Else
                MessageBox.Show(ProjFiles.Count & " Files formatted", "Job Completed", MessageBoxButtons.OK, MessageBoxIcon.Information)
            End If
        End If

    End Sub

    Private Function SplitWords(ByVal s As String) As String()
        Return Regex.Split(s, "\W+")
    End Function

    Public Sub ProjHeaderStrip()
        'Read the header in a project file

        DataSetup()
        Dim headerReader As System.IO.StreamReader = My.Computer.FileSystem.OpenTextFileReader(B4AActiveProjectFile)
        Dim HString As String = ""

        Do

            HString = headerReader.ReadLine

            If HString.Contains("Module") Then
                If Processed = 0 Then

                    If HString.Length > 8 Then

                        'recognise modules 1 - 9
                        If HString.Substring(7, 1) = "=" Then
                            If IsNumeric(HString.Substring(6, 1)) Then
                                ProjFiles.Add(MyDir & HString.Substring(8) & ".bas")
                            End If
                        End If

                        'recognise modules 9 - 99
                        If HString.Substring(8, 1) = "=" Then
                            If IsNumeric(HString.Substring(6, 1)) And IsNumeric(HString.Substring(7, 1)) Then
                                ProjFiles.Add(MyDir & HString.Substring(9) & ".bas")
                            End If
                        End If

                    End If

                End If

            End If

        Loop While HString <> "@EndOfDesignText@"

        headerReader.Close()

    End Sub

    Public Sub DataSetup()

        'Faults Table
        column = New System.Data.DataColumn()
        column.DataType = System.Type.GetType("System.String")
        column.ColumnName = "Module"
        column.ReadOnly = True
        Faults.Columns.Add(column)
        column = New System.Data.DataColumn()
        column.DataType = System.Type.GetType("System.String")
        column.ColumnName = "Sub"
        column.ReadOnly = True
        Faults.Columns.Add(column)
        column = New System.Data.DataColumn()
        column.DataType = System.Type.GetType("System.String")
        column.ColumnName = "Variable_Name"
        column.ReadOnly = True
        Faults.Columns.Add(column)
        column = New System.Data.DataColumn()
        column.DataType = System.Type.GetType("System.String")
        column.ColumnName = "Fault Description"
        column.ReadOnly = True
        Faults.Columns.Add(column)

        'Variable table
        Varcol = New System.Data.DataColumn()
        Varcol.DataType = System.Type.GetType("System.String")
        Varcol.ColumnName = "Module"
        VarList.Columns.Add(Varcol)

        Varcol = New System.Data.DataColumn()
        Varcol.DataType = System.Type.GetType("System.String")
        Varcol.ColumnName = "SubName"
        VarList.Columns.Add(Varcol)

        Varcol = New System.Data.DataColumn()
        Varcol.DataType = System.Type.GetType("System.String")
        Varcol.ColumnName = "VarName"
        VarList.Columns.Add(Varcol)

        'Varscope 0=ProjectGlobal(Public across project) - Process_Global
        'Varscope 1=DocumentGlobal(Private across module) - Global
        'Varscope 2=SubGlobal (Private across sub)
        Varcol = New System.Data.DataColumn()
        Varcol.DataType = System.Type.GetType("System.Int16")
        Varcol.ColumnName = "VarScope"
        VarList.Columns.Add(Varcol)

        Varcol = New System.Data.DataColumn()
        Varcol.DataType = System.Type.GetType("System.Int16")
        Varcol.ColumnName = "VarHits"
        VarList.Columns.Add(Varcol)

        Varcol = New System.Data.DataColumn()
        Varcol.DataType = System.Type.GetType("System.Int16")
        Varcol.ColumnName = "ModCount"
        VarList.Columns.Add(Varcol)





    End Sub


    Private Sub PrintDocument1_PrintPage(ByVal sender As Object, ByVal e As System.Drawing.Printing.PrintPageEventArgs) Handles PrintDocument1.PrintPage

        Dim drawRect As RectangleF
        Dim titlefont As New Font("Microsoft Sans Serif", 10, FontStyle.Bold) 'Define the default font
        Dim subtitlefont As New Font("Microsoft Sans Serif", 8, FontStyle.Bold) 'Define the default font
        Dim testfont As New Font("Microsoft Sans Serif", 6, FontStyle.Regular) 'Define the default font
        Dim X As Integer = 20
        Dim Y As Integer = 60
        Dim str As String = ""
        Static Printnum As Integer
        Dim counter As Integer = 0

        'Title
        Using blackbrush As Brush = New SolidBrush(Color.Black)
            drawRect = New RectangleF(20, 14, 300, 100)
            e.Graphics.DrawString("B4ACoder has found the following faults", titlefont, blackbrush, drawRect)

            drawRect = New RectangleF(20, 40, 400, 100)
            e.Graphics.DrawString("Module", subtitlefont, blackbrush, drawRect)
            drawRect = New RectangleF(100, 40, 400, 100)
            e.Graphics.DrawString("Sub", subtitlefont, blackbrush, drawRect)
            drawRect = New RectangleF(180, 40, 400, 100)
            e.Graphics.DrawString("Variable", subtitlefont, blackbrush, drawRect)
            drawRect = New RectangleF(280, 40, 400, 100)
            e.Graphics.DrawString("Fault", subtitlefont, blackbrush, drawRect)

        End Using

        For Each row In Faults.Rows


            If counter >= Printnum Then


                str = row(0).ToString & vbTab & row(1).ToString & vbTab & row(2).ToString & vbTab & row(3).ToString
                Using blackbrush As Brush = New SolidBrush(Color.Black)

                    drawRect = New RectangleF(X, Y, 400, 100)
                    e.Graphics.DrawString(row(0).ToString, testfont, blackbrush, drawRect)
                    drawRect = New RectangleF(X + 80, Y, 400, 100)
                    e.Graphics.DrawString(row(1).ToString, testfont, blackbrush, drawRect)
                    drawRect = New RectangleF(X + 160, Y, 400, 100)
                    e.Graphics.DrawString(row(2).ToString, testfont, blackbrush, drawRect)
                    drawRect = New RectangleF(X + 260, Y, 400, 100)
                    e.Graphics.DrawString(row(3).ToString, testfont, blackbrush, drawRect)


                    Y = Y + 15
                    If Y >= e.PageBounds.Height - 80 Then
                        Y = 60
                        X = X + 380

                        '2nd SubTitle
                        drawRect = New RectangleF(400, 40, 400, 100)
                        e.Graphics.DrawString("Module", subtitlefont, blackbrush, drawRect)
                        drawRect = New RectangleF(480, 40, 400, 100)
                        e.Graphics.DrawString("Sub", subtitlefont, blackbrush, drawRect)
                        drawRect = New RectangleF(560, 40, 400, 100)
                        e.Graphics.DrawString("Variable", subtitlefont, blackbrush, drawRect)
                        drawRect = New RectangleF(660, 40, 400, 100)
                        e.Graphics.DrawString("Fault", subtitlefont, blackbrush, drawRect)

                        If X >= 500 Then
                            Printnum = Printnum + 1
                            Exit For
                        End If

                    End If
                End Using

                Printnum = Printnum + 1
            End If

            counter = counter + 1

        Next

        If Printnum < Faults.Rows.Count Then
            e.HasMorePages = True
        Else
            e.HasMorePages = False
        End If

    End Sub

    Public Sub PrintFaults()
        PrintDocument1.Print()
    End Sub

    Private Sub SubScan(ByVal filename As String)
        'scan project and compare with sub list

        Dim fileReader As System.IO.StreamReader = My.Computer.FileSystem.OpenTextFileReader(filename)

        Do While Not fileReader.EndOfStream 'Read through a file line by line
            mystring = fileReader.ReadLine.ToLower

            For x As Integer = SubRoutines.Count - 1 To 0 Step -1

                If mystring.Length > 4 Then
                    If Not (mystring.Substring(0, 3) = "sub") Then

                        If mystring.Contains(SubRoutines(x).ToString) Then
                            SubRoutines.RemoveAt(x)
                        End If
                    End If
                End If

            Next

        Loop


        fileReader.Close()

    End Sub

    Private Sub ClearSubLevelVars()
        'Clear sub level variables that have been used
        Dim X As Integer

        For X = VarList.Rows.Count - 1 To 0 Step -1

            Varrow = VarList.Rows(X)

            If CInt(Varrow("VarScope")) = 2 Then 'identify  sub level variables

                If CInt(Varrow("VarHits")) > 0 Then 'If variable has been used
                    VarList.Rows.Remove(Varrow)
                End If

            End If

        Next

        VarList.AcceptChanges()

    End Sub

    Private Sub ClearModLevelVars()
        'Clear sub level variables that have been used

        Dim X As Integer

        For X = VarList.Rows.Count - 1 To 0 Step -1

            Varrow = VarList.Rows(X)

            Select Case CInt(Varrow("VarScope"))

                Case Is = 1  'identify  sub level variables

                    If CInt(Varrow("VarHits")) > 0 Then 'If variable has been used
                        VarList.Rows.Remove(Varrow)
                    End If

                Case Is = 0  'identify  project level variables

                    If CInt(Varrow("VarHits")) > 0 Then 'If variable has been used
                        Varrow("VarHits") = 0
                        Varrow("ModCount") = CInt(Varrow("ModCount")) + 1
                    End If

            End Select

        Next

        VarList.AcceptChanges()

    End Sub

End Module
