/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.keywords.SimpleMessageLoop;
import java.util.concurrent.ConcurrentHashMap;

@BA.Hide
public class StandardBA
extends BA {
    private final Thread ownerThread = Thread.currentThread();
    private static final ConcurrentHashMap<Thread, SimpleMessageLoop> loops = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StandardBA(String packageName, String className, Object eventsTarget) {
        super(packageName, className, eventsTarget);
        ConcurrentHashMap<Thread, SimpleMessageLoop> concurrentHashMap = loops;
        synchronized (concurrentHashMap) {
            if (!loops.containsKey(this.ownerThread)) {
                loops.put(this.ownerThread, new SimpleMessageLoop());
            }
        }
    }

    @Override
    public void startMessageLoop() throws InterruptedException {
        if (this.ownerThread != Thread.currentThread()) {
            throw new RuntimeException("StartMessageLoop called from wrong thread.");
        }
        SimpleMessageLoop loop = loops.get(this.ownerThread);
        loop.runMessageLoop();
    }

    @Override
    public void postRunnable(Runnable runnable2) {
        SimpleMessageLoop loop = loops.get(this.ownerThread);
        loop.put(runnable2);
    }

    @Override
    public void stopMessageLoop() {
        this.postRunnable(SimpleMessageLoop.STOP);
    }

    @Override
    public Thread getOwnerThread() {
        return this.ownerThread;
    }

    @Override
    public void cleanMessageLoop() throws InterruptedException {
        SimpleMessageLoop loop = loops.get(this.ownerThread);
        loop.clear();
    }
}

