/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.objects.streams;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.keywords.Bit;
import anywheresoftware.b4a.keywords.Common;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;

public class File {
    private static final String assetsDir = "AssetsDir";
    @BA.Hide
    public static String assetsDirName = "/Files";
    @BA.Hide
    public static Class<?> getResourceClass = File.class;
    private static int os;

    public static String getDirAssets() {
        return assetsDir;
    }

    public static String getDirTemp() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String getDirApp() {
        return System.getProperty("user.dir");
    }

    public static String DirData(String AppName) throws IOException {
        if (os == 0) {
            String s = System.getProperty("os.name", "").toLowerCase(BA.cul);
            os = s.contains("win") ? 1 : (s.contains("mac") ? 2 : 3);
        }
        if (os == 1 || os == 2) {
            String res = os == 1 ? File.Combine(System.getenv("AppData"), AppName) : File.Combine(Common.GetSystemProperty("user.home", ""), "Library/Application Support/" + AppName);
            if (!File.Exists(res, "")) {
                File.MakeDir(res, "");
            }
            return res;
        }
        return File.getDirApp();
    }

    public static String GetFileParent(String FileName) {
        String s = new java.io.File(FileName).getParent();
        return s == null ? "" : s;
    }

    public static String GetName(String FilePath) {
        return new java.io.File(FilePath).getName();
    }

    public static boolean Exists(String Dir, String FileName) throws IOException {
        if ("".equals(Dir)) {
            Dir = null;
        }
        return new java.io.File(Dir, FileName).exists();
    }

    public static boolean Delete(String Dir, String FileName) {
        if ("".equals(Dir)) {
            Dir = null;
        }
        return new java.io.File(Dir, FileName).delete();
    }

    public static void MakeDir(String Parent, String Dir) {
        java.io.File file = new java.io.File(Parent, Dir);
        file.mkdirs();
    }

    public static long Size(String Dir, String FileName) {
        if ("".equals(Dir)) {
            Dir = null;
        }
        return new java.io.File(Dir, FileName).length();
    }

    public static long LastModified(String Dir, String FileName) {
        if ("".equals(Dir)) {
            Dir = null;
        }
        return new java.io.File(Dir, FileName).lastModified();
    }

    public static boolean IsDirectory(String Dir, String FileName) {
        if ("".equals(Dir)) {
            Dir = null;
        }
        return new java.io.File(Dir, FileName).isDirectory();
    }

    public static String GetUri(String Dir, String FileName) {
        if (Dir.equals(File.getDirAssets())) {
            URL u = getResourceClass.getResource(String.valueOf(assetsDirName) + "/" + FileName);
            if (u == null) {
                throw new RuntimeException("Asset file not found: " + FileName);
            }
            return u.toString();
        }
        return new java.io.File(File.Combine(Dir, FileName)).toURI().toString();
    }

    public static String Combine(String Dir, String FileName) {
        if ("".equals(Dir)) {
            Dir = null;
        }
        return new java.io.File(Dir, FileName).toString();
    }

    public static anywheresoftware.b4a.objects.collections.List ListFiles(String Dir) throws IOException {
        anywheresoftware.b4a.objects.collections.List list = new anywheresoftware.b4a.objects.collections.List();
        if (!Dir.equals(assetsDir)) {
            java.io.File folder = new java.io.File(Dir);
            if (!folder.isDirectory()) {
                throw new IOException(String.valueOf(Dir) + " is not a folder.");
            }
            String[] f = folder.list();
            if (f != null) {
                list.setObject(Arrays.asList(f));
            }
        } else {
            throw new RuntimeException("Cannot list assets files");
        }
        return list;
    }

    public static InputStreamWrapper OpenInput(String Dir, String FileName) throws IOException {
        InputStreamWrapper is = new InputStreamWrapper();
        if (Dir.equals(assetsDir)) {
            InputStream in = getResourceClass.getResourceAsStream(String.valueOf(assetsDirName) + "/" + FileName);
            if (in == null) {
                throw new FileNotFoundException(FileName);
            }
            is.setObject(in);
        } else {
            if ("".equals(Dir)) {
                Dir = null;
            }
            is.setObject(new BufferedInputStream(new FileInputStream(new java.io.File(Dir, FileName)), 8192));
        }
        return is;
    }

    public static anywheresoftware.b4a.objects.collections.List ReadList(String Dir, String FileName) throws IOException {
        InputStreamWrapper in = File.OpenInput(Dir, FileName);
        TextReaderWrapper tr = new TextReaderWrapper();
        tr.Initialize((InputStream)in.getObject());
        return tr.ReadList();
    }

    public static void WriteList(String Dir, String FileName, anywheresoftware.b4a.objects.collections.List List2) throws IOException {
        OutputStreamWrapper out = File.OpenOutput(Dir, FileName, false);
        TextWriterWrapper tw = new TextWriterWrapper();
        tw.Initialize((OutputStream)out.getObject());
        tw.WriteList(List2);
        tw.Close();
    }

    public static void WriteString(String Dir, String FileName, String Text) throws IOException {
        OutputStreamWrapper out = File.OpenOutput(Dir, FileName, false);
        TextWriterWrapper tw = new TextWriterWrapper();
        tw.Initialize((OutputStream)out.getObject());
        tw.Write(Text);
        tw.Close();
    }

    public static String ReadString(String Dir, String FileName) throws IOException {
        InputStreamWrapper in = File.OpenInput(Dir, FileName);
        TextReaderWrapper tr = new TextReaderWrapper();
        tr.Initialize((InputStream)in.getObject());
        String res = tr.ReadAll();
        in.Close();
        return res;
    }

    public static void WriteMap(String Dir, String FileName, anywheresoftware.b4a.objects.collections.Map Map2) throws IOException {
        OutputStreamWrapper out = File.OpenOutput(Dir, FileName, false);
        Properties p = new Properties();
        Map m = (Map)Map2.getObject();
        for (Map.Entry e : m.entrySet()) {
            p.setProperty(String.valueOf(e.getKey()), String.valueOf(e.getValue()));
        }
        p.store((OutputStream)out.getObject(), null);
        out.Close();
    }

    public static anywheresoftware.b4a.objects.collections.Map ReadMap(String Dir, String FileName) throws IOException {
        return File.ReadMap2(Dir, FileName, null);
    }

    public static anywheresoftware.b4a.objects.collections.Map ReadMap2(String Dir, String FileName, anywheresoftware.b4a.objects.collections.Map Map2) throws IOException {
        InputStreamWrapper in = File.OpenInput(Dir, FileName);
        Properties p = new Properties();
        p.load((InputStream)in.getObject());
        if (Map2 == null) {
            Map2 = new anywheresoftware.b4a.objects.collections.Map();
        }
        if (!Map2.IsInitialized()) {
            Map2.Initialize();
        }
        for (Map.Entry<Object, Object> e : p.entrySet()) {
            Map2.Put(e.getKey(), e.getValue());
        }
        in.Close();
        return Map2;
    }

    public static void Copy(String DirSource, String FileSource, String DirTarget, String FileTarget) throws IOException {
        File.Delete(DirTarget, FileTarget);
        InputStream in = (InputStream)File.OpenInput(DirSource, FileSource).getObject();
        OutputStream out = (OutputStream)File.OpenOutput(DirTarget, FileTarget, false).getObject();
        File.Copy2(in, out);
        in.close();
        out.close();
    }

    public static void Copy2(InputStream In, OutputStream Out) throws IOException {
        byte[] buffer = new byte[8192];
        int count = 0;
        while ((count = In.read(buffer)) > 0) {
            Out.write(buffer, 0, count);
        }
        In.close();
    }

    public static Object Copy2Async(BA ba, final InputStream In, final OutputStream Out) {
        Object senderFilter = new Object();
        BA.runAsync(ba, senderFilter, "complete", new Object[]{false}, new Callable<Object[]>(){

            @Override
            public Object[] call() throws Exception {
                File.Copy2(In, Out);
                return new Object[]{true};
            }
        });
        return senderFilter;
    }

    public static Object ListFilesAsync(BA ba, final String Dir) {
        Object senderFilter = new Object();
        BA.runAsync(ba, senderFilter, "complete", new Object[]{false, new anywheresoftware.b4a.objects.collections.List()}, new Callable<Object[]>(){

            @Override
            public Object[] call() throws Exception {
                anywheresoftware.b4a.objects.collections.List l = File.ListFiles(Dir);
                return new Object[]{true, l};
            }
        });
        return senderFilter;
    }

    public static Object CopyAsync(BA ba, final String DirSource, final String FileSource, final String DirTarget, final String FileTarget) throws IOException {
        Object senderFilter = new Object();
        BA.runAsync(ba, senderFilter, "complete", new Object[]{false}, new Callable<Object[]>(){

            @Override
            public Object[] call() throws Exception {
                File.Copy(DirSource, FileSource, DirTarget, FileTarget);
                return new Object[]{true};
            }
        });
        return senderFilter;
    }

    public static byte[] ReadBytes(String Dir, String FileName) throws IOException {
        return Bit.InputStreamToBytes((InputStream)File.OpenInput(Dir, FileName).getObject());
    }

    public static void WriteBytes(String Dir, String FileName, byte[] Data) throws IOException {
        OutputStreamWrapper o = File.OpenOutput(Dir, FileName, false);
        try {
            o.WriteBytes(Data, 0, Data.length);
        }
        finally {
            o.Close();
        }
    }

    public static OutputStreamWrapper OpenOutput(String Dir, String FileName, boolean Append) throws FileNotFoundException {
        if ("".equals(Dir)) {
            Dir = null;
        }
        OutputStreamWrapper o = new OutputStreamWrapper();
        o.setObject(new BufferedOutputStream(new FileOutputStream(new java.io.File(Dir, FileName), Append)));
        return o;
    }

    @BA.ShortName(value="InputStream")
    public static class InputStreamWrapper
    extends AbsObjectWrapper<InputStream> {
        public void InitializeFromBytesArray(byte[] Buffer2, int StartOffset, int MaxCount) {
            this.setObject(new ByteArrayInputStream(Buffer2, StartOffset, MaxCount));
        }

        public void Close() throws IOException {
            ((InputStream)this.getObject()).close();
        }

        public int ReadBytes(byte[] Buffer2, int StartOffset, int MaxCount) throws IOException {
            return ((InputStream)this.getObject()).read(Buffer2, StartOffset, MaxCount);
        }

        public int BytesAvailable() throws IOException {
            return ((InputStream)this.getObject()).available();
        }
    }

    @BA.ShortName(value="OutputStream")
    public static class OutputStreamWrapper
    extends AbsObjectWrapper<OutputStream> {
        public void InitializeToBytesArray(int StartSize) {
            this.setObject(new ByteArrayOutputStream(StartSize));
        }

        public byte[] ToBytesArray() {
            if (!(this.getObject() instanceof ByteArrayOutputStream)) {
                throw new RuntimeException("ToBytes can only be called after InitializeToBytesArray.");
            }
            return ((ByteArrayOutputStream)this.getObject()).toByteArray();
        }

        public void Close() throws IOException {
            ((OutputStream)this.getObject()).close();
        }

        public void Flush() throws IOException {
            ((OutputStream)this.getObject()).flush();
        }

        public void WriteBytes(byte[] Buffer2, int StartOffset, int Length) throws IOException {
            ((OutputStream)this.getObject()).write(Buffer2, StartOffset, Length);
        }
    }

    @BA.ShortName(value="TextReader")
    public static class TextReaderWrapper
    extends AbsObjectWrapper<BufferedReader> {
        public void Initialize(InputStream InputStream2) {
            this.setObject(new BufferedReader(new InputStreamReader(InputStream2, Charset.forName("UTF8")), 4096));
        }

        public void Initialize2(InputStream InputStream2, String Encoding) {
            this.setObject(new BufferedReader(new InputStreamReader(InputStream2, Charset.forName(Encoding)), 4096));
        }

        public String ReadLine() throws IOException {
            return ((BufferedReader)this.getObject()).readLine();
        }

        public int Read(char[] Buffer2, int StartOffset, int Length) throws IOException {
            return ((BufferedReader)this.getObject()).read(Buffer2, StartOffset, Length);
        }

        public boolean Ready() throws IOException {
            return ((BufferedReader)this.getObject()).ready();
        }

        public String ReadAll() throws IOException {
            int count;
            char[] buffer = new char[1024];
            StringBuilder sb = new StringBuilder(1024);
            while ((count = this.Read(buffer, 0, buffer.length)) != -1) {
                if (count < buffer.length) {
                    sb.append(new String(buffer, 0, count));
                    continue;
                }
                sb.append(buffer);
            }
            this.Close();
            return sb.toString();
        }

        public anywheresoftware.b4a.objects.collections.List ReadList() throws IOException {
            String line;
            anywheresoftware.b4a.objects.collections.List List2 = new anywheresoftware.b4a.objects.collections.List();
            List2.Initialize();
            while ((line = this.ReadLine()) != null) {
                List2.Add(line);
            }
            this.Close();
            return List2;
        }

        public int Skip(int NumberOfCharaceters) throws IOException {
            return (int)((BufferedReader)this.getObject()).skip(NumberOfCharaceters);
        }

        public void Close() throws IOException {
            ((BufferedReader)this.getObject()).close();
        }
    }

    @BA.ShortName(value="TextWriter")
    public static class TextWriterWrapper
    extends AbsObjectWrapper<BufferedWriter> {
        public void Initialize(OutputStream OutputStream2) {
            this.setObject(new BufferedWriter(new OutputStreamWriter(OutputStream2, Charset.forName("UTF8")), 4096));
        }

        public void Initialize2(OutputStream OutputStream2, String Encoding) {
            this.setObject(new BufferedWriter(new OutputStreamWriter(OutputStream2, Charset.forName(Encoding)), 4096));
        }

        public void Write(String Text) throws IOException {
            ((BufferedWriter)this.getObject()).write(Text);
        }

        public void WriteLine(String Text) throws IOException {
            ((BufferedWriter)this.getObject()).write(String.valueOf(Text) + "\n");
        }

        public void WriteList(anywheresoftware.b4a.objects.collections.List List2) throws IOException {
            for (Object line : (List)List2.getObject()) {
                this.WriteLine(String.valueOf(line));
            }
        }

        public void Close() throws IOException {
            ((BufferedWriter)this.getObject()).close();
        }

        public void Flush() throws IOException {
            ((BufferedWriter)this.getObject()).flush();
        }
    }
}

