/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.randomaccessfile;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.objects.streams.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.zip.Adler32;

@BA.ShortName(value="AsyncStreams")
public class AsyncStreams {
    static final int STREAM_PREFIX = -2;
    static final byte[] CLOSE_PILL = new byte[0];
    private String eventName;
    private BA ba;
    private AIN ain;
    private Thread tin;
    private AOUT aout;
    private Thread tout;
    public String StreamFolder;
    public boolean ContinueAfterTimeout;
    volatile long streamReceived;
    volatile long streamTotal;
    public int OutputQueueMaxSize = 100;

    public void Initialize(BA ba, InputStream In, OutputStream Out, String EventName) throws IOException {
        this.shared(ba, In, Out, EventName, false, false);
    }

    public void InitializePrefix(BA ba, InputStream In, boolean BigEndian, OutputStream Out, String EventName) throws IOException {
        this.StreamFolder = File.getDirTemp();
        this.shared(ba, In, Out, EventName, BigEndian, true);
    }

    public long getStreamTotal() {
        return this.streamTotal;
    }

    public long getStreamReceived() {
        return this.streamReceived;
    }

    private void shared(BA ba, InputStream In, OutputStream Out, String EventName, boolean BigEndian, boolean Prefix) throws IOException {
        if (this.IsInitialized()) {
            this.Close();
        }
        this.ba = ba;
        this.eventName = EventName.toLowerCase(BA.cul);
        if (In != null) {
            this.ain = new AIN(In, BigEndian, Prefix);
            this.tin = new Thread(this.ain);
            this.tin.setDaemon(true);
            this.tin.start();
        }
        if (Out != null) {
            this.aout = new AOUT(Out, BigEndian, Prefix);
            this.tout = new Thread(this.aout);
            this.tout.setDaemon(true);
            this.tout.start();
        }
    }

    public boolean IsInitialized() {
        return this.ain != null || this.aout != null;
    }

    public boolean Write(byte[] Buffer2) {
        return this.Write2(Buffer2, 0, Buffer2.length);
    }

    public boolean Write2(byte[] Buffer2, int Start2, int Length) {
        AOUT a = this.aout;
        if (a == null) {
            return false;
        }
        return a.put(Buffer2, Start2, Length);
    }

    public boolean SendAllAndClose() {
        return this.Write2(CLOSE_PILL, 0, 0);
    }

    public boolean WriteStream(InputStream In, Long Size) {
        AOUT a = this.aout;
        if (a == null) {
            return false;
        }
        return a.put(In, Size);
    }

    public int getOutputQueueSize() {
        if (this.aout == null) {
            return 0;
        }
        return this.aout.queue.size();
    }

    public synchronized void Close() throws IOException {
        if (this.tin != null && this.ain != null) {
            this.ain.close();
            if (Thread.currentThread() != this.tin) {
                this.tin.interrupt();
            }
        }
        if (this.tout != null && this.aout != null) {
            this.aout.close();
            if (Thread.currentThread() != this.tout) {
                this.tout.interrupt();
            }
        }
        this.ain = null;
        this.aout = null;
    }

    public void StopWithoutClosingStreams() throws IOException {
        if (this.tin != null && this.ain != null) {
            this.ain.working = false;
            this.tin.interrupt();
        }
        if (this.tout != null && this.aout != null) {
            this.aout.working = false;
            this.tout.interrupt();
        }
        this.ain = null;
        this.aout = null;
    }

    private class AIN
    implements Runnable {
        private final InputStream in;
        private byte[] buffer = new byte[8192];
        private final byte[] prefixBuffer = new byte[4];
        private final boolean prefix;
        public volatile boolean working = true;
        private String ev;
        private ByteBuffer bb;

        public AIN(InputStream in, boolean bigEndian, boolean prefix) {
            this.ev = String.valueOf(AsyncStreams.this.eventName) + "_newdata";
            this.in = in;
            this.prefix = prefix;
            if (prefix) {
                this.bb = ByteBuffer.wrap(new byte[8]);
                this.bb.order(bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            }
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try lbl-1000:
            // 2 sources

            {
                while (true) {
                    block25: {
                        if (!this.working) {
                            return;
                        }
                        if (!this.prefix) {
                            try {
                                count = this.in.read(this.buffer);
                                if (count == 0) continue;
                                if (count < 0) {
                                    this.closeUnexpected();
                                    return;
                                }
                                if (!this.working) {
                                    return;
                                }
                                data = new byte[count];
                                System.arraycopy(this.buffer, 0, data, 0, count);
                            }
                            catch (SocketTimeoutException ste) {
                                if (!this.working) {
                                    return;
                                }
                                if (AsyncStreams.this.ContinueAfterTimeout) continue;
                                throw ste;
                            }
                        }
                        if (!this.readNumberOfBytes(this.in, this.prefixBuffer, 4)) {
                            return;
                        }
                        if (!this.working) {
                            return;
                        }
                        this.bb.clear();
                        this.bb.put(this.prefixBuffer, 0, 4);
                        msgLength = this.bb.getInt(0);
                        if (msgLength > 100000000) {
                            throw new RuntimeException("Message size too large. Prefix mode can only work if both sides of the connection follow the 'prefix' protocol.");
                        }
                        if (msgLength != -2) break block25;
                        if (!this.readNumberOfBytes(this.in, this.buffer, 8)) {
                            return;
                        }
                        this.bb.clear();
                        this.bb.put(this.buffer, 0, 8);
                        AsyncStreams.this.streamTotal = this.bb.getLong(0);
                        AsyncStreams.this.streamReceived = 0L;
                        i = 1;
                        if (true) ** GOTO lbl63
                    }
                    if (msgLength > this.buffer.length) {
                        this.buffer = new byte[msgLength];
                    }
                    if (!this.readNumberOfBytes(this.in, this.buffer, msgLength)) {
                        return;
                    }
                    data = new byte[msgLength];
                    System.arraycopy(this.buffer, 0, data, 0, data.length);
                    AsyncStreams.access$1(AsyncStreams.this).raiseEventFromDifferentThread((Object)AsyncStreams.this, null, AsyncStreams.this, this.ev, true, new Object[]{data});
                    continue;
                    break;
                }
            }
            catch (Exception e) {
                if (this.working == false) return;
                e.printStackTrace();
                AsyncStreams.access$1(AsyncStreams.this).setLastException(e);
                AsyncStreams.access$1(AsyncStreams.this).raiseEventFromDifferentThread((Object)AsyncStreams.this, null, AsyncStreams.this, String.valueOf(AsyncStreams.access$0(AsyncStreams.this)) + "_error", false, null);
            }
            return;
            do {
                ++i;
lbl63:
                // 2 sources

            } while (File.Exists(AsyncStreams.this.StreamFolder, "AsyncInput" + String.valueOf(i)));
            FileName = "AsyncInput" + String.valueOf(i);
            out = (OutputStream)File.OpenOutput(AsyncStreams.this.StreamFolder, FileName, false).getObject();
            try {
                adler = new Adler32();
                while (AsyncStreams.this.streamReceived < AsyncStreams.this.streamTotal) {
                    remain = AsyncStreams.this.streamTotal - AsyncStreams.this.streamReceived;
                    len = (int)(remain > (long)this.buffer.length ? (long)this.buffer.length : remain);
                    if (!this.readNumberOfBytes(this.in, this.buffer, len)) break;
                    adler.update(this.buffer, 0, len);
                    out.write(this.buffer, 0, len);
                    AsyncStreams.this.streamReceived += (long)len;
                }
                if (!this.readNumberOfBytes(this.in, this.buffer, 8)) {
                    return;
                }
                this.bb.clear();
                this.bb.put(this.buffer, 0, 8);
                crc = this.bb.getLong(0);
                if (crc != adler.getValue()) {
                    throw new Exception("CRC value does not match.");
                }
            }
            finally {
                out.close();
            }
            AsyncStreams.access$1(AsyncStreams.this).raiseEventFromDifferentThread((Object)AsyncStreams.this, null, AsyncStreams.this, String.valueOf(AsyncStreams.access$0(AsyncStreams.this)) + "_newstream", true, new Object[]{AsyncStreams.this.StreamFolder, FileName});
            ** while (true)
        }

        private boolean readNumberOfBytes(InputStream in, byte[] buffer, int len) throws IOException {
            int count = 0;
            while (count < len) {
                int c = in.read(buffer, count, len - count);
                if (c == -1) {
                    this.closeUnexpected();
                    return false;
                }
                count += c;
            }
            return true;
        }

        private void closeUnexpected() throws IOException {
            AsyncStreams.this.ba.raiseEventFromDifferentThread((Object)AsyncStreams.this, (Object)null, 0, String.valueOf(AsyncStreams.this.eventName) + "_terminated", false, (Object[])null);
            AsyncStreams.this.Close();
        }

        public void close() {
            this.working = false;
            try {
                this.in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private class AOUT
    implements Runnable {
        private final OutputStream out;
        public volatile boolean working = true;
        private final ArrayBlockingQueue<Object> queue;
        private final boolean prefix;
        private final ByteBuffer bb;
        private byte[] streamBuffer;

        public AOUT(OutputStream out, boolean bigEndian, boolean prefix) {
            this.queue = new ArrayBlockingQueue(AsyncStreams.this.OutputQueueMaxSize);
            this.out = out;
            this.prefix = prefix;
            if (prefix) {
                this.bb = ByteBuffer.wrap(new byte[8]);
                this.bb.order(bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            } else {
                this.bb = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.working) {
                try {
                    Object b = this.queue.take();
                    if (b instanceof byte[]) {
                        if (b == CLOSE_PILL) {
                            AsyncStreams.this.ba.raiseEventFromDifferentThread((Object)AsyncStreams.this, (Object)null, 0, String.valueOf(AsyncStreams.this.eventName) + "_terminated", false, (Object[])null);
                            AsyncStreams.this.Close();
                            return;
                        }
                        this.out.write((byte[])b);
                        continue;
                    }
                    StreamAndSize st = (StreamAndSize)b;
                    try {
                        int len;
                        Adler32 adler = new Adler32();
                        ByteBuffer byteBuffer = this.bb;
                        synchronized (byteBuffer) {
                            this.bb.putInt(0, -2);
                            this.out.write(this.bb.array(), 0, 4);
                            this.bb.putLong(0, st.size);
                            this.out.write(this.bb.array(), 0, 8);
                        }
                        if (this.streamBuffer == null) {
                            this.streamBuffer = new byte[8192];
                        }
                        while ((len = st.in.read(this.streamBuffer)) > 0) {
                            this.out.write(this.streamBuffer, 0, len);
                            adler.update(this.streamBuffer, 0, len);
                        }
                        ByteBuffer byteBuffer2 = this.bb;
                        synchronized (byteBuffer2) {
                            this.bb.putLong(0, adler.getValue());
                            this.out.write(this.bb.array(), 0, 8);
                        }
                    }
                    finally {
                        try {
                            st.in.close();
                        }
                        catch (Exception ee) {
                            ee.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    if (!this.working) continue;
                    e.printStackTrace();
                    AsyncStreams.this.ba.setLastException(e);
                    AsyncStreams.this.ba.raiseEventFromDifferentThread((Object)AsyncStreams.this, null, AsyncStreams.this, String.valueOf(AsyncStreams.this.eventName) + "_error", false, null);
                }
            }
        }

        public boolean put(InputStream in, long size) {
            if (!this.prefix) {
                throw new RuntimeException("WriteStream is only supported in prefix mode.");
            }
            try {
                StreamAndSize st = new StreamAndSize();
                st.in = in;
                st.size = size;
                return this.queue.offer(st, 100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean put(byte[] buffer, int start, int len) {
            byte[] b;
            if (buffer == CLOSE_PILL) {
                b = CLOSE_PILL;
            } else if (!this.prefix) {
                b = new byte[len];
                System.arraycopy(buffer, start, b, 0, len);
            } else {
                b = new byte[len + 4];
                ByteBuffer byteBuffer = this.bb;
                synchronized (byteBuffer) {
                    this.bb.putInt(0, len);
                    System.arraycopy(this.bb.array(), 0, b, 0, 4);
                }
                System.arraycopy(buffer, start, b, 4, len);
            }
            try {
                return this.queue.offer(b, 100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public void close() {
            this.working = false;
            try {
                this.out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static class StreamAndSize {
        long size;
        InputStream in;

        StreamAndSize() {
        }
    }
}

