/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4h.okhttp;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.objects.streams.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.JavaNetCookieJar;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.http.RequestLine;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

@BA.ShortName(value="OkHttpClient")
@BA.Version(value=1.5f)
public class OkHttpClientWrapper {
    @BA.Hide
    public OkHttpClient client;
    private String eventName;

    public void Initialize(String EventName) {
        this.client = this.sharedInit(EventName).build();
    }

    public void InitializeAcceptAll(String EventName) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        OkHttpClient.Builder builder = this.sharedInit(EventName);
        builder.hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }
        });
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, new TrustManager[]{new NaiveTrustManager()}, new SecureRandom());
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        Object[] trustManagers = trustManagerFactory.getTrustManagers();
        if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
            throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
        }
        X509TrustManager trustManager = (X509TrustManager)trustManagers[0];
        builder.sslSocketFactory(sslSocketFactory, trustManager);
        this.client = builder.build();
    }

    @BA.Hide
    public OkHttpClient.Builder sharedInit(String EventName) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        this.eventName = EventName.toLowerCase(BA.cul);
        OkHttpClientWrapper.setTimeout(builder, 30000);
        CookieManager cm = new CookieManager();
        cm.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        builder.cookieJar(new JavaNetCookieJar(cm));
        return builder;
    }

    public boolean IsInitialized() {
        return this.client != null;
    }

    static void setTimeout(OkHttpClient.Builder builder, int TimeoutMs) {
        builder.connectTimeout(TimeoutMs, TimeUnit.MILLISECONDS);
        builder.writeTimeout(TimeoutMs, TimeUnit.MILLISECONDS);
        builder.readTimeout(TimeoutMs, TimeUnit.MILLISECONDS);
    }

    public boolean Execute(BA ba, OkHttpRequest HttpRequest, int TaskId) throws IOException {
        return this.ExecuteCredentials(ba, HttpRequest, TaskId, null, null);
    }

    public boolean ExecuteCredentials(BA ba, OkHttpRequest Request2, int TaskId, String UserName, String Password) {
        if (BA.isTaskRunning(this, TaskId)) {
            return false;
        }
        ExecuteHelper runnable2 = new ExecuteHelper(ba, Request2, TaskId, UserName, Password);
        BA.submitRunnable(runnable2, this, TaskId);
        return true;
    }

    private Response executeWithTimeout(Runnable handler, OkHttpClient myClient, Request req, BA ba, int TaskId) throws IOException {
        return myClient.newCall(req).execute();
    }

    @BA.Hide
    public static class B4AAuthenticator
    implements Authenticator {
        public final String username;
        public final String password;
        private static Pattern ptDigest;
        private static final char[] HEXADECIMAL;

        static {
            HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        }

        public B4AAuthenticator(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public Request authenticate(Route route, Response response) throws IOException {
            String credential;
            String v;
            if (this.responseCount(response) >= 3) {
                return null;
            }
            String raw = response.header("WWW-Authenticate");
            if (raw == null) {
                raw = "";
            }
            if ((v = raw.toLowerCase(BA.cul)).contains("digest")) {
                credential = this.handleDigest(response, raw);
            } else {
                credential = Credentials.basic(this.username, this.password);
                if (credential.equals(response.request().header("Authorization"))) {
                    return null;
                }
            }
            return response.request().newBuilder().header("Authorization", credential).build();
        }

        private String handleDigest(Response response, String raw) throws IOException {
            String serverDigestValue;
            MessageDigest md;
            Request request = response.request();
            String methodName = request.method();
            String uri = RequestLine.INSTANCE.requestPath(request.url());
            if (ptDigest == null) {
                ptDigest = Pattern.compile("(\\w+)=\\\"([^\"]+)\\\"");
            }
            Matcher m = ptDigest.matcher(raw);
            HashMap<String, String> params = new HashMap<String, String>();
            while (m.find()) {
                params.put(m.group(1), m.group(2));
            }
            String nonce = (String)params.get("nonce");
            String realm = (String)params.get("realm");
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException();
            }
            StringBuilder temp = new StringBuilder();
            temp.append(this.username).append(":").append(realm).append(":").append(this.password);
            byte[] binary = md.digest(temp.toString().getBytes("ISO-8859-1"));
            String md5a1 = B4AAuthenticator.encode(binary);
            String a2 = String.valueOf(methodName) + ":" + uri;
            boolean qopMissing = !raw.contains("qop");
            String md5a2 = B4AAuthenticator.encode(md.digest(a2.getBytes("ASCII")));
            String NC = "00000001";
            String cnonce = null;
            if (qopMissing) {
                StringBuilder tmp2 = new StringBuilder();
                tmp2.append(md5a1);
                tmp2.append(':');
                tmp2.append(nonce);
                tmp2.append(':');
                tmp2.append(md5a2);
                serverDigestValue = tmp2.toString();
            } else {
                String qopOption = "auth";
                cnonce = B4AAuthenticator.encode(md.digest(Long.toString(System.currentTimeMillis()).getBytes("ASCII")));
                StringBuilder tmp2 = new StringBuilder();
                tmp2.append(md5a1);
                tmp2.append(':');
                tmp2.append(nonce);
                tmp2.append(':');
                tmp2.append(NC);
                tmp2.append(':');
                tmp2.append(cnonce);
                tmp2.append(':');
                tmp2.append(qopOption);
                tmp2.append(':');
                tmp2.append(md5a2);
                serverDigestValue = tmp2.toString();
            }
            String serverDigest = B4AAuthenticator.encode(md.digest(serverDigestValue.getBytes("ASCII")));
            StringBuilder sb = new StringBuilder();
            sb.append("Digest ").append(this.param("username", this.username, true)).append(",").append(this.param("realm", realm, true)).append(",").append(this.param("nonce", nonce, true)).append(",").append(this.param("uri", uri, true)).append(",");
            if (!qopMissing) {
                sb.append(this.param("qop", "auth", false)).append(",").append(this.param("nc", NC, false)).append(",").append(this.param("cnonce", cnonce, true)).append(",");
            }
            sb.append(this.param("response", serverDigest, true));
            String opaque = (String)params.get("opaque");
            if (opaque != null) {
                sb.append(",").append(this.param("opaque", opaque, true));
            }
            return sb.toString();
        }

        private String param(String key, String value, boolean quote) {
            return String.valueOf(key) + "=" + (quote ? "\"" : "") + value + (quote ? "\"" : "");
        }

        private static String encode(byte[] binaryData) {
            if (binaryData.length != 16) {
                return null;
            }
            char[] buffer = new char[32];
            int i = 0;
            while (i < 16) {
                int low = binaryData[i] & 0xF;
                int high = (binaryData[i] & 0xF0) >> 4;
                buffer[i * 2] = HEXADECIMAL[high];
                buffer[i * 2 + 1] = HEXADECIMAL[low];
                ++i;
            }
            return new String(buffer);
        }

        private int responseCount(Response response) {
            int result = 1;
            while ((response = response.priorResponse()) != null) {
                ++result;
            }
            return result;
        }
    }

    class ExecuteHelper
    implements Runnable {
        private BA ba;
        private OkHttpRequest HttpRequest;
        private int TaskId;
        private String UserName;
        private String Password;

        public ExecuteHelper(BA ba, OkHttpRequest HttpRequest, int TaskId, String UserName, String Password) {
            this.ba = ba;
            this.HttpRequest = HttpRequest;
            this.TaskId = TaskId;
            this.UserName = UserName;
            this.Password = Password;
        }

        @Override
        public void run() {
            Response response = null;
            OkHttpResponse res = new OkHttpResponse();
            res.innerInitialize(OkHttpClientWrapper.this);
            try {
                boolean recoverable;
                OkHttpClient.Builder builder = OkHttpClientWrapper.this.client.newBuilder();
                OkHttpClientWrapper.setTimeout(builder, this.HttpRequest.timeout);
                Request req = this.HttpRequest.builder.build();
                boolean bl = recoverable = !(req.body() instanceof PostPayload) || ((PostPayload)req.body()).data != null;
                if (this.UserName != null && this.UserName.length() > 0) {
                    builder.authenticator(new B4AAuthenticator(this.UserName, this.Password));
                    if (req.body() instanceof PostPayload && !recoverable) {
                        String credential = Credentials.basic(this.UserName, this.Password);
                        req = req.newBuilder().header("Authorization", credential).build();
                    }
                }
                builder.retryOnConnectionFailure(recoverable);
                response = OkHttpClientWrapper.this.executeWithTimeout(this, builder.build(), req, this.ba, this.TaskId);
                if (response == null) {
                    return;
                }
                res.response = response;
                if (!response.isSuccessful()) {
                    throw new Exception();
                }
                this.ba.raiseEventFromDifferentThread((Object)OkHttpClientWrapper.this.client, (Object)OkHttpClientWrapper.this, this.TaskId, String.valueOf(OkHttpClientWrapper.this.eventName) + "_responsesuccess", true, new Object[]{res, this.TaskId});
            }
            catch (Exception e) {
                String reason;
                int statusCode;
                if (response != null) {
                    statusCode = response.code();
                    reason = response.message();
                    if (reason == null) {
                        reason = "";
                    }
                } else {
                    e.printStackTrace();
                    reason = e.toString();
                    statusCode = -1;
                }
                if (response != null) {
                    try {
                        res.errorMessage = response.body().string();
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
                this.ba.raiseEventFromDifferentThread((Object)OkHttpClientWrapper.this.client, (Object)OkHttpClientWrapper.this, this.TaskId, String.valueOf(OkHttpClientWrapper.this.eventName) + "_responseerror", false, new Object[]{res, reason, statusCode, this.TaskId});
            }
        }
    }

    private static class NaiveTrustManager
    implements X509TrustManager {
        private NaiveTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] cert, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] cert, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    @BA.ShortName(value="OkHttpRequest")
    public static class OkHttpRequest {
        int timeout = 30000;
        @BA.Hide
        public Request.Builder builder;
        @BA.Hide
        public PostPayload pp;

        public void InitializeGet(String URL2) {
            this.builder = new Request.Builder().url(URL2).get();
        }

        public void InitializeHead(String URL2) {
            this.builder = new Request.Builder().url(URL2).head();
        }

        public void InitializeDelete(String URL2) {
            this.builder = new Request.Builder().url(URL2).delete();
        }

        public void InitializeDelete2(String URL2, byte[] Data) {
            this.pp = PostPayload.createFromArray(Data);
            this.builder = new Request.Builder().url(URL2).delete(this.pp);
        }

        public void InitializePost(String URL2, InputStream InputStream2, int Length) {
            this.pp = PostPayload.createFromStream(InputStream2, Length);
            this.builder = new Request.Builder().url(URL2).post(this.pp);
        }

        public void InitializePost2(String URL2, byte[] Data) {
            this.pp = PostPayload.createFromArray(Data);
            this.builder = new Request.Builder().url(URL2).post(this.pp);
        }

        public void InitializePut(String URL2, InputStream InputStream2, int Length) {
            this.pp = PostPayload.createFromStream(InputStream2, Length);
            this.builder = new Request.Builder().url(URL2).put(this.pp);
        }

        public void InitializePut2(String URL2, byte[] Data) {
            this.pp = PostPayload.createFromArray(Data);
            this.builder = new Request.Builder().url(URL2).put(this.pp);
        }

        public void InitializePatch(String URL2, InputStream InputStream2, int Length) {
            this.pp = PostPayload.createFromStream(InputStream2, Length);
            this.builder = new Request.Builder().url(URL2).patch(this.pp);
        }

        public void InitializePatch2(String URL2, byte[] Data) {
            this.pp = PostPayload.createFromArray(Data);
            this.builder = new Request.Builder().url(URL2).patch(this.pp);
        }

        public void SetHeader(String Name, String Value) {
            this.builder.addHeader(Name, Value);
        }

        public void RemoveHeaders(String Name) {
            this.builder.removeHeader(Name);
        }

        public int getTimeout() {
            return this.timeout;
        }

        public void setTimeout(int t) {
            this.timeout = t;
        }

        public void SetContentType(String ContentType) {
            if (this.pp == null) {
                throw new RuntimeException("Request does not support this method.");
            }
            this.pp.contentType = ContentType;
        }

        public void SetContentEncoding(String Encoding) {
            this.builder.header("Content-Encoding", Encoding);
        }
    }

    @BA.ShortName(value="OkHttpResponse")
    public static class OkHttpResponse {
        private OkHttpClientWrapper parent;
        String errorMessage = "";
        @BA.Hide
        public Response response;

        private void innerInitialize(OkHttpClientWrapper parent) {
            this.parent = parent;
        }

        public anywheresoftware.b4a.objects.collections.Map GetHeaders() {
            return OkHttpResponse.convertHeaders(this.response.headers().toMultimap());
        }

        public String getContentType() {
            return this.response.header("Content-Type", "");
        }

        public String getContentEncoding() {
            return this.response.header("Content-Encoding", "");
        }

        public String getErrorResponse() {
            return this.errorMessage;
        }

        public long getContentLength() throws IOException {
            return this.response.body().contentLength();
        }

        static anywheresoftware.b4a.objects.collections.Map convertHeaders(Map<String, List<String>> headers) {
            anywheresoftware.b4a.objects.collections.Map m = new anywheresoftware.b4a.objects.collections.Map();
            m.Initialize();
            for (Map.Entry<String, List<String>> e : headers.entrySet()) {
                m.Put(e.getKey(), e.getValue());
            }
            return m;
        }

        public int getStatusCode() {
            return this.response == null ? -1 : this.response.code();
        }

        public void Release() throws IOException {
            if (this.response != null && this.response.body() != null) {
                Util.closeQuietly(this.response.body().source());
            }
        }

        public boolean GetAsynchronously(final BA ba, final String EventName, final OutputStream Output, final boolean CloseOutput, final int TaskId) throws IOException {
            if (BA.isTaskRunning(this.parent, TaskId)) {
                this.Release();
                return false;
            }
            Runnable runnable2 = new Runnable(){

                @Override
                public void run() {
                    try {
                        File.Copy2(OkHttpResponse.this.response.body().byteStream(), Output);
                        if (CloseOutput) {
                            Output.close();
                        }
                        ba.raiseEventFromDifferentThread((Object)OkHttpResponse.this, (Object)OkHttpResponse.this.parent, TaskId, String.valueOf(EventName.toLowerCase(BA.cul)) + "_streamfinish", true, new Object[]{true, TaskId});
                    }
                    catch (IOException e) {
                        ba.setLastException(e);
                        if (CloseOutput) {
                            try {
                                Output.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        ba.raiseEventFromDifferentThread((Object)OkHttpResponse.this, (Object)OkHttpResponse.this.parent, TaskId, String.valueOf(EventName.toLowerCase(BA.cul)) + "_streamfinish", true, new Object[]{false, TaskId});
                    }
                    OkHttpResponse.this.response.body().close();
                }
            };
            BA.submitRunnable(runnable2, this.parent, TaskId);
            return true;
        }
    }

    @BA.Hide
    public static class PostPayload
    extends RequestBody {
        public String contentType = "application/x-www-form-urlencoded";
        private long contentLength = -1L;
        private Source source;
        public byte[] data;

        public static PostPayload createFromStream(InputStream input, int Length) {
            PostPayload pp = new PostPayload();
            pp.source = Okio.source(input);
            pp.contentLength = Length;
            return pp;
        }

        public static PostPayload createFromArray(byte[] data) {
            PostPayload pp = new PostPayload();
            pp.data = data;
            return pp;
        }

        @Override
        public MediaType contentType() {
            MediaType mt = MediaType.parse(this.contentType);
            return mt;
        }

        @Override
        public long contentLength() throws IOException {
            if (this.data != null) {
                return this.data.length;
            }
            return this.contentLength;
        }

        @Override
        public void writeTo(BufferedSink sink2) throws IOException {
            if (this.data != null) {
                sink2.write(this.data);
            } else {
                sink2.write(this.source, this.contentLength);
            }
        }
    }
}

