/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.launcher;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.launcher.Java13CommandLauncher;
import org.apache.commons.exec.util.StringUtils;

public class VmsCommandLauncher
extends Java13CommandLauncher {
    @Override
    public Process exec(CommandLine cmd, Map<String, String> env) throws IOException {
        CommandLine vmsCmd = new CommandLine(this.createCommandFile(cmd, env).getPath());
        return super.exec(vmsCmd, env);
    }

    @Override
    public Process exec(CommandLine cmd, Map<String, String> env, File workingDir) throws IOException {
        CommandLine vmsCmd = new CommandLine(this.createCommandFile(cmd, env).getPath());
        return super.exec(vmsCmd, env, workingDir);
    }

    @Override
    public boolean isFailure(int exitValue) {
        return exitValue % 2 == 0;
    }

    private File createCommandFile(CommandLine cmd, Map<String, String> env) throws IOException {
        File script = File.createTempFile("EXEC", ".TMP");
        script.deleteOnExit();
        PrintWriter out = null;
        try {
            String[] args2;
            out = new PrintWriter(new FileWriter(script.getAbsolutePath(), true));
            if (env != null) {
                Set<Map.Entry<String, String>> entries = env.entrySet();
                for (Map.Entry<String, String> entry : entries) {
                    out.print("$ ");
                    out.print(entry.getKey());
                    out.print(" == ");
                    out.println('\"');
                    String value = entry.getValue();
                    if (value.indexOf(34) > 0) {
                        StringBuilder sb = new StringBuilder();
                        int i = 0;
                        while (i < value.length()) {
                            char c = value.charAt(i);
                            if (c == '\"') {
                                sb.append('\"');
                            }
                            sb.append(c);
                            ++i;
                        }
                        value = sb.toString();
                    }
                    out.print(value);
                    out.println('\"');
                }
            }
            String command = cmd.getExecutable();
            if (cmd.isFile()) {
                out.print("$ @");
                String[] parts = StringUtils.split(command, "/");
                out.print(parts[0]);
                out.print(":[");
                out.print(parts[1]);
                int lastPart = parts.length - 1;
                int i = 2;
                while (i < lastPart) {
                    out.print(".");
                    out.print(parts[i]);
                    ++i;
                }
                out.print("]");
                out.print(parts[lastPart]);
            } else {
                out.print("$ ");
                out.print(command);
            }
            String[] stringArray = args2 = cmd.getArguments();
            int n = args2.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                out.println(" -");
                out.print(arg);
                ++n2;
            }
            out.println();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return script;
    }
}

