/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.objects;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.objects.HttpServer;
import anywheresoftware.b4a.objects.streams.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.servlets.MultiPartFilter;

@BA.Hide
public class Servlet
extends HttpServlet {
    private final HttpServer server;
    private FilterChain dummyChain = new FilterChain(){

        @Override
        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            Servlet.this.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        }
    };
    private MultiPartFilter multiPartFilter = new MultiPartFilter();

    public Servlet(HttpServer server) {
        this.server = server;
        this.multiPartFilter.myInit(new java.io.File(server.TempFolder), server.context);
    }

    @Override
    public void init() {
    }

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse resp) {
        try {
            this.multiPartFilter.doFilter(req, resp, this.dummyChain);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse resp) {
        this.handleRequest(req, resp);
    }

    public void handleRequest(HttpServletRequest req, HttpServletResponse resp) {
        try {
            final CountDownLatch cdl = new CountDownLatch(1);
            final ServletResponseWrapper respWrapper = new ServletResponseWrapper(resp);
            final ServletRequestWrapper reqWrapper = new ServletRequestWrapper(req);
            BA.handler.post(new Runnable(){

                @Override
                public void run() {
                    ((Servlet)Servlet.this).server.ba.raiseEvent((Object)Servlet.this.server, String.valueOf(((Servlet)Servlet.this).server.eventName) + "_handlerequest", new Object[]{reqWrapper, respWrapper});
                    cdl.countDown();
                }
            });
            if (!cdl.await(this.server.lockTimeout, TimeUnit.MILLISECONDS)) {
                throw new RuntimeException("Timeout!");
            }
            if (respWrapper.redirect != null) {
                resp.sendRedirect(respWrapper.redirect);
            } else {
                if (respWrapper.response != null) {
                    resp.getOutputStream().write(respWrapper.response);
                }
                if (respWrapper.in != null) {
                    File.Copy2((InputStream)respWrapper.in, (OutputStream)resp.getOutputStream());
                    respWrapper.in.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @BA.ShortName(value="ServletRequest")
    public static class ServletRequestWrapper {
        private final HttpServletRequest req;

        public ServletRequestWrapper(HttpServletRequest req) {
            this.req = req;
        }

        public String GetHeader(String Name) {
            String h = this.req.getHeader(Name);
            return h == null ? "" : h;
        }

        public String getMethod() {
            return this.req.getMethod();
        }

        public String getRequestURI() {
            return this.req.getRequestURI();
        }

        public String getRemoteAddress() {
            return this.req.getRemoteAddr();
        }

        public String GetParameter(String Name) {
            String h = this.req.getParameter(Name);
            return h == null ? "" : h;
        }

        public String GetUploadedFile(String Key) {
            if (this.req.getAttribute(Key) == null) {
                return "";
            }
            return ((java.io.File)this.req.getAttribute(Key)).getName();
        }
    }

    @BA.ShortName(value="ServletResponse")
    public static class ServletResponseWrapper {
        private final HttpServletResponse res;
        byte[] response;
        InputStream in;
        String redirect;

        public ServletResponseWrapper(HttpServletResponse res) {
            this.res = res;
        }

        public void SendString(String Text) throws UnsupportedEncodingException {
            this.response = Text.getBytes("UTF8");
            this.res.setContentLength(this.response.length);
        }

        public void SendFile(String Dir, String FileName) throws IOException {
            File.InputStreamWrapper i = File.OpenInput((String)Dir, (String)FileName);
            if (!Dir.equals(File.getDirAssets())) {
                this.res.setContentLength((int)File.Size((String)Dir, (String)FileName));
            }
            this.in = (InputStream)i.getObject();
        }

        public void setStatus(int v) {
            this.res.setStatus(v);
        }

        public void SetHeader(String Name, String Value) {
            this.res.setHeader(Name, Value);
        }

        public void SetContentType(String Type2) {
            this.res.setContentType(Type2);
        }

        public void SendRedirect(String Location2) {
            this.redirect = Location2;
        }
    }
}

