/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.webdav;

import java.io.IOException;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpEventListenerWrapper;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.security.SecurityListener;
import org.eclipse.jetty.client.webdav.MkcolExchange;
import org.eclipse.jetty.client.webdav.PropfindExchange;
import org.eclipse.jetty.client.webdav.WebdavSupportedExchange;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;

public class WebdavListener
extends HttpEventListenerWrapper {
    private HttpDestination _destination;
    private HttpExchange _exchange;
    private boolean _requestComplete;
    private boolean _responseComplete;
    private boolean _webdavEnabled;
    private boolean _needIntercept;

    public WebdavListener(HttpDestination destination, HttpExchange ex) {
        super(ex.getEventListener(), true);
        this._destination = destination;
        this._exchange = ex;
        if ("PUT".equalsIgnoreCase(this._exchange.getMethod())) {
            this._webdavEnabled = true;
        }
    }

    @Override
    public void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
        if (!this._webdavEnabled) {
            this._needIntercept = false;
            super.onResponseStatus(version, status, reason);
            return;
        }
        if (Log.isDebugEnabled()) {
            Log.debug("WebdavListener:Response Status: " + status);
        }
        if (status == 403 || status == 409) {
            if (this._webdavEnabled) {
                if (Log.isDebugEnabled()) {
                    Log.debug("WebdavListener:Response Status: dav enabled, taking a stab at resolving put issue");
                }
                this.setDelegatingResponses(false);
                this._needIntercept = true;
            } else {
                if (Log.isDebugEnabled()) {
                    Log.debug("WebdavListener:Response Status: Webdav Disabled");
                }
                this.setDelegatingResponses(true);
                this.setDelegatingRequests(true);
                this._needIntercept = false;
            }
        } else {
            this._needIntercept = false;
            this.setDelegatingResponses(true);
            this.setDelegatingRequests(true);
        }
        super.onResponseStatus(version, status, reason);
    }

    @Override
    public void onResponseComplete() throws IOException {
        block8: {
            this._responseComplete = true;
            if (this._needIntercept) {
                if (this._requestComplete && this._responseComplete) {
                    try {
                        if (this.resolveCollectionIssues()) {
                            this.setDelegatingRequests(true);
                            this.setDelegatingResponses(true);
                            this._requestComplete = false;
                            this._responseComplete = false;
                            this._destination.resend(this._exchange);
                            break block8;
                        }
                        this.setDelegationResult(false);
                        this.setDelegatingRequests(true);
                        this.setDelegatingResponses(true);
                        super.onResponseComplete();
                    }
                    catch (IOException ioe) {
                        Log.debug("WebdavListener:Complete:IOException: might not be dealing with dav server, delegate");
                        super.onResponseComplete();
                    }
                } else {
                    if (Log.isDebugEnabled()) {
                        Log.debug("WebdavListener:Not ready, calling super");
                    }
                    super.onResponseComplete();
                }
            } else {
                super.onResponseComplete();
            }
        }
    }

    @Override
    public void onRequestComplete() throws IOException {
        block8: {
            this._requestComplete = true;
            if (this._needIntercept) {
                if (this._requestComplete && this._responseComplete) {
                    try {
                        if (this.resolveCollectionIssues()) {
                            this.setDelegatingRequests(true);
                            this.setDelegatingResponses(true);
                            this._requestComplete = false;
                            this._responseComplete = false;
                            this._destination.resend(this._exchange);
                            break block8;
                        }
                        this.setDelegatingRequests(true);
                        this.setDelegatingResponses(true);
                        super.onRequestComplete();
                    }
                    catch (IOException ioe) {
                        Log.debug("WebdavListener:Complete:IOException: might not be dealing with dav server, delegate");
                        super.onRequestComplete();
                    }
                } else {
                    if (Log.isDebugEnabled()) {
                        Log.debug("WebdavListener:Not ready, calling super");
                    }
                    super.onRequestComplete();
                }
            } else {
                super.onRequestComplete();
            }
        }
    }

    private boolean resolveCollectionIssues() throws IOException {
        String uri = this._exchange.getURI();
        String[] uriCollection = this._exchange.getURI().split("/");
        int checkNum = uriCollection.length;
        int rewind = 0;
        String parentUri = URIUtil.parentPath(uri);
        while (parentUri != null && !this.checkExists(parentUri)) {
            ++rewind;
            parentUri = URIUtil.parentPath(parentUri);
        }
        if (this.checkWebdavSupported()) {
            int i = 0;
            while (i < rewind) {
                this.makeCollection(String.valueOf(parentUri) + "/" + uriCollection[checkNum - rewind - 1]);
                parentUri = String.valueOf(parentUri) + "/" + uriCollection[checkNum - rewind - 1];
                --rewind;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean checkExists(String uri) throws IOException {
        if (uri == null) {
            System.out.println("have failed miserably");
            return false;
        }
        PropfindExchange propfindExchange = new PropfindExchange();
        propfindExchange.setAddress(this._exchange.getAddress());
        propfindExchange.setMethod("GET");
        propfindExchange.setScheme(this._exchange.getScheme());
        propfindExchange.setEventListener(new SecurityListener(this._destination, propfindExchange));
        propfindExchange.setConfigureListeners(false);
        propfindExchange.setURI(uri);
        this._destination.send(propfindExchange);
        try {
            propfindExchange.waitForDone();
            return propfindExchange.exists();
        }
        catch (InterruptedException ie) {
            Log.ignore(ie);
            return false;
        }
    }

    private boolean makeCollection(String uri) throws IOException {
        MkcolExchange mkcolExchange = new MkcolExchange();
        mkcolExchange.setAddress(this._exchange.getAddress());
        mkcolExchange.setMethod("MKCOL " + uri + " HTTP/1.1");
        mkcolExchange.setScheme(this._exchange.getScheme());
        mkcolExchange.setEventListener(new SecurityListener(this._destination, mkcolExchange));
        mkcolExchange.setConfigureListeners(false);
        mkcolExchange.setURI(uri);
        this._destination.send(mkcolExchange);
        try {
            mkcolExchange.waitForDone();
            return mkcolExchange.exists();
        }
        catch (InterruptedException ie) {
            Log.ignore(ie);
            return false;
        }
    }

    private boolean checkWebdavSupported() throws IOException {
        WebdavSupportedExchange supportedExchange = new WebdavSupportedExchange();
        supportedExchange.setAddress(this._exchange.getAddress());
        supportedExchange.setMethod("OPTIONS");
        supportedExchange.setScheme(this._exchange.getScheme());
        supportedExchange.setEventListener(new SecurityListener(this._destination, supportedExchange));
        supportedExchange.setConfigureListeners(false);
        supportedExchange.setURI(this._exchange.getURI());
        this._destination.send(supportedExchange);
        try {
            supportedExchange.waitTilCompletion();
            return supportedExchange.isWebdavSupported();
        }
        catch (InterruptedException ie) {
            Log.ignore(ie);
            return false;
        }
    }
}

