/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy.bindings;

import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppLifeCycle;
import org.eclipse.jetty.deploy.graph.Node;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.log.Log;

public class StandardUndeployer
implements AppLifeCycle.Binding {
    @Override
    public String[] getBindingTargets() {
        return new String[]{"undeploying"};
    }

    @Override
    public void processBinding(Node node, App app) throws Exception {
        ContextHandler handler = app.getContextHandler();
        ContextHandlerCollection chcoll = app.getDeploymentManager().getContexts();
        this.recursiveRemoveContext(chcoll, handler);
    }

    private void recursiveRemoveContext(HandlerCollection coll, ContextHandler context) {
        Handler[] children = coll.getHandlers();
        int originalCount = children.length;
        int i = 0;
        int n = children.length;
        while (i < n) {
            Handler child = children[i];
            Log.debug("Child handler: " + child);
            if (child.equals(context)) {
                Log.debug("Removing handler: " + child);
                coll.removeHandler(child);
                child.destroy();
                Log.debug(String.format("After removal: %d (originally %d)", coll.getHandlers().length, originalCount));
            } else if (child instanceof HandlerCollection) {
                this.recursiveRemoveContext((HandlerCollection)child, context);
            }
            ++i;
        }
    }
}

