/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jmx;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBean;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;

public class ObjectMBean
implements DynamicMBean {
    private static Class[] OBJ_ARG = new Class[]{Object.class};
    protected Object _managed;
    private MBeanInfo _info;
    private Map _getters = new HashMap();
    private Map _setters = new HashMap();
    private Map _methods = new HashMap();
    private Set _convert = new HashSet();
    private ClassLoader _loader;
    private MBeanContainer _mbeanContainer;
    private static String OBJECT_NAME_CLASS = ObjectName.class.getName();
    private static String OBJECT_NAME_ARRAY_CLASS = ObjectName[].class.getName();

    public static Object mbeanFor(Object o) {
        try {
            Class<Object> oClass = o.getClass();
            Object mbean = null;
            while (mbean == null && oClass != null) {
                String pName = oClass.getPackage().getName();
                String cName = oClass.getName().substring(pName.length() + 1);
                String mName = String.valueOf(pName) + ".jmx." + cName + "MBean";
                try {
                    block13: {
                        Class<Object> mClass;
                        Class<Object> clazz = mClass = Object.class.equals(oClass) ? (oClass = ObjectMBean.class) : Loader.loadClass(oClass, mName, true);
                        if (Log.isDebugEnabled()) {
                            Log.debug("mbeanFor " + o + " mClass=" + mClass);
                        }
                        try {
                            Constructor constructor = mClass.getConstructor(OBJ_ARG);
                            mbean = constructor.newInstance(o);
                        }
                        catch (Exception e) {
                            Log.ignore(e);
                            if (!ModelMBean.class.isAssignableFrom(mClass)) break block13;
                            mbean = mClass.newInstance();
                            ((ModelMBean)mbean).setManagedResource(o, "objectReference");
                        }
                    }
                    if (Log.isDebugEnabled()) {
                        Log.debug("mbeanFor " + o + " is " + mbean);
                    }
                    return mbean;
                }
                catch (ClassNotFoundException e) {
                    if (e.toString().endsWith("MBean")) {
                        Log.ignore(e);
                    } else {
                        Log.warn(e);
                    }
                }
                catch (Error e) {
                    Log.warn(e);
                    mbean = null;
                }
                catch (Exception e) {
                    Log.warn(e);
                    mbean = null;
                }
                oClass = oClass.getSuperclass();
            }
        }
        catch (Exception e) {
            Log.ignore(e);
        }
        return null;
    }

    public ObjectMBean(Object managedObject) {
        this._managed = managedObject;
        this._loader = Thread.currentThread().getContextClassLoader();
    }

    public Object getManagedObject() {
        return this._managed;
    }

    public ObjectName getObjectName() {
        return null;
    }

    public String getObjectContextBasis() {
        return null;
    }

    public String getObjectNameBasis() {
        return null;
    }

    protected void setMBeanContainer(MBeanContainer container) {
        this._mbeanContainer = container;
    }

    public MBeanContainer getMBeanContainer() {
        return this._mbeanContainer;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        block9: {
            try {
                if (this._info != null) break block9;
                String desc = null;
                Object attributes = null;
                Object constructors = null;
                Object operations = null;
                Object notifications = null;
                Class<?> o_class = this._managed.getClass();
                Object influences = ObjectMBean.findInfluences(null, this._managed.getClass());
                HashSet<String> defined = new HashSet<String>();
                int i = 0;
                while (i < LazyList.size(influences)) {
                    Class<ObjectMBean> oClass = (Class<ObjectMBean>)LazyList.get(influences, i);
                    if (Object.class.equals((Object)oClass)) {
                        oClass = ObjectMBean.class;
                    }
                    String pName = oClass.getPackage().getName();
                    String cName = oClass.getName().substring(pName.length() + 1);
                    String rName = String.valueOf(pName.replace('.', '/')) + "/jmx/" + cName + "-mbean";
                    try {
                        Log.debug(rName);
                        ResourceBundle bundle = Loader.getResourceBundle(o_class, rName, true, Locale.getDefault());
                        Enumeration<String> e = bundle.getKeys();
                        while (e.hasMoreElements()) {
                            String key = e.nextElement();
                            String value = bundle.getString(key);
                            if (key.equals(cName)) {
                                if (desc != null) continue;
                                desc = value;
                                continue;
                            }
                            if (key.indexOf(40) > 0) {
                                if (defined.contains(key) || key.indexOf(91) >= 0) continue;
                                defined.add(key);
                                operations = LazyList.add(operations, this.defineOperation(key, value, bundle));
                                continue;
                            }
                            if (defined.contains(key)) continue;
                            defined.add(key);
                            MBeanAttributeInfo info = this.defineAttribute(key, value);
                            if (info == null) continue;
                            attributes = LazyList.add(attributes, info);
                        }
                    }
                    catch (MissingResourceException e) {
                        Log.ignore(e);
                    }
                    ++i;
                }
                this._info = new MBeanInfo(o_class.getName(), desc, (MBeanAttributeInfo[])LazyList.toArray(attributes, MBeanAttributeInfo.class), (MBeanConstructorInfo[])LazyList.toArray(constructors, MBeanConstructorInfo.class), (MBeanOperationInfo[])LazyList.toArray(operations, MBeanOperationInfo.class), (MBeanNotificationInfo[])LazyList.toArray(notifications, MBeanNotificationInfo.class));
            }
            catch (RuntimeException e) {
                Log.warn(e);
                throw e;
            }
        }
        return this._info;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        ObjectName mbean;
        void var4_10;
        block10: {
            Object object;
            Method getter = (Method)this._getters.get(name);
            if (getter == null) {
                throw new AttributeNotFoundException(name);
            }
            Object o = this._managed;
            if (getter.getDeclaringClass().isInstance(this)) {
                o = this;
            }
            if ((object = getter.invoke(o, null)) == null || !this._convert.contains(name)) return var4_10;
            if (object.getClass().isArray()) {
                ObjectName[] on = new ObjectName[Array.getLength(object)];
                int i = 0;
                while (i < on.length) {
                    on[i] = this._mbeanContainer.findMBean(Array.get(object, i));
                    ++i;
                }
                ObjectName[] objectNameArray = on;
                return var4_10;
            }
            if (object instanceof Collection) {
                Collection c = (Collection)object;
                ObjectName[] on = new ObjectName[c.size()];
                int i = 0;
                for (Object obj : c) {
                    on[i++] = this._mbeanContainer.findMBean(obj);
                }
                ObjectName[] objectNameArray = on;
                return var4_10;
            }
            mbean = this._mbeanContainer.findMBean(object);
            if (mbean != null) break block10;
            return null;
        }
        try {
            ObjectName objectName = mbean;
            return var4_10;
        }
        catch (IllegalAccessException e) {
            Log.warn("EXCEPTION ", e);
            throw new AttributeNotFoundException(e.toString());
        }
        catch (InvocationTargetException e) {
            Log.warn("EXCEPTION ", e);
            throw new ReflectionException(new Exception(e.getCause()));
        }
    }

    @Override
    public AttributeList getAttributes(String[] names) {
        AttributeList results = new AttributeList(names.length);
        int i = 0;
        while (i < names.length) {
            try {
                results.add(new Attribute(names[i], this.getAttribute(names[i])));
            }
            catch (Exception e) {
                Log.warn("EXCEPTION ", e);
            }
            ++i;
        }
        return results;
    }

    @Override
    public void setAttribute(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Method setter;
        if (attr == null) {
            return;
        }
        if (Log.isDebugEnabled()) {
            Log.debug("setAttribute " + this._managed + ":" + attr.getName() + "=" + attr.getValue());
        }
        if ((setter = (Method)this._setters.get(attr.getName())) == null) {
            throw new AttributeNotFoundException(attr.getName());
        }
        try {
            Object value;
            Object o = this._managed;
            if (setter.getDeclaringClass().isInstance(this)) {
                o = this;
            }
            if ((value = attr.getValue()) != null && this._convert.contains(attr.getName())) {
                if (value.getClass().isArray()) {
                    Class<?> t = setter.getParameterTypes()[0].getComponentType();
                    Object na = Array.newInstance(t, Array.getLength(value));
                    int i = Array.getLength(value);
                    while (i-- > 0) {
                        Array.set(na, i, this._mbeanContainer.findBean((ObjectName)Array.get(value, i)));
                    }
                    value = na;
                } else {
                    value = this._mbeanContainer.findBean((ObjectName)value);
                }
            }
            setter.invoke(o, value);
        }
        catch (IllegalAccessException e) {
            Log.warn("EXCEPTION ", e);
            throw new AttributeNotFoundException(e.toString());
        }
        catch (InvocationTargetException e) {
            Log.warn("EXCEPTION ", e);
            throw new ReflectionException(new Exception(e.getCause()));
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attrs) {
        Log.debug("setAttributes");
        AttributeList results = new AttributeList(attrs.size());
        Iterator iter = attrs.iterator();
        while (iter.hasNext()) {
            try {
                Attribute attr = (Attribute)iter.next();
                this.setAttribute(attr);
                results.add(new Attribute(attr.getName(), this.getAttribute(attr.getName())));
            }
            catch (Exception e) {
                Log.warn("EXCEPTION ", e);
            }
        }
        return results;
    }

    @Override
    public Object invoke(String name, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (Log.isDebugEnabled()) {
            Log.debug("invoke " + name);
        }
        String methodKey = String.valueOf(name) + "(";
        if (signature != null) {
            int i = 0;
            while (i < signature.length) {
                methodKey = String.valueOf(methodKey) + (i > 0 ? "," : "") + signature[i];
                ++i;
            }
        }
        methodKey = String.valueOf(methodKey) + ")";
        ClassLoader old_loader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this._loader);
            Method method = (Method)this._methods.get(methodKey);
            if (method == null) {
                throw new NoSuchMethodException(methodKey);
            }
            Object o = this._managed;
            if (method.getDeclaringClass().isInstance(this)) {
                o = this;
            }
            Object object = method.invoke(o, params);
            return object;
        }
        catch (NoSuchMethodException e) {
            Log.warn("EXCEPTION ", e);
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            Log.warn("EXCEPTION ", e);
            throw new MBeanException(e);
        }
        catch (InvocationTargetException e) {
            Log.warn("EXCEPTION ", e);
            throw new ReflectionException(new Exception(e.getCause()));
        }
        finally {
            Thread.currentThread().setContextClassLoader(old_loader);
        }
    }

    private static Object findInfluences(Object influences, Class aClass) {
        if (aClass != null) {
            influences = LazyList.add(influences, aClass);
            influences = ObjectMBean.findInfluences(influences, aClass.getSuperclass());
            Class<?>[] ifs = aClass.getInterfaces();
            int i = 0;
            while (ifs != null && i < ifs.length) {
                influences = ObjectMBean.findInfluences(influences, ifs[i]);
                ++i;
            }
        }
        return influences;
    }

    /*
     * Unable to fully structure code
     */
    public MBeanAttributeInfo defineAttribute(String name, String metaData) {
        description = "";
        writable = true;
        onMBean = false;
        convert = false;
        if (metaData != null) {
            tokens = metaData.split(":", 3);
            t = 0;
            while (t < tokens.length - 1) {
                tokens[t] = tokens[t].trim();
                if ("RO".equals(tokens[t])) {
                    writable = false;
                } else {
                    onMBean = "MMBean".equalsIgnoreCase(tokens[t]) != false || "MBean".equalsIgnoreCase(tokens[t]) != false;
                    convert = "MMBean".equalsIgnoreCase(tokens[t]) != false || "MObject".equalsIgnoreCase(tokens[t]) != false;
                }
                ++t;
            }
            description = tokens[tokens.length - 1];
        }
        uName = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
        v0 = oClass = onMBean != false ? this.getClass() : this._managed.getClass();
        if (Log.isDebugEnabled()) {
            Log.debug("defineAttribute " + name + " " + onMBean + ":" + writable + ":" + oClass + ":" + description);
        }
        type = null;
        getter = null;
        setter = null;
        methods = oClass.getMethods();
        m = 0;
        while (m < methods.length) {
            block23: {
                block24: {
                    block26: {
                        block25: {
                            if ((methods[m].getModifiers() & 1) == 0) break block23;
                            if (!methods[m].getName().equals("get" + uName) || methods[m].getParameterTypes().length != 0) break block24;
                            if (getter == null) break block25;
                            Log.warn("Multiple mbean getters for attr " + name + " in " + oClass);
                            break block23;
                        }
                        getter = methods[m];
                        if (type == null || type.equals(methods[m].getReturnType())) break block26;
                        Log.warn("Type conflict for mbean attr " + name + " in " + oClass);
                        break block23;
                    }
                    type = methods[m].getReturnType();
                }
                if (!methods[m].getName().equals("is" + uName) || methods[m].getParameterTypes().length != 0) ** GOTO lbl50
                if (getter != null) {
                    Log.warn("Multiple mbean getters for attr " + name + " in " + oClass);
                } else {
                    getter = methods[m];
                    if (type != null && !type.equals(methods[m].getReturnType())) {
                        Log.warn("Type conflict for mbean attr " + name + " in " + oClass);
                    } else {
                        type = methods[m].getReturnType();
lbl50:
                        // 2 sources

                        if (writable && methods[m].getName().equals("set" + uName) && methods[m].getParameterTypes().length == 1) {
                            if (setter != null) {
                                Log.warn("Multiple setters for mbean attr " + name + " in " + oClass);
                            } else {
                                setter = methods[m];
                                if (type != null && !type.equals(methods[m].getParameterTypes()[0])) {
                                    Log.warn("Type conflict for mbean attr " + name + " in " + oClass);
                                } else {
                                    type = methods[m].getParameterTypes()[0];
                                }
                            }
                        }
                    }
                }
            }
            ++m;
        }
        if (convert) {
            if (type == null) {
                Log.warn("No mbean type for " + name + " on " + this._managed.getClass());
                return null;
            }
            if (type.isPrimitive() && !type.isArray()) {
                Log.warn("Cannot convert mbean primative " + name);
                return null;
            }
        }
        if (getter == null && setter == null) {
            Log.warn("No mbean getter or setters found for " + name + " in " + oClass);
            return null;
        }
        try {
            this._getters.put(name, getter);
            this._setters.put(name, setter);
            info = null;
            if (convert) {
                this._convert.add(name);
                info = type.isArray() ? new MBeanAttributeInfo(name, ObjectMBean.OBJECT_NAME_ARRAY_CLASS, description, getter != null, setter != null, getter != null && getter.getName().startsWith("is") != false) : new MBeanAttributeInfo(name, ObjectMBean.OBJECT_NAME_CLASS, description, getter != null, setter != null, getter != null && getter.getName().startsWith("is") != false);
            } else {
                info = new MBeanAttributeInfo(name, description, getter, setter);
            }
            return info;
        }
        catch (Exception e) {
            Log.warn(String.valueOf(name) + ": " + metaData, e);
            throw new IllegalArgumentException(e.toString());
        }
    }

    private MBeanOperationInfo defineOperation(String signature, String metaData, ResourceBundle bundle) {
        boolean convert;
        String impact_name;
        String[] tokens = metaData.split(":", 3);
        int i = tokens.length - 1;
        String description = tokens[i--];
        String string = impact_name = i < 0 ? "UNKNOWN" : tokens[i--].trim();
        if (i == 0) {
            tokens[0] = tokens[0].trim();
        }
        boolean onMBean = i == 0 && ("MBean".equalsIgnoreCase(tokens[0]) || "MMBean".equalsIgnoreCase(tokens[0]));
        boolean bl = convert = i == 0 && ("MObject".equalsIgnoreCase(tokens[0]) || "MMBean".equalsIgnoreCase(tokens[0]));
        if (Log.isDebugEnabled()) {
            Log.debug("defineOperation " + signature + " " + onMBean + ":" + impact_name + ":" + description);
        }
        Class<?> oClass = onMBean ? this.getClass() : this._managed.getClass();
        try {
            int impact = 3;
            if (impact_name == null || impact_name.equals("UNKNOWN")) {
                impact = 3;
            } else if (impact_name.equals("ACTION")) {
                impact = 1;
            } else if (impact_name.equals("INFO")) {
                impact = 0;
            } else if (impact_name.equals("ACTION_INFO")) {
                impact = 2;
            } else {
                Log.warn("Unknown impact '" + impact_name + "' for " + signature);
            }
            String[] parts = signature.split("[\\(\\)]");
            String method_name = parts[0];
            String arguments = parts.length == 2 ? parts[1] : null;
            String[] args = arguments == null ? new String[]{} : arguments.split(" *, *");
            Class[] types = new Class[args.length];
            MBeanParameterInfo[] pInfo = new MBeanParameterInfo[args.length];
            signature = method_name;
            i = 0;
            while (i < args.length) {
                Class<?> type = TypeUtil.fromName(args[i]);
                if (type == null) {
                    type = Thread.currentThread().getContextClassLoader().loadClass(args[i]);
                }
                types[i] = type;
                args[i] = type.isPrimitive() ? TypeUtil.toName(type) : args[i];
                signature = String.valueOf(signature) + (i > 0 ? "," : "(") + args[i];
                ++i;
            }
            signature = String.valueOf(signature) + (i > 0 ? ")" : "()");
            i = 0;
            while (i < args.length) {
                String param_desc = bundle.getString(String.valueOf(signature) + "[" + i + "]");
                parts = param_desc.split(" *: *", 2);
                if (Log.isDebugEnabled()) {
                    Log.debug(String.valueOf(parts[0]) + ": " + parts[1]);
                }
                pInfo[i] = new MBeanParameterInfo(parts[0].trim(), args[i], parts[1].trim());
                ++i;
            }
            Method method = oClass.getMethod(method_name, types);
            Class<?> returnClass = method.getReturnType();
            this._methods.put(signature, method);
            if (convert) {
                this._convert.add(signature);
            }
            return new MBeanOperationInfo(method_name, description, pInfo, returnClass.isPrimitive() ? TypeUtil.toName(returnClass) : returnClass.getName(), impact);
        }
        catch (Exception e) {
            Log.warn("Operation '" + signature + "'", e);
            throw new IllegalArgumentException(e.toString());
        }
    }
}

