/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jndi;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.WeakHashMap;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.eclipse.jetty.jndi.NamingContext;
import org.eclipse.jetty.jndi.NamingUtil;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.log.Logger;

public class ContextFactory
implements ObjectFactory {
    private static Logger __log = NamingUtil.__log;
    private static final WeakHashMap __contextMap = new WeakHashMap();
    private static final ThreadLocal __threadContext = new ThreadLocal();

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env) throws Exception {
        Context ctx = (Context)__threadContext.get();
        if (ctx != null) {
            if (__log.isDebugEnabled()) {
                __log.debug("Using the Context that is bound on the thread", new Object[0]);
            }
            return ctx;
        }
        ClassLoader loader = null;
        if (ContextHandler.getCurrentContext() != null) {
            loader = ContextHandler.getCurrentContext().getContextHandler().getClassLoader();
        }
        if (loader != null) {
            if (__log.isDebugEnabled()) {
                __log.debug("Using classloader of current org.eclipse.jetty.server.handler.ContextHandler", new Object[0]);
            }
        } else {
            loader = Thread.currentThread().getContextClassLoader();
            if (__log.isDebugEnabled()) {
                __log.debug("Using thread context classloader", new Object[0]);
            }
        }
        if ((ctx = (Context)__contextMap.get(loader)) == null && (ctx = this.getParentClassLoaderContext(loader)) == null) {
            Reference ref = (Reference)obj;
            StringRefAddr parserAddr = (StringRefAddr)ref.get("parser");
            String parserClassName = parserAddr == null ? null : (String)parserAddr.getContent();
            NameParser parser = parserClassName == null ? null : loader.loadClass(parserClassName).newInstance();
            ctx = new NamingContext(env, name.get(0), (NamingContext)nameCtx, parser);
            if (__log.isDebugEnabled()) {
                __log.debug("No entry for classloader: " + loader, new Object[0]);
            }
            __contextMap.put(loader, ctx);
        }
        return ctx;
    }

    public Context getParentClassLoaderContext(ClassLoader loader) {
        Context ctx = null;
        ClassLoader cl = loader;
        cl = cl.getParent();
        while (cl != null && ctx == null) {
            ctx = (Context)__contextMap.get(cl);
            cl = cl.getParent();
        }
        return ctx;
    }

    public static Context setComponentContext(Context ctx) {
        Context previous = (Context)__threadContext.get();
        __threadContext.set(ctx);
        return previous;
    }

    public static void resetComponentContext(Context ctx) {
        __threadContext.set(ctx);
    }

    public static void dump(Appendable out, String indent) throws IOException {
        out.append("o.e.j.jndi.ContextFactory@").append(Long.toHexString(__contextMap.hashCode())).append("\n");
        int size = __contextMap.size();
        int i = 0;
        for (Map.Entry entry : __contextMap.entrySet()) {
            boolean last = ++i == size;
            ClassLoader loader = (ClassLoader)entry.getKey();
            out.append(indent).append(" +- ").append(loader.getClass().getSimpleName()).append("@").append(Long.toHexString(loader.hashCode())).append(": ");
            NamingContext context = (NamingContext)entry.getValue();
            context.dump(out, String.valueOf(indent) + (last ? "    " : " |  "));
        }
    }
}

