/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jndi.java;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;
import org.eclipse.jetty.jndi.java.javaRootURLContext;
import org.eclipse.jetty.util.log.Log;

public class javaURLContextFactory
implements ObjectFactory {
    public Object getObjectInstance(Object url, Name name, Context ctx, Hashtable env) throws Exception {
        if (url == null) {
            if (Log.isDebugEnabled()) {
                Log.debug(">>> new root context requested ");
            }
            return new javaRootURLContext(env);
        }
        if (url instanceof String) {
            if (Log.isDebugEnabled()) {
                Log.debug(">>> resolution of url " + url + " requested");
            }
            javaRootURLContext rootctx = new javaRootURLContext(env);
            return rootctx.lookup((String)url);
        }
        if (url instanceof String[]) {
            if (Log.isDebugEnabled()) {
                Log.debug(">>> resolution of array of urls requested");
            }
            String[] urls = (String[])url;
            javaRootURLContext rootctx = new javaRootURLContext(env);
            Object object = null;
            NamingException e = null;
            int i = 0;
            while (i < urls.length && object == null) {
                try {
                    object = rootctx.lookup(urls[i]);
                }
                catch (NamingException x) {
                    e = x;
                }
                ++i;
            }
            if (object == null) {
                throw e;
            }
            return object;
        }
        if (Log.isDebugEnabled()) {
            Log.debug(">>> No idea what to do, so return a new root context anyway");
        }
        return new javaRootURLContext(env);
    }
}

