/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.eclipse.jetty.plus.jaas.JAASUserPrincipal;
import org.eclipse.jetty.plus.jaas.callback.ObjectCallback;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;

public class JAASLoginService
extends AbstractLifeCycle
implements LoginService {
    public static String DEFAULT_ROLE_CLASS_NAME = "org.eclipse.jetty.plus.jaas.JAASRole";
    public static String[] DEFAULT_ROLE_CLASS_NAMES = new String[]{DEFAULT_ROLE_CLASS_NAME};
    protected String[] _roleClassNames = DEFAULT_ROLE_CLASS_NAMES;
    protected String _callbackHandlerClass;
    protected String _realmName;
    protected String _loginModuleName;
    protected JAASUserPrincipal _defaultUser = new JAASUserPrincipal(null, null, null);
    protected IdentityService _identityService;

    public JAASLoginService() {
    }

    public JAASLoginService(String name) {
        this();
        this._realmName = name;
        this._loginModuleName = name;
    }

    @Override
    public String getName() {
        return this._realmName;
    }

    public void setName(String name) {
        this._realmName = name;
    }

    @Override
    public IdentityService getIdentityService() {
        return this._identityService;
    }

    @Override
    public void setIdentityService(IdentityService identityService) {
        this._identityService = identityService;
    }

    public void setLoginModuleName(String name) {
        this._loginModuleName = name;
    }

    public void setCallbackHandlerClass(String classname) {
        this._callbackHandlerClass = classname;
    }

    public void setRoleClassNames(String[] classnames) {
        ArrayList<String> tmp = new ArrayList<String>();
        if (classnames != null) {
            tmp.addAll(Arrays.asList(classnames));
        }
        if (!tmp.contains(DEFAULT_ROLE_CLASS_NAME)) {
            tmp.add(DEFAULT_ROLE_CLASS_NAME);
        }
        this._roleClassNames = tmp.toArray(new String[tmp.size()]);
    }

    public String[] getRoleClassNames() {
        return this._roleClassNames;
    }

    @Override
    protected void doStart() throws Exception {
        if (this._identityService == null) {
            this._identityService = new DefaultIdentityService();
        }
        super.doStart();
    }

    @Override
    public UserIdentity login(final String username, final Object credentials) {
        try {
            CallbackHandler callbackHandler = new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    Callback[] callbackArray = callbacks;
                    int n = callbacks.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Callback callback = callbackArray[n2];
                        if (callback instanceof NameCallback) {
                            ((NameCallback)callback).setName(username);
                        } else if (callback instanceof PasswordCallback) {
                            ((PasswordCallback)callback).setPassword(credentials.toString().toCharArray());
                        } else if (callback instanceof ObjectCallback) {
                            ((ObjectCallback)callback).setObject(credentials);
                        }
                        ++n2;
                    }
                }
            };
            Subject subject = new Subject();
            LoginContext loginContext = new LoginContext(this._loginModuleName, subject, callbackHandler);
            loginContext.login();
            JAASUserPrincipal userPrincipal = new JAASUserPrincipal(this.getUserName(callbackHandler), subject, loginContext);
            subject.getPrincipals().add(userPrincipal);
            return this._identityService.newUserIdentity(subject, userPrincipal, this.getGroups(subject));
        }
        catch (LoginException e) {
            Log.warn(e);
        }
        catch (IOException e) {
            Log.warn(e);
        }
        catch (UnsupportedCallbackException e) {
            Log.warn(e);
        }
        return null;
    }

    @Override
    public boolean validate(UserIdentity user) {
        return true;
    }

    private String getUserName(CallbackHandler callbackHandler) throws IOException, UnsupportedCallbackException {
        NameCallback nameCallback = new NameCallback("foo");
        callbackHandler.handle(new Callback[]{nameCallback});
        return nameCallback.getName();
    }

    @Override
    public void logout(UserIdentity user) {
        Set<JAASUserPrincipal> userPrincipals = user.getSubject().getPrincipals(JAASUserPrincipal.class);
        LoginContext loginContext = userPrincipals.iterator().next().getLoginContext();
        try {
            loginContext.logout();
        }
        catch (LoginException e) {
            Log.warn(e);
        }
    }

    private String[] getGroups(Subject subject) {
        String[] roleClassNames = this.getRoleClassNames();
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        try {
            String[] stringArray = roleClassNames;
            int n = roleClassNames.length;
            int n2 = 0;
            while (n2 < n) {
                String roleClassName = stringArray[n2];
                Class<?> load_class = Thread.currentThread().getContextClassLoader().loadClass(roleClassName);
                Set<?> rolesForType = subject.getPrincipals(load_class);
                for (Principal principal : rolesForType) {
                    groups.add(principal.getName());
                }
                ++n2;
            }
            return groups.toArray(new String[groups.size()]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

