/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.rewrite.handler.LegacyRule;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.log.Log;

public class RuleContainer
extends Rule {
    protected Rule[] _rules;
    protected String _originalPathAttribute;
    protected boolean _rewriteRequestURI = true;
    protected boolean _rewritePathInfo = true;
    protected LegacyRule _legacy;

    @Deprecated
    public LegacyRule getLegacyRule() {
        if (this._legacy == null) {
            this._legacy = new LegacyRule();
            this.addRule(this._legacy);
        }
        return this._legacy;
    }

    @Deprecated
    public void setLegacyRule(LegacyRule legacyRule) {
        this._legacy = legacyRule;
    }

    public Rule[] getRules() {
        return this._rules;
    }

    public void setRules(Rule[] rules) {
        if (this._legacy == null) {
            this._rules = rules;
        } else {
            this._rules = null;
            this.addRule(this._legacy);
            if (rules != null) {
                Rule[] ruleArray = rules;
                int n = rules.length;
                int n2 = 0;
                while (n2 < n) {
                    Rule rule = ruleArray[n2];
                    this.addRule(rule);
                    ++n2;
                }
            }
        }
    }

    public void addRule(Rule rule) {
        this._rules = (Rule[])LazyList.addToArray(this._rules, rule, Rule.class);
    }

    public boolean isRewriteRequestURI() {
        return this._rewriteRequestURI;
    }

    public void setRewriteRequestURI(boolean rewriteRequestURI) {
        this._rewriteRequestURI = rewriteRequestURI;
    }

    public boolean isRewritePathInfo() {
        return this._rewritePathInfo;
    }

    public void setRewritePathInfo(boolean rewritePathInfo) {
        this._rewritePathInfo = rewritePathInfo;
    }

    public String getOriginalPathAttribute() {
        return this._originalPathAttribute;
    }

    public void setOriginalPathAttribute(String originalPathAttribte) {
        this._originalPathAttribute = originalPathAttribte;
    }

    @Override
    public String matchAndApply(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.apply(target, request, response);
    }

    protected String apply(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean original_set = this._originalPathAttribute == null;
        Rule[] ruleArray = this._rules;
        int n = this._rules.length;
        int n2 = 0;
        while (n2 < n) {
            Rule rule = ruleArray[n2];
            String applied = rule.matchAndApply(target, request, response);
            if (applied != null) {
                Log.debug("applied {}", rule);
                if (!target.equals(applied)) {
                    Log.debug("rewrote {} to {}", target, applied);
                    if (!original_set) {
                        original_set = true;
                        request.setAttribute(this._originalPathAttribute, target);
                    }
                    if (this._rewriteRequestURI) {
                        ((Request)request).setRequestURI(applied);
                    }
                    if (this._rewritePathInfo) {
                        ((Request)request).setPathInfo(applied);
                    }
                    target = applied;
                }
                if (rule.isHandling()) {
                    Log.debug("handling {}", rule);
                    (request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest()).setHandled(true);
                }
                if (rule.isTerminating()) {
                    Log.debug("terminating {}", rule);
                    break;
                }
            }
            ++n2;
        }
        return target;
    }
}

