/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.security.Principal;
import javax.security.auth.Subject;
import org.eclipse.jetty.server.UserIdentity;

public class DefaultUserIdentity
implements UserIdentity {
    private final Subject _subject;
    private final Principal _userPrincipal;
    private final String[] _roles;

    public DefaultUserIdentity(Subject subject, Principal userPrincipal, String[] roles) {
        this._subject = subject;
        this._userPrincipal = userPrincipal;
        this._roles = roles;
    }

    @Override
    public Subject getSubject() {
        return this._subject;
    }

    @Override
    public Principal getUserPrincipal() {
        return this._userPrincipal;
    }

    @Override
    public boolean isUserInRole(String role, UserIdentity.Scope scope) {
        if (scope != null && scope.getRoleRefMap() != null) {
            role = scope.getRoleRefMap().get(role);
        }
        String[] stringArray = this._roles;
        int n = this._roles.length;
        int n2 = 0;
        while (n2 < n) {
            String r = stringArray[n2];
            if (r.equals(role)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(DefaultUserIdentity.class.getSimpleName()) + "('" + this._userPrincipal + "')";
    }
}

