/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;

public class DeferredAuthentication
implements Authentication.Deferred {
    protected final Authenticator _authenticator;
    private LoginService _loginService;
    private IdentityService _identityService;
    private Object _previousAssociation;
    static HttpServletResponse __deferredResponse = new HttpServletResponse(){

        @Override
        public void addCookie(Cookie cookie) {
        }

        @Override
        public void addDateHeader(String name, long date) {
        }

        @Override
        public void addHeader(String name, String value) {
        }

        @Override
        public void addIntHeader(String name, int value) {
        }

        @Override
        public boolean containsHeader(String name) {
            return false;
        }

        @Override
        public String encodeRedirectURL(String url) {
            return null;
        }

        @Override
        public String encodeRedirectUrl(String url) {
            return null;
        }

        @Override
        public String encodeURL(String url) {
            return null;
        }

        @Override
        public String encodeUrl(String url) {
            return null;
        }

        @Override
        public void sendError(int sc) throws IOException {
        }

        @Override
        public void sendError(int sc, String msg) throws IOException {
        }

        @Override
        public void sendRedirect(String location) throws IOException {
        }

        @Override
        public void setDateHeader(String name, long date) {
        }

        @Override
        public void setHeader(String name, String value) {
        }

        @Override
        public void setIntHeader(String name, int value) {
        }

        @Override
        public void setStatus(int sc) {
        }

        @Override
        public void setStatus(int sc, String sm) {
        }

        @Override
        public void flushBuffer() throws IOException {
        }

        @Override
        public int getBufferSize() {
            return 1024;
        }

        @Override
        public String getCharacterEncoding() {
            return null;
        }

        @Override
        public String getContentType() {
            return null;
        }

        @Override
        public Locale getLocale() {
            return null;
        }

        @Override
        public ServletOutputStream getOutputStream() throws IOException {
            return __nullOut;
        }

        @Override
        public PrintWriter getWriter() throws IOException {
            return IO.getNullPrintWriter();
        }

        @Override
        public boolean isCommitted() {
            return true;
        }

        @Override
        public void reset() {
        }

        @Override
        public void resetBuffer() {
        }

        @Override
        public void setBufferSize(int size) {
        }

        @Override
        public void setCharacterEncoding(String charset) {
        }

        @Override
        public void setContentLength(int len) {
        }

        @Override
        public void setContentType(String type) {
        }

        @Override
        public void setLocale(Locale loc) {
        }
    };
    private static ServletOutputStream __nullOut = new ServletOutputStream(){

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void print(String s) throws IOException {
        }

        @Override
        public void println(String s) throws IOException {
        }
    };

    public DeferredAuthentication(Authenticator authenticator) {
        if (authenticator == null) {
            throw new NullPointerException("No Authenticator");
        }
        this._authenticator = authenticator;
    }

    public DeferredAuthentication(LoginAuthenticator authenticator) {
        if (authenticator == null) {
            throw new NullPointerException("No Authenticator");
        }
        this._authenticator = authenticator;
    }

    public IdentityService getIdentityService() {
        return this._identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this._identityService = identityService;
    }

    public LoginService getLoginService() {
        return this._loginService;
    }

    public void setLoginService(LoginService loginService) {
        this._loginService = loginService;
    }

    @Override
    public Authentication authenticate(ServletRequest request) {
        try {
            Authentication authentication = this._authenticator.validateRequest(request, __deferredResponse, true);
            if (authentication != null && authentication instanceof Authentication.User && !(authentication instanceof Authentication.ResponseSent)) {
                if (this._identityService != null) {
                    this._previousAssociation = this._identityService.associate(((Authentication.User)authentication).getUserIdentity());
                }
                return authentication;
            }
        }
        catch (ServerAuthException e) {
            Log.debug(e);
        }
        return Authentication.UNAUTHENTICATED;
    }

    @Override
    public Authentication authenticate(ServletRequest request, ServletResponse response) {
        try {
            Authentication authentication = this._authenticator.validateRequest(request, response, true);
            if (authentication instanceof Authentication.User && this._identityService != null) {
                this._previousAssociation = this._identityService.associate(((Authentication.User)authentication).getUserIdentity());
            }
            return authentication;
        }
        catch (ServerAuthException e) {
            Log.debug(e);
            return Authentication.UNAUTHENTICATED;
        }
    }

    @Override
    public Authentication login(String username, String password) {
        UserIdentity user;
        if (this._loginService != null && (user = this._loginService.login(username, password)) != null) {
            UserAuthentication authentication = new UserAuthentication("API", user);
            if (this._identityService != null) {
                this._previousAssociation = this._identityService.associate(user);
            }
            return authentication;
        }
        return null;
    }

    public Object getPreviousAssociation() {
        return this._previousAssociation;
    }

    public boolean isDeferred(HttpServletResponse response) {
        return response == __deferredResponse;
    }
}

