/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import javax.servlet.http.Cookie;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.log.Log;

public class CookieCutter {
    private Cookie[] _cookies;
    private Cookie[] _lastCookies;
    Object _lazyFields;
    int _fields;

    public Cookie[] getCookies() {
        if (this._cookies != null) {
            return this._cookies;
        }
        if (this._lastCookies != null && this._lazyFields != null && this._fields == LazyList.size(this._lazyFields)) {
            this._cookies = this._lastCookies;
        } else {
            this.parseFields();
        }
        this._lastCookies = this._cookies;
        return this._cookies;
    }

    public void setCookies(Cookie[] cookies) {
        this._cookies = cookies;
        this._lastCookies = null;
        this._lazyFields = null;
        this._fields = 0;
    }

    public void reset() {
        this._cookies = null;
        this._fields = 0;
    }

    /*
     * Unable to fully structure code
     */
    public void addCookieField(String f) {
        block3: {
            if (f == null) {
                return;
            }
            if ((f = f.trim()).length() == 0) {
                return;
            }
            if (LazyList.size(this._lazyFields) <= this._fields) break block3;
            if (!f.equals(LazyList.get(this._lazyFields, this._fields))) ** GOTO lbl10
            ++this._fields;
            return;
lbl-1000:
            // 1 sources

            {
                this._lazyFields = LazyList.remove(this._lazyFields, this._fields);
lbl10:
                // 2 sources

                ** while (LazyList.size((Object)this._lazyFields) > this._fields)
            }
        }
        this._cookies = null;
        this._lastCookies = null;
        this._lazyFields = LazyList.add(this._lazyFields, this._fields++, f);
    }

    protected void parseFields() {
        this._lastCookies = null;
        this._cookies = null;
        Object cookies = null;
        int version = 0;
        while (LazyList.size(this._lazyFields) > this._fields) {
            this._lazyFields = LazyList.remove(this._lazyFields, this._fields);
        }
        int f = 0;
        while (f < this._fields) {
            String hdr = (String)LazyList.get(this._lazyFields, f);
            String name = null;
            String value = null;
            Cookie cookie = null;
            boolean invalue = false;
            boolean quoted = false;
            boolean escaped = false;
            int tokenstart = -1;
            int tokenend = -1;
            int i = 0;
            int length = hdr.length();
            int last = length - 1;
            while (i < length) {
                block48: {
                    block49: {
                        char c;
                        block50: {
                            block46: {
                                block47: {
                                    c = hdr.charAt(i);
                                    if (!quoted) break block46;
                                    if (!escaped) break block47;
                                    escaped = false;
                                    break block48;
                                }
                                switch (c) {
                                    case '\"': {
                                        tokenend = i;
                                        quoted = false;
                                        if (i == last) {
                                            if (invalue) {
                                                value = hdr.substring(tokenstart, tokenend + 1);
                                            } else {
                                                name = hdr.substring(tokenstart, tokenend + 1);
                                                value = "";
                                            }
                                        }
                                        break block49;
                                    }
                                    case '\\': {
                                        escaped = true;
                                        break;
                                    }
                                }
                                break block48;
                            }
                            if (!invalue) break block50;
                            switch (c) {
                                case '\t': 
                                case ' ': {
                                    break block48;
                                }
                                case '\"': {
                                    if (tokenstart < 0) {
                                        quoted = true;
                                        tokenstart = i;
                                    }
                                    tokenend = i;
                                    if (i == last) {
                                        value = hdr.substring(tokenstart, tokenend + 1);
                                        break;
                                    }
                                    break block48;
                                }
                                case ',': 
                                case ';': {
                                    value = tokenstart >= 0 ? hdr.substring(tokenstart, tokenend + 1) : "";
                                    tokenstart = -1;
                                    invalue = false;
                                    break;
                                }
                                default: {
                                    if (tokenstart < 0) {
                                        tokenstart = i;
                                    }
                                    tokenend = i;
                                    if (i == last) {
                                        value = hdr.substring(tokenstart, tokenend + 1);
                                        break;
                                    }
                                    break block48;
                                }
                            }
                            break block49;
                        }
                        switch (c) {
                            case '\t': 
                            case ' ': {
                                break block48;
                            }
                            case '\"': {
                                if (tokenstart < 0) {
                                    quoted = true;
                                    tokenstart = i;
                                }
                                tokenend = i;
                                if (i == last) {
                                    name = hdr.substring(tokenstart, tokenend + 1);
                                    value = "";
                                    break;
                                }
                                break block48;
                            }
                            case ',': 
                            case ';': {
                                if (tokenstart >= 0) {
                                    name = hdr.substring(tokenstart, tokenend + 1);
                                    value = "";
                                }
                                tokenstart = -1;
                                break;
                            }
                            case '=': {
                                if (tokenstart >= 0) {
                                    name = hdr.substring(tokenstart, tokenend + 1);
                                }
                                tokenstart = -1;
                                invalue = true;
                                break block48;
                            }
                            default: {
                                if (tokenstart < 0) {
                                    tokenstart = i;
                                }
                                tokenend = i;
                                if (i != last) break block48;
                                name = hdr.substring(tokenstart, tokenend + 1);
                                value = "";
                            }
                        }
                    }
                    if (value != null && name != null) {
                        name = QuotedStringTokenizer.unquote(name);
                        value = QuotedStringTokenizer.unquote(value);
                        try {
                            if (name.startsWith("$")) {
                                String lowercaseName = name.toLowerCase();
                                if ("$path".equals(lowercaseName)) {
                                    if (cookie != null) {
                                        cookie.setPath(value);
                                    }
                                } else if ("$domain".equals(lowercaseName)) {
                                    if (cookie != null) {
                                        cookie.setDomain(value);
                                    }
                                } else if ("$port".equals(lowercaseName)) {
                                    if (cookie != null) {
                                        cookie.setComment("$port=" + value);
                                    }
                                } else if ("$version".equals(lowercaseName)) {
                                    version = Integer.parseInt(value);
                                }
                            } else {
                                cookie = new Cookie(name, value);
                                if (version > 0) {
                                    cookie.setVersion(version);
                                }
                                cookies = LazyList.add(cookies, cookie);
                            }
                        }
                        catch (Exception e) {
                            Log.warn(e.toString());
                            Log.debug(e);
                        }
                        name = null;
                        value = null;
                    }
                }
                ++i;
            }
            ++f;
        }
        this._cookies = (Cookie[])LazyList.toArray(cookies, Cookie.class);
        this._lastCookies = this._cookies;
    }
}

