/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.eclipse.jetty.http.AbstractGenerator;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.util.ByteArrayOutputStream2;

public class HttpWriter
extends Writer {
    public static final int MAX_OUTPUT_CHARS = 512;
    private static final int WRITE_CONV = 0;
    private static final int WRITE_ISO1 = 1;
    private static final int WRITE_UTF8 = 2;
    final HttpOutput _out;
    final AbstractGenerator _generator;
    int _writeMode;
    int _surrogate;

    public HttpWriter(HttpOutput out) {
        this._out = out;
        this._generator = this._out._generator;
        this._surrogate = 0;
    }

    public void setCharacterEncoding(String encoding) {
        if (encoding == null || "ISO-8859-1".equalsIgnoreCase(encoding)) {
            this._writeMode = 1;
        } else if ("UTF-8".equalsIgnoreCase(encoding)) {
            this._writeMode = 2;
        } else {
            this._writeMode = 0;
            if (this._out._characterEncoding == null || !this._out._characterEncoding.equalsIgnoreCase(encoding)) {
                this._out._converter = null;
            }
        }
        this._out._characterEncoding = encoding;
        if (this._out._bytes == null) {
            this._out._bytes = new ByteArrayOutputStream2(512);
        }
    }

    @Override
    public void close() throws IOException {
        this._out.close();
    }

    @Override
    public void flush() throws IOException {
        this._out.flush();
    }

    @Override
    public void write(String s, int offset, int length) throws IOException {
        while (length > 512) {
            this.write(s, offset, 512);
            offset += 512;
            length -= 512;
        }
        if (this._out._chars == null) {
            this._out._chars = new char[512];
        }
        char[] chars = this._out._chars;
        s.getChars(offset, offset + length, chars, 0);
        this.write(chars, 0, length);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void write(char[] s, int offset, int length) throws IOException {
        out = this._out;
        while (length > 0) {
            out._bytes.reset();
            chars = length > 512 ? 512 : length;
            switch (this._writeMode) {
                case 0: {
                    converter = this.getConverter();
                    converter.write(s, offset, chars);
                    converter.flush();
                    break;
                }
                case 1: {
                    buffer = out._bytes.getBuf();
                    bytes = out._bytes.getCount();
                    if (chars > buffer.length - bytes) {
                        chars = buffer.length - bytes;
                    }
                    i = 0;
                    while (i < chars) {
                        c = s[offset + i];
                        buffer[bytes++] = (byte)(c < 256 ? c : 63);
                        ++i;
                    }
                    if (bytes < 0) break;
                    out._bytes.setCount(bytes);
                    break;
                }
                case 2: {
                    buffer = out._bytes.getBuf();
                    bytes = out._bytes.getCount();
                    if (bytes + chars > buffer.length) {
                        chars = buffer.length - bytes;
                    }
                    i = 0;
                    while (i < chars) {
                        code = s[offset + i];
                        if (this._surrogate != 0) ** GOTO lbl37
                        if (!Character.isHighSurrogate((char)code)) ** GOTO lbl43
                        this._surrogate = code;
                        ** GOTO lbl99
lbl37:
                        // 1 sources

                        if (Character.isLowSurrogate((char)code)) {
                            code = Character.toCodePoint((char)this._surrogate, (char)code);
                        } else {
                            code = this._surrogate;
                            this._surrogate = 0;
                            --i;
                        }
lbl43:
                        // 3 sources

                        if ((code & -128) == 0) {
                            if (bytes >= buffer.length) {
                                chars = i;
                                break;
                            }
                            buffer[bytes++] = (byte)code;
                        } else {
                            if ((code & -2048) == 0) {
                                if (bytes + 2 > buffer.length) {
                                    chars = i;
                                    break;
                                }
                                buffer[bytes++] = (byte)(192 | code >> 6);
                                buffer[bytes++] = (byte)(128 | code & 63);
                            } else if ((code & -65536) == 0) {
                                if (bytes + 3 > buffer.length) {
                                    chars = i;
                                    break;
                                }
                                buffer[bytes++] = (byte)(224 | code >> 12);
                                buffer[bytes++] = (byte)(128 | code >> 6 & 63);
                                buffer[bytes++] = (byte)(128 | code & 63);
                            } else if ((code & -14680064) == 0) {
                                if (bytes + 4 > buffer.length) {
                                    chars = i;
                                    break;
                                }
                                buffer[bytes++] = (byte)(240 | code >> 18);
                                buffer[bytes++] = (byte)(128 | code >> 12 & 63);
                                buffer[bytes++] = (byte)(128 | code >> 6 & 63);
                                buffer[bytes++] = (byte)(128 | code & 63);
                            } else if ((code & -201326592) == 0) {
                                if (bytes + 5 > buffer.length) {
                                    chars = i;
                                    break;
                                }
                                buffer[bytes++] = (byte)(248 | code >> 24);
                                buffer[bytes++] = (byte)(128 | code >> 18 & 63);
                                buffer[bytes++] = (byte)(128 | code >> 12 & 63);
                                buffer[bytes++] = (byte)(128 | code >> 6 & 63);
                                buffer[bytes++] = (byte)(128 | code & 63);
                            } else if ((code & -2147483648) == 0) {
                                if (bytes + 6 > buffer.length) {
                                    chars = i;
                                    break;
                                }
                                buffer[bytes++] = (byte)(252 | code >> 30);
                                buffer[bytes++] = (byte)(128 | code >> 24 & 63);
                                buffer[bytes++] = (byte)(128 | code >> 18 & 63);
                                buffer[bytes++] = (byte)(128 | code >> 12 & 63);
                                buffer[bytes++] = (byte)(128 | code >> 6 & 63);
                                buffer[bytes++] = (byte)(128 | code & 63);
                            } else {
                                buffer[bytes++] = 63;
                            }
                            this._surrogate = 0;
                            if (bytes == buffer.length) {
                                chars = i + 1;
                                break;
                            }
                        }
lbl99:
                        // 4 sources

                        ++i;
                    }
                    out._bytes.setCount(bytes);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            out._bytes.writeTo(out);
            length -= chars;
            offset += chars;
        }
    }

    private Writer getConverter() throws IOException {
        if (this._out._converter == null) {
            this._out._converter = new OutputStreamWriter((OutputStream)this._out._bytes, this._out._characterEncoding);
        }
        return this._out._converter;
    }
}

