/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.TypeUtil;

public abstract class AbstractHandlerContainer
extends AbstractHandler
implements HandlerContainer {
    @Override
    public Handler[] getChildHandlers() {
        Object list = this.expandChildren(null, null);
        return (Handler[])LazyList.toArray(list, Handler.class);
    }

    @Override
    public Handler[] getChildHandlersByClass(Class<?> byclass) {
        Object list = this.expandChildren(null, byclass);
        return (Handler[])LazyList.toArray(list, byclass);
    }

    @Override
    public <T extends Handler> T getChildHandlerByClass(Class<T> byclass) {
        Object list = this.expandChildren(null, byclass);
        if (list == null) {
            return null;
        }
        return (T)((Handler)LazyList.get(list, 0));
    }

    protected Object expandChildren(Object list, Class<?> byClass) {
        return list;
    }

    protected Object expandHandler(Handler handler, Object list, Class<Handler> byClass) {
        if (handler == null) {
            return list;
        }
        if (byClass == null || byClass.isAssignableFrom(handler.getClass())) {
            list = LazyList.add(list, handler);
        }
        if (handler instanceof AbstractHandlerContainer) {
            list = ((AbstractHandlerContainer)handler).expandChildren(list, byClass);
        } else if (handler instanceof HandlerContainer) {
            HandlerContainer container = (HandlerContainer)((Object)handler);
            Object[] handlers = byClass == null ? container.getChildHandlers() : container.getChildHandlersByClass(byClass);
            list = LazyList.addArray(list, handlers);
        }
        return list;
    }

    public static <T extends HandlerContainer> T findContainerOf(HandlerContainer root, Class<T> type, Handler handler) {
        if (root == null || handler == null) {
            return null;
        }
        Handler[] branches = root.getChildHandlersByClass(type);
        if (branches != null) {
            Handler[] handlerArray = branches;
            int n = branches.length;
            int n2 = 0;
            while (n2 < n) {
                Handler h = handlerArray[n2];
                HandlerContainer container = (HandlerContainer)((Object)h);
                Handler[] candidates = container.getChildHandlersByClass(handler.getClass());
                if (candidates != null) {
                    Handler[] handlerArray2 = candidates;
                    int n3 = candidates.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Handler c = handlerArray2[n4];
                        if (c == handler) {
                            return (T)container;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.dumpThis(out);
        AbstractHandlerContainer.dump(out, indent, TypeUtil.asList(this.getHandlers()), this.getBeans());
    }
}

