/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.server.AsyncContinuation;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.log.Log;

public class ContextHandlerCollection
extends HandlerCollection {
    private volatile PathMap _contextMap;
    private Class<? extends ContextHandler> _contextClass = ContextHandler.class;

    public ContextHandlerCollection() {
        super(true);
    }

    public void mapContexts() {
        PathMap contextMap = new PathMap();
        Handler[] branches = this.getHandlers();
        int b = 0;
        while (branches != null && b < branches.length) {
            block20: {
                Handler[] handlers;
                block19: {
                    block18: {
                        handlers = null;
                        if (!(branches[b] instanceof ContextHandler)) break block18;
                        handlers = new Handler[]{branches[b]};
                        break block19;
                    }
                    if (!(branches[b] instanceof HandlerContainer)) break block20;
                    handlers = ((HandlerContainer)((Object)branches[b])).getChildHandlersByClass(ContextHandler.class);
                }
                int i = 0;
                while (i < handlers.length) {
                    HashMap hosts;
                    ContextHandler handler = (ContextHandler)handlers[i];
                    String contextPath = handler.getContextPath();
                    if (contextPath == null || contextPath.indexOf(44) >= 0 || contextPath.startsWith("*")) {
                        throw new IllegalArgumentException("Illegal context spec:" + contextPath);
                    }
                    if (!contextPath.startsWith("/")) {
                        contextPath = String.valueOf('/') + contextPath;
                    }
                    if (contextPath.length() > 1) {
                        if (contextPath.endsWith("/")) {
                            contextPath = String.valueOf(contextPath) + "*";
                        } else if (!contextPath.endsWith("/*")) {
                            contextPath = String.valueOf(contextPath) + "/*";
                        }
                    }
                    Object contexts = contextMap.get(contextPath);
                    String[] vhosts = handler.getVirtualHosts();
                    if (vhosts != null && vhosts.length > 0) {
                        if (contexts instanceof Map) {
                            hosts = (Map)contexts;
                        } else {
                            hosts = new HashMap();
                            hosts.put("*", contexts);
                            contextMap.put(contextPath, hosts);
                        }
                        int j = 0;
                        while (j < vhosts.length) {
                            String vhost = vhosts[j];
                            contexts = hosts.get(vhost);
                            contexts = LazyList.add(contexts, branches[b]);
                            hosts.put(vhost, contexts);
                            ++j;
                        }
                    } else if (contexts instanceof Map) {
                        hosts = (HashMap)contexts;
                        contexts = hosts.get("*");
                        contexts = LazyList.add(contexts, branches[b]);
                        hosts.put("*", contexts);
                    } else {
                        contexts = LazyList.add(contexts, branches[b]);
                        contextMap.put(contextPath, contexts);
                    }
                    ++i;
                }
            }
            ++b;
        }
        this._contextMap = contextMap;
    }

    @Override
    public void setHandlers(Handler[] handlers) {
        this._contextMap = null;
        super.setHandlers(handlers);
        if (this.isStarted()) {
            this.mapContexts();
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.mapContexts();
        super.doStart();
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ContextHandler context;
        Handler[] handlers = this.getHandlers();
        if (handlers == null || handlers.length == 0) {
            return;
        }
        AsyncContinuation async = baseRequest.getAsyncContinuation();
        if (async.isAsync() && (context = async.getContextHandler()) != null) {
            context.handle(target, baseRequest, request, response);
            return;
        }
        PathMap map = this._contextMap;
        if (map != null && target != null && target.startsWith("/")) {
            Object contexts = map.getLazyMatches(target);
            int i = 0;
            while (i < LazyList.size(contexts)) {
                Map.Entry entry = (Map.Entry)LazyList.get(contexts, i);
                Object list = entry.getValue();
                if (list instanceof Map) {
                    Handler handler;
                    Map hosts = (Map)list;
                    String host = this.normalizeHostname(request.getServerName());
                    list = hosts.get(host);
                    int j = 0;
                    while (j < LazyList.size(list)) {
                        handler = (Handler)LazyList.get(list, j);
                        handler.handle(target, baseRequest, request, response);
                        if (baseRequest.isHandled()) {
                            return;
                        }
                        ++j;
                    }
                    list = hosts.get("*." + host.substring(host.indexOf(".") + 1));
                    j = 0;
                    while (j < LazyList.size(list)) {
                        handler = (Handler)LazyList.get(list, j);
                        handler.handle(target, baseRequest, request, response);
                        if (baseRequest.isHandled()) {
                            return;
                        }
                        ++j;
                    }
                    list = hosts.get("*");
                    j = 0;
                    while (j < LazyList.size(list)) {
                        handler = (Handler)LazyList.get(list, j);
                        handler.handle(target, baseRequest, request, response);
                        if (baseRequest.isHandled()) {
                            return;
                        }
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j < LazyList.size(list)) {
                        Handler handler = (Handler)LazyList.get(list, j);
                        handler.handle(target, baseRequest, request, response);
                        if (baseRequest.isHandled()) {
                            return;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < handlers.length) {
                handlers[i].handle(target, baseRequest, request, response);
                if (baseRequest.isHandled()) {
                    return;
                }
                ++i;
            }
        }
    }

    public ContextHandler addContext(String contextPath, String resourceBase) {
        try {
            ContextHandler context = this._contextClass.newInstance();
            context.setContextPath(contextPath);
            context.setResourceBase(resourceBase);
            this.addHandler(context);
            return context;
        }
        catch (Exception e) {
            Log.debug(e);
            throw new Error(e);
        }
    }

    public Class getContextClass() {
        return this._contextClass;
    }

    public void setContextClass(Class contextClass) {
        if (contextClass == null || !ContextHandler.class.isAssignableFrom(contextClass)) {
            throw new IllegalArgumentException();
        }
        this._contextClass = contextClass;
    }

    private String normalizeHostname(String host) {
        if (host == null) {
            return null;
        }
        if (host.endsWith(".")) {
            return host.substring(0, host.length() - 1);
        }
        return host;
    }
}

