/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.RolloverFileOutputStream;

public class DebugHandler
extends HandlerWrapper {
    private DateCache _date = new DateCache("HH:mm:ss", Locale.US);
    private OutputStream _out;
    private PrintStream _print;

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Response base_response = baseRequest.getResponse();
        Thread thread = Thread.currentThread();
        String old_name = thread.getName();
        boolean suspend = false;
        boolean retry = false;
        String name = (String)request.getAttribute("org.eclipse.jetty.thread.name");
        if (name == null) {
            name = String.valueOf(old_name) + ":" + baseRequest.getScheme() + "://" + baseRequest.getLocalAddr() + ":" + baseRequest.getLocalPort() + baseRequest.getUri();
        } else {
            retry = true;
        }
        String ex = null;
        try {
            try {
                String d = this._date.now();
                int ms = this._date.lastMs();
                if (retry) {
                    this._print.println(String.valueOf(d) + (ms > 99 ? "." : (ms > 9 ? ".0" : ".00")) + ms + ":" + name + " RETRY");
                } else {
                    this._print.println(String.valueOf(d) + (ms > 99 ? "." : (ms > 9 ? ".0" : ".00")) + ms + ":" + name + " " + baseRequest.getRemoteAddr() + " " + request.getMethod() + " " + baseRequest.getHeader("Cookie") + "; " + baseRequest.getHeader("User-Agent"));
                }
                thread.setName(name);
                this.getHandler().handle(target, baseRequest, request, response);
            }
            catch (IOException ioe) {
                ex = ioe.toString();
                throw ioe;
            }
            catch (ServletException se) {
                ex = String.valueOf(se.toString()) + ":" + se.getCause();
                throw se;
            }
            catch (RuntimeException rte) {
                ex = rte.toString();
                throw rte;
            }
            catch (Error e) {
                ex = e.toString();
                throw e;
            }
        }
        catch (Throwable throwable) {
            thread.setName(old_name);
            String d = this._date.now();
            int ms = this._date.lastMs();
            suspend = baseRequest.getAsyncContinuation().isSuspended();
            if (suspend) {
                request.setAttribute("org.eclipse.jetty.thread.name", name);
                this._print.println(String.valueOf(d) + (ms > 99 ? "." : (ms > 9 ? ".0" : ".00")) + ms + ":" + name + " SUSPEND");
            } else {
                this._print.println(String.valueOf(d) + (ms > 99 ? "." : (ms > 9 ? ".0" : ".00")) + ms + ":" + name + " " + base_response.getStatus() + (ex == null ? "" : "/" + ex) + " " + base_response.getContentType() + " " + base_response.getContentCount());
            }
            throw throwable;
        }
        thread.setName(old_name);
        String d = this._date.now();
        int ms = this._date.lastMs();
        suspend = baseRequest.getAsyncContinuation().isSuspended();
        if (suspend) {
            request.setAttribute("org.eclipse.jetty.thread.name", name);
            this._print.println(String.valueOf(d) + (ms > 99 ? "." : (ms > 9 ? ".0" : ".00")) + ms + ":" + name + " SUSPEND");
        } else {
            this._print.println(String.valueOf(d) + (ms > 99 ? "." : (ms > 9 ? ".0" : ".00")) + ms + ":" + name + " " + base_response.getStatus() + (ex == null ? "" : "/" + ex) + " " + base_response.getContentType() + " " + base_response.getContentCount());
        }
    }

    @Override
    protected void doStart() throws Exception {
        if (this._out == null) {
            this._out = new RolloverFileOutputStream("./logs/yyyy_mm_dd.debug.log", true);
        }
        this._print = new PrintStream(this._out);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this._print.close();
    }

    public OutputStream getOutputStream() {
        return this._out;
    }

    public void setOutputStream(OutputStream out) {
        this._out = out;
    }
}

