/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.MultiException;

public class HandlerCollection
extends AbstractHandlerContainer {
    private final boolean _mutableWhenRunning;
    private volatile Handler[] _handlers;
    private boolean _parallelStart = false;

    public HandlerCollection() {
        this._mutableWhenRunning = false;
    }

    public HandlerCollection(boolean mutableWhenRunning) {
        this._mutableWhenRunning = mutableWhenRunning;
    }

    @Override
    public Handler[] getHandlers() {
        return this._handlers;
    }

    public void setHandlers(Handler[] handlers) {
        if (!this._mutableWhenRunning && this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        Object[] old_handlers = this._handlers == null ? null : (Handler[])this._handlers.clone();
        this._handlers = handlers;
        Server server = this.getServer();
        MultiException mex = new MultiException();
        int i = 0;
        while (handlers != null && i < handlers.length) {
            if (handlers[i].getServer() != server) {
                handlers[i].setServer(server);
            }
            ++i;
        }
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, old_handlers, handlers, "handler");
        }
        i = 0;
        while (old_handlers != null && i < old_handlers.length) {
            if (old_handlers[i] != null) {
                try {
                    if (old_handlers[i].isStarted()) {
                        old_handlers[i].stop();
                    }
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
            ++i;
        }
        mex.ifExceptionThrowRuntime();
    }

    public boolean isParallelStart() {
        return this._parallelStart;
    }

    public void setParallelStart(boolean parallelStart) {
        this._parallelStart = parallelStart;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this._handlers != null && this.isStarted()) {
            MultiException mex = null;
            int i = 0;
            while (i < this._handlers.length) {
                try {
                    this._handlers[i].handle(target, baseRequest, request, response);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (mex == null) {
                        mex = new MultiException();
                    }
                    mex.add(e);
                }
                ++i;
            }
            if (mex != null) {
                if (mex.size() == 1) {
                    throw new ServletException(mex.getThrowable(0));
                }
                throw new ServletException(mex);
            }
        }
    }

    @Override
    protected void doStart() throws Exception {
        final MultiException mex = new MultiException();
        if (this._handlers != null) {
            if (this._parallelStart) {
                final CountDownLatch latch = new CountDownLatch(this._handlers.length);
                final ClassLoader loader = Thread.currentThread().getContextClassLoader();
                int i = 0;
                while (i < this._handlers.length) {
                    final int h = i++;
                    this.getServer().getThreadPool().dispatch(new Runnable(){

                        @Override
                        public void run() {
                            ClassLoader orig = Thread.currentThread().getContextClassLoader();
                            try {
                                try {
                                    Thread.currentThread().setContextClassLoader(loader);
                                    HandlerCollection.this._handlers[h].start();
                                }
                                catch (Throwable e) {
                                    mex.add(e);
                                    Thread.currentThread().setContextClassLoader(orig);
                                    latch.countDown();
                                }
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(orig);
                                latch.countDown();
                            }
                        }
                    });
                }
                latch.await();
            } else {
                int i = 0;
                while (i < this._handlers.length) {
                    try {
                        this._handlers[i].start();
                    }
                    catch (Throwable e) {
                        mex.add(e);
                    }
                    ++i;
                }
            }
        }
        super.doStart();
        mex.ifExceptionThrow();
    }

    @Override
    protected void doStop() throws Exception {
        MultiException mex = new MultiException();
        try {
            super.doStop();
        }
        catch (Throwable e) {
            mex.add(e);
        }
        if (this._handlers != null) {
            int i = this._handlers.length;
            while (i-- > 0) {
                try {
                    this._handlers[i].stop();
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        mex.ifExceptionThrow();
    }

    @Override
    public void setServer(Server server) {
        if (this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        Server old_server = this.getServer();
        super.setServer(server);
        Handler[] h = this.getHandlers();
        int i = 0;
        while (h != null && i < h.length) {
            h[i].setServer(server);
            ++i;
        }
        if (server != null && server != old_server) {
            server.getContainer().update((Object)this, null, this._handlers, "handler");
        }
    }

    public void addHandler(Handler handler) {
        this.setHandlers((Handler[])LazyList.addToArray(this.getHandlers(), handler, Handler.class));
    }

    public void removeHandler(Handler handler) {
        Object[] handlers = this.getHandlers();
        if (handlers != null && handlers.length > 0) {
            this.setHandlers((Handler[])LazyList.removeFromArray(handlers, handler));
        }
    }

    protected Object expandChildren(Object list, Class byClass) {
        Handler[] handlers = this.getHandlers();
        int i = 0;
        while (handlers != null && i < handlers.length) {
            list = this.expandHandler(handlers[i], list, byClass);
            ++i;
        }
        return list;
    }

    @Override
    public void destroy() {
        if (!this.isStopped()) {
            throw new IllegalStateException("!STOPPED");
        }
        Handler[] children = this.getChildHandlers();
        this.setHandlers(null);
        Handler[] handlerArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Handler child = handlerArray[n2];
            child.destroy();
            ++n2;
        }
        super.destroy();
    }
}

