/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.server.session.AbstractSessionIdManager;
import org.eclipse.jetty.server.session.AbstractSessionManager;

public class HashSessionIdManager
extends AbstractSessionIdManager {
    private final Map<String, Set<WeakReference<HttpSession>>> _sessions = new HashMap<String, Set<WeakReference<HttpSession>>>();

    public HashSessionIdManager() {
    }

    public HashSessionIdManager(Random random) {
        super(random);
    }

    @Override
    public String getNodeId(String clusterId, HttpServletRequest request) {
        String worker;
        String string = worker = request == null ? null : (String)request.getAttribute("org.eclipse.jetty.ajp.JVMRoute");
        if (worker != null) {
            return String.valueOf(clusterId) + '.' + worker;
        }
        if (this._workerName != null) {
            return String.valueOf(clusterId) + '.' + this._workerName;
        }
        return clusterId;
    }

    @Override
    public String getClusterId(String nodeId) {
        int dot = nodeId.lastIndexOf(46);
        return dot > 0 ? nodeId.substring(0, dot) : nodeId;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        this._sessions.clear();
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean idInUse(String id) {
        HashSessionIdManager hashSessionIdManager = this;
        synchronized (hashSessionIdManager) {
            return this._sessions.containsKey(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSession(HttpSession session) {
        String id = this.getClusterId(session.getId());
        WeakReference<HttpSession> ref = new WeakReference<HttpSession>(session);
        HashSessionIdManager hashSessionIdManager = this;
        synchronized (hashSessionIdManager) {
            Set<WeakReference<HttpSession>> sessions = this._sessions.get(id);
            if (sessions == null) {
                sessions = new HashSet<WeakReference<HttpSession>>();
                this._sessions.put(id, sessions);
            }
            sessions.add(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSession(HttpSession session) {
        String id = this.getClusterId(session.getId());
        HashSessionIdManager hashSessionIdManager = this;
        synchronized (hashSessionIdManager) {
            Collection sessions = this._sessions.get(id);
            if (sessions != null) {
                Iterator iter = sessions.iterator();
                while (iter.hasNext()) {
                    WeakReference ref = (WeakReference)iter.next();
                    HttpSession s = (HttpSession)ref.get();
                    if (s == null) {
                        iter.remove();
                        continue;
                    }
                    if (s != session) continue;
                    iter.remove();
                    break;
                }
                if (sessions.isEmpty()) {
                    this._sessions.remove(id);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateAll(String id) {
        Collection sessions;
        HashSessionIdManager hashSessionIdManager = this;
        synchronized (hashSessionIdManager) {
            sessions = this._sessions.remove(id);
        }
        if (sessions != null) {
            for (WeakReference ref : sessions) {
                AbstractSessionManager.Session session = (AbstractSessionManager.Session)ref.get();
                if (session == null || !session.isValid()) continue;
                session.invalidate();
            }
            sessions.clear();
        }
    }
}

