/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import java.io.IOException;
import java.util.HashSet;
import java.util.Queue;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.Timeout;

public class DoSFilter
implements Filter {
    static final String __TRACKER = "DoSFilter.Tracker";
    static final String __THROTTLED = "DoSFilter.Throttled";
    static final int __DEFAULT_MAX_REQUESTS_PER_SEC = 25;
    static final int __DEFAULT_DELAY_MS = 100;
    static final int __DEFAULT_THROTTLE = 5;
    static final int __DEFAULT_WAIT_MS = 50;
    static final long __DEFAULT_THROTTLE_MS = 30000L;
    static final long __DEFAULT_MAX_REQUEST_MS_INIT_PARAM = 30000L;
    static final long __DEFAULT_MAX_IDLE_TRACKER_MS_INIT_PARAM = 30000L;
    static final String MANAGED_ATTR_INIT_PARAM = "managedAttr";
    static final String MAX_REQUESTS_PER_S_INIT_PARAM = "maxRequestsPerSec";
    static final String DELAY_MS_INIT_PARAM = "delayMs";
    static final String THROTTLED_REQUESTS_INIT_PARAM = "throttledRequests";
    static final String MAX_WAIT_INIT_PARAM = "maxWaitMs";
    static final String THROTTLE_MS_INIT_PARAM = "throttleMs";
    static final String MAX_REQUEST_MS_INIT_PARAM = "maxRequestMs";
    static final String MAX_IDLE_TRACKER_MS_INIT_PARAM = "maxIdleTrackerMs";
    static final String INSERT_HEADERS_INIT_PARAM = "insertHeaders";
    static final String TRACK_SESSIONS_INIT_PARAM = "trackSessions";
    static final String REMOTE_PORT_INIT_PARAM = "remotePort";
    static final String IP_WHITELIST_INIT_PARAM = "ipWhitelist";
    static final int USER_AUTH = 2;
    static final int USER_SESSION = 2;
    static final int USER_IP = 1;
    static final int USER_UNKNOWN = 0;
    ServletContext _context;
    protected String _name;
    protected long _delayMs;
    protected long _throttleMs;
    protected long _maxWaitMs;
    protected long _maxRequestMs;
    protected long _maxIdleTrackerMs;
    protected boolean _insertHeaders;
    protected boolean _trackSessions;
    protected boolean _remotePort;
    protected int _throttledRequests;
    protected Semaphore _passes;
    protected Queue<Continuation>[] _queue;
    protected ContinuationListener[] _listener;
    protected int _maxRequestsPerSec;
    protected final ConcurrentHashMap<String, RateTracker> _rateTrackers = new ConcurrentHashMap();
    protected String _whitelistStr;
    private final HashSet<String> _whitelist = new HashSet();
    private final Timeout _requestTimeoutQ = new Timeout();
    private final Timeout _trackerTimeoutQ = new Timeout();
    private Thread _timerThread;
    private volatile boolean _running;

    @Override
    public void init(FilterConfig filterConfig) {
        this._context = filterConfig.getServletContext();
        this._queue = new Queue[this.getMaxPriority() + 1];
        this._listener = new ContinuationListener[this.getMaxPriority() + 1];
        int p = 0;
        while (p < this._queue.length) {
            this._queue[p] = new ConcurrentLinkedQueue<Continuation>();
            final int priority = p;
            this._listener[p] = new ContinuationListener(){

                @Override
                public void onComplete(Continuation continuation) {
                }

                @Override
                public void onTimeout(Continuation continuation) {
                    DoSFilter.this._queue[priority].remove(continuation);
                }
            };
            ++p;
        }
        this._rateTrackers.clear();
        int baseRateLimit = 25;
        if (filterConfig.getInitParameter(MAX_REQUESTS_PER_S_INIT_PARAM) != null) {
            baseRateLimit = Integer.parseInt(filterConfig.getInitParameter(MAX_REQUESTS_PER_S_INIT_PARAM));
        }
        this._maxRequestsPerSec = baseRateLimit;
        long delay = 100L;
        if (filterConfig.getInitParameter(DELAY_MS_INIT_PARAM) != null) {
            delay = Integer.parseInt(filterConfig.getInitParameter(DELAY_MS_INIT_PARAM));
        }
        this._delayMs = delay;
        int throttledRequests = 5;
        if (filterConfig.getInitParameter(THROTTLED_REQUESTS_INIT_PARAM) != null) {
            throttledRequests = Integer.parseInt(filterConfig.getInitParameter(THROTTLED_REQUESTS_INIT_PARAM));
        }
        this._passes = new Semaphore(throttledRequests, true);
        this._throttledRequests = throttledRequests;
        long wait = 50L;
        if (filterConfig.getInitParameter(MAX_WAIT_INIT_PARAM) != null) {
            wait = Integer.parseInt(filterConfig.getInitParameter(MAX_WAIT_INIT_PARAM));
        }
        this._maxWaitMs = wait;
        long suspend = 30000L;
        if (filterConfig.getInitParameter(THROTTLE_MS_INIT_PARAM) != null) {
            suspend = Integer.parseInt(filterConfig.getInitParameter(THROTTLE_MS_INIT_PARAM));
        }
        this._throttleMs = suspend;
        long maxRequestMs = 30000L;
        if (filterConfig.getInitParameter(MAX_REQUEST_MS_INIT_PARAM) != null) {
            maxRequestMs = Long.parseLong(filterConfig.getInitParameter(MAX_REQUEST_MS_INIT_PARAM));
        }
        this._maxRequestMs = maxRequestMs;
        long maxIdleTrackerMs = 30000L;
        if (filterConfig.getInitParameter(MAX_IDLE_TRACKER_MS_INIT_PARAM) != null) {
            maxIdleTrackerMs = Long.parseLong(filterConfig.getInitParameter(MAX_IDLE_TRACKER_MS_INIT_PARAM));
        }
        this._maxIdleTrackerMs = maxIdleTrackerMs;
        this._whitelistStr = "";
        if (filterConfig.getInitParameter(IP_WHITELIST_INIT_PARAM) != null) {
            this._whitelistStr = filterConfig.getInitParameter(IP_WHITELIST_INIT_PARAM);
        }
        this.initWhitelist();
        String tmp = filterConfig.getInitParameter(INSERT_HEADERS_INIT_PARAM);
        this._insertHeaders = tmp == null || Boolean.parseBoolean(tmp);
        tmp = filterConfig.getInitParameter(TRACK_SESSIONS_INIT_PARAM);
        this._trackSessions = tmp == null || Boolean.parseBoolean(tmp);
        tmp = filterConfig.getInitParameter(REMOTE_PORT_INIT_PARAM);
        this._remotePort = tmp != null && Boolean.parseBoolean(tmp);
        this._requestTimeoutQ.setNow();
        this._requestTimeoutQ.setDuration(this._maxRequestMs);
        this._trackerTimeoutQ.setNow();
        this._trackerTimeoutQ.setDuration(this._maxIdleTrackerMs);
        this._running = true;
        this._timerThread = new Thread(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        this._timerThread.start();
        if (this._context != null && Boolean.parseBoolean(filterConfig.getInitParameter(MANAGED_ATTR_INIT_PARAM))) {
            this._context.setAttribute(filterConfig.getFilterName(), this);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterchain) throws IOException, ServletException {
        block28: {
            block27: {
                block29: {
                    block25: {
                        block26: {
                            srequest = (HttpServletRequest)request;
                            sresponse = (HttpServletResponse)response;
                            now = this._requestTimeoutQ.getNow();
                            tracker = (RateTracker)request.getAttribute("DoSFilter.Tracker");
                            if (tracker == null) {
                                tracker = this.getRateTracker(request);
                                overRateLimit = tracker.isRateExceeded(now);
                                if (!overRateLimit) {
                                    this.doFilterChain(filterchain, srequest, sresponse);
                                    return;
                                }
                                Log.warn("DOS ALERT: ip=" + srequest.getRemoteAddr() + ",session=" + srequest.getRequestedSessionId() + ",user=" + srequest.getUserPrincipal());
                                switch ((int)this._delayMs) {
                                    case -1: {
                                        if (this._insertHeaders) {
                                            ((HttpServletResponse)response).addHeader("DoSFilter", "unavailable");
                                        }
                                        ((HttpServletResponse)response).sendError(503);
                                        return;
                                    }
                                    case 0: {
                                        request.setAttribute("DoSFilter.Tracker", tracker);
                                        break;
                                    }
                                    default: {
                                        if (this._insertHeaders) {
                                            ((HttpServletResponse)response).addHeader("DoSFilter", "delayed");
                                        }
                                        continuation = ContinuationSupport.getContinuation(request);
                                        request.setAttribute("DoSFilter.Tracker", tracker);
                                        if (this._delayMs > 0L) {
                                            continuation.setTimeout(this._delayMs);
                                        }
                                        continuation.suspend();
                                        return;
                                    }
                                }
                            }
                            accepted = false;
                            accepted = this._passes.tryAcquire(this._maxWaitMs, TimeUnit.MILLISECONDS);
                            if (accepted) ** GOTO lbl63
                            continuation = ContinuationSupport.getContinuation(request);
                            throttled = (Boolean)request.getAttribute("DoSFilter.Throttled");
                            if (throttled == Boolean.TRUE || this._throttleMs <= 0L) break block25;
                            priority = this.getPriority(request, tracker);
                            request.setAttribute("DoSFilter.Throttled", Boolean.TRUE);
                            if (this._insertHeaders) {
                                ((HttpServletResponse)response).addHeader("DoSFilter", "throttled");
                            }
                            if (this._throttleMs > 0L) {
                                continuation.setTimeout(this._throttleMs);
                            }
                            continuation.suspend();
                            continuation.addContinuationListener(this._listener[priority]);
                            this._queue[priority].add(continuation);
                            if (!accepted) break block26;
                            p = this._queue.length;
                            while (p-- > 0) {
                                continuation = this._queue[p].poll();
                                if (continuation == null || !continuation.isSuspended()) continue;
                                continuation.resume();
                                break;
                            }
                            this._passes.release();
                        }
                        return;
                    }
                    try {
                        try {
                            if (request.getAttribute("javax.servlet.resumed") == Boolean.TRUE) {
                                this._passes.acquire();
                                accepted = true;
                            }
lbl63:
                            // 4 sources

                            if (accepted) {
                                this.doFilterChain(filterchain, srequest, sresponse);
                            } else {
                                if (this._insertHeaders) {
                                    ((HttpServletResponse)response).addHeader("DoSFilter", "unavailable");
                                }
                                ((HttpServletResponse)response).sendError(503);
                            }
                            break block27;
                        }
                        catch (InterruptedException e) {
                            this._context.log("DoS", e);
                            ((HttpServletResponse)response).sendError(503);
                            if (!accepted) break block28;
                            p = this._queue.length;
                            ** while (p-- > 0)
                        }
                    }
                    catch (Throwable var13_22) {
                        if (!accepted) break block29;
                        p = this._queue.length;
                        ** while (p-- > 0)
                    }
lbl-1000:
                    // 1 sources

                    {
                        continuation = this._queue[p].poll();
                        if (continuation == null || !continuation.isSuspended()) continue;
                        continuation.resume();
                        break;
                    }
lbl80:
                    // 2 sources

                    this._passes.release();
                    break block28;
lbl-1000:
                    // 1 sources

                    {
                        continuation = this._queue[p].poll();
                        if (continuation == null || !continuation.isSuspended()) continue;
                        continuation.resume();
                        break;
                    }
lbl90:
                    // 2 sources

                    this._passes.release();
                }
                throw var13_22;
            }
            if (accepted) {
                p = this._queue.length;
                while (p-- > 0) {
                    continuation = this._queue[p].poll();
                    if (continuation == null || !continuation.isSuspended()) continue;
                    continuation.resume();
                    break;
                }
                this._passes.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterChain(FilterChain chain, final HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException {
        final Thread thread = Thread.currentThread();
        Timeout.Task requestTimeout = new Timeout.Task(){

            @Override
            public void expired() {
                DoSFilter.this.closeConnection(request, response, thread);
            }
        };
        try {
            Timeout timeout = this._requestTimeoutQ;
            synchronized (timeout) {
                this._requestTimeoutQ.schedule(requestTimeout);
            }
            chain.doFilter(request, response);
        }
        catch (Throwable throwable) {
            Timeout timeout = this._requestTimeoutQ;
            synchronized (timeout) {
                requestTimeout.cancel();
            }
            throw throwable;
        }
        Timeout timeout = this._requestTimeoutQ;
        synchronized (timeout) {
            requestTimeout.cancel();
        }
    }

    protected void closeConnection(HttpServletRequest request, HttpServletResponse response, Thread thread) {
        if (!response.isCommitted()) {
            response.setHeader("Connection", "close");
        }
        try {
            try {
                response.getWriter().close();
            }
            catch (IllegalStateException e) {
                response.getOutputStream().close();
            }
        }
        catch (IOException e) {
            Log.warn(e);
        }
        thread.interrupt();
    }

    protected int getPriority(ServletRequest request, RateTracker tracker) {
        if (this.extractUserId(request) != null) {
            return 2;
        }
        if (tracker != null) {
            return tracker.getType();
        }
        return 0;
    }

    protected int getMaxPriority() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RateTracker getRateTracker(ServletRequest request) {
        int type;
        HttpServletRequest srequest = (HttpServletRequest)request;
        HttpSession session = srequest.getSession(false);
        String loadId = this.extractUserId(request);
        if (loadId != null) {
            type = 2;
        } else if (this._trackSessions && session != null && !session.isNew()) {
            loadId = session.getId();
            type = 2;
        } else {
            loadId = this._remotePort ? String.valueOf(request.getRemoteAddr()) + request.getRemotePort() : request.getRemoteAddr();
            type = 1;
        }
        RateTracker tracker = this._rateTrackers.get(loadId);
        if (tracker == null) {
            RateTracker t = this._whitelist.contains(request.getRemoteAddr()) ? new FixedRateTracker(loadId, type, this._maxRequestsPerSec) : new RateTracker(loadId, type, this._maxRequestsPerSec);
            tracker = this._rateTrackers.putIfAbsent(loadId, t);
            if (tracker == null) {
                tracker = t;
            }
            if (type == 1) {
                Timeout timeout = this._trackerTimeoutQ;
                synchronized (timeout) {
                    this._trackerTimeoutQ.schedule(tracker);
                }
            } else if (session != null) {
                session.setAttribute(__TRACKER, tracker);
            }
        }
        return tracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this._running = false;
        this._timerThread.interrupt();
        Timeout timeout = this._requestTimeoutQ;
        synchronized (timeout) {
            this._requestTimeoutQ.cancelAll();
        }
        timeout = this._trackerTimeoutQ;
        synchronized (timeout) {
            this._trackerTimeoutQ.cancelAll();
        }
        this._rateTrackers.clear();
        this._whitelist.clear();
    }

    protected String extractUserId(ServletRequest request) {
        return null;
    }

    protected void initWhitelist() {
        this._whitelist.clear();
        StringTokenizer tokenizer = new StringTokenizer(this._whitelistStr, ",");
        while (tokenizer.hasMoreTokens()) {
            this._whitelist.add(tokenizer.nextToken().trim());
        }
        Log.info("Whitelisted IP addresses: {}", this._whitelist.toString());
    }

    public int getMaxRequestsPerSec() {
        return this._maxRequestsPerSec;
    }

    public void setMaxRequestsPerSec(int value) {
        this._maxRequestsPerSec = value;
    }

    public long getDelayMs() {
        return this._delayMs;
    }

    public void setDelayMs(long value) {
        this._delayMs = value;
    }

    public long getMaxWaitMs() {
        return this._maxWaitMs;
    }

    public void setMaxWaitMs(long value) {
        this._maxWaitMs = value;
    }

    public int getThrottledRequests() {
        return this._throttledRequests;
    }

    public void setThrottledRequests(int value) {
        this._passes = new Semaphore(value - this._throttledRequests + this._passes.availablePermits(), true);
        this._throttledRequests = value;
    }

    public long getThrottleMs() {
        return this._throttleMs;
    }

    public void setThrottleMs(long value) {
        this._throttleMs = value;
    }

    public long getMaxRequestMs() {
        return this._maxRequestMs;
    }

    public void setMaxRequestMs(long value) {
        this._maxRequestMs = value;
    }

    public long getMaxIdleTrackerMs() {
        return this._maxIdleTrackerMs;
    }

    public void setMaxIdleTrackerMs(long value) {
        this._maxIdleTrackerMs = value;
    }

    public boolean isInsertHeaders() {
        return this._insertHeaders;
    }

    public void setInsertHeaders(boolean value) {
        this._insertHeaders = value;
    }

    public boolean isTrackSessions() {
        return this._trackSessions;
    }

    public void setTrackSessions(boolean value) {
        this._trackSessions = value;
    }

    public boolean isRemotePort() {
        return this._remotePort;
    }

    public void setRemotePort(boolean value) {
        this._remotePort = value;
    }

    public String getWhitelist() {
        return this._whitelistStr;
    }

    public void setWhitelist(String value) {
        this._whitelistStr = value;
        this.initWhitelist();
    }

    static /* synthetic */ boolean access$1(DoSFilter doSFilter) {
        return doSFilter._running;
    }

    static /* synthetic */ Timeout access$2(DoSFilter doSFilter) {
        return doSFilter._requestTimeoutQ;
    }

    class FixedRateTracker
    extends RateTracker {
        public FixedRateTracker(String id, int type, int numRecentRequestsTracked) {
            super(id, type, numRecentRequestsTracked);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isRateExceeded(long now) {
            FixedRateTracker fixedRateTracker = this;
            synchronized (fixedRateTracker) {
                this._timestamps[this._next] = now;
                this._next = (this._next + 1) % this._timestamps.length;
            }
            return false;
        }

        @Override
        public String toString() {
            return "Fixed" + super.toString();
        }
    }

    class RateTracker
    extends Timeout.Task
    implements HttpSessionBindingListener {
        protected final String _id;
        protected final int _type;
        protected final long[] _timestamps;
        protected int _next;

        public RateTracker(String id, int type, int maxRequestsPerSecond) {
            this._id = id;
            this._type = type;
            this._timestamps = new long[maxRequestsPerSecond];
            this._next = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isRateExceeded(long now) {
            long last;
            RateTracker rateTracker = this;
            synchronized (rateTracker) {
                last = this._timestamps[this._next];
                this._timestamps[this._next] = now;
                this._next = (this._next + 1) % this._timestamps.length;
            }
            boolean exceeded = last != 0L && now - last < 1000L;
            return exceeded;
        }

        public String getId() {
            return this._id;
        }

        public int getType() {
            return this._type;
        }

        @Override
        public void valueBound(HttpSessionBindingEvent event) {
        }

        @Override
        public void valueUnbound(HttpSessionBindingEvent event) {
            DoSFilter.this._rateTrackers.remove(this._id);
        }

        @Override
        public void expired() {
            boolean hasRecentRequest;
            long now = DoSFilter.this._trackerTimeoutQ.getNow();
            int latestIndex = this._next == 0 ? 3 : (this._next - 1) % this._timestamps.length;
            long last = this._timestamps[latestIndex];
            boolean bl = hasRecentRequest = last != 0L && now - last < 1000L;
            if (hasRecentRequest) {
                this.reschedule();
            } else {
                DoSFilter.this._rateTrackers.remove(this._id);
            }
        }

        public String toString() {
            return "RateTracker/" + this._id + "/" + this._type;
        }
    }
}

