/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import org.eclipse.jetty.util.LazyList;

public class MultiException
extends Exception {
    private Object nested;

    public MultiException() {
        super("Multiple exceptions");
    }

    public void add(Throwable e) {
        if (e instanceof MultiException) {
            MultiException me = (MultiException)e;
            int i = 0;
            while (i < LazyList.size(me.nested)) {
                this.nested = LazyList.add(this.nested, LazyList.get(me.nested, i));
                ++i;
            }
        } else {
            this.nested = LazyList.add(this.nested, e);
        }
    }

    public int size() {
        return LazyList.size(this.nested);
    }

    public List getThrowables() {
        return LazyList.getList(this.nested);
    }

    public Throwable getThrowable(int i) {
        return (Throwable)LazyList.get(this.nested, i);
    }

    public void ifExceptionThrow() throws Exception {
        switch (LazyList.size(this.nested)) {
            case 0: {
                break;
            }
            case 1: {
                Throwable th = (Throwable)LazyList.get(this.nested, 0);
                if (th instanceof Error) {
                    throw (Error)th;
                }
                if (th instanceof Exception) {
                    throw (Exception)th;
                }
            }
            default: {
                throw this;
            }
        }
    }

    public void ifExceptionThrowRuntime() throws Error {
        switch (LazyList.size(this.nested)) {
            case 0: {
                break;
            }
            case 1: {
                Throwable th = (Throwable)LazyList.get(this.nested, 0);
                if (th instanceof Error) {
                    throw (Error)th;
                }
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
                throw new RuntimeException(th);
            }
            default: {
                throw new RuntimeException(this);
            }
        }
    }

    public void ifExceptionThrowMulti() throws MultiException {
        if (LazyList.size(this.nested) > 0) {
            throw this;
        }
    }

    @Override
    public String toString() {
        if (LazyList.size(this.nested) > 0) {
            return String.valueOf(MultiException.class.getSimpleName()) + LazyList.getList(this.nested);
        }
        return String.valueOf(MultiException.class.getSimpleName()) + "[]";
    }

    @Override
    public void printStackTrace() {
        super.printStackTrace();
        int i = 0;
        while (i < LazyList.size(this.nested)) {
            ((Throwable)LazyList.get(this.nested, i)).printStackTrace();
            ++i;
        }
    }

    @Override
    public void printStackTrace(PrintStream out) {
        super.printStackTrace(out);
        int i = 0;
        while (i < LazyList.size(this.nested)) {
            ((Throwable)LazyList.get(this.nested, i)).printStackTrace(out);
            ++i;
        }
    }

    @Override
    public void printStackTrace(PrintWriter out) {
        super.printStackTrace(out);
        int i = 0;
        while (i < LazyList.size(this.nested)) {
            ((Throwable)LazyList.get(this.nested, i)).printStackTrace(out);
            ++i;
        }
    }
}

