/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;

public class StringUtil {
    public static final String ALL_INTERFACES = "0.0.0.0";
    public static final String CRLF = "\r\n";
    public static final String __LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    public static final String __ISO_8859_1 = "ISO-8859-1";
    public static final String __UTF8 = "UTF-8";
    public static final String __UTF8Alt = "UTF8";
    public static final String __UTF16 = "UTF-16";
    public static final Charset __UTF8_CHARSET = Charset.forName("UTF-8");
    public static final Charset __ISO_8859_1_CHARSET = Charset.forName("ISO-8859-1");
    private static char[] lowercases;

    static {
        char[] cArray = new char[128];
        cArray[1] = '\u0001';
        cArray[2] = 2;
        cArray[3] = 3;
        cArray[4] = 4;
        cArray[5] = 5;
        cArray[6] = 6;
        cArray[7] = 7;
        cArray[8] = 8;
        cArray[9] = 9;
        cArray[10] = 10;
        cArray[11] = 11;
        cArray[12] = 12;
        cArray[13] = 13;
        cArray[14] = 14;
        cArray[15] = 15;
        cArray[16] = 16;
        cArray[17] = 17;
        cArray[18] = 18;
        cArray[19] = 19;
        cArray[20] = 20;
        cArray[21] = 21;
        cArray[22] = 22;
        cArray[23] = 23;
        cArray[24] = 24;
        cArray[25] = 25;
        cArray[26] = 26;
        cArray[27] = 27;
        cArray[28] = 28;
        cArray[29] = 29;
        cArray[30] = 30;
        cArray[31] = 31;
        cArray[32] = 32;
        cArray[33] = 33;
        cArray[34] = 34;
        cArray[35] = 35;
        cArray[36] = 36;
        cArray[37] = 37;
        cArray[38] = 38;
        cArray[39] = 39;
        cArray[40] = 40;
        cArray[41] = 41;
        cArray[42] = 42;
        cArray[43] = 43;
        cArray[44] = 44;
        cArray[45] = 45;
        cArray[46] = 46;
        cArray[47] = 47;
        cArray[48] = 48;
        cArray[49] = 49;
        cArray[50] = 50;
        cArray[51] = 51;
        cArray[52] = 52;
        cArray[53] = 53;
        cArray[54] = 54;
        cArray[55] = 55;
        cArray[56] = 56;
        cArray[57] = 57;
        cArray[58] = 58;
        cArray[59] = 59;
        cArray[60] = 60;
        cArray[61] = 61;
        cArray[62] = 62;
        cArray[63] = 63;
        cArray[64] = 64;
        cArray[65] = 97;
        cArray[66] = 98;
        cArray[67] = 99;
        cArray[68] = 100;
        cArray[69] = 101;
        cArray[70] = 102;
        cArray[71] = 103;
        cArray[72] = 104;
        cArray[73] = 105;
        cArray[74] = 106;
        cArray[75] = 107;
        cArray[76] = 108;
        cArray[77] = 109;
        cArray[78] = 110;
        cArray[79] = 111;
        cArray[80] = 112;
        cArray[81] = 113;
        cArray[82] = 114;
        cArray[83] = 115;
        cArray[84] = 116;
        cArray[85] = 117;
        cArray[86] = 118;
        cArray[87] = 119;
        cArray[88] = 120;
        cArray[89] = 121;
        cArray[90] = 122;
        cArray[91] = 91;
        cArray[92] = 92;
        cArray[93] = 93;
        cArray[94] = 94;
        cArray[95] = 95;
        cArray[96] = 96;
        cArray[97] = 97;
        cArray[98] = 98;
        cArray[99] = 99;
        cArray[100] = 100;
        cArray[101] = 101;
        cArray[102] = 102;
        cArray[103] = 103;
        cArray[104] = 104;
        cArray[105] = 105;
        cArray[106] = 106;
        cArray[107] = 107;
        cArray[108] = 108;
        cArray[109] = 109;
        cArray[110] = 110;
        cArray[111] = 111;
        cArray[112] = 112;
        cArray[113] = 113;
        cArray[114] = 114;
        cArray[115] = 115;
        cArray[116] = 116;
        cArray[117] = 117;
        cArray[118] = 118;
        cArray[119] = 119;
        cArray[120] = 120;
        cArray[121] = 121;
        cArray[122] = 122;
        cArray[123] = 123;
        cArray[124] = 124;
        cArray[125] = 125;
        cArray[126] = 126;
        cArray[127] = 127;
        lowercases = cArray;
    }

    public static String asciiToLowerCase(String s) {
        char[] c = null;
        int i = s.length();
        while (i-- > 0) {
            char c2;
            char c1 = s.charAt(i);
            if (c1 > '\u007f' || c1 == (c2 = lowercases[c1])) continue;
            c = s.toCharArray();
            c[i] = c2;
            break;
        }
        while (i-- > 0) {
            if (c[i] > '\u007f') continue;
            c[i] = lowercases[c[i]];
        }
        return c == null ? s : new String(c);
    }

    public static boolean startsWithIgnoreCase(String s, String w) {
        if (w == null) {
            return true;
        }
        if (s == null || s.length() < w.length()) {
            return false;
        }
        int i = 0;
        while (i < w.length()) {
            char c2;
            char c1 = s.charAt(i);
            if (c1 != (c2 = w.charAt(i))) {
                if (c1 <= '\u007f') {
                    c1 = lowercases[c1];
                }
                if (c2 <= '\u007f') {
                    c2 = lowercases[c2];
                }
                if (c1 != c2) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean endsWithIgnoreCase(String s, String w) {
        int wl;
        if (w == null) {
            return true;
        }
        if (s == null) {
            return false;
        }
        int sl = s.length();
        if (sl < (wl = w.length())) {
            return false;
        }
        int i = wl;
        while (i-- > 0) {
            char c2;
            char c1;
            if ((c1 = s.charAt(--sl)) == (c2 = w.charAt(i))) continue;
            if (c1 <= '\u007f') {
                c1 = lowercases[c1];
            }
            if (c2 <= '\u007f') {
                c2 = lowercases[c2];
            }
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }

    public static int indexFrom(String s, String chars) {
        int i = 0;
        while (i < s.length()) {
            if (chars.indexOf(s.charAt(i)) >= 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String replace(String s, String sub, String with) {
        int c = 0;
        int i = s.indexOf(sub, c);
        if (i == -1) {
            return s;
        }
        StringBuilder buf = new StringBuilder(s.length() + with.length());
        do {
            buf.append(s.substring(c, i));
            buf.append(with);
        } while ((i = s.indexOf(sub, c = i + sub.length())) != -1);
        if (c < s.length()) {
            buf.append(s.substring(c, s.length()));
        }
        return buf.toString();
    }

    public static String unquote(String s) {
        return QuotedStringTokenizer.unquote(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(StringBuilder buf, String s, int offset, int length) {
        StringBuilder stringBuilder = buf;
        synchronized (stringBuilder) {
            int end = offset + length;
            int i = offset;
            while (i < end) {
                if (i >= s.length()) break;
                buf.append(s.charAt(i));
                ++i;
            }
        }
    }

    public static void append(StringBuilder buf, byte b, int base) {
        int bi = 0xFF & b;
        int c = 48 + bi / base % base;
        if (c > 57) {
            c = 97 + (c - 48 - 10);
        }
        buf.append((char)c);
        c = 48 + bi % base;
        if (c > 57) {
            c = 97 + (c - 48 - 10);
        }
        buf.append((char)c);
    }

    public static void append2digits(StringBuffer buf, int i) {
        if (i < 100) {
            buf.append((char)(i / 10 + 48));
            buf.append((char)(i % 10 + 48));
        }
    }

    public static void append2digits(StringBuilder buf, int i) {
        if (i < 100) {
            buf.append((char)(i / 10 + 48));
            buf.append((char)(i % 10 + 48));
        }
    }

    public static String nonNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public static boolean equals(String s, char[] buf, int offset, int length) {
        if (s.length() != length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (buf[offset + i] != s.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String toUTF8String(byte[] b, int offset, int length) {
        try {
            return new String(b, offset, length, __UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toString(byte[] b, int offset, int length, String charset) {
        try {
            return new String(b, offset, length, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean isUTF8(String charset) {
        return charset == __UTF8 || __UTF8.equalsIgnoreCase(charset) || __UTF8Alt.equalsIgnoreCase(charset);
    }

    public static String printable(String name) {
        if (name == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(name.length());
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (!Character.isISOControl(c)) {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    public static String printable(byte[] b) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < b.length) {
            char c = (char)b[i];
            if (Character.isWhitespace(c) || c > ' ' && c < '\u007f') {
                buf.append(c);
            } else {
                buf.append("0x");
                TypeUtil.toHex(b[i], buf);
            }
            ++i;
        }
        return buf.toString();
    }

    public static byte[] getBytes(String s) {
        try {
            return s.getBytes(__ISO_8859_1);
        }
        catch (Exception e) {
            Log.warn(e);
            return s.getBytes();
        }
    }

    public static byte[] getBytes(String s, String charset) {
        try {
            return s.getBytes(charset);
        }
        catch (Exception e) {
            Log.warn(e);
            return s.getBytes();
        }
    }

    public static String sidBytesToString(byte[] sidBytes) {
        StringBuilder sidString = new StringBuilder();
        sidString.append("S-");
        sidString.append(Byte.toString(sidBytes[0])).append('-');
        StringBuilder tmpBuilder = new StringBuilder();
        int i = 2;
        while (i <= 7) {
            tmpBuilder.append(Integer.toHexString(sidBytes[i] & 0xFF));
            ++i;
        }
        sidString.append(Long.parseLong(tmpBuilder.toString(), 16));
        int subAuthorityCount = sidBytes[1];
        int i2 = 0;
        while (i2 < subAuthorityCount) {
            int offset = i2 * 4;
            tmpBuilder.setLength(0);
            tmpBuilder.append(String.format("%02X%02X%02X%02X", sidBytes[11 + offset] & 0xFF, sidBytes[10 + offset] & 0xFF, sidBytes[9 + offset] & 0xFF, sidBytes[8 + offset] & 0xFF));
            sidString.append('-').append(Long.parseLong(tmpBuilder.toString(), 16));
            ++i2;
        }
        return sidString.toString();
    }

    public static byte[] sidStringToBytes(String sidString) {
        String[] sidTokens = sidString.split("-");
        int subAuthorityCount = sidTokens.length - 3;
        int byteCount = 0;
        byte[] sidBytes = new byte[8 + 4 * subAuthorityCount];
        sidBytes[byteCount++] = (byte)Integer.parseInt(sidTokens[1]);
        sidBytes[byteCount++] = (byte)subAuthorityCount;
        String hexStr = Long.toHexString(Long.parseLong(sidTokens[2]));
        while (hexStr.length() < 12) {
            hexStr = "0" + hexStr;
        }
        int i = 0;
        while (i < hexStr.length()) {
            sidBytes[byteCount++] = (byte)Integer.parseInt(hexStr.substring(i, i + 2), 16);
            i += 2;
        }
        i = 3;
        while (i < sidTokens.length) {
            hexStr = Long.toHexString(Long.parseLong(sidTokens[i]));
            while (hexStr.length() < 8) {
                hexStr = "0" + hexStr;
            }
            int j = hexStr.length();
            while (j > 0) {
                sidBytes[byteCount++] = (byte)Integer.parseInt(hexStr.substring(j - 2, j), 16);
                j -= 2;
            }
            ++i;
        }
        return sidBytes;
    }
}

