/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;

public abstract class Utf8Appendable {
    protected final Appendable _appendable;
    protected int _more;
    protected int _bits;

    public Utf8Appendable(Appendable appendable) {
        this._appendable = appendable;
    }

    public abstract int length();

    public void append(byte b) {
        try {
            this.appendByte(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void append(byte[] b, int offset, int length) {
        try {
            int end = offset + length;
            int i = offset;
            while (i < end) {
                this.appendByte(b[i]);
                ++i;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean append(byte[] b, int offset, int length, int maxChars) {
        try {
            int end = offset + length;
            int i = offset;
            while (true) {
                if (i >= end) {
                    return true;
                }
                if (this.length() > maxChars) {
                    return false;
                }
                this.appendByte(b[i]);
                ++i;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void appendByte(byte b) throws IOException {
        if (b >= 0) {
            if (this._more > 0) {
                this._appendable.append('?');
                this._more = 0;
                this._bits = 0;
                return;
            } else {
                this._appendable.append((char)(0x7F & b));
            }
            return;
        } else if (this._more == 0) {
            if ((b & 0xC0) != 192) {
                this._appendable.append('?');
                this._more = 0;
                this._bits = 0;
                return;
            } else if ((b & 0xE0) == 192) {
                this._more = 1;
                this._bits = b & 0x1F;
                return;
            } else if ((b & 0xF0) == 224) {
                this._more = 2;
                this._bits = b & 0xF;
                return;
            } else if ((b & 0xF8) == 240) {
                this._more = 3;
                this._bits = b & 7;
                return;
            } else if ((b & 0xFC) == 248) {
                this._more = 4;
                this._bits = b & 3;
                return;
            } else {
                if ((b & 0xFE) != 252) throw new IllegalArgumentException("!utf8");
                this._more = 5;
                this._bits = b & 1;
            }
            return;
        } else {
            if ((b & 0xC0) == 192) {
                this._appendable.append('?');
                this._more = 0;
                this._bits = 0;
                throw new IllegalArgumentException("!utf8");
            }
            this._bits = this._bits << 6 | b & 0x3F;
            if (--this._more != 0) return;
            this._appendable.append(new String(Character.toChars(this._bits)));
        }
    }
}

