/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import java.util.EventListener;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.log.Log;

public class Container {
    private final CopyOnWriteArrayList<Listener> _listeners = new CopyOnWriteArrayList();

    public void addEventListener(Listener listener) {
        this._listeners.add(listener);
    }

    public void removeEventListener(Listener listener) {
        this._listeners.remove(listener);
    }

    public void update(Object parent, Object oldChild, Object child, String relationship) {
        if (oldChild != null && !oldChild.equals(child)) {
            this.remove(parent, oldChild, relationship);
        }
        if (child != null && !child.equals(oldChild)) {
            this.add(parent, child, relationship);
        }
    }

    public void update(Object parent, Object oldChild, Object child, String relationship, boolean addRemove) {
        if (oldChild != null && !oldChild.equals(child)) {
            this.remove(parent, oldChild, relationship);
            if (addRemove) {
                this.removeBean(oldChild);
            }
        }
        if (child != null && !child.equals(oldChild)) {
            if (addRemove) {
                this.addBean(child);
            }
            this.add(parent, child, relationship);
        }
    }

    public void update(Object parent, Object[] oldChildren, Object[] children, String relationship) {
        this.update(parent, oldChildren, children, relationship, false);
    }

    public void update(Object parent, Object[] oldChildren, Object[] children, String relationship, boolean addRemove) {
        int i;
        Object[] newChildren = null;
        if (children != null) {
            newChildren = new Object[children.length];
            i = children.length;
            while (i-- > 0) {
                boolean new_child = true;
                if (oldChildren != null) {
                    int j = oldChildren.length;
                    while (j-- > 0) {
                        if (children[i] == null || !children[i].equals(oldChildren[j])) continue;
                        oldChildren[j] = null;
                        new_child = false;
                    }
                }
                if (!new_child) continue;
                newChildren[i] = children[i];
            }
        }
        if (oldChildren != null) {
            i = oldChildren.length;
            while (i-- > 0) {
                if (oldChildren[i] == null) continue;
                this.remove(parent, oldChildren[i], relationship);
                if (!addRemove) continue;
                this.removeBean(oldChildren[i]);
            }
        }
        if (newChildren != null) {
            i = 0;
            while (i < newChildren.length) {
                if (newChildren[i] != null) {
                    if (addRemove) {
                        this.addBean(newChildren[i]);
                    }
                    this.add(parent, newChildren[i], relationship);
                }
                ++i;
            }
        }
    }

    public void addBean(Object obj) {
        if (this._listeners != null) {
            int i = 0;
            while (i < LazyList.size(this._listeners)) {
                Listener listener = (Listener)LazyList.get(this._listeners, i);
                listener.addBean(obj);
                ++i;
            }
        }
    }

    public void removeBean(Object obj) {
        if (this._listeners != null) {
            int i = 0;
            while (i < LazyList.size(this._listeners)) {
                ((Listener)LazyList.get(this._listeners, i)).removeBean(obj);
                ++i;
            }
        }
    }

    private void add(Object parent, Object child, String relationship) {
        if (Log.isDebugEnabled()) {
            Log.debug("Container " + parent + " + " + child + " as " + relationship);
        }
        if (this._listeners != null) {
            Relationship event = new Relationship(this, parent, child, relationship);
            int i = 0;
            while (i < LazyList.size(this._listeners)) {
                ((Listener)LazyList.get(this._listeners, i)).add(event);
                ++i;
            }
        }
    }

    private void remove(Object parent, Object child, String relationship) {
        if (Log.isDebugEnabled()) {
            Log.debug("Container " + parent + " - " + child + " as " + relationship);
        }
        if (this._listeners != null) {
            Relationship event = new Relationship(this, parent, child, relationship);
            int i = 0;
            while (i < LazyList.size(this._listeners)) {
                ((Listener)LazyList.get(this._listeners, i)).remove(event);
                ++i;
            }
        }
    }

    public static interface Listener
    extends EventListener {
        public void addBean(Object var1);

        public void removeBean(Object var1);

        public void add(Relationship var1);

        public void remove(Relationship var1);
    }

    public static class Relationship {
        private Object _parent;
        private Object _child;
        private String _relationship;
        private Container _container;

        private Relationship(Container container, Object parent, Object child, String relationship) {
            this._container = container;
            this._parent = parent;
            this._child = child;
            this._relationship = relationship;
        }

        public Container getContainer() {
            return this._container;
        }

        public Object getChild() {
            return this._child;
        }

        public Object getParent() {
            return this._parent;
        }

        public String getRelationship() {
            return this._relationship;
        }

        public String toString() {
            return this._parent + "---" + this._relationship + "-->" + this._child;
        }

        public int hashCode() {
            return this._parent.hashCode() + this._child.hashCode() + this._relationship.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Relationship)) {
                return false;
            }
            Relationship r = (Relationship)o;
            return r._parent == this._parent && r._child == this._child && r._relationship.equals(this._relationship);
        }
    }
}

