/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.log;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.log.LoggerLog;
import org.eclipse.jetty.util.log.StdErrLog;

public class Log {
    public static final String EXCEPTION = "EXCEPTION ";
    public static final String IGNORED = "IGNORED";
    public static String __logClass;
    public static boolean __ignored;
    private static Logger __log;
    private static boolean __initialized;

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                __logClass = System.getProperty("org.eclipse.jetty.util.log.class", "org.eclipse.jetty.util.log.Slf4jLog");
                __ignored = Boolean.parseBoolean(System.getProperty("org.eclipse.jetty.util.log.IGNORED", "false"));
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean initialized() {
        if (__log != null) {
            return true;
        }
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            if (__initialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return __log != null;
            }
            __initialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            try {
                Class log_class = Loader.loadClass(Log.class, __logClass);
                if (__log == null || !__log.getClass().equals(log_class)) {
                    __log = (Logger)log_class.newInstance();
                    __log.debug("Logging to {} via {}", __log, log_class.getName());
                }
            }
            catch (NoClassDefFoundError e) {
                Log.initStandardLogging(e);
            }
            catch (Exception e) {
                Log.initStandardLogging(e);
            }
            return __log != null;
        }
    }

    private static void initStandardLogging(Throwable e) {
        if (e != null && __ignored) {
            e.printStackTrace();
        }
        if (__log == null) {
            Class<StdErrLog> log_class = StdErrLog.class;
            __log = new StdErrLog();
            __log.debug("Logging to {} via {}", __log, log_class.getName());
        }
    }

    public static void setLog(Logger log) {
        __log = log;
    }

    public static Logger getLog() {
        Log.initialized();
        return __log;
    }

    static boolean isIgnored() {
        return __ignored;
    }

    public static void setLogToParent(String name) {
        ClassLoader loader = Log.class.getClassLoader();
        if (loader.getParent() != null) {
            try {
                Class<?> uberlog = loader.getParent().loadClass("org.eclipse.jetty.util.log.Log");
                Method getLogger = uberlog.getMethod("getLogger", String.class);
                Object logger = getLogger.invoke(null, name);
                Log.setLog(new LoggerLog(logger));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Log.setLog(Log.getLogger(name));
        }
    }

    public static void debug(Throwable th) {
        if (!Log.isDebugEnabled()) {
            return;
        }
        __log.debug(EXCEPTION, th);
    }

    public static void debug(String msg) {
        if (!Log.initialized()) {
            return;
        }
        __log.debug(msg, new Object[0]);
    }

    public static void debug(String msg, Object arg) {
        if (!Log.initialized()) {
            return;
        }
        __log.debug(msg, arg);
    }

    public static void debug(String msg, Object arg0, Object arg1) {
        if (!Log.initialized()) {
            return;
        }
        __log.debug(msg, arg0, arg1);
    }

    public static void ignore(Throwable thrown) {
        if (!Log.initialized()) {
            return;
        }
        if (__ignored) {
            __log.warn(IGNORED, thrown);
        }
    }

    public static void info(String msg) {
        if (!Log.initialized()) {
            return;
        }
        __log.info(msg, new Object[0]);
    }

    public static void info(String msg, Object arg) {
        if (!Log.initialized()) {
            return;
        }
        __log.info(msg, arg);
    }

    public static void info(String msg, Object arg0, Object arg1) {
        if (!Log.initialized()) {
            return;
        }
        __log.info(msg, arg0, arg1);
    }

    public static boolean isDebugEnabled() {
        if (!Log.initialized()) {
            return false;
        }
        return __log.isDebugEnabled();
    }

    public static void warn(String msg) {
        if (!Log.initialized()) {
            return;
        }
        __log.warn(msg, new Object[0]);
    }

    public static void warn(String msg, Object arg) {
        if (!Log.initialized()) {
            return;
        }
        __log.warn(msg, arg);
    }

    public static void warn(String msg, Object arg0, Object arg1) {
        if (!Log.initialized()) {
            return;
        }
        __log.warn(msg, arg0, arg1);
    }

    public static void warn(String msg, Throwable th) {
        if (!Log.initialized()) {
            return;
        }
        __log.warn(msg, th);
    }

    public static void warn(Throwable th) {
        if (!Log.initialized()) {
            return;
        }
        __log.warn(EXCEPTION, th);
    }

    public static Logger getLogger(String name) {
        if (!Log.initialized()) {
            return null;
        }
        return name == null ? __log : __log.getLogger(name);
    }
}

