/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.ThreadPool;

public class QueuedThreadPool
extends AbstractLifeCycle
implements ThreadPool.SizedThreadPool,
Executor,
Dumpable {
    private final AtomicInteger _threadsStarted = new AtomicInteger();
    private final AtomicInteger _threadsIdle = new AtomicInteger();
    private final AtomicLong _lastShrink = new AtomicLong();
    private final ConcurrentLinkedQueue<Thread> _threads = new ConcurrentLinkedQueue();
    private final Object _joinLock = new Object();
    private BlockingQueue<Runnable> _jobs;
    private String _name;
    private int _maxIdleTimeMs = 60000;
    private int _maxThreads = 254;
    private int _minThreads = 8;
    private int _maxQueued = -1;
    private int _priority = 5;
    private boolean _daemon = false;
    private int _maxStopTime = 100;
    private boolean _detailedDump = false;
    private Runnable _runnable = new Runnable(){

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 13[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    };

    public QueuedThreadPool() {
        this._name = "qtp" + super.hashCode();
    }

    public QueuedThreadPool(int maxThreads) {
        this();
        this.setMaxThreads(maxThreads);
    }

    public QueuedThreadPool(BlockingQueue<Runnable> jobQ) {
        this();
        this._jobs = jobQ;
        this._jobs.clear();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this._threadsStarted.set(0);
        if (this._jobs == null) {
            this._jobs = this._maxQueued > 0 ? new ArrayBlockingQueue(this._maxQueued) : new BlockingArrayQueue(this._minThreads, this._minThreads);
        }
        int threads = this._threadsStarted.get();
        while (this.isRunning() && threads < this._minThreads) {
            this.startThread(threads);
            threads = this._threadsStarted.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws Exception {
        super.doStop();
        long start = System.currentTimeMillis();
        while (this._threadsStarted.get() > 0 && System.currentTimeMillis() - start < (long)(this._maxStopTime / 2)) {
            Thread.sleep(1L);
        }
        this._jobs.clear();
        Runnable noop = new Runnable(){

            @Override
            public void run() {
            }
        };
        int i = this._threadsIdle.get();
        while (i-- > 0) {
            this._jobs.offer(noop);
        }
        Thread.yield();
        if (this._threadsStarted.get() > 0) {
            for (Thread thread : this._threads) {
                thread.interrupt();
            }
        }
        while (this._threadsStarted.get() > 0 && System.currentTimeMillis() - start < (long)this._maxStopTime) {
            Thread.sleep(1L);
        }
        Thread.yield();
        int size = this._threads.size();
        if (size > 0) {
            Log.warn(String.valueOf(size) + " threads could not be stopped");
            if (Log.isDebugEnabled()) {
                for (Thread unstopped : this._threads) {
                    Log.debug("Couldn't stop " + unstopped);
                    StackTraceElement[] stackTraceElementArray = unstopped.getStackTrace();
                    int n = stackTraceElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StackTraceElement element = stackTraceElementArray[n2];
                        Log.debug(" at " + element);
                        ++n2;
                    }
                }
            }
        }
        Object object = this._joinLock;
        synchronized (object) {
            this._joinLock.notifyAll();
        }
    }

    public void setDaemon(boolean daemon) {
        this._daemon = daemon;
    }

    public void setMaxIdleTimeMs(int maxIdleTimeMs) {
        this._maxIdleTimeMs = maxIdleTimeMs;
    }

    public void setMaxStopTimeMs(int stopTimeMs) {
        this._maxStopTime = stopTimeMs;
    }

    @Override
    public void setMaxThreads(int maxThreads) {
        this._maxThreads = maxThreads;
        if (this._minThreads > this._maxThreads) {
            this._minThreads = this._maxThreads;
        }
    }

    @Override
    public void setMinThreads(int minThreads) {
        this._minThreads = minThreads;
        if (this._minThreads > this._maxThreads) {
            this._maxThreads = this._minThreads;
        }
        int threads = this._threadsStarted.get();
        while (this.isStarted() && threads < this._minThreads) {
            this.startThread(threads);
            threads = this._threadsStarted.get();
        }
    }

    public void setName(String name) {
        if (this.isRunning()) {
            throw new IllegalStateException("started");
        }
        this._name = name;
    }

    public void setThreadsPriority(int priority) {
        this._priority = priority;
    }

    public int getMaxQueued() {
        return this._maxQueued;
    }

    public void setMaxQueued(int max) {
        if (this.isRunning()) {
            throw new IllegalStateException("started");
        }
        this._maxQueued = max;
    }

    public int getMaxIdleTimeMs() {
        return this._maxIdleTimeMs;
    }

    public int getMaxStopTimeMs() {
        return this._maxStopTime;
    }

    @Override
    public int getMaxThreads() {
        return this._maxThreads;
    }

    @Override
    public int getMinThreads() {
        return this._minThreads;
    }

    public String getName() {
        return this._name;
    }

    public int getThreadsPriority() {
        return this._priority;
    }

    public boolean isDaemon() {
        return this._daemon;
    }

    public boolean isDetailedDump() {
        return this._detailedDump;
    }

    public void setDetailedDump(boolean detailedDump) {
        this._detailedDump = detailedDump;
    }

    @Override
    public boolean dispatch(Runnable job) {
        if (this.isRunning()) {
            int jobQ = this._jobs.size();
            int idle = this.getIdleThreads();
            if (this._jobs.offer(job)) {
                int threads;
                if ((idle == 0 || jobQ > idle) && (threads = this._threadsStarted.get()) < this._maxThreads) {
                    this.startThread(threads);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void execute(Runnable job) {
        if (!this.dispatch(job)) {
            throw new RejectedExecutionException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void join() throws InterruptedException {
        var1_1 = this._joinLock;
        synchronized (var1_1) {
            while (this.isRunning()) {
                this._joinLock.wait();
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
            if (true) ** GOTO lbl13
        }
        do {
            Thread.sleep(1L);
lbl13:
            // 2 sources

        } while (this.isStopping());
    }

    @Override
    public int getThreads() {
        return this._threadsStarted.get();
    }

    @Override
    public int getIdleThreads() {
        return this._threadsIdle.get();
    }

    @Override
    public boolean isLowOnThreads() {
        return this._threadsStarted.get() == this._maxThreads && this._jobs.size() >= this._threadsIdle.get();
    }

    private boolean startThread(int threads) {
        int next = threads + 1;
        if (!this._threadsStarted.compareAndSet(threads, next)) {
            return false;
        }
        boolean started = false;
        try {
            Thread thread = this.newThread(this._runnable);
            thread.setDaemon(this._daemon);
            thread.setPriority(this._priority);
            thread.setName(String.valueOf(this._name) + "-" + thread.getId());
            this._threads.add(thread);
            thread.start();
            started = true;
        }
        finally {
            if (!started) {
                this._threadsStarted.decrementAndGet();
            }
        }
        return started;
    }

    protected Thread newThread(Runnable runnable) {
        return new Thread(runnable);
    }

    @Override
    public String dump() {
        return AggregateLifeCycle.dump(this);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        ArrayList<Object> dump = new ArrayList<Object>(this.getMaxThreads());
        for (final Thread thread : this._threads) {
            final StackTraceElement[] trace = thread.getStackTrace();
            boolean inIdleJobPoll = false;
            StackTraceElement[] stackTraceElementArray = trace;
            int n = trace.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement t = stackTraceElementArray[n2];
                if ("idleJobPoll".equals(t.getMethodName())) {
                    inIdleJobPoll = true;
                    break;
                }
                ++n2;
            }
            final boolean idle = inIdleJobPoll;
            if (this._detailedDump) {
                dump.add(new Dumpable(){

                    @Override
                    public void dump(Appendable out, String indent) throws IOException {
                        out.append(String.valueOf(thread.getId())).append(' ').append(thread.getName()).append(' ').append(thread.getState().toString()).append(idle ? " IDLE" : "").append('\n');
                        if (!idle) {
                            AggregateLifeCycle.dump(out, indent, Arrays.asList(trace));
                        }
                    }

                    @Override
                    public String dump() {
                        return null;
                    }
                });
                continue;
            }
            dump.add(String.valueOf(thread.getId()) + " " + thread.getName() + " " + (Object)((Object)thread.getState()) + " @ " + (trace.length > 0 ? trace[0] : "???") + (idle ? " IDLE" : ""));
        }
        out.append(String.valueOf(this)).append("\n");
        AggregateLifeCycle.dump(out, indent, dump);
    }

    public String toString() {
        return String.valueOf(this._name) + "{" + this.getMinThreads() + "<=" + this.getIdleThreads() + "<=" + this.getThreads() + "/" + this.getMaxThreads() + "," + (this._jobs == null ? -1 : this._jobs.size()) + "}";
    }

    private Runnable idleJobPoll() throws InterruptedException {
        return this._jobs.poll(this._maxIdleTimeMs, TimeUnit.MILLISECONDS);
    }

    public boolean stopThread(long id) {
        for (Thread thread : this._threads) {
            if (thread.getId() != id) continue;
            thread.stop();
            return true;
        }
        return false;
    }

    public boolean interruptThread(long id) {
        for (Thread thread : this._threads) {
            if (thread.getId() != id) continue;
            thread.interrupt();
            return true;
        }
        return false;
    }

    public String dumpThread(long id) {
        for (Thread thread : this._threads) {
            if (thread.getId() != id) continue;
            StringBuilder buf = new StringBuilder();
            buf.append(thread.getId()).append(" ").append(thread.getName()).append(" ").append((Object)thread.getState()).append(":\n");
            StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement element = stackTraceElementArray[n2];
                buf.append("  at ").append(element.toString()).append('\n');
                ++n2;
            }
            return buf.toString();
        }
        return null;
    }

    static /* synthetic */ AtomicInteger access$0(QueuedThreadPool queuedThreadPool) {
        return queuedThreadPool._threadsStarted;
    }

    static /* synthetic */ ConcurrentLinkedQueue access$1(QueuedThreadPool queuedThreadPool) {
        return queuedThreadPool._threads;
    }

    static /* synthetic */ BlockingQueue access$2(QueuedThreadPool queuedThreadPool) {
        return queuedThreadPool._jobs;
    }

    static /* synthetic */ AtomicInteger access$3(QueuedThreadPool queuedThreadPool) {
        return queuedThreadPool._threadsIdle;
    }

    static /* synthetic */ int access$4(QueuedThreadPool queuedThreadPool) {
        return queuedThreadPool._maxIdleTimeMs;
    }

    static /* synthetic */ int access$5(QueuedThreadPool queuedThreadPool) {
        return queuedThreadPool._minThreads;
    }

    static /* synthetic */ AtomicLong access$6(QueuedThreadPool queuedThreadPool) {
        return queuedThreadPool._lastShrink;
    }

    static /* synthetic */ Runnable access$7(QueuedThreadPool queuedThreadPool) throws InterruptedException {
        return queuedThreadPool.idleJobPoll();
    }
}

