/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;
import org.eclipse.jetty.util.PatternMatcher;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;

public abstract class JarScanner
extends PatternMatcher {
    public abstract void processEntry(URI var1, JarEntry var2);

    public void scan(Pattern pattern, URI[] uris, boolean isNullInclusive) throws Exception {
        super.match(pattern, uris, isNullInclusive);
    }

    public void scan(Pattern pattern, ClassLoader loader, boolean isNullInclusive, boolean visitParent) throws Exception {
        while (loader != null) {
            URL[] urls;
            if (loader instanceof URLClassLoader && (urls = ((URLClassLoader)loader).getURLs()) != null) {
                URI[] uris = new URI[urls.length];
                int i = 0;
                URL[] uRLArray = urls;
                int n = urls.length;
                int n2 = 0;
                while (n2 < n) {
                    URL u = uRLArray[n2];
                    uris[i++] = u.toURI();
                    ++n2;
                }
                this.scan(pattern, uris, isNullInclusive);
            }
            loader = visitParent ? loader.getParent() : null;
        }
    }

    @Override
    public void matched(URI uri) throws Exception {
        Log.debug("Search of {}", uri);
        if (uri.toString().toLowerCase().endsWith(".jar")) {
            InputStream in = Resource.newResource(uri).getInputStream();
            if (in == null) {
                return;
            }
            JarInputStream jar_in = new JarInputStream(in);
            try {
                JarEntry entry = jar_in.getNextJarEntry();
                while (entry != null) {
                    this.processEntry(uri, entry);
                    entry = jar_in.getNextJarEntry();
                }
            }
            finally {
                jar_in.close();
            }
        }
    }
}

