/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Random;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.websocket.WebSocketBuffers;
import org.eclipse.jetty.websocket.WebSocketConnectionD07;
import org.eclipse.jetty.websocket.WebSocketGenerator;

public class WebSocketGeneratorD07
implements WebSocketGenerator {
    private final WebSocketBuffers _buffers;
    private final EndPoint _endp;
    private Buffer _buffer;
    private final byte[] _mask = new byte[4];
    private int _m;
    private boolean _opsent;
    private final MaskGen _maskGen;

    public WebSocketGeneratorD07(WebSocketBuffers buffers, EndPoint endp) {
        this._buffers = buffers;
        this._endp = endp;
        this._maskGen = null;
    }

    public WebSocketGeneratorD07(WebSocketBuffers buffers, EndPoint endp, MaskGen maskGen) {
        this._buffers = buffers;
        this._endp = endp;
        this._maskGen = maskGen;
    }

    @Override
    public synchronized void addFrame(byte flags, byte opcode, byte[] content, int offset, int length) throws IOException {
        int payload;
        boolean mask;
        boolean bl = mask = this._maskGen != null;
        if (this._buffer == null) {
            this._buffer = mask ? this._buffers.getBuffer() : this._buffers.getDirectBuffer();
        }
        boolean last = WebSocketConnectionD07.isLastFrame(flags);
        byte orig = opcode;
        int space = mask ? 14 : 10;
        do {
            opcode = this._opsent ? (byte)0 : opcode;
            opcode = (byte)(((0xF & flags) << 4) + (0xF & opcode));
            this._opsent = true;
            payload = length;
            if (payload + space > this._buffer.capacity()) {
                opcode = (byte)(opcode & 0x7F);
                payload = this._buffer.capacity() - space;
            } else if (last) {
                opcode = (byte)(opcode | 0x80);
            }
            if (this._buffer.space() <= space) {
                this.flushBuffer();
                if (this._buffer.space() <= space) {
                    this.flush();
                }
            }
            if (payload > 65535) {
                this._buffer.put(new byte[]{opcode, mask ? (byte)-1 : 127, (byte)(payload >> 56 & 0x7F), (byte)(payload >> 48 & 0xFF), (byte)(payload >> 40 & 0xFF), (byte)(payload >> 32 & 0xFF), (byte)(payload >> 24 & 0xFF), (byte)(payload >> 16 & 0xFF), (byte)(payload >> 8 & 0xFF), (byte)(payload & 0xFF)});
            } else if (payload >= 126) {
                this._buffer.put(new byte[]{opcode, mask ? (byte)-2 : 126, (byte)(payload >> 8), (byte)(payload & 0xFF)});
            } else {
                this._buffer.put(new byte[]{opcode, (byte)(mask ? 0x80 | payload : payload)});
            }
            if (mask) {
                this._maskGen.genMask(this._mask);
                this._m = 0;
                this._buffer.put(this._mask);
            }
            int remaining = payload;
            while (remaining > 0) {
                int chunk;
                this._buffer.compact();
                int n = chunk = remaining < this._buffer.space() ? remaining : this._buffer.space();
                if (mask) {
                    int i = 0;
                    while (i < chunk) {
                        this._buffer.put((byte)(content[offset + (payload - remaining) + i] ^ this._mask[this._m++ % 4]));
                        ++i;
                    }
                } else {
                    this._buffer.put(content, offset + (payload - remaining), chunk);
                }
                remaining -= chunk;
                if (this._buffer.space() > 0) {
                    this.flushBuffer();
                    continue;
                }
                this.flush();
                if (remaining != 0) continue;
                this.flushBuffer();
            }
            offset += payload;
        } while ((length -= payload) > 0);
        boolean bl2 = this._opsent = !last;
        if (this._buffer != null && this._buffer.length() == 0) {
            this._buffers.returnBuffer(this._buffer);
            this._buffer = null;
        }
    }

    public synchronized int flushBuffer() throws IOException {
        if (!this._endp.isOpen()) {
            throw new EofException();
        }
        if (this._buffer != null) {
            return this._endp.flush(this._buffer);
        }
        return 0;
    }

    @Override
    public synchronized int flush() throws IOException {
        if (this._buffer == null) {
            return 0;
        }
        int result = this.flushBuffer();
        if (!this._endp.isBlocking()) {
            long now = System.currentTimeMillis();
            long end = now + (long)this._endp.getMaxIdleTime();
            while (this._buffer.length() > 0) {
                boolean ready = this._endp.blockWritable(end - now);
                if (!ready) {
                    now = System.currentTimeMillis();
                    if (now < end) continue;
                    throw new IOException("Write timeout");
                }
                result += this.flushBuffer();
            }
        }
        this._buffer.compact();
        return result;
    }

    @Override
    public synchronized boolean isBufferEmpty() {
        return this._buffer == null || this._buffer.length() == 0;
    }

    public synchronized void idle() {
        if (this._buffer != null && this._buffer.length() == 0) {
            this._buffers.returnBuffer(this._buffer);
            this._buffer = null;
        }
    }

    public static class FixedMaskGen
    implements MaskGen {
        final byte[] _mask;

        public FixedMaskGen() {
            this._mask = new byte[]{-1, -1, -1, -1};
        }

        public FixedMaskGen(byte[] mask) {
            this._mask = mask;
        }

        @Override
        public void genMask(byte[] mask) {
            mask[0] = this._mask[0];
            mask[1] = this._mask[1];
            mask[2] = this._mask[2];
            mask[3] = this._mask[3];
        }
    }

    public static interface MaskGen {
        public void genMask(byte[] var1);
    }

    public static class NullMaskGen
    implements MaskGen {
        @Override
        public void genMask(byte[] mask) {
            mask[3] = 0;
            mask[2] = 0;
            mask[1] = 0;
            mask[0] = 0;
        }
    }

    public static class RandomMaskGen
    implements MaskGen {
        final Random _random;

        public RandomMaskGen() {
            this._random = new SecureRandom();
        }

        public RandomMaskGen(Random random) {
            this._random = random;
        }

        @Override
        public void genMask(byte[] mask) {
            this._random.nextBytes(mask);
        }
    }
}

