/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.objects;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.objects.Base64;
import anywheresoftware.b4a.objects.collections.List;
import anywheresoftware.b4a.objects.streams.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.regex.Pattern;

@BA.ShortName(value="StringUtils")
@BA.Version(value=1.0f)
public class StringUtils {
    public String EncodeBase64(byte[] Data) {
        return Base64.encodeBytes(Data);
    }

    public byte[] DecodeBase64(String Data) throws IOException {
        return Base64.decode(Data);
    }

    public String EncodeUrl(String Url, String CharSet) throws UnsupportedEncodingException {
        return URLEncoder.encode(Url, CharSet);
    }

    public String DecodeUrl(String Url, String CharSet) throws UnsupportedEncodingException {
        return URLDecoder.decode(Url, CharSet);
    }

    public static void SaveCSV(String Dir, String FileName, char SeparatorChar, List Table) throws IOException {
        StringUtils.SaveCSV2(Dir, FileName, SeparatorChar, Table, null);
    }

    public static void SaveCSV2(String Dir, String FileName, char SeparatorChar, List Table, List Headers) throws IOException {
        int colCount = ((String[])Table.Get(0)).length;
        StringBuilder data = new StringBuilder();
        Pattern problemChars = Pattern.compile("[\"\\r\\n" + SeparatorChar + "]");
        if (Headers != null) {
            for (Object s : (java.util.List)Headers.getObject()) {
                data.append(StringUtils.Word((String)s, problemChars, SeparatorChar));
            }
            data.setCharAt(data.length() - 1, '\n');
        }
        int rowI = 0;
        while (rowI < Table.getSize()) {
            String[] row = (String[])Table.Get(rowI);
            int i = 0;
            while (i < colCount) {
                data.append(StringUtils.Word(row[i], problemChars, SeparatorChar));
                ++i;
            }
            data.setCharAt(data.length() - 1, '\n');
            ++rowI;
        }
        File.WriteString(Dir, FileName, data.toString());
    }

    private static String Word(String word, Pattern problemChars, char sep) {
        if (problemChars.matcher(word).find()) {
            word = "\"" + word + "\"";
            int i = word.indexOf(34, 1);
            while (i > -1 && i < word.length() - 1) {
                word = String.valueOf(word.substring(0, i)) + "\"" + word.substring(i);
                i = word.indexOf("\"", i + 2);
            }
        }
        return String.valueOf(word) + sep;
    }

    public static List LoadCSV(String Dir, String FileName, char SeparatorChar) throws IOException {
        return StringUtils.LoadCSV2(Dir, FileName, SeparatorChar, null);
    }

    public static List LoadCSV2(String Dir, String FileName, char SeparatorChar, List Headers) throws IOException {
        int i2;
        int i = 0;
        String data = File.ReadString(Dir, FileName);
        List Table = new List();
        Table.Initialize();
        ArrayList<String> alFirstLine = new ArrayList<String>();
        boolean unixEnd = true;
        while (i < data.length()) {
            if (data.charAt(i) == '\"') {
                i2 = data.indexOf("\"", i + 1);
                boolean shouldReplaceQuotes = false;
                while (i2 < data.length() && i2 > -1) {
                    if (i2 == data.length() - 1 || data.charAt(i2 + 1) != '\"') break;
                    shouldReplaceQuotes = true;
                    i2 = data.indexOf("\"", i2 + 2);
                }
                String ret = data.substring(i + 1, i2);
                if (shouldReplaceQuotes) {
                    ret = ret.replace("\"\"", "\"");
                }
                alFirstLine.add(ret);
                i = i2 + 2;
                if (data.charAt(i2 + 1) != '\r' && data.charAt(i2 + 1) != '\n') continue;
                if (data.charAt(i2 + 1) != '\r') break;
                unixEnd = false;
                ++i;
                break;
            }
            i2 = data.indexOf(SeparatorChar, i);
            int i3 = data.indexOf(10, i);
            if (i3 == -1) {
                data = String.valueOf(data) + "\n";
                i3 = data.length() - 1;
            }
            if (i3 < i2 || i2 == -1) {
                if (data.charAt(i3 - 1) == '\r') {
                    unixEnd = false;
                    --i3;
                }
                alFirstLine.add(data.substring(i, i3));
                i = i3 + (unixEnd ? 1 : 2);
                break;
            }
            alFirstLine.add(data.substring(i, i2));
            i = i2 + 1;
        }
        if (data.charAt(data.length() - 1) != '\n') {
            data = String.valueOf(data) + (unixEnd ? "\n" : "\r\n");
        }
        int colCount = alFirstLine.size();
        if (Headers != null) {
            if (!Headers.IsInitialized()) {
                Headers.Initialize();
            }
            for (String s : alFirstLine) {
                Headers.Add(s);
            }
        } else {
            String[] list = new String[colCount];
            int a = 0;
            while (a < list.length) {
                list[a] = (String)alFirstLine.get(a);
                ++a;
            }
            Table.Add(list);
        }
        int[] ii = new int[]{i};
        while (ii[0] < data.length() - 1) {
            String[] list = new String[colCount];
            i2 = 0;
            while (i2 < colCount - 1) {
                list[i2] = StringUtils.ReadWord(data, ii, SeparatorChar);
                ++i2;
            }
            if (!unixEnd) {
                list[i2] = StringUtils.ReadWord(data, ii, '\r');
                ii[0] = ii[0] + 1;
            } else {
                list[i2] = StringUtils.ReadWord(data, ii, '\n');
            }
            Table.Add(list);
        }
        return Table;
    }

    private static String ReadWord(String data, int[] ii, char sep) {
        String ret;
        if (data.charAt(ii[0]) == '\"') {
            int i2 = data.indexOf("\"", ii[0] + 1);
            boolean shouldReplaceQuotes = false;
            while (i2 < data.length() && i2 > -1) {
                if (i2 == data.length() - 1 || data.charAt(i2 + 1) != '\"') break;
                shouldReplaceQuotes = true;
                i2 = data.indexOf("\"", i2 + 2);
            }
            ret = data.substring(ii[0] + 1, i2);
            if (shouldReplaceQuotes) {
                ret = ret.replace("\"\"", "\"");
            }
            ii[0] = i2 + 2;
        } else {
            int i2 = data.indexOf(sep, ii[0]);
            ret = data.substring(ii[0], i2);
            ii[0] = i2 + 1;
        }
        return ret;
    }
}

