/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.ObjectWrapper;
import anywheresoftware.b4a.objects.streams.File;
import anywheresoftware.b4j.objects.ButtonWrapper;
import anywheresoftware.b4j.objects.CanvasWrapper;
import anywheresoftware.b4j.objects.CheckboxWrapper;
import anywheresoftware.b4j.objects.ComboBoxWrapper;
import anywheresoftware.b4j.objects.HTMLEditorWrapper;
import anywheresoftware.b4j.objects.ImageViewWrapper;
import anywheresoftware.b4j.objects.LabelWrapper;
import anywheresoftware.b4j.objects.ListViewWrapper;
import anywheresoftware.b4j.objects.MenuItemWrapper;
import anywheresoftware.b4j.objects.NodeWrapper;
import anywheresoftware.b4j.objects.ProgressIndicatorWrapper;
import anywheresoftware.b4j.objects.SliderWrapper;
import anywheresoftware.b4j.objects.TableViewWrapper;
import anywheresoftware.b4j.objects.TextInputControlWrapper;
import anywheresoftware.b4j.objects.TreeViewWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.Accordion;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.ListView;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Slider;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import javafx.scene.control.TreeView;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.web.HTMLEditor;

@BA.Hide
public class PaneWrapper<T extends Pane>
extends NodeWrapper<T>
implements BA.IterableList {
    @BA.Hide
    public static final LinkedList<NativeAndWrapper> nativeToWrapper = new LinkedList();

    static {
        nativeToWrapper.add(new NativeAndWrapper(TreeView.class, TreeViewWrapper.class));
        nativeToWrapper.add(new NativeAndWrapper(HTMLEditor.class, HTMLEditorWrapper.class));
        nativeToWrapper.add(new NativeAndWrapper(TableView.class, TableViewWrapper.class));
        nativeToWrapper.add(new NativeAndWrapper(Slider.class, SliderWrapper.class));
        nativeToWrapper.add(new NativeAndWrapper(ListView.class, ListViewWrapper.class));
        nativeToWrapper.add(new NativeAndWrapper(ComboBox.class, ComboBoxWrapper.class));
        nativeToWrapper.add(new NativeAndWrapper(Button.class, ButtonWrapper.class));
        nativeToWrapper.add(new NativeAndWrapper(CheckBox.class, CheckboxWrapper.class));
        nativeToWrapper.add(new NativeAndWrapper(RadioButton.class, ButtonWrapper.RadioButtonWrapper.class));
        nativeToWrapper.add(new NativeAndWrapper(ToggleButton.class, ButtonWrapper.ToggleButtonWrapper.class));
        nativeToWrapper.add(new NativeAndWrapper(ButtonBase.class, NodeWrapper.ButtonBaseWrapper.class));
        nativeToWrapper.add(new NativeAndWrapper(Label.class, LabelWrapper.class));
        nativeToWrapper.add(new NativeAndWrapper(Labeled.class, NodeWrapper.LabeledWrapper.class));
        nativeToWrapper.add(new NativeAndWrapper(TextField.class, TextInputControlWrapper.TextFieldWrapper.class));
        nativeToWrapper.add(new NativeAndWrapper(TextArea.class, TextInputControlWrapper.TextAreaWrapper.class));
        nativeToWrapper.add(new NativeAndWrapper(TextInputControl.class, TextInputControlWrapper.class));
        nativeToWrapper.add(new NativeAndWrapper(ListView.class, ListViewWrapper.class));
        nativeToWrapper.add(new NativeAndWrapper(ImageView.class, ImageViewWrapper.class));
        nativeToWrapper.add(new NativeAndWrapper(ProgressIndicator.class, ProgressIndicatorWrapper.class));
        nativeToWrapper.add(new NativeAndWrapper(MenuBar.class, MenuItemWrapper.MenuBarWrapper.class));
        nativeToWrapper.add(new NativeAndWrapper(Control.class, NodeWrapper.ControlWrapper.class));
        nativeToWrapper.add(new NativeAndWrapper(AnchorPane.class, AnchorPaneWrapper.class));
        nativeToWrapper.add(new NativeAndWrapper(Pane.class, PaneWrapper.class));
        nativeToWrapper.add(new NativeAndWrapper(Parent.class, NodeWrapper.ParentWrapper.class));
        nativeToWrapper.add(new NativeAndWrapper(Canvas.class, CanvasWrapper.class));
        nativeToWrapper.add(new NativeAndWrapper(Node.class, NodeWrapper.class));
    }

    @BA.RaisesSynchronousEvents
    public void LoadLayout(BA tba, String LayoutFile) throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        FXMLLoader loader = new FXMLLoader();
        if (!LayoutFile.contains(".")) {
            LayoutFile = String.valueOf(LayoutFile) + ".fxml";
        }
        loader.setLocation(this.getClass().getResource("/Files/" + LayoutFile));
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream in = (InputStream)File.OpenInput(File.getDirAssets(), LayoutFile).getObject();){
            Parent p = (Parent)loader.load(in);
            HashMap<String, Object> viewsToSend = null;
            viewsToSend = new HashMap<String, Object>();
            this.setEventsAndVariables(tba, Arrays.asList(p), viewsToSend);
            if (BA.isShellModeRuntimeCheck(tba)) {
                tba.raiseEvent2(null, true, "SEND_VIEWS_AFTER_LAYOUT", true, viewsToSend);
            } else {
                Class<?> cls = Class.forName(tba.className);
                for (Map.Entry e : viewsToSend.entrySet()) {
                    try {
                        Field field = cls.getField("_" + (String)e.getKey());
                        if (field == null) continue;
                        try {
                            ObjectWrapper ow = (ObjectWrapper)field.get(tba.eventsTarget);
                            ow.setObject(((ObjectWrapper)e.getValue()).getObject());
                        }
                        catch (IllegalArgumentException ee) {
                            throw new RuntimeException("Field " + (String)e.getKey() + " was declared with the wrong type.");
                        }
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                }
            }
            AnchorPane.setBottomAnchor((Node)p, (Double)0.0);
            AnchorPane.setLeftAnchor((Node)p, (Double)0.0);
            AnchorPane.setRightAnchor((Node)p, (Double)0.0);
            AnchorPane.setTopAnchor((Node)p, (Double)0.0);
            ((Pane)this.getObject()).getChildren().add((Object)p);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void setEventsAndVariables(BA tba, Iterable<? extends Node> nodes, Map<String, Object> viewsToSend) throws InstantiationException, IllegalAccessException {
        for (Node node : nodes) {
            Control c;
            ContextMenu cm;
            this.handleNode(tba, node, viewsToSend);
            if (node instanceof Control && (cm = (c = (Control)node).getContextMenu()) != null) {
                if (cm.getId() != null) {
                    String name = cm.getId().toLowerCase(BA.cul);
                    MenuItemWrapper.ContextMenuWrapper cmw = new MenuItemWrapper.ContextMenuWrapper();
                    cmw.setObject(cm);
                    cmw.innerInitialize(tba, name, true);
                    viewsToSend.put(name, cmw);
                }
                this.handleMenus(tba, (List)cm.getItems(), viewsToSend);
            }
            if (node instanceof MenuBar) {
                MenuBar mb = (MenuBar)node;
                this.handleMenus(tba, (List)mb.getMenus(), viewsToSend);
            } else if (node instanceof MenuButton) {
                this.handleMenus(tba, (List)((MenuButton)node).getItems(), viewsToSend);
            }
            Object kids = null;
            if (node instanceof ToolBar) {
                kids = ((ToolBar)node).getItems();
            } else if (node instanceof TabPane) {
                kids = new ArrayList();
                for (Tab t : ((TabPane)node).getTabs()) {
                    if (t.getContent() == null) continue;
                    ((ArrayList)kids).add(t.getContent());
                }
            } else if (node instanceof SplitPane) {
                kids = ((SplitPane)node).getItems();
            } else if (node instanceof Accordion) {
                kids = new ArrayList(((Accordion)node).getPanes());
            } else if (node instanceof TitledPane) {
                kids = Arrays.asList(((TitledPane)node).getContent());
            } else if (node instanceof ScrollPane) {
                kids = Arrays.asList(((ScrollPane)node).getContent());
            } else if (node instanceof HTMLEditor) {
                kids = null;
            } else if (node instanceof Parent) {
                kids = ((Parent)node).getChildrenUnmodifiable();
            }
            if (kids == null) continue;
            this.setEventsAndVariables(tba, (Iterable<Node>)kids, viewsToSend);
        }
    }

    private void handleNode(BA tba, Node n, Map<String, Object> viewsToSend) throws InstantiationException, IllegalAccessException {
        if (n.getId() != null) {
            NodeWrapper nodeWrapper = null;
            for (NativeAndWrapper nw : nativeToWrapper) {
                if (!nw.nativeClass.isAssignableFrom(n.getClass())) continue;
                nodeWrapper = (NodeWrapper)AbsObjectWrapper.ConvertToWrapper((ObjectWrapper)nw.wrapperClass.newInstance(), n);
                break;
            }
            String name = n.getId().toLowerCase(BA.cul);
            viewsToSend.put(name, nodeWrapper);
            nodeWrapper.innerInitialize(tba, name, true);
        }
    }

    private <TT extends MenuItem> void handleMenus(BA tba, List<TT> menus, Map<String, Object> viewsToSend) {
        for (MenuItem mi : menus) {
            if (mi instanceof Menu) {
                Menu menu = (Menu)mi;
                if (menu.getId() != null) {
                    String name = menu.getId().toLowerCase(BA.cul);
                    MenuItemWrapper.MenuWrapper mw = new MenuItemWrapper.MenuWrapper();
                    mw.setObject(menu);
                    mw.innerInitialize(tba, name, true);
                    viewsToSend.put(name, mw);
                }
                this.handleMenus(tba, (List<TT>)menu.getItems(), viewsToSend);
                continue;
            }
            if (mi.getId() == null) continue;
            String name = mi.getId().toLowerCase(BA.cul);
            MenuItemWrapper miw = mi instanceof CheckMenuItem ? new MenuItemWrapper.CheckMenuItemWrapper() : new MenuItemWrapper();
            miw.setObject(mi);
            miw.innerInitialize(tba, name, true);
            viewsToSend.put(name, miw);
        }
    }

    @Override
    @BA.Hide
    public void innerInitialize(final BA ba, final String eventName, boolean keepOldObject) {
        super.innerInitialize(ba, eventName, keepOldObject);
        if (ba.subExists(String.valueOf(eventName) + "_resize")) {
            ((Pane)this.getObject()).widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> arg0, Number arg1, Number arg2) {
                    if (arg2 != null && PaneWrapper.this.getHeight() != 0.0) {
                        ba.raiseEventFromUI(PaneWrapper.this.getObject(), String.valueOf(eventName) + "_resize", arg2.doubleValue(), PaneWrapper.this.getHeight());
                    }
                }
            });
            ((Pane)this.getObject()).heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> arg0, Number arg1, Number arg2) {
                    if (arg2 != null && PaneWrapper.this.getWidth() != 0.0) {
                        ba.raiseEventFromUI(PaneWrapper.this.getObject(), String.valueOf(eventName) + "_resize", PaneWrapper.this.getWidth(), arg2.doubleValue());
                    }
                }
            });
        }
    }

    public BA.IterableList GetAllViewsRecursive() {
        return new AllViewsIterator((Parent)this.getObject());
    }

    public double getPrefHeight() {
        return ((Pane)this.getObject()).getPrefHeight();
    }

    public void setPrefHeight(double d) {
        ((Pane)this.getObject()).setPrefHeight(d);
    }

    public double getPrefWidth() {
        return ((Pane)this.getObject()).getPrefWidth();
    }

    public void setPrefWidth(double d) {
        ((Pane)this.getObject()).setPrefWidth(d);
    }

    public double getHeight() {
        return ((Pane)this.getObject()).getHeight();
    }

    public double getWidth() {
        return ((Pane)this.getObject()).getWidth();
    }

    public void AddNode(Node Node2, double Left, double Top, double Width, double Height) {
        this.InsertNode(this.getNumberOfNodes(), Node2, Left, Top, Width, Height);
    }

    public void RemoveAllNodes() {
        ((Pane)this.getObject()).getChildren().clear();
    }

    public void RemoveNodeAt(int Index) {
        ((Pane)this.getObject()).getChildren().remove(Index);
    }

    public void InsertNode(int Index, Node Node2, double Left, double Top, double Width, double Height) {
        ((Pane)this.getObject()).getChildren().add(Index, (Object)Node2);
        if (Left != -1.0) {
            Node2.setLayoutX(Left - Node2.getLayoutBounds().getMinX());
        }
        if (Top != -1.0) {
            Node2.setLayoutY(Top - Node2.getLayoutBounds().getMinY());
        }
        if (Node2 instanceof MenuBar) {
            MenuBar mb = (MenuBar)Node2;
            AnchorPane.setLeftAnchor((Node)mb, (Double)0.0);
            AnchorPane.setRightAnchor((Node)mb, (Double)0.0);
        } else if (Node2 instanceof Control) {
            ((Control)Node2).setPrefSize(Width > 0.0 ? Width : -1.0, Height > 0.0 ? Height : -1.0);
        } else if (Node2 instanceof ImageView) {
            ((ImageView)Node2).setFitWidth(Width);
            ((ImageView)Node2).setFitHeight(Height);
        } else if (Node2 instanceof Canvas) {
            ((Canvas)Node2).setWidth(Width);
            ((Canvas)Node2).setHeight(Height);
        }
    }

    public int getNumberOfNodes() {
        return ((Pane)this.getObject()).getChildren().size();
    }

    public NodeWrapper.ConcreteNodeWrapper GetNode(int Index) {
        return (NodeWrapper.ConcreteNodeWrapper)AbsObjectWrapper.ConvertToWrapper(new NodeWrapper.ConcreteNodeWrapper(), ((Pane)this.getObject()).getChildren().get(Index));
    }

    @Override
    @BA.Hide
    public int getSize() {
        return this.getNumberOfNodes();
    }

    @Override
    @BA.Hide
    public Object Get(int index) {
        return ((Pane)this.getObject()).getChildren().get(index);
    }

    @BA.Hide
    public static class AllViewsIterator
    implements BA.IterableList {
        private ArrayList<Node> views = new ArrayList();

        public AllViewsIterator(Parent parent) {
            this.addViews(parent);
        }

        private void addViews(Parent parent) {
            for (Node n : parent.getChildrenUnmodifiable()) {
                this.views.add(n);
                if (!(n instanceof Parent)) continue;
                this.addViews((Parent)n);
            }
        }

        @Override
        public Object Get(int index) {
            return this.views.get(index);
        }

        @Override
        public int getSize() {
            return this.views.size();
        }
    }

    @BA.ShortName(value="AnchorPane")
    public static class AnchorPaneWrapper
    extends PaneWrapper<AnchorPane> {
        @Override
        @BA.Hide
        public void innerInitialize(BA ba, String eventName, boolean keepOldObject) {
            if (!keepOldObject) {
                this.setObject(new AnchorPane());
            }
            super.innerInitialize(ba, eventName, true);
        }

        public void SetAnchors(Node Child, double Left, double Top, double Right, double Bottom) {
            this.checkResize(Child);
            this.SetLeftAnchor(Child, Left);
            this.SetTopAnchor(Child, Top);
            this.SetRightAnchor(Child, Right);
            this.SetBottomAnchor(Child, Bottom);
        }

        public void FillHorizontally(Node Child, double DistanceFromLeft, double DistanceFromRight) {
            this.checkResize(Child);
            this.SetLeftAnchor(Child, DistanceFromLeft);
            this.SetRightAnchor(Child, DistanceFromRight);
        }

        public void FillVertically(Node Child, double DistanceFromTop, double DistanceFromBottom) {
            this.checkResize(Child);
            this.SetTopAnchor(Child, DistanceFromTop);
            this.SetBottomAnchor(Child, DistanceFromBottom);
        }

        public double GetLeftAnchor(Node Child) {
            Double d = AnchorPane.getLeftAnchor((Node)Child);
            return d == null ? -1.0 : d;
        }

        public double GetTopAnchor(Node Child) {
            Double d = AnchorPane.getTopAnchor((Node)Child);
            return d == null ? -1.0 : d;
        }

        public double GetBottomAnchor(Node Child) {
            Double d = AnchorPane.getBottomAnchor((Node)Child);
            return d == null ? -1.0 : d;
        }

        public double GetRightAnchor(Node Child) {
            Double d = AnchorPane.getRightAnchor((Node)Child);
            return d == null ? -1.0 : d;
        }

        private void checkResize(Node Child) {
            if (!Child.isResizable()) {
                BA.Log("Child is not resizable: " + Child);
            }
        }

        public void SetLeftAnchor(Node Child, double Offset) {
            this.checkResize(Child);
            AnchorPane.setLeftAnchor((Node)Child, (Double)(Offset == -1.0 ? null : Double.valueOf(Offset)));
        }

        public void SetTopAnchor(Node Child, double Offset) {
            this.checkResize(Child);
            AnchorPane.setTopAnchor((Node)Child, (Double)(Offset == -1.0 ? null : Double.valueOf(Offset)));
        }

        public void SetBottomAnchor(Node Child, double Offset) {
            this.checkResize(Child);
            AnchorPane.setBottomAnchor((Node)Child, (Double)(Offset == -1.0 ? null : Double.valueOf(Offset)));
        }

        public void SetRightAnchor(Node Child, double Offset) {
            this.checkResize(Child);
            AnchorPane.setRightAnchor((Node)Child, (Double)(Offset == -1.0 ? null : Double.valueOf(Offset)));
        }
    }

    @BA.ShortName(value="Pane")
    public static class ConcretePaneWrapper
    extends PaneWrapper<Pane> {
        @Override
        @BA.Hide
        public void innerInitialize(BA ba, String eventName, boolean keepOldObject) {
            if (!keepOldObject) {
                this.setObject(new AnchorPane());
            }
            super.innerInitialize(ba, eventName, true);
        }
    }

    @BA.Hide
    public static class NativeAndWrapper {
        public final Class<?> nativeClass;
        public final Class<?> wrapperClass;

        public NativeAndWrapper(Class<?> nativeClass, Class<?> wrapperClass) {
            this.nativeClass = nativeClass;
            this.wrapperClass = wrapperClass;
        }
    }
}

