/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.keywords.Common;
import anywheresoftware.b4a.objects.collections.List;
import anywheresoftware.b4j.objects.NodeWrapper;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.util.Callback;

@BA.ShortName(value="TableView")
public class TableViewWrapper
extends NodeWrapper.ControlWrapper<TableView<Object[]>> {
    @Override
    @BA.Hide
    public void innerInitialize(final BA ba, final String eventName, boolean keepOldObject) {
        if (!keepOldObject) {
            this.setObject(new TableView());
        }
        super.innerInitialize(ba, eventName, true);
        if (ba.subExists(String.valueOf(eventName) + "_selectedrowchanged")) {
            ((TableView)this.getObject()).getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> arg0, Number arg1, Number arg2) {
                    Object[] row = null;
                    if (arg2.intValue() > -1) {
                        row = (Object[])((TableView)TableViewWrapper.this.getObject()).getItems().get(arg2.intValue());
                    }
                    ba.raiseEventFromUI(TableViewWrapper.this.getObject(), String.valueOf(eventName) + "_selectedrowchanged", arg2.intValue(), row);
                }
            });
        }
    }

    public void SetColumns(List Columns) {
        ((TableView)this.getObject()).getColumns().clear();
        if (Columns == null || !Columns.IsInitialized()) {
            return;
        }
        int colIndex = 0;
        double w = (this.getPrefWidth() - (double)Common.DipToCurrent(20)) / (double)Columns.getSize();
        for (Object colName : (java.util.List)Columns.getObject()) {
            TableColumn tc = new TableColumn(String.valueOf(colName));
            tc.setPrefWidth(w);
            tc.setCellValueFactory((Callback)new MyCellValueFactory(colIndex));
            ((TableView)this.getObject()).getColumns().add((Object)tc);
            ++colIndex;
        }
    }

    public int getColumnsCount() {
        return ((TableView)this.getObject()).getColumns().size();
    }

    public String GetColumnHeader(int Index) {
        return ((TableColumn)((TableView)this.getObject()).getColumns().get(Index)).getText();
    }

    public void SetColumnHeader(int Index, String Header2) {
        ((TableColumn)((TableView)this.getObject()).getColumns().get(Index)).setText(Header2);
    }

    public double GetColumnWidth(int Index) {
        return ((TableColumn)((TableView)this.getObject()).getColumns().get(Index)).getWidth();
    }

    public void SetColumnWidth(int Index, double Width) {
        ((TableColumn)((TableView)this.getObject()).getColumns().get(Index)).setPrefWidth(Width);
    }

    public void SetColumnSortable(int Index, boolean Sortable) {
        ((TableColumn)((TableView)this.getObject()).getColumns().get(Index)).setSortable(Sortable);
    }

    public void SetColumnVisible(int Index, boolean Visible) {
        ((TableColumn)((TableView)this.getObject()).getColumns().get(Index)).setVisible(Visible);
    }

    public boolean GetColumnVisible(int Index) {
        return ((TableColumn)((TableView)this.getObject()).getColumns().get(Index)).isVisible();
    }

    public int getSelectedRow() {
        return ((TableView)this.getObject()).getSelectionModel().getSelectedIndex();
    }

    public void setSelectedRow(int row) {
        ((TableView)this.getObject()).getSelectionModel().clearAndSelect(row);
    }

    public Object[] getSelectedRowValues() {
        return (Object[])((TableView)this.getObject()).getSelectionModel().getSelectedItem();
    }

    public void setSelectedRowValues(Object[] r) {
        ((TableView)this.getObject()).getSelectionModel().clearSelection();
        ((TableView)this.getObject()).getSelectionModel().select((Object)r);
    }

    public void ScrollTo(int Index) {
        ((TableView)this.getObject()).scrollTo(Index);
    }

    public void setItems(List list) {
        ((TableView)this.getObject()).setItems(FXCollections.observableList((java.util.List)((java.util.List)list.getObject())));
    }

    public List getItems() {
        return (List)AbsObjectWrapper.ConvertToWrapper(new List(), ((TableView)this.getObject()).getItems());
    }

    private static class MyCellValueFactory
    implements Callback<TableColumn.CellDataFeatures<Object[], Object>, ObservableValue<Object>> {
        private final int colIndex;

        public MyCellValueFactory(int colIndex) {
            this.colIndex = colIndex;
        }

        public ObservableValue<Object> call(TableColumn.CellDataFeatures<Object[], Object> arg0) {
            return new ReadOnlyObjectWrapper(((Object[])arg0.getValue())[this.colIndex]);
        }
    }
}

