/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4j.objects.NodeWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;

@BA.Hide
public class TextInputControlWrapper<T extends TextInputControl>
extends NodeWrapper.ControlWrapper<T> {
    @Override
    @BA.Hide
    public void innerInitialize(final BA ba, final String eventName, boolean keepOldObject) {
        super.innerInitialize(ba, eventName, keepOldObject);
        if (ba.subExists(String.valueOf(eventName) + "_textchanged")) {
            ((TextInputControl)this.getObject()).textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> arg0, String old, String newValue) {
                    ba.raiseEventFromUI(TextInputControlWrapper.this.getObject(), String.valueOf(eventName) + "_textchanged", old, newValue);
                }
            });
        }
    }

    public String getText() {
        return ((TextInputControl)this.getObject()).getText();
    }

    public void setText(String s) {
        ((TextInputControl)this.getObject()).setText(s);
    }

    public String getPromptText() {
        return ((TextInputControl)this.getObject()).getPromptText();
    }

    public void setPromptText(String s) {
        ((TextInputControl)this.getObject()).setPromptText(s);
    }

    public int getSelectionStart() {
        return ((TextInputControl)this.getObject()).getSelection().getStart();
    }

    public int getSelectionEnd() {
        return ((TextInputControl)this.getObject()).getSelection().getEnd();
    }

    public void SetSelection(int StartIndex, int EndIndex) {
        ((TextInputControl)this.getObject()).selectRange(StartIndex, EndIndex);
    }

    public void SelectAll() {
        ((TextInputControl)this.getObject()).selectAll();
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + ", Text: " + this.getText() + ", ";
    }

    public boolean getEditable() {
        return ((TextInputControl)this.getObject()).isEditable();
    }

    public void setEditable(boolean b) {
        ((TextInputControl)this.getObject()).setEditable(b);
    }

    @BA.ShortName(value="TextArea")
    public static class TextAreaWrapper
    extends TextInputControlWrapper<TextArea> {
        @Override
        @BA.Hide
        public void innerInitialize(BA ba, String eventName, boolean keepOldObject) {
            if (!keepOldObject) {
                this.setObject(new TextArea());
            }
            super.innerInitialize(ba, eventName, true);
        }

        public boolean getWrapText() {
            return ((TextArea)this.getObject()).isWrapText();
        }

        public void setWrapText(boolean b) {
            ((TextArea)this.getObject()).setWrapText(b);
        }

        public double getScrollTopPosition() {
            return ((TextArea)this.getObject()).getScrollTop();
        }

        public void setScrollTopPosition(double d) {
            ((TextArea)this.getObject()).setScrollTop(d);
        }

        public double getScrollLeftPosition() {
            return ((TextArea)this.getObject()).getScrollLeft();
        }

        public void setScrollLeftPosition(double d) {
            ((TextArea)this.getObject()).setScrollLeft(d);
        }
    }

    @BA.ShortName(value="TextField")
    public static class TextFieldWrapper
    extends TextInputControlWrapper<TextField> {
        @Override
        @BA.Hide
        public void innerInitialize(final BA ba, final String eventName, boolean keepOldObject) {
            if (!keepOldObject) {
                this.setObject(new TextField());
            }
            super.innerInitialize(ba, eventName, true);
            if (ba.subExists(String.valueOf(eventName) + "_action")) {
                ((TextField)this.getObject()).setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent arg0) {
                        ba.raiseEventFromUI(TextFieldWrapper.this.getObject(), String.valueOf(eventName) + "_action", new Object[0]);
                        arg0.consume();
                    }
                });
            }
        }
    }
}

