/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects.collections;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.objects.collections.List;
import anywheresoftware.b4a.objects.collections.Map;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

@BA.Version(value=1.0f)
@BA.ShortName(value="JSONParser")
public class JSONParser
extends AbsObjectWrapper<JSONTokener> {
    public void Initialize(String Text) {
        JSONTokener j = new JSONTokener(Text);
        this.setObject(j);
    }

    public Map NextObject() throws JSONException {
        Object o = ((JSONTokener)this.getObject()).nextValue();
        if (!(o instanceof JSONObject)) {
            throw new RuntimeException("JSON Object expected.");
        }
        Map m = new Map();
        m.setObject(this.convertObjToMap((JSONObject)o));
        return m;
    }

    public List NextArray() throws JSONException {
        Object o = ((JSONTokener)this.getObject()).nextValue();
        if (!(o instanceof JSONArray)) {
            throw new RuntimeException("JSON Array expected.");
        }
        List l = new List();
        l.setObject(this.convertObjToList((JSONArray)o));
        return l;
    }

    public Object NextValue() throws JSONException {
        Object o = ((JSONTokener)this.getObject()).nextValue();
        if (o instanceof JSONObject || o instanceof JSONArray) {
            throw new RuntimeException("Simple value expected.");
        }
        return o;
    }

    private Map.MyMap convertObjToMap(JSONObject j) throws JSONException {
        Map.MyMap m = new Map.MyMap();
        Iterator it = j.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = j.get(key);
            if (JSONObject.NULL.equals(value)) {
                m.put(key, (Object)null);
                continue;
            }
            if (value instanceof JSONObject) {
                m.put(key, this.convertObjToMap((JSONObject)value));
                continue;
            }
            if (value instanceof JSONArray) {
                m.put(key, this.convertObjToList((JSONArray)value));
                continue;
            }
            m.put(key, value);
        }
        return m;
    }

    private ArrayList<Object> convertObjToList(JSONArray ja) throws JSONException {
        ArrayList<Object> a = new ArrayList<Object>(ja.length());
        int i = 0;
        while (i < ja.length()) {
            Object value = ja.get(i);
            if (JSONObject.NULL.equals(value)) {
                a.add(null);
            } else if (value instanceof JSONObject) {
                a.add(this.convertObjToMap((JSONObject)value));
            } else if (value instanceof JSONArray) {
                a.add(this.convertObjToList((JSONArray)value));
            } else {
                a.add(value);
            }
            ++i;
        }
        return a;
    }

    @BA.ShortName(value="JSONGenerator")
    public static class JSONGenerator {
        Object json;

        public void Initialize(Map Map2) throws JSONException {
            this.json = this.convertMapToJO((Map.MyMap)Map2.getObject());
        }

        public void Initialize2(List List2) throws JSONException {
            this.json = this.convertListToJA((java.util.List)List2.getObject());
        }

        public String ToString() {
            if (this.json == null) {
                throw new RuntimeException("JSON was not initialized.");
            }
            if (this.json instanceof JSONObject) {
                return ((JSONObject)this.json).toString();
            }
            return ((JSONArray)this.json).toString();
        }

        public String ToPrettyString(int Indent) throws JSONException {
            if (this.json == null) {
                throw new RuntimeException("JSON was not initialized.");
            }
            if (this.json instanceof JSONObject) {
                return ((JSONObject)this.json).toString(Indent);
            }
            return ((JSONArray)this.json).toString(Indent);
        }

        private JSONObject convertMapToJO(Map.MyMap map) throws JSONException {
            JSONObject j = new JSONObject();
            for (Map.Entry<Object, Object> e : map.entrySet()) {
                String key = String.valueOf(e.getKey());
                Object o = e.getValue();
                if (o instanceof Map.MyMap) {
                    j.put(key, this.convertMapToJO((Map.MyMap)o));
                    continue;
                }
                if (o instanceof Map) {
                    j.put(key, this.convertMapToJO((Map.MyMap)((Map)o).getObject()));
                    continue;
                }
                if (o instanceof java.util.List) {
                    j.put(key, this.convertListToJA((java.util.List)o));
                    continue;
                }
                if (o instanceof List) {
                    j.put(key, this.convertListToJA((java.util.List)((List)o).getObject()));
                    continue;
                }
                if (o == null) {
                    j.put(key, JSONObject.NULL);
                    continue;
                }
                j.put(key, o);
            }
            return j;
        }

        private JSONArray convertListToJA(java.util.List<Object> list) throws JSONException {
            JSONArray ja = new JSONArray();
            for (Object o : list) {
                if (o instanceof Map.MyMap) {
                    ja.put(this.convertMapToJO((Map.MyMap)o));
                    continue;
                }
                if (o instanceof Map) {
                    ja.put(this.convertMapToJO((Map.MyMap)((Map)o).getObject()));
                    continue;
                }
                if (o instanceof java.util.List) {
                    ja.put(this.convertListToJA((java.util.List)o));
                    continue;
                }
                if (o instanceof List) {
                    ja.put(this.convertListToJA((java.util.List)((List)o).getObject()));
                    continue;
                }
                if (o == null) {
                    ja.put(JSONObject.NULL);
                    continue;
                }
                ja.put(o);
            }
            return ja;
        }
    }
}

