/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.animation;

import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.util.Duration;

public class Timer {
    private final Runnable runnable;
    private final java.util.Timer timer;
    private final ObjectProperty<Duration> delayObjectProperty = new SimpleObjectProperty((Object)this, "delay", (Object)Duration.millis((double)0.0));
    private final ObjectProperty<Duration> cycleDurationObjectProperty = new SimpleObjectProperty((Object)this, "cycleDuration", (Object)Duration.millis((double)1000.0));
    private final ObjectProperty<Boolean> repeatsObjectProperty = new SimpleObjectProperty((Object)this, "repeats", (Object)Boolean.TRUE);
    private final AtomicReference<TimerTask> timerTaskAtomicReference = new AtomicReference<Object>(null);

    public Timer(Runnable runnable) {
        this(true, runnable);
    }

    public Timer(boolean isDaemon, Runnable runnable) {
        this.runnable = runnable;
        this.timer = new java.util.Timer(isDaemon);
    }

    public ObjectProperty<Duration> delayProperty() {
        return this.delayObjectProperty;
    }

    public Duration getDelay() {
        return (Duration)this.delayObjectProperty.getValue();
    }

    public void setDelay(Duration value) {
        this.delayObjectProperty.setValue((Object)value);
    }

    public Timer withDelay(Duration value) {
        this.setDelay(value);
        return this;
    }

    public ObjectProperty<Duration> cycleDurationProperty() {
        return this.cycleDurationObjectProperty;
    }

    public Duration getCycleDuration() {
        return (Duration)this.cycleDurationObjectProperty.getValue();
    }

    public void setCycleDuration(Duration value) {
        this.cycleDurationObjectProperty.setValue((Object)value);
    }

    public Timer withCycleDuration(Duration value) {
        this.setCycleDuration(value);
        return this;
    }

    public ObjectProperty<Boolean> repeatsProperty() {
        return this.repeatsObjectProperty;
    }

    public boolean getRepeats() {
        return (Boolean)this.repeatsObjectProperty.getValue();
    }

    public void setRepeats(boolean value) {
        this.repeatsObjectProperty.setValue((Object)value);
    }

    public Timer withRepeats(boolean value) {
        this.setRepeats(value);
        return this;
    }

    public synchronized Timer start() {
        if (this.timerTaskAtomicReference.get() != null) {
            throw new IllegalStateException("Timer already started");
        }
        TimerTask lTimerTask = new TimerTask(){

            @Override
            public void run() {
                Platform.runLater((Runnable)Timer.this.runnable);
                if (!((Boolean)Timer.this.repeatsObjectProperty.getValue()).booleanValue()) {
                    Timer.this.stop();
                }
            }
        };
        this.timer.schedule(lTimerTask, (long)((Duration)this.delayObjectProperty.getValue()).toMillis(), (long)((Duration)this.cycleDurationObjectProperty.getValue()).toMillis());
        this.timerTaskAtomicReference.set(lTimerTask);
        return this;
    }

    public Timer stop() {
        TimerTask lTimerTask = this.timerTaskAtomicReference.getAndSet(null);
        if (lTimerTask != null) {
            lTimerTask.cancel();
        }
        return this;
    }

    public Timer restart() {
        this.stop();
        this.start();
        return this;
    }
}

