/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.dialogs;

import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import jfxtras.labs.dialogs.MonologFXButton;

public class MonologFX
extends Stage {
    private Type type;
    private Scene scene;
    private BorderPane pane = new BorderPane();
    private ImageView icon = new ImageView();
    private Label message = new Label();
    private HBox buttonBox = new HBox(10.0);
    private List<MonologFXButton> buttons = new ArrayList<MonologFXButton>();
    private int buttonCancel = -1;
    private int buttonSelected = -1;
    private ButtonAlignment buttonAlignment = ButtonAlignment.CENTER;
    private List<String> stylesheets = new ArrayList<String>();

    public MonologFX() {
        this.initDialog(Type.INFO);
    }

    public MonologFX(Type t) {
        this.initDialog(t);
    }

    private void addOKButton() {
        MonologFXButton okBtn = new MonologFXButton();
        okBtn.setType(MonologFXButton.Type.OK);
        okBtn.setLabel("_OK");
        okBtn.setCancelButton(true);
        okBtn.setDefaultButton(true);
        this.addButton(okBtn);
    }

    private void addYesNoButtons() {
        MonologFXButton yesBtn = new MonologFXButton();
        yesBtn.setType(MonologFXButton.Type.YES);
        yesBtn.setLabel("_Yes");
        yesBtn.setCancelButton(false);
        yesBtn.setDefaultButton(false);
        this.addButton(yesBtn);
        MonologFXButton noBtn = new MonologFXButton();
        noBtn.setType(MonologFXButton.Type.NO);
        noBtn.setLabel("_No");
        noBtn.setCancelButton(false);
        noBtn.setDefaultButton(false);
        this.addButton(noBtn);
    }

    public void addButton(MonologFXButton btnToAdd) {
        this.buttons.add(btnToAdd);
        final Button btn = new Button();
        btn.setMnemonicParsing(true);
        btn.setText(btnToAdd.getLabel());
        if (btnToAdd.getIcon() != null) {
            btn.setGraphic(btnToAdd.getIcon());
        }
        btn.setDefaultButton(btnToAdd.isDefaultButton());
        if (btnToAdd.isCancelButton()) {
            btn.setCancelButton(true);
            this.buttonCancel = this.buttons.size() - 1;
        }
        if (btn.isDefaultButton()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    btn.requestFocus();
                }
            });
        }
        btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent evt) {
                for (int i = 0; i < MonologFX.this.buttons.size(); ++i) {
                    if (!((MonologFXButton)MonologFX.this.buttons.get(i)).getLabel().equalsIgnoreCase(((Button)evt.getSource()).getText())) continue;
                    MonologFX.this.buttonSelected = i;
                    break;
                }
                ((Stage)((Node)evt.getSource()).getScene().getWindow()).close();
            }
        });
        this.buttonBox.getChildren().add((Object)btn);
    }

    public void addStylesheet(String stylesheet) {
        try {
            String newStyle = ((Object)((Object)this)).getClass().getResource(stylesheet).toExternalForm();
            this.stylesheets.add(newStyle);
        }
        catch (Exception ex) {
            System.err.println("Unable to find specified stylesheet: " + stylesheet);
            System.err.println("Error message: " + ex.getMessage());
        }
    }

    private void initDialog(Type t) {
        this.initStyle(StageStyle.UTILITY);
        this.setType(t);
        this.initModality(Modality.APPLICATION_MODAL);
        this.setMaxWidth(Screen.getPrimary().getVisualBounds().getWidth() / 2.0);
    }

    private void loadIconFromResource(String fileName) {
        Image imgIcon = new Image(((Object)((Object)this)).getClass().getResourceAsStream(fileName));
        this.icon.setPreserveRatio(true);
        this.icon.setFitHeight(48.0);
        this.icon.setImage(imgIcon);
    }

    public void setButtonAlignment(ButtonAlignment buttonAlignment) {
        this.buttonAlignment = buttonAlignment;
    }

    public void setMessage(String msg) {
        this.message.setText(msg);
        this.message.setWrapText(true);
    }

    public void setModal(boolean isModal) {
        this.initModality(isModal ? Modality.APPLICATION_MODAL : Modality.NONE);
    }

    public void setTitleText(String title) {
        this.setTitle(title);
    }

    public void setType(Type typeToSet) {
        this.type = typeToSet;
    }

    public void setPos(double x, double y) {
        this.setX(x);
        this.setY(y);
    }

    private void populateStage() {
        String iconFile;
        switch (this.type) {
            case ACCEPT: {
                iconFile = "Dialog-accept.jpg";
                if (this.buttons.size() != 0) break;
                this.addOKButton();
                break;
            }
            case ERROR: {
                iconFile = "Dialog-error.jpg";
                if (this.buttons.size() != 0) break;
                this.addOKButton();
                break;
            }
            case INFO: {
                iconFile = "Dialog-info.jpg";
                if (this.buttons.size() != 0) break;
                this.addOKButton();
                break;
            }
            case QUESTION: {
                iconFile = "Dialog-question.jpg";
                break;
            }
            default: {
                iconFile = "Dialog-info.jpg";
            }
        }
        try {
            this.loadIconFromResource(iconFile);
        }
        catch (Exception ex) {
            System.err.println("Exception trying to load icon file: " + ex.getMessage());
        }
        BorderPane.setAlignment((Node)this.icon, (Pos)Pos.CENTER_LEFT);
        BorderPane.setMargin((Node)this.icon, (Insets)new Insets(5.0));
        this.pane.setLeft((Node)this.icon);
        BorderPane.setAlignment((Node)this.message, (Pos)Pos.CENTER);
        BorderPane.setMargin((Node)this.message, (Insets)new Insets(5.0));
        this.pane.setCenter((Node)this.message);
        switch (this.buttonAlignment) {
            case LEFT: {
                this.buttonBox.setAlignment(Pos.CENTER_LEFT);
                break;
            }
            case CENTER: {
                this.buttonBox.setAlignment(Pos.CENTER);
                break;
            }
            case RIGHT: {
                this.buttonBox.setAlignment(Pos.CENTER_RIGHT);
            }
        }
        BorderPane.setMargin((Node)this.buttonBox, (Insets)new Insets(5.0));
        this.pane.setBottom((Node)this.buttonBox);
        this.scene = new Scene((Parent)this.pane);
        for (int i = 0; i < this.stylesheets.size(); ++i) {
            try {
                this.scene.getStylesheets().add((Object)this.stylesheets.get(i));
                continue;
            }
            catch (Exception ex) {
                System.err.println("Unable to load specified stylesheet: " + this.stylesheets.get(i));
                System.err.println(ex.getMessage());
            }
        }
        this.setScene(this.scene);
    }

    public MonologFXButton.Type showDialog() {
        this.populateStage();
        if (this.type == Type.QUESTION && this.buttons.size() == 0) {
            this.addYesNoButtons();
        }
        this.setResizable(false);
        this.sizeToScene();
        if (!(this.getX() > -1.0) || !(this.getY() > -1.0)) {
            this.centerOnScreen();
        }
        this.showAndWait();
        if (this.buttonSelected == -1) {
            return this.buttonCancel == -1 ? MonologFXButton.Type.CANCEL : this.buttons.get(this.buttonCancel).getType();
        }
        return this.buttons.get(this.buttonSelected).getType();
    }

    public static enum ButtonAlignment {
        LEFT,
        RIGHT,
        CENTER;

    }

    public static enum Type {
        ACCEPT,
        ERROR,
        INFO,
        QUESTION;

    }
}

