/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.dialogs;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public class MonologFXButton {
    private List<String> defLabels = Arrays.asList("_OK", "_Cancel", "_Abort", "_Retry", "_Ignore", "_Yes", "_No", "Custom_1", "Custom_2", "Custom_3");
    private HashMap<Type, String> defaultLabels = new HashMap();
    private Type type = Type.OK;
    private String label = "";
    private Node icon;
    private boolean defaultButton = false;
    private boolean cancelButton = false;

    public MonologFXButton() {
        int i = 0;
        for (Type t : Type.values()) {
            this.defaultLabels.put(t, this.defLabels.get(i));
            ++i;
        }
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getLabel() {
        if (!this.label.isEmpty()) {
            return this.label;
        }
        String labelToReturn = this.defaultLabels.get((Object)this.getType());
        try {
            ResourceBundle res = ResourceBundle.getBundle("jfxtras/labs/dialogs/MonologFXButton", Locale.getDefault());
            if (res != null) {
                labelToReturn = res.getString(labelToReturn.replaceAll("_", "").toUpperCase());
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return labelToReturn;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Node getIcon() {
        return this.icon;
    }

    public void setIcon(String iconFile) {
        try {
            this.icon = new ImageView(new Image(this.getClass().getResourceAsStream(iconFile)));
        }
        catch (Exception e) {
            System.err.println("Exception trying to load button icon:" + e.getMessage());
        }
    }

    public boolean isDefaultButton() {
        return this.defaultButton;
    }

    public void setDefaultButton(boolean defaultButton) {
        this.defaultButton = defaultButton;
    }

    public boolean isCancelButton() {
        return this.cancelButton;
    }

    public void setCancelButton(boolean cancelButton) {
        this.cancelButton = cancelButton;
    }

    public static enum Type {
        OK,
        CANCEL,
        ABORT,
        RETRY,
        IGNORE,
        YES,
        NO,
        CUSTOM1,
        CUSTOM2,
        CUSTOM3;

    }
}

