/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import jfxtras.labs.internal.scene.control.behavior.BatteryBehavior;
import jfxtras.labs.scene.control.gauge.Battery;
import jfxtras.labs.scene.control.gauge.GradientLookup;

public class BatterySkin
extends SkinBase<Battery, BatteryBehavior> {
    private Battery control;
    private boolean isDirty;
    private boolean initialized;
    private Group background;
    private Group main;
    private Group foreground;
    private Path plug;
    private Path flashFrame;
    private Path flashMain;
    private Rectangle fluid;
    private Rectangle fluidHighlight;
    private GradientLookup lookup;
    private Color currentLevelColor;

    public BatterySkin(Battery CONTROL) {
        super((Control)CONTROL, (BehaviorBase)new BatteryBehavior(CONTROL));
        this.control = CONTROL;
        this.initialized = false;
        this.isDirty = false;
        this.background = new Group();
        this.main = new Group();
        this.foreground = new Group();
        this.plug = new Path();
        this.flashFrame = new Path();
        this.flashMain = new Path();
        this.fluid = new Rectangle();
        this.fluidHighlight = new Rectangle();
        this.lookup = new GradientLookup(this.control.getLevelColors());
        this.currentLevelColor = Color.RED;
        this.init();
    }

    private void init() {
        if (this.control.getPrefWidth() < 0.0 | this.control.getPrefHeight() < 0.0) {
            this.control.setPrefSize(120.0, 255.0);
        }
        if (this.control.getMinWidth() < 0.0 | this.control.getMinHeight() < 0.0) {
            this.control.setMinSize(30.0, 85.0);
        }
        if (this.control.getMaxWidth() < 0.0 | this.control.getMaxHeight() < 0.0) {
            this.control.setMaxSize(1200.0, 2550.0);
        }
        this.registerChangeListener((ObservableValue)this.control.prefWidthProperty(), "PREF_WIDTH");
        this.registerChangeListener((ObservableValue)this.control.prefHeightProperty(), "PREF_HEIGHT");
        this.registerChangeListener((ObservableValue)this.control.chargingProperty(), "CHARGING");
        this.registerChangeListener((ObservableValue)this.control.chargeIndicatorProperty(), "CHARGE_INDICATOR");
        this.registerChangeListener((ObservableValue)this.control.chargingLevelProperty(), "CHARGE_LEVEL");
        this.registerChangeListener((ObservableValue)this.control.levelColorsProperty(), "LEVEL_COLORS");
        this.initialized = true;
        this.repaint();
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        super.handleControlPropertyChanged(PROPERTY);
        if ("CHARGING".equals(PROPERTY)) {
            this.plug.setVisible(this.control.isCharging());
            this.flashFrame.setVisible(this.control.isCharging());
            this.flashMain.setVisible(this.control.isCharging());
        } else if ("CHARGE_INDICATOR".equals(PROPERTY)) {
            if (this.control.getChargeIndicator() == Battery.ChargeIndicator.PLUG) {
                this.plug.setOpacity(1.0);
                this.flashFrame.setOpacity(0.0);
                this.flashMain.setOpacity(0.0);
            } else {
                this.plug.setOpacity(0.0);
                this.flashFrame.setOpacity(1.0);
                this.flashMain.setOpacity(1.0);
            }
        } else if ("CHARGE_LEVEL".equals(PROPERTY)) {
            this.currentLevelColor = this.lookup.getColorAt(this.control.getChargingLevel());
            this.updateFluid();
        } else if ("LEVEL_COLORS".equals(PROPERTY)) {
            this.lookup = new GradientLookup(this.control.getLevelColors());
            this.updateFluid();
        } else if ("PREF_WIDTH".equals(PROPERTY)) {
            this.repaint();
        } else if ("PREF_HEIGHT".equals(PROPERTY)) {
            this.repaint();
        }
    }

    public void repaint() {
        this.isDirty = true;
        this.requestLayout();
    }

    public void layoutChildren() {
        if (!this.isDirty) {
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.control.getScene() != null) {
            this.drawBackground();
            this.drawMain();
            this.drawForeground();
            this.getChildren().setAll((Object[])new Node[]{this.background, this.main, this.foreground});
        }
        this.isDirty = false;
        super.layoutChildren();
    }

    public final Battery getSkinnable() {
        return this.control;
    }

    public final void dispose() {
        this.control = null;
    }

    protected double computePrefWidth(double PREF_WIDTH) {
        double prefWidth = 255.0;
        if (PREF_WIDTH != -1.0) {
            prefWidth = Math.max(0.0, PREF_WIDTH - this.getInsets().getLeft() - this.getInsets().getRight());
        }
        return super.computePrefWidth(prefWidth);
    }

    protected double computePrefHeight(double PREF_HEIGHT) {
        double prefHeight = 255.0;
        if (PREF_HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, PREF_HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom());
        }
        return super.computePrefWidth(prefHeight);
    }

    public final void drawBackground() {
        double SIZE;
        double WIDTH = SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double HEIGHT = SIZE;
        this.background.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        this.background.getChildren().add((Object)IBOUNDS);
        Path EMPTY_BOTTOM = new Path();
        EMPTY_BOTTOM.setFillRule(FillRule.EVEN_ODD);
        EMPTY_BOTTOM.getElements().add((Object)new MoveTo(0.27450980392156865 * WIDTH, 0.9372549019607843 * HEIGHT));
        EMPTY_BOTTOM.getElements().add((Object)new CubicCurveTo(0.27450980392156865 * WIDTH, 0.9294117647058824 * HEIGHT, 0.3764705882352941 * WIDTH, 0.9215686274509803 * HEIGHT, 0.5019607843137255 * WIDTH, 0.9215686274509803 * HEIGHT));
        EMPTY_BOTTOM.getElements().add((Object)new CubicCurveTo(0.6274509803921569 * WIDTH, 0.9215686274509803 * HEIGHT, 0.7294117647058823 * WIDTH, 0.9294117647058824 * HEIGHT, 0.7294117647058823 * WIDTH, 0.9372549019607843 * HEIGHT));
        EMPTY_BOTTOM.getElements().add((Object)new CubicCurveTo(0.7294117647058823 * WIDTH, 0.9450980392156862 * HEIGHT, 0.6274509803921569 * WIDTH, 0.9529411764705882 * HEIGHT, 0.5019607843137255 * WIDTH, 0.9529411764705882 * HEIGHT));
        EMPTY_BOTTOM.getElements().add((Object)new CubicCurveTo(0.3764705882352941 * WIDTH, 0.9529411764705882 * HEIGHT, 0.27450980392156865 * WIDTH, 0.9450980392156862 * HEIGHT, 0.27450980392156865 * WIDTH, 0.9372549019607843 * HEIGHT));
        EMPTY_BOTTOM.getElements().add((Object)new ClosePath());
        Color EMPTY_BOTTOM_FILL = Color.color((double)0.2, (double)0.2, (double)0.2, (double)1.0);
        EMPTY_BOTTOM.setFill((Paint)EMPTY_BOTTOM_FILL);
        EMPTY_BOTTOM.setStroke(null);
        Rectangle EMPTY_BACKGROUND = new Rectangle(0.2745098039 * WIDTH, 0.1137254902 * HEIGHT, 0.4549019608 * WIDTH, 0.8235294118 * HEIGHT);
        LinearGradient EMPTY_BACKGROUND_FILL = new LinearGradient(0.2745098039 * WIDTH, 0.0, 0.2745098039 * WIDTH + 0.4549019608 * WIDTH, 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.2, (double)0.2, (double)0.2, (double)0.15)), new Stop(0.23, Color.color((double)0.4, (double)0.4, (double)0.4, (double)0.13)), new Stop(0.48, Color.color((double)0.9764705882, (double)0.9764705882, (double)0.9764705882, (double)0.1)), new Stop(0.49, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.1)), new Stop(0.81, Color.color((double)0.6, (double)0.6, (double)0.6, (double)0.13)), new Stop(1.0, Color.color((double)0.2, (double)0.2, (double)0.2, (double)0.15))});
        EMPTY_BACKGROUND.setFill((Paint)EMPTY_BACKGROUND_FILL);
        EMPTY_BACKGROUND.setStroke(null);
        this.background.getChildren().addAll((Object[])new Node[]{EMPTY_BOTTOM, EMPTY_BACKGROUND});
        this.background.setCache(true);
    }

    public final void drawMain() {
        double SIZE;
        double WIDTH = SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double HEIGHT = SIZE;
        this.main.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        this.main.getChildren().add((Object)IBOUNDS);
        this.fluid = new Rectangle(0.2745098039 * WIDTH, 0.1137254902 * HEIGHT, 0.4549019608 * WIDTH, 0.8235294118 * HEIGHT);
        LinearGradient FLUID_FILL = new LinearGradient(0.2745098039 * WIDTH, 0.0, 0.2745098039 * WIDTH + 0.4549019608 * WIDTH, 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.1411764706, (double)0.2666666667, (double)0.137254902, (double)1.0)), new Stop(0.23, Color.color((double)0.1647058824, (double)0.5450980392, (double)0.0, (double)1.0)), new Stop(0.49, Color.color((double)0.4666666667, (double)0.8588235294, (double)0.0, (double)1.0)), new Stop(0.81, Color.color((double)0.1647058824, (double)0.5450980392, (double)0.0, (double)1.0)), new Stop(1.0, Color.color((double)0.1411764706, (double)0.2666666667, (double)0.137254902, (double)1.0))});
        this.fluid.setFill((Paint)FLUID_FILL);
        this.fluid.setStroke(null);
        if (Double.compare(this.control.getChargingLevel(), 0.0) == 0) {
            this.fluid.setVisible(false);
        }
        this.fluidHighlight = new Rectangle(0.2745098039 * WIDTH, 0.1137254902 * HEIGHT, 0.4549019608 * WIDTH, 0.0078431373 * HEIGHT);
        LinearGradient FLUID_HIGHLIGHT_FILL = new LinearGradient(0.2745098039 * WIDTH, 0.0, 0.2745098039 * WIDTH + 0.4549019608 * WIDTH, 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.4980392157)), new Stop(0.35, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.7764705882)), new Stop(0.63, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.7843137255)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.4980392157))});
        this.fluidHighlight.setFill((Paint)FLUID_HIGHLIGHT_FILL);
        this.fluidHighlight.setStroke(null);
        this.plug = new Path();
        this.plug.setFillRule(FillRule.EVEN_ODD);
        this.plug.getElements().add((Object)new MoveTo(0.48627450980392156 * WIDTH, 0.4196078431372549 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.48627450980392156 * WIDTH, 0.4196078431372549 * HEIGHT, 0.48627450980392156 * WIDTH, 0.34509803921568627 * HEIGHT, 0.48627450980392156 * WIDTH, 0.34509803921568627 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.48627450980392156 * WIDTH, 0.3411764705882353 * HEIGHT, 0.47843137254901963 * WIDTH, 0.33725490196078434 * HEIGHT, 0.4745098039215686 * WIDTH, 0.33725490196078434 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.4745098039215686 * WIDTH, 0.33725490196078434 * HEIGHT, 0.47058823529411764 * WIDTH, 0.33725490196078434 * HEIGHT, 0.47058823529411764 * WIDTH, 0.33725490196078434 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.4627450980392157 * WIDTH, 0.33725490196078434 * HEIGHT, 0.4588235294117647 * WIDTH, 0.3411764705882353 * HEIGHT, 0.4588235294117647 * WIDTH, 0.34901960784313724 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.4588235294117647 * WIDTH, 0.34901960784313724 * HEIGHT, 0.4588235294117647 * WIDTH, 0.4196078431372549 * HEIGHT, 0.4588235294117647 * WIDTH, 0.4196078431372549 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.43137254901960786 * WIDTH, 0.4196078431372549 * HEIGHT, 0.41568627450980394 * WIDTH, 0.4235294117647059 * HEIGHT, 0.41568627450980394 * WIDTH, 0.4235294117647059 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.41568627450980394 * WIDTH, 0.5137254901960784 * HEIGHT, 0.44313725490196076 * WIDTH, 0.5686274509803921 * HEIGHT, 0.48627450980392156 * WIDTH, 0.5803921568627451 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.48627450980392156 * WIDTH, 0.5803921568627451 * HEIGHT, 0.48627450980392156 * WIDTH, 0.6588235294117647 * HEIGHT, 0.48627450980392156 * WIDTH, 0.6588235294117647 * HEIGHT));
        this.plug.getElements().add((Object)new LineTo(0.5294117647058824 * WIDTH, 0.6588235294117647 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.5294117647058824 * WIDTH, 0.6588235294117647 * HEIGHT, 0.5294117647058824 * WIDTH, 0.5843137254901961 * HEIGHT, 0.5294117647058824 * WIDTH, 0.5843137254901961 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.5725490196078431 * WIDTH, 0.5725490196078431 * HEIGHT, 0.6039215686274509 * WIDTH, 0.5294117647058824 * HEIGHT, 0.6039215686274509 * WIDTH, 0.4235294117647059 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.6039215686274509 * WIDTH, 0.4235294117647059 * HEIGHT, 0.5882352941176471 * WIDTH, 0.4235294117647059 * HEIGHT, 0.5607843137254902 * WIDTH, 0.4196078431372549 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.5607843137254902 * WIDTH, 0.4196078431372549 * HEIGHT, 0.5607843137254902 * WIDTH, 0.34901960784313724 * HEIGHT, 0.5607843137254902 * WIDTH, 0.34901960784313724 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.5607843137254902 * WIDTH, 0.3411764705882353 * HEIGHT, 0.5568627450980392 * WIDTH, 0.33725490196078434 * HEIGHT, 0.5490196078431373 * WIDTH, 0.33725490196078434 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.5490196078431373 * WIDTH, 0.33725490196078434 * HEIGHT, 0.5411764705882353 * WIDTH, 0.33725490196078434 * HEIGHT, 0.5411764705882353 * WIDTH, 0.33725490196078434 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.5333333333333333 * WIDTH, 0.33725490196078434 * HEIGHT, 0.5294117647058824 * WIDTH, 0.3411764705882353 * HEIGHT, 0.5294117647058824 * WIDTH, 0.34901960784313724 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.5294117647058824 * WIDTH, 0.34901960784313724 * HEIGHT, 0.5294117647058824 * WIDTH, 0.4196078431372549 * HEIGHT, 0.5294117647058824 * WIDTH, 0.4196078431372549 * HEIGHT));
        this.plug.getElements().add((Object)new LineTo(0.48627450980392156 * WIDTH, 0.4196078431372549 * HEIGHT));
        this.plug.getElements().add((Object)new ClosePath());
        this.plug.setFill((Paint)Color.rgb((int)75, (int)75, (int)75));
        this.plug.setStroke(null);
        InnerShadow PLUG_INNER_SHADOW = new InnerShadow();
        PLUG_INNER_SHADOW.setWidth(0.01411764705882353 * this.plug.getLayoutBounds().getWidth());
        PLUG_INNER_SHADOW.setHeight(0.01411764705882353 * this.plug.getLayoutBounds().getHeight());
        PLUG_INNER_SHADOW.setOffsetX(0.0);
        PLUG_INNER_SHADOW.setOffsetY(-0.0);
        PLUG_INNER_SHADOW.setRadius(0.01411764705882353 * this.plug.getLayoutBounds().getWidth());
        PLUG_INNER_SHADOW.setColor(Color.BLACK);
        PLUG_INNER_SHADOW.setBlurType(BlurType.GAUSSIAN);
        PLUG_INNER_SHADOW.inputProperty().set(null);
        this.plug.setEffect((Effect)PLUG_INNER_SHADOW);
        if (this.control.getChargeIndicator() == Battery.ChargeIndicator.PLUG) {
            this.plug.setOpacity(1.0);
        } else {
            this.plug.setOpacity(0.0);
        }
        if (!this.control.isCharging()) {
            this.plug.setVisible(false);
        }
        this.flashFrame = new Path();
        this.flashFrame.setFillRule(FillRule.EVEN_ODD);
        this.flashFrame.getElements().add((Object)new MoveTo(0.3568627450980392 * WIDTH, 0.37254901960784315 * HEIGHT));
        this.flashFrame.getElements().add((Object)new LineTo(0.5372549019607843 * WIDTH, 0.6274509803921569 * HEIGHT));
        this.flashFrame.getElements().add((Object)new LineTo(0.5372549019607843 * WIDTH, 0.5254901960784314 * HEIGHT));
        this.flashFrame.getElements().add((Object)new LineTo(0.6392156862745098 * WIDTH, 0.615686274509804 * HEIGHT));
        this.flashFrame.getElements().add((Object)new LineTo(0.49411764705882355 * WIDTH, 0.3843137254901961 * HEIGHT));
        this.flashFrame.getElements().add((Object)new LineTo(0.49411764705882355 * WIDTH, 0.5019607843137255 * HEIGHT));
        this.flashFrame.getElements().add((Object)new LineTo(0.3568627450980392 * WIDTH, 0.37254901960784315 * HEIGHT));
        this.flashFrame.getElements().add((Object)new ClosePath());
        this.flashFrame.setFill((Paint)Color.WHITE);
        this.flashFrame.setStroke(null);
        if (this.control.getChargeIndicator() == Battery.ChargeIndicator.FLASH) {
            this.flashFrame.setOpacity(1.0);
        } else {
            this.flashFrame.setOpacity(0.0);
        }
        if (!this.control.isCharging()) {
            this.flashFrame.setVisible(false);
        }
        this.flashMain = new Path();
        this.flashMain.setFillRule(FillRule.EVEN_ODD);
        this.flashMain.getElements().add((Object)new MoveTo(0.3843137254901961 * WIDTH, 0.403921568627451 * HEIGHT));
        this.flashMain.getElements().add((Object)new LineTo(0.5333333333333333 * WIDTH, 0.611764705882353 * HEIGHT));
        this.flashMain.getElements().add((Object)new LineTo(0.5333333333333333 * WIDTH, 0.5137254901960784 * HEIGHT));
        this.flashMain.getElements().add((Object)new LineTo(0.6196078431372549 * WIDTH, 0.592156862745098 * HEIGHT));
        this.flashMain.getElements().add((Object)new LineTo(0.4980392156862745 * WIDTH, 0.4 * HEIGHT));
        this.flashMain.getElements().add((Object)new LineTo(0.4980392156862745 * WIDTH, 0.5137254901960784 * HEIGHT));
        this.flashMain.getElements().add((Object)new LineTo(0.3843137254901961 * WIDTH, 0.403921568627451 * HEIGHT));
        this.flashMain.getElements().add((Object)new ClosePath());
        this.flashMain.setFill((Paint)Color.color((double)0.9960784314, (double)0.9215686275, (double)0.0, (double)1.0));
        this.flashMain.setStroke(null);
        if (this.control.getChargeIndicator() == Battery.ChargeIndicator.FLASH) {
            this.flashMain.setOpacity(1.0);
        } else {
            this.flashMain.setOpacity(0.0);
        }
        if (!this.control.isCharging()) {
            this.flashMain.setVisible(false);
        }
        InnerShadow FLASH_MAIN_INNER_SHADOW = new InnerShadow();
        FLASH_MAIN_INNER_SHADOW.setWidth(0.08470588235294117 * this.flashMain.getLayoutBounds().getWidth());
        FLASH_MAIN_INNER_SHADOW.setHeight(0.08470588235294117 * this.flashMain.getLayoutBounds().getHeight());
        FLASH_MAIN_INNER_SHADOW.setOffsetX(0.0);
        FLASH_MAIN_INNER_SHADOW.setOffsetY(0.0);
        FLASH_MAIN_INNER_SHADOW.setRadius(0.08470588235294117 * this.flashMain.getLayoutBounds().getWidth());
        FLASH_MAIN_INNER_SHADOW.setColor(Color.color((double)0.8509803922, (double)0.5294117647, (double)0.0, (double)1.0));
        FLASH_MAIN_INNER_SHADOW.setBlurType(BlurType.GAUSSIAN);
        this.flashMain.setEffect((Effect)FLASH_MAIN_INNER_SHADOW);
        this.main.getChildren().addAll((Object[])new Node[]{this.fluid, this.fluidHighlight, this.plug, this.flashFrame, this.flashMain});
    }

    private final void updateFluid() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (Double.compare(BatterySkin.this.control.getChargingLevel(), 0.0) == 0) {
                    BatterySkin.this.fluid.setVisible(false);
                } else {
                    BatterySkin.this.fluid.setVisible(true);
                }
                BatterySkin.this.fluid.setHeight(BatterySkin.this.control.getChargingLevel() * 0.8235294118 * BatterySkin.this.control.getPrefHeight());
                BatterySkin.this.fluid.setY(0.1137254902 * BatterySkin.this.control.getPrefHeight() + (0.8235294118 * BatterySkin.this.control.getPrefHeight() - BatterySkin.this.fluid.getHeight()));
                BatterySkin.this.fluid.setFill((Paint)new LinearGradient(0.0166666667 * BatterySkin.this.control.getPrefWidth(), 0.0, 0.0166666667 * BatterySkin.this.control.getPrefWidth() + 0.9666666667 * BatterySkin.this.control.getPrefWidth(), 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.hsb((double)BatterySkin.this.currentLevelColor.getHue(), (double)BatterySkin.this.currentLevelColor.getSaturation(), (double)0.1)), new Stop(0.2, Color.hsb((double)BatterySkin.this.currentLevelColor.getHue(), (double)BatterySkin.this.currentLevelColor.getSaturation(), (double)0.4)), new Stop(0.5, BatterySkin.this.currentLevelColor), new Stop(0.8, Color.hsb((double)BatterySkin.this.currentLevelColor.getHue(), (double)BatterySkin.this.currentLevelColor.getSaturation(), (double)0.4)), new Stop(1.0, Color.hsb((double)BatterySkin.this.currentLevelColor.getHue(), (double)BatterySkin.this.currentLevelColor.getSaturation(), (double)0.1))}));
                BatterySkin.this.fluidHighlight.setY(0.1137254902 * BatterySkin.this.control.getPrefHeight() + (0.8235294118 * BatterySkin.this.control.getPrefHeight() - BatterySkin.this.fluid.getHeight()));
            }
        });
    }

    public final void drawForeground() {
        double SIZE;
        double WIDTH = SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double HEIGHT = SIZE;
        this.foreground.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        this.foreground.getChildren().add((Object)IBOUNDS);
        Rectangle MAIN_REFLECTION = new Rectangle(0.2705882353 * WIDTH, 0.1137254902 * HEIGHT, 0.462745098 * WIDTH, 0.8235294118 * HEIGHT);
        LinearGradient MAIN_REFLECTION_FILL = new LinearGradient(0.2705882353 * WIDTH, 0.0, 0.2705882353 * WIDTH + 0.462745098 * WIDTH, 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.2862745098)), new Stop(0.04, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.1176470588)), new Stop(0.05, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0470588235)), new Stop(0.11, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0470588235)), new Stop(0.13, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0470588235)), new Stop(0.15, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.168627451)), new Stop(0.151, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.2)), new Stop(0.39, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.031372549)), new Stop(0.43, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0392156863)), new Stop(0.44, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0)), new Stop(0.55, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0901960784)), new Stop(0.56, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0980392157)), new Stop(0.69, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0078431373)), new Stop(0.7, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0352941176)), new Stop(0.78, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0862745098)), new Stop(0.79, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0980392157)), new Stop(0.8, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.1137254902)), new Stop(0.81, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.1490196078)), new Stop(0.89, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.1960784314)), new Stop(0.891, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.2)), new Stop(0.92, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0470588235)), new Stop(0.93, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0470588235)), new Stop(0.96, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0470588235)), new Stop(0.97, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0470588235)), new Stop(0.98, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.2235294118)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.4980392157))});
        MAIN_REFLECTION.setFill((Paint)MAIN_REFLECTION_FILL);
        MAIN_REFLECTION.setStroke(null);
        Path TOP_REFLECTION = new Path();
        TOP_REFLECTION.setFillRule(FillRule.EVEN_ODD);
        TOP_REFLECTION.getElements().add((Object)new MoveTo(0.27058823529411763 * WIDTH, 0.11372549019607843 * HEIGHT));
        TOP_REFLECTION.getElements().add((Object)new LineTo(0.7333333333333333 * WIDTH, 0.11372549019607843 * HEIGHT));
        TOP_REFLECTION.getElements().add((Object)new LineTo(0.7333333333333333 * WIDTH, 0.3176470588235294 * HEIGHT));
        TOP_REFLECTION.getElements().add((Object)new CubicCurveTo(0.7333333333333333 * WIDTH, 0.3176470588235294 * HEIGHT, 0.6705882352941176 * WIDTH, 0.3411764705882353 * HEIGHT, 0.5843137254901961 * WIDTH, 0.41568627450980394 * HEIGHT));
        TOP_REFLECTION.getElements().add((Object)new CubicCurveTo(0.4980392156862745 * WIDTH, 0.47843137254901963 * HEIGHT, 0.396078431372549 * WIDTH, 0.48627450980392156 * HEIGHT, 0.396078431372549 * WIDTH, 0.48627450980392156 * HEIGHT));
        TOP_REFLECTION.getElements().add((Object)new CubicCurveTo(0.34509803921568627 * WIDTH, 0.48627450980392156 * HEIGHT, 0.27058823529411763 * WIDTH, 0.47058823529411764 * HEIGHT, 0.27058823529411763 * WIDTH, 0.47058823529411764 * HEIGHT));
        TOP_REFLECTION.getElements().add((Object)new LineTo(0.27058823529411763 * WIDTH, 0.11372549019607843 * HEIGHT));
        TOP_REFLECTION.getElements().add((Object)new ClosePath());
        LinearGradient TOP_REFLECTION_FILL = new LinearGradient(0.2705882353 * WIDTH, 0.0, 0.2705882353 * WIDTH + 0.462745098 * WIDTH, 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.2862745098)), new Stop(0.04, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.1176470588)), new Stop(0.05, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0470588235)), new Stop(0.11, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0470588235)), new Stop(0.13, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0470588235)), new Stop(0.15, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.168627451)), new Stop(0.151, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.2)), new Stop(0.39, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.031372549)), new Stop(0.43, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0392156863)), new Stop(0.44, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0)), new Stop(0.55, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0901960784)), new Stop(0.56, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0980392157)), new Stop(0.69, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0078431373)), new Stop(0.7, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0352941176)), new Stop(0.78, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0862745098)), new Stop(0.79, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0980392157)), new Stop(0.8, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.1137254902)), new Stop(0.81, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.1490196078)), new Stop(0.89, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.1960784314)), new Stop(0.891, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.2)), new Stop(0.92, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0470588235)), new Stop(0.93, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0470588235)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0470588235))});
        TOP_REFLECTION.setFill((Paint)TOP_REFLECTION_FILL);
        TOP_REFLECTION.setStroke(null);
        Path BOTTOM = new Path();
        BOTTOM.setFillRule(FillRule.EVEN_ODD);
        BOTTOM.getElements().add((Object)new MoveTo(0.26666666666666666 * WIDTH, 0.9490196078431372 * HEIGHT));
        BOTTOM.getElements().add((Object)new CubicCurveTo(0.26666666666666666 * WIDTH, 0.9411764705882353 * HEIGHT, 0.27058823529411763 * WIDTH, 0.9333333333333333 * HEIGHT, 0.2784313725490196 * WIDTH, 0.9333333333333333 * HEIGHT));
        BOTTOM.getElements().add((Object)new CubicCurveTo(0.2784313725490196 * WIDTH, 0.9333333333333333 * HEIGHT, 0.3568627450980392 * WIDTH, 0.9372549019607843 * HEIGHT, 0.5019607843137255 * WIDTH, 0.9372549019607843 * HEIGHT));
        BOTTOM.getElements().add((Object)new CubicCurveTo(0.6431372549019608 * WIDTH, 0.9372549019607843 * HEIGHT, 0.7254901960784313 * WIDTH, 0.9333333333333333 * HEIGHT, 0.7254901960784313 * WIDTH, 0.9333333333333333 * HEIGHT));
        BOTTOM.getElements().add((Object)new CubicCurveTo(0.7333333333333333 * WIDTH, 0.9333333333333333 * HEIGHT, 0.7372549019607844 * WIDTH, 0.9411764705882353 * HEIGHT, 0.7372549019607844 * WIDTH, 0.9490196078431372 * HEIGHT));
        BOTTOM.getElements().add((Object)new CubicCurveTo(0.7372549019607844 * WIDTH, 0.9490196078431372 * HEIGHT, 0.7372549019607844 * WIDTH, 0.9764705882352941 * HEIGHT, 0.7372549019607844 * WIDTH, 0.9764705882352941 * HEIGHT));
        BOTTOM.getElements().add((Object)new CubicCurveTo(0.7372549019607844 * WIDTH, 0.984313725490196 * HEIGHT, 0.7333333333333333 * WIDTH, 0.9921568627450981 * HEIGHT, 0.7254901960784313 * WIDTH, 0.9921568627450981 * HEIGHT));
        BOTTOM.getElements().add((Object)new CubicCurveTo(0.7254901960784313 * WIDTH, 0.9921568627450981 * HEIGHT, 0.6823529411764706 * WIDTH, 0.996078431372549 * HEIGHT, 0.5019607843137255 * WIDTH, 0.996078431372549 * HEIGHT));
        BOTTOM.getElements().add((Object)new CubicCurveTo(0.3254901960784314 * WIDTH, 0.996078431372549 * HEIGHT, 0.2784313725490196 * WIDTH, 0.9921568627450981 * HEIGHT, 0.2784313725490196 * WIDTH, 0.9921568627450981 * HEIGHT));
        BOTTOM.getElements().add((Object)new CubicCurveTo(0.27058823529411763 * WIDTH, 0.9921568627450981 * HEIGHT, 0.26666666666666666 * WIDTH, 0.984313725490196 * HEIGHT, 0.26666666666666666 * WIDTH, 0.9764705882352941 * HEIGHT));
        BOTTOM.getElements().add((Object)new CubicCurveTo(0.26666666666666666 * WIDTH, 0.9764705882352941 * HEIGHT, 0.26666666666666666 * WIDTH, 0.9490196078431372 * HEIGHT, 0.26666666666666666 * WIDTH, 0.9490196078431372 * HEIGHT));
        BOTTOM.getElements().add((Object)new ClosePath());
        LinearGradient BOTTOM_FILL = new LinearGradient(0.26666666666666666 * WIDTH, 0.9607843137254902 * HEIGHT, 0.7372549019607844 * WIDTH, 0.9607843137254902 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.368627451, (double)0.3725490196, (double)0.3803921569, (double)1.0)), new Stop(0.13, Color.color((double)0.2, (double)0.2, (double)0.2, (double)1.0)), new Stop(0.15, Color.color((double)0.9254901961, (double)0.9254901961, (double)0.9333333333, (double)1.0)), new Stop(0.4, Color.color((double)0.6156862745, (double)0.6196078431, (double)0.6274509804, (double)1.0)), new Stop(0.44, Color.BLACK), new Stop(0.78, Color.color((double)0.0862745098, (double)0.0784313725, (double)0.0901960784, (double)1.0)), new Stop(0.89, Color.color((double)0.9294117647, (double)0.9294117647, (double)0.9294117647, (double)1.0)), new Stop(0.92, Color.color((double)0.0980392157, (double)0.0901960784, (double)0.1058823529, (double)1.0)), new Stop(0.97, Color.BLACK), new Stop(1.0, Color.color((double)0.3803921569, (double)0.3921568627, (double)0.4117647059, (double)1.0))});
        BOTTOM.setFill((Paint)BOTTOM_FILL);
        BOTTOM.setStroke(null);
        InnerShadow BOTTOM_INNER_SHADOW0 = new InnerShadow();
        BOTTOM_INNER_SHADOW0.setWidth(0.07058823529411765 * BOTTOM.getLayoutBounds().getWidth());
        BOTTOM_INNER_SHADOW0.setHeight(0.07058823529411765 * BOTTOM.getLayoutBounds().getHeight());
        BOTTOM_INNER_SHADOW0.setOffsetX(0.0);
        BOTTOM_INNER_SHADOW0.setOffsetY(0.0);
        BOTTOM_INNER_SHADOW0.setRadius(0.07058823529411765 * BOTTOM.getLayoutBounds().getWidth());
        BOTTOM_INNER_SHADOW0.setColor(Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.6470588235));
        BOTTOM_INNER_SHADOW0.setBlurType(BlurType.GAUSSIAN);
        BOTTOM_INNER_SHADOW0.inputProperty().set(null);
        BOTTOM.setEffect((Effect)BOTTOM_INNER_SHADOW0);
        Path HEAD = new Path();
        HEAD.setFillRule(FillRule.EVEN_ODD);
        HEAD.getElements().add((Object)new MoveTo(0.26666666666666666 * WIDTH, 0.07058823529411765 * HEIGHT));
        HEAD.getElements().add((Object)new CubicCurveTo(0.26666666666666666 * WIDTH, 0.06274509803921569 * HEIGHT, 0.27058823529411763 * WIDTH, 0.054901960784313725 * HEIGHT, 0.2784313725490196 * WIDTH, 0.054901960784313725 * HEIGHT));
        HEAD.getElements().add((Object)new CubicCurveTo(0.2784313725490196 * WIDTH, 0.054901960784313725 * HEIGHT, 0.3568627450980392 * WIDTH, 0.058823529411764705 * HEIGHT, 0.5019607843137255 * WIDTH, 0.058823529411764705 * HEIGHT));
        HEAD.getElements().add((Object)new CubicCurveTo(0.6431372549019608 * WIDTH, 0.058823529411764705 * HEIGHT, 0.7254901960784313 * WIDTH, 0.054901960784313725 * HEIGHT, 0.7254901960784313 * WIDTH, 0.054901960784313725 * HEIGHT));
        HEAD.getElements().add((Object)new CubicCurveTo(0.7333333333333333 * WIDTH, 0.054901960784313725 * HEIGHT, 0.7372549019607844 * WIDTH, 0.06274509803921569 * HEIGHT, 0.7372549019607844 * WIDTH, 0.07058823529411765 * HEIGHT));
        HEAD.getElements().add((Object)new CubicCurveTo(0.7372549019607844 * WIDTH, 0.07058823529411765 * HEIGHT, 0.7372549019607844 * WIDTH, 0.09803921568627451 * HEIGHT, 0.7372549019607844 * WIDTH, 0.09803921568627451 * HEIGHT));
        HEAD.getElements().add((Object)new CubicCurveTo(0.7372549019607844 * WIDTH, 0.10588235294117647 * HEIGHT, 0.7333333333333333 * WIDTH, 0.11372549019607843 * HEIGHT, 0.7254901960784313 * WIDTH, 0.11372549019607843 * HEIGHT));
        HEAD.getElements().add((Object)new CubicCurveTo(0.7254901960784313 * WIDTH, 0.11372549019607843 * HEIGHT, 0.6823529411764706 * WIDTH, 0.11764705882352941 * HEIGHT, 0.5019607843137255 * WIDTH, 0.11764705882352941 * HEIGHT));
        HEAD.getElements().add((Object)new CubicCurveTo(0.3254901960784314 * WIDTH, 0.12156862745098039 * HEIGHT, 0.2784313725490196 * WIDTH, 0.11372549019607843 * HEIGHT, 0.2784313725490196 * WIDTH, 0.11372549019607843 * HEIGHT));
        HEAD.getElements().add((Object)new CubicCurveTo(0.27058823529411763 * WIDTH, 0.11372549019607843 * HEIGHT, 0.26666666666666666 * WIDTH, 0.10588235294117647 * HEIGHT, 0.26666666666666666 * WIDTH, 0.09803921568627451 * HEIGHT));
        HEAD.getElements().add((Object)new CubicCurveTo(0.26666666666666666 * WIDTH, 0.09803921568627451 * HEIGHT, 0.26666666666666666 * WIDTH, 0.07058823529411765 * HEIGHT, 0.26666666666666666 * WIDTH, 0.07058823529411765 * HEIGHT));
        HEAD.getElements().add((Object)new ClosePath());
        LinearGradient HEAD_FILL = new LinearGradient(0.26666666666666666 * WIDTH, 0.08235294117647059 * HEIGHT, 0.7372549019607844 * WIDTH, 0.08235294117647059 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.368627451, (double)0.3725490196, (double)0.3803921569, (double)1.0)), new Stop(0.13, Color.color((double)0.2, (double)0.2, (double)0.2, (double)1.0)), new Stop(0.15, Color.color((double)0.9254901961, (double)0.9254901961, (double)0.9333333333, (double)1.0)), new Stop(0.4, Color.color((double)0.6156862745, (double)0.6196078431, (double)0.6274509804, (double)1.0)), new Stop(0.44, Color.BLACK), new Stop(0.78, Color.color((double)0.0862745098, (double)0.0784313725, (double)0.0901960784, (double)1.0)), new Stop(0.89, Color.color((double)0.9294117647, (double)0.9294117647, (double)0.9294117647, (double)1.0)), new Stop(0.92, Color.color((double)0.0980392157, (double)0.0901960784, (double)0.1058823529, (double)1.0)), new Stop(0.97, Color.BLACK), new Stop(1.0, Color.color((double)0.3803921569, (double)0.3921568627, (double)0.4117647059, (double)1.0))});
        HEAD.setFill((Paint)HEAD_FILL);
        HEAD.setStroke(null);
        InnerShadow HEAD_INNER_SHADOW0 = new InnerShadow();
        HEAD_INNER_SHADOW0.setWidth(0.07058823529411765 * HEAD.getLayoutBounds().getWidth());
        HEAD_INNER_SHADOW0.setHeight(0.07058823529411765 * HEAD.getLayoutBounds().getHeight());
        HEAD_INNER_SHADOW0.setOffsetX(0.0);
        HEAD_INNER_SHADOW0.setOffsetY(0.0);
        HEAD_INNER_SHADOW0.setRadius(0.07058823529411765 * HEAD.getLayoutBounds().getWidth());
        HEAD_INNER_SHADOW0.setColor(Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.6470588235));
        HEAD_INNER_SHADOW0.setBlurType(BlurType.GAUSSIAN);
        HEAD_INNER_SHADOW0.inputProperty().set(null);
        HEAD.setEffect((Effect)HEAD_INNER_SHADOW0);
        Path HEADHIGHLIGHT = new Path();
        HEADHIGHLIGHT.setFillRule(FillRule.EVEN_ODD);
        HEADHIGHLIGHT.getElements().add((Object)new MoveTo(0.3843137254901961 * WIDTH, 0.058823529411764705 * HEIGHT));
        HEADHIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.3843137254901961 * WIDTH, 0.058823529411764705 * HEIGHT, 0.2784313725490196 * WIDTH, 0.054901960784313725 * HEIGHT, 0.2784313725490196 * WIDTH, 0.054901960784313725 * HEIGHT));
        HEADHIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.28627450980392155 * WIDTH, 0.07058823529411765 * HEIGHT, 0.30980392156862746 * WIDTH, 0.08235294117647059 * HEIGHT, 0.3333333333333333 * WIDTH, 0.08235294117647059 * HEIGHT));
        HEADHIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.3568627450980392 * WIDTH, 0.08235294117647059 * HEIGHT, 0.3803921568627451 * WIDTH, 0.07450980392156863 * HEIGHT, 0.3843137254901961 * WIDTH, 0.058823529411764705 * HEIGHT));
        HEADHIGHLIGHT.getElements().add((Object)new ClosePath());
        RadialGradient HEADHIGHLIGHT_FILL = new RadialGradient(0.0, 0.0, 0.3333333333333333 * WIDTH, 0.047058823529411764 * HEIGHT, 0.049019607843137254 * WIDTH, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.WHITE), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0))});
        HEADHIGHLIGHT.setFill((Paint)HEADHIGHLIGHT_FILL);
        HEADHIGHLIGHT.setStroke(null);
        Path CONNTECTORFRAME = new Path();
        CONNTECTORFRAME.setFillRule(FillRule.EVEN_ODD);
        CONNTECTORFRAME.getElements().add((Object)new MoveTo(0.3803921568627451 * WIDTH, 0.011764705882352941 * HEIGHT));
        CONNTECTORFRAME.getElements().add((Object)new CubicCurveTo(0.3803921568627451 * WIDTH, 0.00784313725490196 * HEIGHT, 0.3843137254901961 * WIDTH, 0.00392156862745098 * HEIGHT, 0.38823529411764707 * WIDTH, 0.00392156862745098 * HEIGHT));
        CONNTECTORFRAME.getElements().add((Object)new CubicCurveTo(0.38823529411764707 * WIDTH, 0.00392156862745098 * HEIGHT, 0.41568627450980394 * WIDTH, 0.0, 0.41568627450980394 * WIDTH, 0.0));
        CONNTECTORFRAME.getElements().add((Object)new LineTo(0.5725490196078431 * WIDTH, 0.0));
        CONNTECTORFRAME.getElements().add((Object)new CubicCurveTo(0.5725490196078431 * WIDTH, 0.0, 0.6078431372549019 * WIDTH, 0.00392156862745098 * HEIGHT, 0.6078431372549019 * WIDTH, 0.00392156862745098 * HEIGHT));
        CONNTECTORFRAME.getElements().add((Object)new CubicCurveTo(0.6078431372549019 * WIDTH, 0.00392156862745098 * HEIGHT, 0.611764705882353 * WIDTH, 0.00784313725490196 * HEIGHT, 0.611764705882353 * WIDTH, 0.011764705882352941 * HEIGHT));
        CONNTECTORFRAME.getElements().add((Object)new CubicCurveTo(0.611764705882353 * WIDTH, 0.011764705882352941 * HEIGHT, 0.611764705882353 * WIDTH, 0.050980392156862744 * HEIGHT, 0.611764705882353 * WIDTH, 0.050980392156862744 * HEIGHT));
        CONNTECTORFRAME.getElements().add((Object)new CubicCurveTo(0.611764705882353 * WIDTH, 0.054901960784313725 * HEIGHT, 0.6078431372549019 * WIDTH, 0.058823529411764705 * HEIGHT, 0.6078431372549019 * WIDTH, 0.058823529411764705 * HEIGHT));
        CONNTECTORFRAME.getElements().add((Object)new CubicCurveTo(0.6078431372549019 * WIDTH, 0.058823529411764705 * HEIGHT, 0.38823529411764707 * WIDTH, 0.058823529411764705 * HEIGHT, 0.38823529411764707 * WIDTH, 0.058823529411764705 * HEIGHT));
        CONNTECTORFRAME.getElements().add((Object)new CubicCurveTo(0.3843137254901961 * WIDTH, 0.058823529411764705 * HEIGHT, 0.3803921568627451 * WIDTH, 0.054901960784313725 * HEIGHT, 0.3803921568627451 * WIDTH, 0.050980392156862744 * HEIGHT));
        CONNTECTORFRAME.getElements().add((Object)new CubicCurveTo(0.3803921568627451 * WIDTH, 0.050980392156862744 * HEIGHT, 0.3803921568627451 * WIDTH, 0.011764705882352941 * HEIGHT, 0.3803921568627451 * WIDTH, 0.011764705882352941 * HEIGHT));
        CONNTECTORFRAME.getElements().add((Object)new ClosePath());
        LinearGradient CONNTECTORFRAME_FILL = new LinearGradient(0.3803921568627451 * WIDTH, 0.03137254901960784 * HEIGHT, 0.6078431372549019 * WIDTH, 0.03137254901960784 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.8784313725, (double)0.8588235294, (double)0.8666666667, (double)1.0)), new Stop(1.0, Color.color((double)0.1647058824, (double)0.1450980392, (double)0.1921568627, (double)1.0))});
        CONNTECTORFRAME.setFill((Paint)CONNTECTORFRAME_FILL);
        CONNTECTORFRAME.setStroke(null);
        Path CONNECTORMAIN = new Path();
        CONNECTORMAIN.setFillRule(FillRule.EVEN_ODD);
        CONNECTORMAIN.getElements().add((Object)new MoveTo(0.3843137254901961 * WIDTH, 0.01568627450980392 * HEIGHT));
        CONNECTORMAIN.getElements().add((Object)new CubicCurveTo(0.3843137254901961 * WIDTH, 0.011764705882352941 * HEIGHT, 0.38823529411764707 * WIDTH, 0.00784313725490196 * HEIGHT, 0.39215686274509803 * WIDTH, 0.00784313725490196 * HEIGHT));
        CONNECTORMAIN.getElements().add((Object)new CubicCurveTo(0.39215686274509803 * WIDTH, 0.00784313725490196 * HEIGHT, 0.4117647058823529 * WIDTH, 0.00392156862745098 * HEIGHT, 0.4117647058823529 * WIDTH, 0.00392156862745098 * HEIGHT));
        CONNECTORMAIN.getElements().add((Object)new LineTo(0.5803921568627451 * WIDTH, 0.00392156862745098 * HEIGHT));
        CONNECTORMAIN.getElements().add((Object)new CubicCurveTo(0.5803921568627451 * WIDTH, 0.00392156862745098 * HEIGHT, 0.6039215686274509 * WIDTH, 0.00784313725490196 * HEIGHT, 0.6039215686274509 * WIDTH, 0.00784313725490196 * HEIGHT));
        CONNECTORMAIN.getElements().add((Object)new CubicCurveTo(0.6039215686274509 * WIDTH, 0.00784313725490196 * HEIGHT, 0.6078431372549019 * WIDTH, 0.011764705882352941 * HEIGHT, 0.6078431372549019 * WIDTH, 0.01568627450980392 * HEIGHT));
        CONNECTORMAIN.getElements().add((Object)new CubicCurveTo(0.6078431372549019 * WIDTH, 0.01568627450980392 * HEIGHT, 0.6078431372549019 * WIDTH, 0.047058823529411764 * HEIGHT, 0.6078431372549019 * WIDTH, 0.047058823529411764 * HEIGHT));
        CONNECTORMAIN.getElements().add((Object)new CubicCurveTo(0.6078431372549019 * WIDTH, 0.050980392156862744 * HEIGHT, 0.6039215686274509 * WIDTH, 0.054901960784313725 * HEIGHT, 0.6039215686274509 * WIDTH, 0.054901960784313725 * HEIGHT));
        CONNECTORMAIN.getElements().add((Object)new CubicCurveTo(0.6039215686274509 * WIDTH, 0.054901960784313725 * HEIGHT, 0.39215686274509803 * WIDTH, 0.054901960784313725 * HEIGHT, 0.39215686274509803 * WIDTH, 0.054901960784313725 * HEIGHT));
        CONNECTORMAIN.getElements().add((Object)new CubicCurveTo(0.38823529411764707 * WIDTH, 0.054901960784313725 * HEIGHT, 0.3843137254901961 * WIDTH, 0.050980392156862744 * HEIGHT, 0.3843137254901961 * WIDTH, 0.047058823529411764 * HEIGHT));
        CONNECTORMAIN.getElements().add((Object)new CubicCurveTo(0.3843137254901961 * WIDTH, 0.047058823529411764 * HEIGHT, 0.3843137254901961 * WIDTH, 0.01568627450980392 * HEIGHT, 0.3843137254901961 * WIDTH, 0.01568627450980392 * HEIGHT));
        CONNECTORMAIN.getElements().add((Object)new ClosePath());
        LinearGradient CONNECTORMAIN_FILL = new LinearGradient(0.3843137254901961 * WIDTH, 0.027450980392156862 * HEIGHT, 0.6039215686274509 * WIDTH, 0.027450980392156862 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.8156862745, (double)0.8196078431, (double)0.8470588235, (double)1.0)), new Stop(0.11, Color.color((double)0.2, (double)0.2, (double)0.2, (double)1.0)), new Stop(0.13, Color.color((double)0.9254901961, (double)0.9254901961, (double)0.9333333333, (double)1.0)), new Stop(0.38, Color.color((double)0.6156862745, (double)0.6196078431, (double)0.6274509804, (double)1.0)), new Stop(0.45, Color.BLACK), new Stop(0.78, Color.color((double)0.0862745098, (double)0.0784313725, (double)0.0901960784, (double)1.0)), new Stop(0.92, Color.color((double)0.9294117647, (double)0.9294117647, (double)0.9294117647, (double)1.0)), new Stop(0.95, Color.color((double)0.0980392157, (double)0.0901960784, (double)0.1058823529, (double)1.0)), new Stop(0.98, Color.BLACK), new Stop(1.0, Color.color((double)0.3803921569, (double)0.3921568627, (double)0.4117647059, (double)1.0))});
        CONNECTORMAIN.setFill((Paint)CONNECTORMAIN_FILL);
        CONNECTORMAIN.setStroke(null);
        Path CONNECTORHIGHLIGHT = new Path();
        CONNECTORHIGHLIGHT.setFillRule(FillRule.EVEN_ODD);
        CONNECTORHIGHLIGHT.getElements().add((Object)new MoveTo(0.4980392156862745 * WIDTH, 0.0));
        CONNECTORHIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.4980392156862745 * WIDTH, 0.0, 0.4196078431372549 * WIDTH, 0.0, 0.4196078431372549 * WIDTH, 0.0));
        CONNECTORHIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.42745098039215684 * WIDTH, 0.01568627450980392 * HEIGHT, 0.4392156862745098 * WIDTH, 0.03529411764705882 * HEIGHT, 0.4588235294117647 * WIDTH, 0.03529411764705882 * HEIGHT));
        CONNECTORHIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.4823529411764706 * WIDTH, 0.03529411764705882 * HEIGHT, 0.49411764705882355 * WIDTH, 0.01568627450980392 * HEIGHT, 0.4980392156862745 * WIDTH, 0.0));
        CONNECTORHIGHLIGHT.getElements().add((Object)new ClosePath());
        RadialGradient CONNECTORHIGHLIGHT_FILL = new RadialGradient(0.0, 0.0, 0.4588235294117647 * WIDTH, 0.0, 0.03333333333333333 * WIDTH, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.WHITE), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0))});
        CONNECTORHIGHLIGHT.setFill((Paint)CONNECTORHIGHLIGHT_FILL);
        CONNECTORHIGHLIGHT.setStroke(null);
        this.foreground.getChildren().addAll((Object[])new Node[]{MAIN_REFLECTION, TOP_REFLECTION, BOTTOM, HEAD, HEADHIGHLIGHT, CONNTECTORFRAME, CONNECTORMAIN, CONNECTORHIGHLIGHT});
        this.foreground.setCache(true);
    }
}

