/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import java.math.BigDecimal;
import java.text.ParseException;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import jfxtras.labs.internal.scene.control.behavior.BigDecimalFieldBehaviour;
import jfxtras.labs.scene.control.BigDecimalField;

public class BigDecimalFieldSkin
extends SkinBase<BigDecimalField, BigDecimalFieldBehaviour> {
    private BigDecimalField CONTROL;
    private NumberTextField textField;
    private StackPane btnUp;
    private StackPane btnDown;
    private Path arrowUp;
    private Path arrowDown;
    private final double ARROW_SIZE = 4.0;
    private final double ARROW_HEIGHT = 0.7;

    public BigDecimalFieldSkin(BigDecimalField control) {
        super((Control)control, (BehaviorBase)new BigDecimalFieldBehaviour(control));
        this.CONTROL = control;
        this.createNodes();
        this.initFocusSimulation();
        this.requestLayout();
    }

    public BigDecimalField getSkinnable() {
        return this.CONTROL;
    }

    private void createNodes() {
        this.textField = new NumberTextField();
        this.textField.promptTextProperty().bind((ObservableValue)this.CONTROL.promptTextProperty());
        this.btnUp = new StackPane();
        this.btnUp.getStyleClass().add((Object)"arrow-button");
        this.arrowUp = new Path();
        this.arrowUp.getStyleClass().add((Object)"spinner-arrow");
        this.arrowUp.getElements().addAll((Object[])new PathElement[]{new MoveTo(-4.0, 0.0), new LineTo(0.0, -2.8), new LineTo(4.0, 0.0)});
        this.btnUp.getChildren().add((Object)this.arrowUp);
        this.btnDown = new StackPane();
        this.btnDown.getStyleClass().add((Object)"arrow-button");
        this.arrowDown = new Path();
        this.arrowDown.getStyleClass().add((Object)"spinner-arrow");
        this.arrowDown.getElements().addAll((Object[])new PathElement[]{new MoveTo(-4.0, 0.0), new LineTo(0.0, 2.8), new LineTo(4.0, 0.0)});
        this.btnDown.getChildren().add((Object)this.arrowDown);
        this.getChildren().addAll((Object[])new Node[]{this.textField, this.btnUp, this.btnDown});
        this.btnUp.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                BigDecimalFieldSkin.this.CONTROL.increment();
            }
        });
        this.btnDown.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                BigDecimalFieldSkin.this.CONTROL.decrement();
            }
        });
    }

    protected void layoutChildren() {
        super.layoutChildren();
        Insets insets = this.getInsets();
        double x = insets.getLeft();
        double y = insets.getTop();
        double textfieldHeight = this.getHeight() - insets.getTop() - insets.getBottom();
        double buttonWidth = this.textField.prefHeight(-1.0);
        double textfieldWidth = this.getWidth() - insets.getLeft() - insets.getRight() - buttonWidth;
        this.layoutInArea((Node)this.textField, x, y, textfieldWidth, textfieldHeight, Double.NEGATIVE_INFINITY, HPos.LEFT, VPos.TOP);
        this.layoutInArea((Node)this.btnUp, x + textfieldWidth, y, buttonWidth, textfieldHeight / 2.0, Double.NEGATIVE_INFINITY, HPos.LEFT, VPos.TOP);
        this.layoutInArea((Node)this.btnDown, x + textfieldWidth, y + textfieldHeight / 2.0, buttonWidth, textfieldHeight / 2.0, Double.NEGATIVE_INFINITY, HPos.LEFT, VPos.TOP);
    }

    protected double computePrefWidth(double PREF_WIDTH) {
        super.computePrefWidth(PREF_WIDTH);
        double prefWidth = this.getInsets().getLeft() + this.textField.prefWidth(PREF_WIDTH) + this.textField.prefHeight(PREF_WIDTH) + this.getInsets().getRight();
        return prefWidth;
    }

    private void initFocusSimulation() {
        this.CONTROL.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean wasFocused, Boolean isFocused) {
                if (isFocused.booleanValue()) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            BigDecimalFieldSkin.this.textField.requestFocus();
                        }
                    });
                }
            }
        });
        this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean wasFocused, Boolean isFocused) {
                if (isFocused.booleanValue()) {
                    BigDecimalFieldSkin.this.CONTROL.getStyleClass().add((Object)"big-decimal-field-focused");
                } else {
                    BigDecimalFieldSkin.this.CONTROL.getStyleClass().remove((Object)"big-decimal-field-focused");
                }
            }
        });
    }

    public class NumberTextField
    extends TextField {
        public NumberTextField() {
            this.getStyleClass().add((Object)"number-text-field");
            this.initHandlers();
            this.setText(BigDecimalFieldSkin.this.CONTROL.getText());
        }

        private void initHandlers() {
            this.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent arg0) {
                    NumberTextField.this.parseAndFormatInput();
                }
            });
            this.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (!newValue.booleanValue()) {
                        NumberTextField.this.parseAndFormatInput();
                    }
                }
            });
            BigDecimalFieldSkin.this.CONTROL.numberProperty().addListener(new InvalidationListener(){

                public void invalidated(Observable arg0) {
                    NumberTextField.this.setText(BigDecimalFieldSkin.this.CONTROL.getText());
                }
            });
            this.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent keyEvent) {
                    if (keyEvent.getCode() == KeyCode.DOWN) {
                        BigDecimalFieldSkin.this.CONTROL.decrement();
                        keyEvent.consume();
                    }
                    if (keyEvent.getCode() == KeyCode.UP) {
                        BigDecimalFieldSkin.this.CONTROL.increment();
                        keyEvent.consume();
                    }
                }
            });
        }

        private void parseAndFormatInput() {
            try {
                String input = this.getText();
                if (input == null || input.length() == 0) {
                    BigDecimalFieldSkin.this.CONTROL.setNumber(null);
                    return;
                }
                Number parsedNumber = BigDecimalFieldSkin.this.CONTROL.getFormat().parse(input);
                BigDecimal newValue = new BigDecimal(parsedNumber.toString());
                BigDecimalFieldSkin.this.CONTROL.setNumber(newValue);
                this.selectAll();
            }
            catch (ParseException ex) {
                this.setText(BigDecimalFieldSkin.this.CONTROL.getText());
            }
            catch (IllegalArgumentException ex) {
                this.setText(BigDecimalFieldSkin.this.CONTROL.getText());
            }
        }
    }
}

