/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import java.util.ArrayList;
import java.util.List;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.SVGPath;
import jfxtras.labs.scene.control.BreadcrumbItem;

public class BreadcrumbItemSkin
extends SkinBase<BreadcrumbItem, BehaviorBase<BreadcrumbItem>> {
    public BreadcrumbItemSkin(BreadcrumbItem c) {
        super((Control)c, new BehaviorBase((Control)c));
        HBox box = new HBox();
        final SVGPath leftSide = new SVGPath();
        if (!c.isFirst()) {
            leftSide.setContent("M0 0 L15 0 l0 30 L0 30 l10 -15 Z");
        } else {
            leftSide.setContent("M0 0 L15 0 l0 30 L0 30 Z");
        }
        leftSide.getStyleClass().add((Object)"breadcrumbitem-ui");
        final SVGPath rightSide = new SVGPath();
        rightSide.setContent("M0,0 L5,0 15,15 5,30 0,30 Z");
        rightSide.getStyleClass().add((Object)"breadcrumbitem-ui");
        rightSide.setLayoutY(10.0);
        final StackPane stackPane = new StackPane();
        stackPane.getStyleClass().add((Object)"breadcrumbitem-ui");
        stackPane.setAlignment(Pos.CENTER);
        HBox stackContent = new HBox(10.0);
        stackContent.setAlignment(Pos.CENTER);
        stackPane.getChildren().add((Object)stackContent);
        box.getChildren().add((Object)leftSide);
        box.getChildren().add((Object)stackPane);
        final Label textLabel = new Label();
        if (c != null) {
            if (c.getIcon() != null) {
                ImageView iv = new ImageView(c.getIcon());
                iv.setPreserveRatio(true);
                iv.setFitHeight(20.0);
                stackContent.getChildren().add((Object)iv);
            }
            if (c.getSvgIcon() != null) {
                stackContent.getChildren().add((Object)c.getSvgIcon());
            }
            if (c.getText() != null) {
                textLabel.setText(c.getText());
                textLabel.getStyleClass().add((Object)"breadcrumbitem-text");
                stackContent.getChildren().add((Object)textLabel);
            }
        }
        box.getChildren().add((Object)rightSide);
        leftSide.addEventHandler(MouseEvent.ANY, (EventHandler)new BreadcrumbItemMouseHandler(){
            {
                this.getNodes().add((Node)rightSide);
                this.getNodes().add((Node)stackPane);
                if (!textLabel.getText().isEmpty()) {
                    this.getNodes().add((Node)textLabel);
                }
            }
        });
        rightSide.addEventHandler(MouseEvent.ANY, (EventHandler)new BreadcrumbItemMouseHandler(){
            {
                this.getNodes().add((Node)leftSide);
                this.getNodes().add((Node)stackPane);
                if (!textLabel.getText().isEmpty()) {
                    this.getNodes().add((Node)textLabel);
                }
            }
        });
        stackPane.addEventHandler(MouseEvent.ANY, (EventHandler)new BreadcrumbItemMouseHandler(){
            {
                this.getNodes().add((Node)rightSide);
                this.getNodes().add((Node)leftSide);
                if (!textLabel.getText().isEmpty()) {
                    this.getNodes().add((Node)textLabel);
                }
            }
        });
        box.setPrefHeight(c.getBreadcrumbBar().getPrefHeight());
        this.getChildren().add((Object)box);
    }

    private class BreadcrumbItemMouseHandler
    implements EventHandler<MouseEvent> {
        List<Node> nodes = null;

        private BreadcrumbItemMouseHandler() {
        }

        public List<Node> getNodes() {
            if (this.nodes == null) {
                this.nodes = new ArrayList<Node>();
            }
            return this.nodes;
        }

        public void handle(MouseEvent event) {
            block3: {
                block2: {
                    if (!event.getEventType().equals(MouseEvent.MOUSE_ENTERED)) break block2;
                    for (Node node : this.getNodes()) {
                        node.getStyleClass().add((Object)"breadcrumbitem-ui-hover");
                        node.getStyleClass().add((Object)"breadcrumbitem-text-hover");
                    }
                    break block3;
                }
                if (!event.getEventType().equals(MouseEvent.MOUSE_EXITED)) break block3;
                for (Node node : this.getNodes()) {
                    node.getStyleClass().remove((Object)"breadcrumbitem-ui-hover");
                    node.getStyleClass().remove((Object)"breadcrumbitem-text-hover");
                }
            }
        }
    }
}

