/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Popup;
import jfxtras.labs.internal.scene.control.behavior.CalendarTextFieldBehavior;
import jfxtras.labs.scene.control.CalendarPicker;
import jfxtras.labs.scene.control.CalendarTextField;
import jfxtras.labs.util.NodeUtil;

public class CalendarTextFieldCaspianSkin
extends SkinBase<CalendarTextField, CalendarTextFieldBehavior> {
    private TextField textField = null;
    private ImageView imageView = null;
    private GridPane gridPane = null;
    private CalendarPicker calendarPicker = null;
    private Image closeIconImage = null;
    private static final Date DATE_WITH_TIME = new GregorianCalendar(1111, 0, 1, 2, 2, 2).getTime();
    private Popup popup = null;

    public CalendarTextFieldCaspianSkin(CalendarTextField control) {
        super((Control)control, (BehaviorBase)new CalendarTextFieldBehavior(control));
        this.construct();
    }

    private void construct() {
        this.createNodes();
        ((CalendarTextField)this.getSkinnable()).valueProperty().addListener((ChangeListener)new ChangeListener<Calendar>(){

            public void changed(ObservableValue<? extends Calendar> observableValue, Calendar oldValue, Calendar newValue) {
                CalendarTextFieldCaspianSkin.this.refreshValue();
            }
        });
        this.refreshValue();
        this.initFocusSimulation();
    }

    private void refreshValue() {
        Calendar c = ((CalendarTextField)this.getSkinnable()).getValue();
        String s = c == null ? "" : ((CalendarTextField)this.getSkinnable()).getDateFormat().format(c.getTime());
        this.textField.setText(s);
    }

    private void initFocusSimulation() {
        ((CalendarTextField)this.getSkinnable()).focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean wasFocused, Boolean isFocused) {
                if (isFocused.booleanValue()) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CalendarTextFieldCaspianSkin.this.textField.requestFocus();
                        }
                    });
                }
            }
        });
    }

    private void createNodes() {
        this.textField = new TextField();
        this.textField.setPrefColumnCount(20);
        this.textField.focusedProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable arg0) {
                if (!CalendarTextFieldCaspianSkin.this.textField.isFocused()) {
                    CalendarTextFieldCaspianSkin.this.parse();
                }
            }
        });
        this.textField.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent evt) {
                CalendarTextFieldCaspianSkin.this.parse();
            }
        });
        this.textField.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode() == KeyCode.UP || keyEvent.getCode() == KeyCode.DOWN) {
                    CalendarTextFieldCaspianSkin.this.parse();
                    Calendar lCalendar = (Calendar)((CalendarTextField)CalendarTextFieldCaspianSkin.this.getSkinnable()).getValue().clone();
                    int lField = 5;
                    if (!keyEvent.isShiftDown() && keyEvent.isControlDown()) {
                        lField = 2;
                    }
                    if (!keyEvent.isShiftDown() && keyEvent.isAltDown()) {
                        lField = 1;
                    }
                    if (keyEvent.isShiftDown() && keyEvent.isControlDown() && CalendarTextFieldCaspianSkin.this.isShowingTime()) {
                        lField = 11;
                    }
                    if (keyEvent.isShiftDown() && keyEvent.isAltDown() && CalendarTextFieldCaspianSkin.this.isShowingTime()) {
                        lField = 12;
                    }
                    lCalendar.add(lField, keyEvent.getCode() == KeyCode.UP ? 1 : -1);
                    ((CalendarTextField)CalendarTextFieldCaspianSkin.this.getSkinnable()).setValue(lCalendar);
                }
            }
        });
        this.textField.tooltipProperty().bindBidirectional((Property)((CalendarTextField)this.getSkinnable()).tooltipProperty());
        if (((CalendarTextField)this.getSkinnable()).getTooltip() == null) {
            ((CalendarTextField)this.getSkinnable()).setTooltip(new Tooltip("Type a date or use # for today, or +/-<number>[d|w|m|y] for delta's (for example: -3m for minus 3 months)\nUse cursor up and down plus optional shift (week), ctrl (month) or alt (year) for quick keyboard changes."));
        }
        this.textField.promptTextProperty().bind(((CalendarTextField)this.getSkinnable()).promptTextProperty());
        this.imageView = new ImageView();
        this.imageView.getStyleClass().add((Object)"icon");
        this.imageView.setPickOnBounds(true);
        this.imageView.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent evt) {
                if (CalendarTextFieldCaspianSkin.this.textField.focusedProperty().get()) {
                    CalendarTextFieldCaspianSkin.this.parse();
                }
                CalendarTextFieldCaspianSkin.this.showPopup(evt);
            }
        });
        this.gridPane = new GridPane();
        this.gridPane.setHgap(3.0);
        this.gridPane.add((Node)this.textField, 0, 0);
        this.gridPane.add((Node)this.imageView, 1, 0);
        ColumnConstraints column0 = new ColumnConstraints(100.0, 10.0, Double.MAX_VALUE);
        column0.setHgrow(Priority.ALWAYS);
        this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column0});
        this.getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
        this.getChildren().add((Object)this.gridPane);
        this.calendarPicker = new CalendarPicker();
        this.calendarPicker.setMode(CalendarPicker.Mode.SINGLE);
        Bindings.bindBidirectional(this.calendarPicker.localeProperty(), ((CalendarTextField)this.getSkinnable()).localeProperty());
        Bindings.bindBidirectional(this.calendarPicker.calendarProperty(), ((CalendarTextField)this.getSkinnable()).valueProperty());
        this.calendarPicker.calendarProperty().addListener((ChangeListener)new ChangeListener<Calendar>(){

            public void changed(ObservableValue<? extends Calendar> observable, Calendar oldValue, Calendar newValue) {
                if (CalendarTextFieldCaspianSkin.this.popup != null && !CalendarTextFieldCaspianSkin.this.isShowingTime()) {
                    CalendarTextFieldCaspianSkin.this.popup.hide();
                    CalendarTextFieldCaspianSkin.this.popup = null;
                }
            }
        });
        this.closeIconImage = new Image(((Object)((Object)this)).getClass().getResourceAsStream(((Object)((Object)this)).getClass().getSimpleName() + "CloseWindowIcon.png"));
    }

    private void parse() {
        block17: {
            try {
                String lText = this.textField.getText();
                lText = lText.trim();
                if (lText.length() == 0) {
                    ((CalendarTextField)this.getSkinnable()).setValue(null);
                    return;
                }
                if (lText.startsWith("-") || lText.startsWith("+")) {
                    if (lText.startsWith("+")) {
                        lText = lText.substring(1);
                    }
                    int lUnit = 5;
                    if (lText.toLowerCase().endsWith("d")) {
                        lText = lText.substring(0, lText.length() - 1);
                        lUnit = 5;
                    }
                    if (lText.toLowerCase().endsWith("w")) {
                        lText = lText.substring(0, lText.length() - 1);
                        lUnit = 3;
                    }
                    if (lText.toLowerCase().endsWith("m")) {
                        lText = lText.substring(0, lText.length() - 1);
                        lUnit = 2;
                    }
                    if (lText.toLowerCase().endsWith("y")) {
                        lText = lText.substring(0, lText.length() - 1);
                        lUnit = 1;
                    }
                    int lDelta = Integer.parseInt(lText);
                    Calendar lCalendar = (Calendar)((CalendarTextField)this.getSkinnable()).getValue().clone();
                    lCalendar.add(lUnit, lDelta);
                    ((CalendarTextField)this.getSkinnable()).setValue(lCalendar);
                    break block17;
                }
                if (lText.equals("#")) {
                    ((CalendarTextField)this.getSkinnable()).setValue(Calendar.getInstance());
                    break block17;
                }
                Calendar lCalendar = ((CalendarTextField)this.getSkinnable()).getValue();
                ParseException lParseException = null;
                try {
                    Date lDate = ((CalendarTextField)this.getSkinnable()).getDateFormat().parse(lText);
                    lCalendar = Calendar.getInstance();
                    lCalendar.setTime(lDate);
                }
                catch (ParseException e) {
                    lParseException = e;
                    for (DateFormat lDateFormat : ((CalendarTextField)this.getSkinnable()).getDateFormats()) {
                        try {
                            Date lDate = lDateFormat.parse(lText);
                            lCalendar = Calendar.getInstance();
                            lCalendar.setTime(lDate);
                            lParseException = null;
                            break;
                        }
                        catch (ParseException e2) {
                        }
                    }
                }
                ((CalendarTextField)this.getSkinnable()).setValue(lCalendar);
                this.refreshValue();
                if (lParseException != null) {
                    throw lParseException;
                }
            }
            catch (Throwable t) {
                if (((CalendarTextField)this.getSkinnable()).getParseErrorCallback() != null) {
                    ((CalendarTextField)this.getSkinnable()).getParseErrorCallback().call((Object)t);
                }
                t.printStackTrace();
            }
        }
    }

    private boolean isShowingTime() {
        String lDateAsString = ((DateFormat)((CalendarTextField)this.getSkinnable()).dateFormatProperty().get()).format(DATE_WITH_TIME);
        return lDateAsString.contains("2");
    }

    private void showPopup(MouseEvent evt) {
        if (this.popup == null) {
            this.popup = new Popup();
            this.popup.setAutoFix(true);
            this.popup.setAutoHide(true);
            this.popup.setHideOnEscape(true);
            BorderPane lBorderPane = new BorderPane();
            lBorderPane.getStyleClass().add((Object)(((Object)((Object)this)).getClass().getSimpleName() + "_popup"));
            lBorderPane.setCenter((Node)this.calendarPicker);
            this.calendarPicker.showTimeProperty().set((Object)this.isShowingTime());
            if (this.isShowingTime()) {
                ImageView lImageView = new ImageView(this.closeIconImage);
                lImageView.setPickOnBounds(true);
                lImageView.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent evt) {
                        CalendarTextFieldCaspianSkin.this.popup.hide();
                        CalendarTextFieldCaspianSkin.this.popup = null;
                    }
                });
                lBorderPane.rightProperty().set((Object)lImageView);
            }
            this.popup.getContent().add((Object)lBorderPane);
        }
        this.popup.show((Node)this.textField, NodeUtil.screenX((Node)this.getSkinnable()), NodeUtil.screenY((Node)this.getSkinnable()) + this.textField.getHeight());
        this.calendarPicker.requestFocus();
    }
}

