/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Popup;
import jfxtras.labs.internal.scene.control.behavior.CalendarTimeTextFieldBehavior;
import jfxtras.labs.internal.scene.control.skin.CalendarTimePickerSkin;
import jfxtras.labs.scene.control.CalendarTimePicker;
import jfxtras.labs.scene.control.CalendarTimeTextField;
import jfxtras.labs.util.NodeUtil;

public class CalendarTimeTextFieldCaspianSkin
extends SkinBase<CalendarTimeTextField, CalendarTimeTextFieldBehavior> {
    private TextField textField = null;
    private ImageView imageView = null;
    private GridPane gridPane = null;
    private CalendarTimePicker TimePicker = null;
    private Image closeIconImage = null;
    private Popup popup = null;

    public CalendarTimeTextFieldCaspianSkin(CalendarTimeTextField control) {
        super((Control)control, (BehaviorBase)new CalendarTimeTextFieldBehavior(control));
        this.construct();
    }

    private void construct() {
        this.createNodes();
        ((CalendarTimeTextField)this.getSkinnable()).valueProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable arg0) {
                CalendarTimeTextFieldCaspianSkin.this.refreshValue();
            }
        });
        this.refreshValue();
        this.initFocusSimulation();
    }

    private void refreshValue() {
        Calendar c = ((CalendarTimeTextField)this.getSkinnable()).getValue();
        String s = c == null ? "" : ((CalendarTimeTextField)this.getSkinnable()).getDateFormat().format(c.getTime());
        this.textField.setText(s);
    }

    private void initFocusSimulation() {
        ((CalendarTimeTextField)this.getSkinnable()).focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean wasFocused, Boolean isFocused) {
                if (isFocused.booleanValue()) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CalendarTimeTextFieldCaspianSkin.this.textField.requestFocus();
                        }
                    });
                }
            }
        });
    }

    private void createNodes() {
        this.textField = new TextField();
        this.textField.focusedProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable arg0) {
                if (!CalendarTimeTextFieldCaspianSkin.this.textField.isFocused()) {
                    CalendarTimeTextFieldCaspianSkin.this.parse();
                }
            }
        });
        this.textField.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent evt) {
                CalendarTimeTextFieldCaspianSkin.this.parse();
            }
        });
        this.textField.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode() == KeyCode.UP || keyEvent.getCode() == KeyCode.DOWN) {
                    CalendarTimeTextFieldCaspianSkin.this.parse();
                    Calendar lCalendar = (Calendar)((CalendarTimeTextField)CalendarTimeTextFieldCaspianSkin.this.getSkinnable()).getValue().clone();
                    if (keyEvent.isControlDown()) {
                        lCalendar.add(11, keyEvent.getCode() == KeyCode.UP ? 1 : -1);
                    } else {
                        lCalendar.add(12, keyEvent.getCode() == KeyCode.UP ? ((CalendarTimeTextField)CalendarTimeTextFieldCaspianSkin.this.getSkinnable()).getMinuteStep() : -1 * ((CalendarTimeTextField)CalendarTimeTextFieldCaspianSkin.this.getSkinnable()).getMinuteStep());
                    }
                    ((CalendarTimeTextField)CalendarTimeTextFieldCaspianSkin.this.getSkinnable()).setValue(CalendarTimePickerSkin.blockMinutesToStep(lCalendar, ((CalendarTimeTextField)CalendarTimeTextFieldCaspianSkin.this.getSkinnable()).getMinuteStep()));
                }
            }
        });
        this.textField.tooltipProperty().bindBidirectional((Property)((CalendarTimeTextField)this.getSkinnable()).tooltipProperty());
        if (((CalendarTimeTextField)this.getSkinnable()).getTooltip() == null) {
            ((CalendarTimeTextField)this.getSkinnable()).setTooltip(new Tooltip("Type a time or use # for now, or +/-<number>[h|m] for delta's (for example: -3m for minus 3 minutes)\nUse cursor up and down plus optional ctrl (hour) for quick keyboard changes."));
        }
        this.textField.promptTextProperty().bind(((CalendarTimeTextField)this.getSkinnable()).promptTextProperty());
        this.imageView = new ImageView();
        this.imageView.getStyleClass().add((Object)"icon");
        this.imageView.setPickOnBounds(true);
        this.imageView.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent evt) {
                if (CalendarTimeTextFieldCaspianSkin.this.textField.focusedProperty().get()) {
                    CalendarTimeTextFieldCaspianSkin.this.parse();
                }
                CalendarTimeTextFieldCaspianSkin.this.showPopup(evt);
            }
        });
        this.gridPane = new GridPane();
        this.gridPane.setHgap(3.0);
        this.gridPane.add((Node)this.textField, 0, 0);
        this.gridPane.add((Node)this.imageView, 1, 0);
        ColumnConstraints column0 = new ColumnConstraints(100.0, 10.0, Double.MAX_VALUE);
        column0.setHgrow(Priority.ALWAYS);
        this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column0});
        this.getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
        this.getChildren().add((Object)this.gridPane);
        this.TimePicker = new CalendarTimePicker();
        Bindings.bindBidirectional(this.TimePicker.calendarProperty(), ((CalendarTimeTextField)this.getSkinnable()).valueProperty());
        Bindings.bindBidirectional(this.TimePicker.minuteStepProperty(), ((CalendarTimeTextField)this.getSkinnable()).minuteStepProperty());
        Bindings.bindBidirectional(this.TimePicker.showLabelsProperty(), ((CalendarTimeTextField)this.getSkinnable()).showLabelsProperty());
        this.closeIconImage = new Image(((Object)((Object)this)).getClass().getResourceAsStream(((Object)((Object)this)).getClass().getSimpleName() + "CloseWindowIcon.png"));
    }

    private void parse() {
        block15: {
            try {
                String lText = this.textField.getText();
                lText = lText.trim();
                if (lText.length() == 0) {
                    ((CalendarTimeTextField)this.getSkinnable()).setValue(null);
                    return;
                }
                if (lText.startsWith("-") || lText.startsWith("+")) {
                    if (lText.startsWith("+")) {
                        lText = lText.substring(1);
                    }
                    int lUnit = 5;
                    if (lText.toLowerCase().endsWith("m")) {
                        lText = lText.substring(0, lText.length() - 1);
                        lUnit = 12;
                    }
                    if (lText.toLowerCase().endsWith("h")) {
                        lText = lText.substring(0, lText.length() - 1);
                        lUnit = 11;
                    }
                    int lDelta = Integer.parseInt(lText);
                    Calendar lCalendar = (Calendar)((CalendarTimeTextField)this.getSkinnable()).getValue().clone();
                    lCalendar.add(lUnit, lDelta);
                    ((CalendarTimeTextField)this.getSkinnable()).setValue(CalendarTimePickerSkin.blockMinutesToStep(lCalendar, ((CalendarTimeTextField)this.getSkinnable()).getMinuteStep()));
                    break block15;
                }
                if (lText.equals("#")) {
                    ((CalendarTimeTextField)this.getSkinnable()).setValue(CalendarTimePickerSkin.blockMinutesToStep(Calendar.getInstance(), ((CalendarTimeTextField)this.getSkinnable()).getMinuteStep()));
                    break block15;
                }
                Calendar lCalendar = ((CalendarTimeTextField)this.getSkinnable()).getValue();
                ParseException lParseException = null;
                try {
                    Date lDate = ((CalendarTimeTextField)this.getSkinnable()).getDateFormat().parse(lText);
                    lCalendar = Calendar.getInstance();
                    lCalendar.setTime(lDate);
                }
                catch (ParseException e) {
                    lParseException = e;
                    for (DateFormat lDateFormat : ((CalendarTimeTextField)this.getSkinnable()).getDateFormats()) {
                        try {
                            Date lDate = lDateFormat.parse(lText);
                            lCalendar = Calendar.getInstance();
                            lCalendar.setTime(lDate);
                            lParseException = null;
                            break;
                        }
                        catch (ParseException e2) {
                        }
                    }
                }
                ((CalendarTimeTextField)this.getSkinnable()).setValue(lCalendar);
                this.refreshValue();
                if (lParseException != null) {
                    throw lParseException;
                }
            }
            catch (Throwable t) {
                if (((CalendarTimeTextField)this.getSkinnable()).getParseErrorCallback() != null) {
                    ((CalendarTimeTextField)this.getSkinnable()).getParseErrorCallback().call((Object)t);
                }
                t.printStackTrace();
            }
        }
    }

    private void showPopup(MouseEvent evt) {
        if (this.popup == null) {
            this.popup = new Popup();
            this.popup.setAutoFix(true);
            this.popup.setAutoHide(true);
            this.popup.setHideOnEscape(true);
            BorderPane lBorderPane = new BorderPane();
            lBorderPane.getStyleClass().add((Object)(((Object)((Object)this)).getClass().getSimpleName() + "_popup"));
            lBorderPane.setCenter((Node)this.TimePicker);
            ImageView lImageView = new ImageView(this.closeIconImage);
            lImageView.setPickOnBounds(true);
            lImageView.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent evt) {
                    CalendarTimeTextFieldCaspianSkin.this.popup.hide();
                }
            });
            lBorderPane.rightProperty().set((Object)lImageView);
            this.popup.getContent().add((Object)lBorderPane);
        }
        this.popup.show((Node)this.textField, NodeUtil.screenX((Node)this.getSkinnable()), NodeUtil.screenY((Node)this.getSkinnable()) + this.textField.getHeight());
    }
}

