/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import jfxtras.labs.internal.scene.control.behavior.DotMatrixSegmentBehavior;
import jfxtras.labs.scene.control.gauge.DotMatrixSegment;
import jfxtras.labs.util.Util;

public class DotMatrixSegmentSkin
extends SkinBase<DotMatrixSegment, DotMatrixSegmentBehavior> {
    private DotMatrixSegment control;
    private boolean isDirty;
    private boolean initialized;
    private Group dots;
    private Map<DotMatrixSegment.Dot, Shape> dotMap;

    public DotMatrixSegmentSkin(DotMatrixSegment CONTROL) {
        super((Control)CONTROL, (BehaviorBase)new DotMatrixSegmentBehavior(CONTROL));
        this.control = CONTROL;
        this.initialized = false;
        this.isDirty = false;
        this.dots = new Group();
        this.dotMap = new HashMap<DotMatrixSegment.Dot, Shape>(17);
        this.init();
    }

    private void init() {
        if (this.control.getPrefWidth() < 0.0 | this.control.getPrefHeight() < 0.0) {
            this.control.setPrefSize(40.0, 56.0);
        }
        if (this.control.getMinWidth() < 0.0 | this.control.getMinHeight() < 0.0) {
            this.control.setMinSize(10.0, 14.0);
        }
        if (this.control.getMaxWidth() < 0.0 | this.control.getMaxHeight() < 0.0) {
            this.control.setMaxSize(400.0, 560.0);
        }
        this.createDots();
        this.updateCharacter();
        this.registerChangeListener((ObservableValue)this.control.prefWidthProperty(), "PREF_WIDTH");
        this.registerChangeListener((ObservableValue)this.control.prefHeightProperty(), "PREF_HEIGHT");
        this.registerChangeListener((ObservableValue)this.control.characterProperty(), "CHARACTER");
        this.registerChangeListener((ObservableValue)this.control.colorProperty(), "COLOR");
        this.registerChangeListener((ObservableValue)this.control.plainColorProperty(), "PLAIN_COLOR");
        this.registerChangeListener((ObservableValue)this.control.customDotMappingProperty(), "CUSTOM_MAPPING");
        this.registerChangeListener((ObservableValue)this.control.dotOnProperty(), "DOT_ON");
        this.initialized = true;
        this.repaint();
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        super.handleControlPropertyChanged(PROPERTY);
        if ("CHARACTER".equals(PROPERTY)) {
            this.updateCharacter();
        } else if ("COLOR".equals(PROPERTY)) {
            this.updateSegmentColor();
        } else if ("PLAIN_COLOR".equals(PROPERTY)) {
            this.updateCharacter();
        } else if ("CUSTOM_MAPPING".equals(PROPERTY)) {
            this.updateCharacter();
        } else if ("DOT_ON".equals(PROPERTY)) {
            this.updateCharacter();
        } else if ("PREF_WIDTH".equals(PROPERTY)) {
            this.repaint();
        } else if ("PREF_HEIGHT".equals(PROPERTY)) {
            this.repaint();
        }
    }

    public final void repaint() {
        this.isDirty = true;
        this.requestLayout();
    }

    public void layoutChildren() {
        if (!this.isDirty) {
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.control.getScene() != null) {
            this.updateCharacter();
            this.getChildren().setAll((Object[])new Node[]{this.dots});
        }
        this.isDirty = false;
        super.layoutChildren();
    }

    public final DotMatrixSegment getSkinnable() {
        return this.control;
    }

    public final void dispose() {
        this.control = null;
    }

    protected double computePrefWidth(double PREF_WIDTH) {
        double prefWidth = 40.0;
        if (PREF_WIDTH != -1.0) {
            prefWidth = Math.max(0.0, PREF_WIDTH - this.getInsets().getLeft() - this.getInsets().getRight());
        }
        return super.computePrefWidth(prefWidth);
    }

    protected double computePrefHeight(double PREF_HEIGHT) {
        double prefHeight = 56.0;
        if (PREF_HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, PREF_HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom());
        }
        return super.computePrefWidth(prefHeight);
    }

    private void updateSegmentColor() {
        this.control.setStyle("-fx-segment-color-on: " + Util.colorToCssColor(this.control.getColor()) + "-fx-segment-color-off: " + Util.colorToCssColor(Color.color((double)this.control.getColor().getRed(), (double)this.control.getColor().getGreen(), (double)this.control.getColor().getBlue(), (double)0.075)));
    }

    private void updateCharacter() {
        String ON_STYLE;
        this.updateSegmentColor();
        int ASCII = this.control.getCharacter().isEmpty() ? 20 : (int)this.control.getCharacter().toUpperCase().charAt(0);
        InnerShadow INNER_SHADOW = new InnerShadow();
        INNER_SHADOW.setRadius(0.05 * this.control.getPrefWidth());
        INNER_SHADOW.setColor(Color.hsb((double)this.control.getColor().getHue(), (double)this.control.getColor().getSaturation(), (double)0.2));
        String CURRENT_STYLE = this.control.getStyle();
        String string = ON_STYLE = this.control.isPlainColor() ? "plain-on" : "on";
        if (this.control.getCustomDotMapping().isEmpty()) {
            for (DotMatrixSegment.Dot dot : this.dotMap.keySet()) {
                if (this.control.getDotMapping().containsKey(ASCII)) {
                    if (this.control.getDotMapping().get(ASCII).contains((Object)dot)) {
                        this.dotMap.get((Object)dot).setStyle(CURRENT_STYLE);
                        this.dotMap.get((Object)dot).getStyleClass().setAll((Object[])new String[]{ON_STYLE});
                        this.dotMap.get((Object)dot).setEffect((Effect)INNER_SHADOW);
                        continue;
                    }
                    this.dotMap.get((Object)dot).setStyle(CURRENT_STYLE);
                    this.dotMap.get((Object)dot).getStyleClass().setAll((Object[])new String[]{"off"});
                    this.dotMap.get((Object)dot).setEffect(null);
                    continue;
                }
                this.dotMap.get((Object)dot).setStyle(CURRENT_STYLE);
                this.dotMap.get((Object)dot).getStyleClass().setAll((Object[])new String[]{"off"});
                this.dotMap.get((Object)dot).setEffect(null);
            }
        } else {
            for (DotMatrixSegment.Dot dot : this.dotMap.keySet()) {
                if (this.control.getCustomDotMapping().containsKey(ASCII)) {
                    if (this.control.getCustomDotMapping().get(ASCII).contains((Object)dot)) {
                        this.dotMap.get((Object)dot).setStyle(CURRENT_STYLE);
                        this.dotMap.get((Object)dot).getStyleClass().setAll((Object[])new String[]{ON_STYLE});
                        this.dotMap.get((Object)dot).setEffect((Effect)INNER_SHADOW);
                        continue;
                    }
                    this.dotMap.get((Object)dot).setStyle(CURRENT_STYLE);
                    this.dotMap.get((Object)dot).getStyleClass().setAll((Object[])new String[]{"off"});
                    this.dotMap.get((Object)dot).setEffect(null);
                    continue;
                }
                this.dotMap.get((Object)dot).setStyle(CURRENT_STYLE);
                this.dotMap.get((Object)dot).getStyleClass().setAll((Object[])new String[]{"off"});
                this.dotMap.get((Object)dot).setEffect(null);
            }
        }
    }

    private final void createDots() {
        double WIDTH = this.control.getPrefWidth();
        double HEIGHT = this.control.getPrefHeight();
        this.updateSegmentColor();
        this.dots.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        this.dots.getChildren().add((Object)IBOUNDS);
        Circle D57 = new Circle(0.8902439024390244 * WIDTH, 0.9210526315789473 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D57, (Shape)D57);
        Circle D47 = new Circle(0.6951219512195121 * WIDTH, 0.9210526315789473 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D47, (Shape)D47);
        Circle D37 = new Circle(0.5 * WIDTH, 0.9210526315789473 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D37, (Shape)D37);
        Circle D27 = new Circle(0.3048780487804878 * WIDTH, 0.9210526315789473 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D27, (Shape)D27);
        Circle D17 = new Circle(0.10975609756097561 * WIDTH, 0.9210526315789473 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D17, (Shape)D17);
        Circle D56 = new Circle(0.8902439024390244 * WIDTH, 0.7807017543859649 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D56, (Shape)D56);
        Circle D46 = new Circle(0.6951219512195121 * WIDTH, 0.7807017543859649 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D46, (Shape)D46);
        Circle D36 = new Circle(0.5 * WIDTH, 0.7807017543859649 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D36, (Shape)D36);
        Circle D26 = new Circle(0.3048780487804878 * WIDTH, 0.7807017543859649 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D26, (Shape)D26);
        Circle D16 = new Circle(0.10975609756097561 * WIDTH, 0.7807017543859649 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D16, (Shape)D16);
        Circle D55 = new Circle(0.8902439024390244 * WIDTH, 0.6403508771929824 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D55, (Shape)D55);
        Circle D45 = new Circle(0.6951219512195121 * WIDTH, 0.6403508771929824 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D45, (Shape)D45);
        Circle D35 = new Circle(0.5 * WIDTH, 0.6403508771929824 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D35, (Shape)D35);
        Circle D25 = new Circle(0.3048780487804878 * WIDTH, 0.6403508771929824 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D25, (Shape)D25);
        Circle D15 = new Circle(0.10975609756097561 * WIDTH, 0.6403508771929824 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D15, (Shape)D15);
        Circle D54 = new Circle(0.8902439024390244 * WIDTH, 0.5 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D54, (Shape)D54);
        Circle D44 = new Circle(0.6951219512195121 * WIDTH, 0.5 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D44, (Shape)D44);
        Circle D34 = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D34, (Shape)D34);
        Circle D24 = new Circle(0.3048780487804878 * WIDTH, 0.5 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D24, (Shape)D24);
        Circle D14 = new Circle(0.10975609756097561 * WIDTH, 0.5 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D14, (Shape)D14);
        Circle D53 = new Circle(0.8902439024390244 * WIDTH, 0.35964912280701755 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D53, (Shape)D53);
        Circle D43 = new Circle(0.6951219512195121 * WIDTH, 0.35964912280701755 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D43, (Shape)D43);
        Circle D33 = new Circle(0.5 * WIDTH, 0.35964912280701755 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D33, (Shape)D33);
        Circle D23 = new Circle(0.3048780487804878 * WIDTH, 0.35964912280701755 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D23, (Shape)D23);
        Circle D13 = new Circle(0.10975609756097561 * WIDTH, 0.35964912280701755 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D13, (Shape)D13);
        Circle D52 = new Circle(0.8902439024390244 * WIDTH, 0.21929824561403508 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D52, (Shape)D52);
        Circle D42 = new Circle(0.6951219512195121 * WIDTH, 0.21929824561403508 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D42, (Shape)D42);
        Circle D32 = new Circle(0.5 * WIDTH, 0.21929824561403508 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D32, (Shape)D32);
        Circle D22 = new Circle(0.3048780487804878 * WIDTH, 0.21929824561403508 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D22, (Shape)D22);
        Circle D12 = new Circle(0.10975609756097561 * WIDTH, 0.21929824561403508 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D12, (Shape)D12);
        Circle D51 = new Circle(0.8902439024390244 * WIDTH, 0.07894736842105263 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D51, (Shape)D51);
        Circle D41 = new Circle(0.6951219512195121 * WIDTH, 0.07894736842105263 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D41, (Shape)D41);
        Circle D31 = new Circle(0.5 * WIDTH, 0.07894736842105263 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D31, (Shape)D31);
        Circle D21 = new Circle(0.3048780487804878 * WIDTH, 0.07894736842105263 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D21, (Shape)D21);
        Circle D11 = new Circle(0.10975609756097561 * WIDTH, 0.07894736842105263 * HEIGHT, 0.08536585365853659 * WIDTH);
        this.dotMap.put(DotMatrixSegment.Dot.D11, (Shape)D11);
        for (Shape dot : this.dotMap.values()) {
            dot.getStyleClass().add((Object)"off");
        }
        this.dots.getChildren().addAll((Object[])new Node[]{D57, D47, D37, D27, D17, D56, D46, D36, D26, D16, D55, D45, D35, D25, D15, D54, D44, D34, D24, D14, D53, D43, D33, D23, D13, D52, D42, D32, D22, D12, D51, D41, D31, D21, D11});
    }
}

